/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.template.ruby;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyContext;
import org.rubypeople.rdt.internal.corext.util.CodeFormatterUtil;
import org.rubypeople.rdt.internal.corext.util.Strings;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.RubyHeuristicScanner;

public class RubyFormatter {
    private static final String MARKER = "/*${cursor}*/";
    private final String fLineDelimiter;
    private final int fInitialIndentLevel;
    private boolean fUseCodeFormatter;
    private final IRubyProject fProject;

    public RubyFormatter(String string, int n, boolean bl, IRubyProject iRubyProject) {
        this.fLineDelimiter = string;
        this.fUseCodeFormatter = bl;
        this.fInitialIndentLevel = n;
        this.fProject = iRubyProject;
    }

    public void format(TemplateBuffer templateBuffer, TemplateContext templateContext) throws BadLocationException {
        try {
            DocumentTemplateContext documentTemplateContext;
            if (this.fUseCodeFormatter) {
                try {
                    this.format(templateBuffer, (RubyContext)templateContext);
                }
                catch (BadLocationException badLocationException) {
                    this.indent(templateBuffer);
                }
                catch (MalformedTreeException malformedTreeException) {
                    this.indent(templateBuffer);
                }
            } else {
                this.indent(templateBuffer);
            }
            if (templateContext instanceof DocumentTemplateContext && (documentTemplateContext = (DocumentTemplateContext)templateContext).getStart() == documentTemplateContext.getCompletionOffset() && documentTemplateContext.getDocument().get(documentTemplateContext.getStart(), documentTemplateContext.getEnd() - documentTemplateContext.getStart()).trim().length() == 0) {
                return;
            }
            RubyFormatter.trimBegin(templateBuffer);
        }
        catch (MalformedTreeException malformedTreeException) {
            throw new BadLocationException();
        }
    }

    private static int getCaretOffset(TemplateVariable[] templateVariableArray) {
        int n = 0;
        while (n != templateVariableArray.length) {
            TemplateVariable templateVariable = templateVariableArray[n];
            if (templateVariable.getType().equals("cursor")) {
                return templateVariable.getOffsets()[0];
            }
            ++n;
        }
        return -1;
    }

    private boolean isInsideCommentOrString(String string, int n) {
        Document document = new Document(string);
        RubyPlugin.getDefault().getRubyTextTools().setupRubyDocumentPartitioner((IDocument)document);
        try {
            ITypedRegion iTypedRegion = document.getPartition(n);
            String string2 = iTypedRegion.getType();
            return string2 != null && (string2.equals("__ruby_multiline_comment") || string2.equals("__ruby_singleline_comment") || string2.equals("__ruby_string") || string2.equals("__ruby_character") || string2.equals("__ruby_rdoc"));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void format(TemplateBuffer templateBuffer, RubyContext rubyContext) throws BadLocationException {
        String string = templateBuffer.getString();
        TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
        int n = RubyFormatter.getCaretOffset(templateVariableArray);
        if (n > 0 && Character.isWhitespace(string.charAt(n - 1)) && n < string.length() && Character.isWhitespace(string.charAt(n)) && !this.isInsideCommentOrString(string, n)) {
            List list = RubyFormatter.variablesToPositions(templateVariableArray);
            InsertEdit insertEdit = new InsertEdit(n, MARKER);
            string = RubyFormatter.edit(string, list, (TextEdit)insertEdit);
            RubyFormatter.positionsToVariables(list, templateVariableArray);
            templateBuffer.setContent(string, templateVariableArray);
            try {
                this.plainFormat(templateBuffer, rubyContext);
                string = templateBuffer.getString();
                templateVariableArray = templateBuffer.getVariables();
                n = RubyFormatter.getCaretOffset(templateVariableArray);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                list = RubyFormatter.variablesToPositions(templateVariableArray);
                DeleteEdit deleteEdit = new DeleteEdit(n, MARKER.length());
                string = RubyFormatter.edit(string, list, (TextEdit)deleteEdit);
                RubyFormatter.positionsToVariables(list, templateVariableArray);
                templateBuffer.setContent(string, templateVariableArray);
                throw throwable;
            }
            {
                Object var8_10 = null;
                list = RubyFormatter.variablesToPositions(templateVariableArray);
                DeleteEdit deleteEdit = new DeleteEdit(n, MARKER.length());
                string = RubyFormatter.edit(string, list, (TextEdit)deleteEdit);
                RubyFormatter.positionsToVariables(list, templateVariableArray);
                templateBuffer.setContent(string, templateVariableArray);
                return;
            }
        }
        this.plainFormat(templateBuffer, rubyContext);
    }

    private void plainFormat(TemplateBuffer templateBuffer, RubyContext rubyContext) throws BadLocationException {
        MultiTextEdit multiTextEdit;
        Document document = new Document(templateBuffer.getString());
        TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
        List list = RubyFormatter.variablesToPositions(templateVariableArray);
        Map map = rubyContext.getRubyScript() != null ? rubyContext.getRubyScript().getRubyProject().getOptions(true) : RubyCore.getOptions();
        String string = document.get();
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        int[] nArray2 = nArray;
        TextEdit textEdit = null;
        int n = 0;
        while (n < nArray2.length && textEdit == null) {
            textEdit = CodeFormatterUtil.format2(nArray2[n], string, this.fInitialIndentLevel, this.fLineDelimiter, map);
            ++n;
        }
        if (textEdit == null) {
            throw new BadLocationException();
        }
        if (textEdit instanceof MultiTextEdit) {
            multiTextEdit = (MultiTextEdit)textEdit;
        } else {
            multiTextEdit = new MultiTextEdit(0, document.getLength());
            multiTextEdit.addChild(textEdit);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TextEdit textEdit2 = (TextEdit)iterator.next();
            try {
                multiTextEdit.addChild(textEdit2);
            }
            catch (MalformedTreeException malformedTreeException) {}
        }
        multiTextEdit.apply((IDocument)document, 2);
        RubyFormatter.positionsToVariables(list, templateVariableArray);
        templateBuffer.setContent(document.get(), templateVariableArray);
    }

    private void indent(TemplateBuffer templateBuffer) throws BadLocationException, MalformedTreeException {
        TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
        List list = RubyFormatter.variablesToPositions(templateVariableArray);
        Document document = new Document(templateBuffer.getString());
        MultiTextEdit multiTextEdit = new MultiTextEdit(0, document.getLength());
        multiTextEdit.addChildren(list.toArray(new TextEdit[list.size()]));
        int n = document.getLineOffset(0);
        String string = CodeFormatterUtil.createIndentString(this.fInitialIndentLevel, this.fProject);
        InsertEdit insertEdit = new InsertEdit(n, string);
        multiTextEdit.addChild((TextEdit)insertEdit);
        multiTextEdit.apply((IDocument)document, 2);
        multiTextEdit.removeChild((TextEdit)insertEdit);
        this.formatDelimiter((IDocument)document, multiTextEdit, 0);
        int n2 = document.getNumberOfLines();
        new RubyHeuristicScanner((IDocument)document);
        int n3 = 1;
        while (n3 < n2) {
            IRegion iRegion = document.getLineInformation(n3);
            n = iRegion.getOffset();
            if (string != null) {
                insertEdit = new ReplaceEdit(n, 0, string.toString());
                multiTextEdit.addChild((TextEdit)insertEdit);
                multiTextEdit.apply((IDocument)document, 2);
                multiTextEdit.removeChild((TextEdit)insertEdit);
                this.formatDelimiter((IDocument)document, multiTextEdit, n3);
            }
            ++n3;
        }
        RubyFormatter.positionsToVariables(list, templateVariableArray);
        templateBuffer.setContent(document.get(), templateVariableArray);
    }

    private void formatDelimiter(IDocument iDocument, MultiTextEdit multiTextEdit, int n) throws BadLocationException {
        IRegion iRegion = iDocument.getLineInformation(n);
        String string = iDocument.getLineDelimiter(n);
        if (string != null) {
            ReplaceEdit replaceEdit = new ReplaceEdit(iRegion.getOffset() + iRegion.getLength(), string.length(), this.fLineDelimiter);
            multiTextEdit.addChild((TextEdit)replaceEdit);
            multiTextEdit.apply(iDocument, 2);
            multiTextEdit.removeChild((TextEdit)replaceEdit);
        }
    }

    private static void trimBegin(TemplateBuffer templateBuffer) throws BadLocationException {
        String string = templateBuffer.getString();
        TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
        List list = RubyFormatter.variablesToPositions(templateVariableArray);
        int n = 0;
        while (n != string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        string = RubyFormatter.edit(string, list, (TextEdit)new DeleteEdit(0, n));
        RubyFormatter.positionsToVariables(list, templateVariableArray);
        templateBuffer.setContent(string, templateVariableArray);
    }

    private static String edit(String string, List list, TextEdit textEdit) throws BadLocationException {
        MultiTextEdit multiTextEdit = new MultiTextEdit(0, string.length());
        multiTextEdit.addChildren(list.toArray(new TextEdit[list.size()]));
        multiTextEdit.addChild(textEdit);
        Document document = new Document(string);
        multiTextEdit.apply((IDocument)document);
        return document.get();
    }

    private static List variablesToPositions(TemplateVariable[] templateVariableArray) {
        ArrayList<RangeMarker> arrayList = new ArrayList<RangeMarker>(5);
        int n = 0;
        while (n != templateVariableArray.length) {
            int[] nArray = templateVariableArray[n].getOffsets();
            String string = templateVariableArray[n].getDefaultValue();
            int n2 = 0;
            while (n2 < string.length() && Character.isWhitespace(string.charAt(n2)) && !Strings.isLineDelimiterChar(string.charAt(n2))) {
                ++n2;
            }
            templateVariableArray[n].getValues()[0] = string.substring(n2);
            int n3 = 0;
            while (n3 != nArray.length) {
                int n4 = n3;
                nArray[n4] = nArray[n4] + n2;
                arrayList.add(new RangeMarker(nArray[n3], 0));
                ++n3;
            }
            ++n;
        }
        return arrayList;
    }

    private static void positionsToVariables(List list, TemplateVariable[] templateVariableArray) {
        Iterator iterator = list.iterator();
        int n = 0;
        while (n != templateVariableArray.length) {
            TemplateVariable templateVariable = templateVariableArray[n];
            int[] nArray = new int[templateVariable.getOffsets().length];
            int n2 = 0;
            while (n2 != nArray.length) {
                nArray[n2] = ((TextEdit)iterator.next()).getOffset();
                ++n2;
            }
            templateVariable.setOffsets(nArray);
            ++n;
        }
    }
}

