/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.generic;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSignatureParser {
    private final String signature;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$generic$GenericSignatureParser;

    public GenericSignatureParser(String signature) {
        if (signature.indexOf(40) < 0 || signature.indexOf(58) >= 0) {
            throw new IllegalArgumentException(new StringBuffer().append("Bad method signature: ").append(signature).toString());
        }
        this.signature = !signature.startsWith("(") ? signature.substring(signature.indexOf("(")) : signature;
    }

    public Iterator<String> parameterSignatureIterator() {
        return new ParameterSignatureIterator();
    }

    public String getReturnTypeSignature() {
        int endOfParams = this.signature.lastIndexOf(41);
        if (endOfParams < 0) {
            throw new IllegalArgumentException(new StringBuffer().append("Bad method signature: ").append(this.signature).toString());
        }
        return this.signature.substring(endOfParams + 1);
    }

    public int getNumParameters() {
        int count = 0;
        Iterator<String> i = this.parameterSignatureIterator();
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        return count;
    }

    public static int getNumParametersForInvocation(InvokeInstruction inv, ConstantPoolGen cpg) {
        GenericSignatureParser sigParser = new GenericSignatureParser(inv.getSignature(cpg));
        return sigParser.getNumParameters();
    }

    @CheckForNull
    public static Iterator<String> getGenericSignatureIterator(Method target) {
        try {
            GenericSignatureParser parser = null;
            String genericSignature = null;
            for (Attribute a : target.getAttributes()) {
                if (!(a instanceof Signature)) continue;
                Signature sig = (Signature)a;
                if (genericSignature != null) {
                    if (genericSignature.equals(sig.getSignature())) continue;
                    return null;
                }
                genericSignature = sig.getSignature();
                if (!GenericSignatureParser.compareSignatures(target.getSignature(), genericSignature)) continue;
                parser = new GenericSignatureParser(genericSignature);
            }
            Iterator<String> iter = parser == null ? null : parser.parameterSignatureIterator();
            return iter;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static boolean compareSignatures(String plainSignature, String genericSignature) {
        GenericSignatureParser plainParser = new GenericSignatureParser(plainSignature);
        GenericSignatureParser genericParser = new GenericSignatureParser(genericSignature);
        return plainParser.getNumParameters() == genericParser.getNumParameters();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$ba$generic$GenericSignatureParser == null ? (class$edu$umd$cs$findbugs$ba$generic$GenericSignatureParser = GenericSignatureParser.class$("edu.umd.cs.findbugs.ba.generic.GenericSignatureParser")) : class$edu$umd$cs$findbugs$ba$generic$GenericSignatureParser).getName()).append(" '<method signature>'").toString());
            System.exit(1);
        }
        GenericSignatureParser parser = new GenericSignatureParser(args[0]);
        Iterator<String> i = parser.parameterSignatureIterator();
        while (i.hasNext()) {
            String s = i.next();
            System.out.println(s);
            Type t = GenericUtilities.getType(s);
            System.out.println(new StringBuffer().append("-~- ").append(t).toString());
            if (t instanceof ObjectType) {
                System.out.println(new StringBuffer().append("-~- ").append(((ObjectType)t).toString()).toString());
            }
            System.out.println(new StringBuffer().append("-~- ").append(t.getClass()).toString());
        }
        System.out.println(new StringBuffer().append(parser.getNumParameters()).append(" parameter(s)").toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterSignatureIterator
    implements Iterator<String> {
        private int index = 1;

        private ParameterSignatureIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < GenericSignatureParser.this.signature.length() && GenericSignatureParser.this.signature.charAt(this.index) != ')';
        }

        @Override
        public String next() {
            boolean done;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StringBuffer result = new StringBuffer();
            do {
                done = true;
                char ch = GenericSignatureParser.this.signature.charAt(this.index);
                switch (ch) {
                    case '*': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'Z': {
                        result.append(GenericSignatureParser.this.signature.charAt(this.index));
                        ++this.index;
                        break;
                    }
                    case 'L': 
                    case 'T': {
                        String tmp = "";
                        int startsemi = this.index;
                        int semi = -1;
                        do {
                            if ((semi = GenericSignatureParser.this.signature.indexOf(59, startsemi + 1)) < 0) {
                                throw new IllegalArgumentException(new StringBuffer().append("Invalid method signature: ").append(GenericSignatureParser.this.signature).toString());
                            }
                            tmp = GenericSignatureParser.this.signature.substring(this.index, semi + 1);
                            startsemi = semi;
                        } while (tmp.split("<").length != tmp.split(">").length);
                        result.append(tmp);
                        this.index = semi + 1;
                        break;
                    }
                    case '+': 
                    case '-': 
                    case '[': {
                        result.append(GenericSignatureParser.this.signature.charAt(this.index));
                        ++this.index;
                        done = false;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(new StringBuffer().append("Invalid method signature: ").append(GenericSignatureParser.this.signature).toString());
                    }
                }
            } while (!done);
            return result.toString();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }
    }
}

