/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ForwardDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReturnInstruction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockAnalysis
extends ForwardDataflowAnalysis<LockSet> {
    private static final boolean DEBUG = SystemProperties.getBoolean("la.debug");
    private MethodGen methodGen;
    private ValueNumberDataflow vnaDataflow;
    private ValueNumberAnalysis vna;
    private boolean isSynchronized;
    private boolean isStatic;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$LockAnalysis;

    public LockAnalysis(MethodGen methodGen, ValueNumberDataflow vnaDataflow, DepthFirstSearch dfs) {
        super(dfs);
        this.methodGen = methodGen;
        this.vnaDataflow = vnaDataflow;
        this.vna = (ValueNumberAnalysis)vnaDataflow.getAnalysis();
        this.isSynchronized = methodGen.isSynchronized();
        this.isStatic = methodGen.isStatic();
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Analyzing Locks in ").append(methodGen.getClassName()).append(".").append(methodGen.getName()).toString());
        }
    }

    @Override
    public LockSet createFact() {
        return new LockSet();
    }

    @Override
    public void copy(LockSet source, LockSet dest) {
        dest.copyFrom(source);
    }

    @Override
    public void initEntryFact(LockSet result) {
        result.clear();
        result.setDefaultLockCount(0);
        if (this.isSynchronized && !this.isStatic) {
            ValueNumber thisValue = this.vna.getThisValue();
            result.setLockCount(thisValue.getNumber(), 1);
        } else if (this.isSynchronized && this.isStatic) {
            ValueNumber thisValue = this.vna.getClassObjectValue(this.methodGen.getClassName());
            result.setLockCount(thisValue.getNumber(), 1);
        }
    }

    @Override
    public void initResultFact(LockSet result) {
        result.clear();
        result.setDefaultLockCount(-1);
    }

    @Override
    public void makeFactTop(LockSet fact) {
        fact.clear();
        fact.setDefaultLockCount(-1);
    }

    @Override
    public boolean isTop(LockSet fact) {
        return fact.isTop();
    }

    @Override
    public boolean same(LockSet fact1, LockSet fact2) {
        return fact1.sameAs(fact2);
    }

    @Override
    public void meetInto(LockSet fact, Edge edge, LockSet result) throws DataflowAnalysisException {
        result.meetWith(fact);
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, LockSet fact) throws DataflowAnalysisException {
        Instruction ins = handle.getInstruction();
        short opcode = ins.getOpcode();
        if (opcode == 194 || opcode == 195) {
            ValueNumberFrame frame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(new Location(handle, basicBlock));
            if (frame.isValid()) {
                int lockNumber = ((ValueNumber)frame.getTopValue()).getNumber();
                this.lockOp(fact, lockNumber, opcode == 194 ? 1 : -1);
            }
        } else if (ins instanceof ReturnInstruction && this.isSynchronized && !this.isStatic) {
            this.lockOp(fact, this.vna.getThisValue().getNumber(), -1);
        }
    }

    private void lockOp(LockSet fact, int lockNumber, int delta) {
        int value = fact.getLockCount(lockNumber);
        if (value < 0) {
            return;
        }
        if ((value += delta) < 0) {
            value = -2;
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Setting ").append(lockNumber).append(" to ").append(value).append(" in ").append(this.methodGen.getClassName()).append(".").append(this.methodGen.getName()).toString());
        }
        fact.setLockCount(lockNumber, value);
    }

    @Override
    public boolean isFactValid(LockSet fact) {
        return true;
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$ba$LockAnalysis == null ? (class$edu$umd$cs$findbugs$ba$LockAnalysis = LockAnalysis.class$("edu.umd.cs.findbugs.ba.LockAnalysis")) : class$edu$umd$cs$findbugs$ba$LockAnalysis).getName()).append(" <classfile>").toString());
            System.exit(1);
        }
        DataflowTestDriver<LockSet, LockAnalysis> driver = new DataflowTestDriver<LockSet, LockAnalysis>(){

            @Override
            public Dataflow<LockSet, LockAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                return classContext.getLockDataflow(method);
            }
        };
        driver.execute(argv[0]);
    }

    @Override
    public /* synthetic */ boolean isFactValid(Object x0) {
        return this.isFactValid((LockSet)x0);
    }

    @Override
    public /* synthetic */ void transferInstruction(InstructionHandle x0, BasicBlock x1, Object x2) throws DataflowAnalysisException {
        this.transferInstruction(x0, x1, (LockSet)x2);
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((LockSet)x0, x1, (LockSet)x2);
    }

    @Override
    public /* synthetic */ boolean same(Object x0, Object x1) {
        return this.same((LockSet)x0, (LockSet)x1);
    }

    @Override
    public /* synthetic */ boolean isTop(Object x0) {
        return this.isTop((LockSet)x0);
    }

    @Override
    public /* synthetic */ void makeFactTop(Object x0) {
        this.makeFactTop((LockSet)x0);
    }

    @Override
    public /* synthetic */ void initResultFact(Object x0) {
        this.initResultFact((LockSet)x0);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((LockSet)x0);
    }

    @Override
    public /* synthetic */ void copy(Object x0, Object x1) {
        this.copy((LockSet)x0, (LockSet)x1);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

