/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.Monitorable;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.TableProfileManager;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ProfileResultsViewer;
import ca.sqlpower.architect.swingui.ProgressWatcher;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.architect.swingui.event.TaskTerminationEvent;
import ca.sqlpower.architect.swingui.event.TaskTerminationListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class ProfileRowComponent
extends JPanel
implements Selectable {
    private static final Logger logger = Logger.getLogger(ProfileRowComponent.class);
    private static ImageIcon tableIcon = ASUtils.createIcon("Table", "Table Result", 16);
    private static ImageIcon stopIcon;
    private static ImageIcon refreshIcon;
    private static ImageIcon deleteIcon;
    final JLabel statusLabel = new JLabel(String.format("Rows: %d   %s   Time:  %d ms", 500, "Mar 9, 2007", 15000));
    final TableProfileResult result;
    final JButton reProfileButton;
    final JButton cancelButton;
    final JButton deleteButton;
    private ProfileManager pm;
    boolean selected = false;
    List<SelectionListener> listeners = new ArrayList<SelectionListener>();

    public ProfileRowComponent(final TableProfileResult result, final ProfileManager pm) {
        super(new RowComponentLayout(5, 5));
        this.result = result;
        this.pm = pm;
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        final JProgressBar progressBar = new JProgressBar();
        this.setBackground(Color.WHITE);
        this.add((Component)new JLabel(tableIcon), (Object)ComponentType.ICON);
        this.reProfileButton = new JButton(refreshIcon);
        this.reProfileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (result.isCancelled()) {
                    result.setCancelled(false);
                    progressBar.setVisible(true);
                    ProgressWatcher watcher = new ProgressWatcher(progressBar, (Monitorable)result);
                    ProfileRowComponent.this.add((Component)progressBar, (Object)ComponentType.PROGRESS_BAR);
                    ProfileRowComponent.this.revalidate();
                    watcher.addTaskTerminationListener(new ResultTaskTerminationListener());
                    result.populate();
                }
                logger.debug((Object)"REFRESH");
            }
        });
        this.cancelButton = new JButton(stopIcon);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                result.setCancelled(true);
                ProfileRowComponent.this.statusLabel.setVisible(true);
                ProfileRowComponent.this.statusLabel.setText("Cancelled");
                ProfileRowComponent.this.remove(ProfileRowComponent.this.cancelButton);
                ProfileRowComponent.this.add((Component)ProfileRowComponent.this.deleteButton, (Object)ComponentType.DELETE);
                progressBar.setVisible(false);
                ProfileRowComponent.this.reProfileButton.setVisible(true);
                logger.debug((Object)"STOP");
            }
        });
        this.deleteButton = new JButton(deleteIcon);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                logger.debug((Object)("ProfileRowComponent: DELETE object: " + result));
                pm.removeProfile(result);
            }
        });
        this.add((Component)new JLabel(((SQLTable)result.getProfiledObject()).getName()), (Object)ComponentType.TABLE_NAME);
        this.add((Component)this.reProfileButton, (Object)ComponentType.RELOAD);
        this.reProfileButton.setVisible(false);
        ProgressWatcher watcher = new ProgressWatcher(progressBar, (Monitorable)result);
        this.add((Component)progressBar, (Object)ComponentType.PROGRESS_BAR);
        watcher.addTaskTerminationListener(new ResultTaskTerminationListener());
        this.statusLabel.setVisible(false);
        this.add((Component)this.statusLabel, (Object)ComponentType.TABLE_INFO);
        this.add((Component)this.cancelButton, (Object)ComponentType.CANCEL);
        this.addMouseListener(new ProfileRowMouseListener());
    }

    public TableProfileResult getResult() {
        return this.result;
    }

    public void setSelected(boolean v, int selectionType) {
        this.selected = v;
        this.setBackground(this.selected ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("List.background"));
        this.fireSelectionEvent(new SelectionEvent(this, this.selected ? 1 : 2, selectionType));
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void addSelectionListener(SelectionListener l) {
        this.listeners.add(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.listeners.remove(l);
    }

    public void fireSelectionEvent(SelectionEvent e) {
        for (SelectionListener listener : this.listeners) {
            if (e.getType() == 1) {
                listener.itemSelected(e);
                continue;
            }
            listener.itemDeselected(e);
        }
    }

    static {
        refreshIcon = ASUtils.createJLFIcon("general/Refresh", "Re-Profile", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24));
        stopIcon = ASUtils.createJLFIcon("general/Stop", "Stop Profile", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24));
        deleteIcon = ASUtils.createJLFIcon("general/Delete", "Delete Profile", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24));
    }

    private class ResultTaskTerminationListener
    implements TaskTerminationListener {
        private ResultTaskTerminationListener() {
        }

        public void taskFinished(TaskTerminationEvent e) {
            ProfileRowComponent.this.reProfileButton.setVisible(true);
            ProfileRowComponent.this.remove(ProfileRowComponent.this.cancelButton);
            ProfileRowComponent.this.add((Component)ProfileRowComponent.this.deleteButton, (Object)ComponentType.DELETE);
            if (!ProfileRowComponent.this.result.isCancelled()) {
                ProfileRowComponent.this.statusLabel.setVisible(true);
                ProfileRowComponent.this.statusLabel.setText(ProfileRowComponent.this.result.toString());
            }
        }
    }

    private class ProfileRowMouseListener
    extends MouseAdapter {
        private ProfileRowMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            Object obj = evt.getSource();
            if (evt.getButton() == 1) {
                if (evt.getClickCount() == 2) {
                    if (ProfileRowComponent.this.getResult().isFinished() && !ProfileRowComponent.this.getResult().isCancelled() && !(obj instanceof JButton)) {
                        ProfileResultsViewer profileResultsViewer = new ProfileResultsViewer((TableProfileManager)ProfileRowComponent.this.pm);
                        profileResultsViewer.clearScanList();
                        profileResultsViewer.addTableProfileResultToScan(ProfileRowComponent.this.result);
                        profileResultsViewer.addTableProfileResult(ProfileRowComponent.this.result);
                        profileResultsViewer.getDialog().setVisible(true);
                    }
                } else if ((evt.getModifiers() & 2) != 0) {
                    ProfileRowComponent.this.setSelected(!ProfileRowComponent.this.selected, 8);
                } else if ((evt.getModifiers() & 1) != 0) {
                    ProfileRowComponent.this.setSelected(true, 16);
                } else {
                    ProfileRowComponent.this.setSelected(true, 4);
                }
            }
        }
    }

    private static class RowComponentLayout
    implements LayoutManager2 {
        private int xGap;
        private int yGap;
        private Component icon;
        private Component tableName;
        private Component tableInfo;
        private Component progressBar;
        private Component reload;
        private Component cancel;
        private Component delete;

        public RowComponentLayout(int xGap, int yGap) {
            logger.debug((Object)"RowComponentLayout constructed");
            this.xGap = xGap;
            this.yGap = yGap;
        }

        public void addLayoutComponent(Component comp, Object constraints) {
            ComponentType type = (ComponentType)((Object)constraints);
            switch (type) {
                case ICON: {
                    this.icon = comp;
                    break;
                }
                case TABLE_NAME: {
                    this.tableName = comp;
                    break;
                }
                case TABLE_INFO: {
                    this.tableInfo = comp;
                    break;
                }
                case PROGRESS_BAR: {
                    this.progressBar = comp;
                    break;
                }
                case RELOAD: {
                    this.reload = comp;
                    break;
                }
                case CANCEL: {
                    this.cancel = comp;
                    break;
                }
                case DELETE: {
                    this.delete = comp;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown constraint given to RowCompnentLayout");
                }
            }
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }

        public Dimension maximumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        public void addLayoutComponent(String name, Component comp) {
            this.addLayoutComponent(comp, name);
        }

        public void layoutContainer(Container parent) {
            int y;
            int x;
            Dimension preferredSize;
            logger.debug((Object)"layoutContainer called");
            JComponent p = (JComponent)parent;
            Insets inset = p.getBorder().getBorderInsets(p);
            int height = parent.getHeight() + inset.top;
            int width = parent.getWidth() + inset.left;
            int stretchyPreferredWidth = width - inset.left - inset.right - 3 * this.xGap - this.icon.getPreferredSize().width - 2 * this.reload.getPreferredSize().width;
            if (this.icon != null) {
                preferredSize = this.icon.getPreferredSize();
                x = inset.left;
                y = height / 2 - preferredSize.height / 2;
                this.icon.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
            if (this.tableName != null) {
                preferredSize = new Dimension(stretchyPreferredWidth, this.tableName.getPreferredSize().height);
                x = inset.left + this.icon.getPreferredSize().width + this.xGap;
                y = height / 2 - this.yGap / 2 - preferredSize.height;
                this.tableName.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
            if (this.tableInfo != null) {
                preferredSize = new Dimension(stretchyPreferredWidth, this.tableInfo.getPreferredSize().height);
                x = inset.left + this.icon.getPreferredSize().width + this.xGap;
                y = height / 2 + this.yGap / 2;
                this.tableInfo.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
            if (this.progressBar != null) {
                preferredSize = new Dimension(stretchyPreferredWidth, this.progressBar.getPreferredSize().height);
                x = inset.left + this.icon.getPreferredSize().width + this.xGap;
                y = height / 2 + this.yGap / 2;
                this.progressBar.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
            if (this.delete != null) {
                preferredSize = this.delete.getPreferredSize();
                x = width - inset.right - preferredSize.width;
                y = height / 2 - preferredSize.height / 2;
                this.delete.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
            if (this.cancel != null) {
                preferredSize = this.cancel.getPreferredSize();
                x = width - inset.right - preferredSize.width;
                y = height / 2 - preferredSize.height / 2;
                this.cancel.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
            if (this.reload != null) {
                preferredSize = this.reload.getPreferredSize();
                x = width - inset.right - this.cancel.getPreferredSize().width - this.xGap - preferredSize.width;
                y = height / 2 - preferredSize.height / 2;
                this.reload.setBounds(x, y, preferredSize.width, preferredSize.height);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(this.icon.getMinimumSize().width + 3 * this.xGap + Math.max(this.progressBar.getMinimumSize().width, this.tableName.getMinimumSize().width) + 2 * this.reload.getMinimumSize().width, this.tableName.getMinimumSize().height + this.yGap + this.progressBar.getMinimumSize().height);
        }

        public Dimension preferredLayoutSize(Container parent) {
            JComponent p = (JComponent)parent;
            Insets inset = p.getBorder().getBorderInsets(p);
            int maxOfBarAndInfo = Math.max(this.progressBar.getPreferredSize().width, this.tableInfo.getPreferredSize().width);
            return new Dimension(this.icon.getPreferredSize().width + 3 * this.xGap + Math.max(maxOfBarAndInfo, this.tableName.getPreferredSize().width) + 2 * this.reload.getPreferredSize().width + inset.left + inset.right, this.tableName.getPreferredSize().height + this.yGap + this.progressBar.getPreferredSize().height + inset.top + inset.bottom);
        }

        public void removeLayoutComponent(Component comp) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ComponentType {
        ICON,
        TABLE_NAME,
        TABLE_INFO,
        PROGRESS_BAR,
        RELOAD,
        CANCEL,
        DELETE;

    }
}

