/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLIndex;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.util.table.CleanupTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexColumnTableModel
extends AbstractTableModel
implements CleanupTableModel {
    private final SQLIndex index;
    private final SQLTable table;
    private List<SQLColumn> usedColumns = null;
    private IndexListener listener = new IndexListener();

    public IndexColumnTableModel(SQLIndex index, SQLTable table) {
        if (table == null) {
            throw new NullPointerException();
        }
        index.addSQLObjectListener(this.listener);
        this.index = index;
        this.table = table;
    }

    public SQLIndex getIndex() {
        return this.index;
    }

    public List<SQLColumn> getUsedColumns() throws ArchitectException {
        this.usedColumns = new ArrayList<SQLColumn>();
        for (SQLIndex.Column c : this.index.getChildren()) {
            if (c.getColumn() == null) continue;
            this.usedColumns.add(c.getColumn());
        }
        return this.usedColumns;
    }

    public void cleanup() {
        this.index.removeSQLObjectListener(this.listener);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return IndexColumnTableColumns.values()[columnIndex].columnClass;
    }

    @Override
    public int getColumnCount() {
        return IndexColumnTableColumns.values().length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return IndexColumnTableColumns.values()[columnIndex].getName();
    }

    private IndexColumnTableColumns getColumnInfo(int columnIndex) {
        return IndexColumnTableColumns.values()[columnIndex];
    }

    @Override
    public int getRowCount() {
        try {
            return this.index.getChildCount();
        }
        catch (ArchitectException e) {
            throw new ArchitectRuntimeException(e);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SQLIndex.Column c;
        try {
            c = this.index.getChild(rowIndex);
        }
        catch (ArchitectException e) {
            throw new ArchitectRuntimeException(e);
        }
        IndexColumnTableColumns tableColumnInfo = this.getColumnInfo(columnIndex);
        if (tableColumnInfo == IndexColumnTableColumns.COLUMN) {
            return c.getColumn();
        }
        if (tableColumnInfo == IndexColumnTableColumns.ASC) {
            return c.isAscending();
        }
        if (tableColumnInfo == IndexColumnTableColumns.DESC) {
            return c.isDescending();
        }
        if (tableColumnInfo == IndexColumnTableColumns.NAME) {
            return c.getName();
        }
        throw new ArchitectRuntimeException(new ArchitectException("Someone forgot to implement a getValue for " + (Object)((Object)tableColumnInfo)));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SQLIndex.Column c;
        try {
            c = this.index.getChild(rowIndex);
        }
        catch (ArchitectException e) {
            throw new ArchitectRuntimeException(e);
        }
        IndexColumnTableColumns tableColumnInfo = this.getColumnInfo(columnIndex);
        if (tableColumnInfo == IndexColumnTableColumns.COLUMN) {
            c.setColumn((SQLColumn)aValue);
        } else if (tableColumnInfo == IndexColumnTableColumns.ASC) {
            c.setAscending((Boolean)aValue);
        } else if (tableColumnInfo == IndexColumnTableColumns.DESC) {
            c.setDescending((Boolean)aValue);
        } else if (tableColumnInfo == IndexColumnTableColumns.NAME) {
            c.setName((String)aValue);
        } else {
            throw new ArchitectRuntimeException(new ArchitectException("Someone forgot to implement a setValue for " + (Object)((Object)tableColumnInfo)));
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public SQLTable getTable() {
        return this.table;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndexColumnTableColumns {
        NAME("Expression", String.class),
        COLUMN("Index Column", SQLColumn.class),
        ASC("ASC", Boolean.class),
        DESC("DESC", Boolean.class);

        String name;
        Class columnClass;

        private IndexColumnTableColumns(String name, Class t) {
            this.name = name;
            this.columnClass = t;
        }

        public String getName() {
            return this.name;
        }
    }

    private class IndexListener
    implements SQLObjectListener {
        private IndexListener() {
        }

        public void dbChildrenInserted(SQLObjectEvent e) {
            if (e.getChangedIndices().length > 1) {
                IndexColumnTableModel.this.fireTableStructureChanged();
            } else {
                IndexColumnTableModel.this.fireTableRowsInserted(e.getChangedIndices()[0], e.getChangedIndices()[0]);
            }
        }

        public void dbChildrenRemoved(SQLObjectEvent e) {
            if (e.getChangedIndices().length > 1) {
                IndexColumnTableModel.this.fireTableStructureChanged();
            } else {
                IndexColumnTableModel.this.fireTableRowsDeleted(e.getChangedIndices()[0], e.getChangedIndices()[0]);
            }
        }

        public void dbObjectChanged(SQLObjectEvent e) {
            if (e.getChangedIndices().length > 1) {
                IndexColumnTableModel.this.fireTableStructureChanged();
            } else {
                IndexColumnTableModel.this.fireTableRowsUpdated(e.getChangedIndices()[0], e.getChangedIndices()[0]);
            }
        }

        public void dbStructureChanged(SQLObjectEvent e) {
            IndexColumnTableModel.this.fireTableStructureChanged();
        }
    }
}

