/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLExceptionNode;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.profile.ProfileChangeEvent;
import ca.sqlpower.architect.profile.ProfileChangeListener;
import ca.sqlpower.architect.profile.ProfileResult;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBTreeModel
implements TreeModel,
SQLObjectListener,
Serializable {
    private static Logger logger = Logger.getLogger(DBTreeModel.class);
    private boolean testMode = false;
    protected SQLObject root = new DBTreeRoot();
    private final ArchitectSession session;
    protected LinkedList treeModelListeners;

    public DBTreeModel(ArchitectSession session) throws ArchitectException {
        this(null, session);
    }

    public DBTreeModel(Collection<SQLDatabase> initialDatabases, ArchitectSession session) throws ArchitectException {
        this.session = session;
        if (initialDatabases != null) {
            Iterator<SQLDatabase> it = initialDatabases.iterator();
            while (it.hasNext()) {
                this.root.addChild(it.next());
            }
        }
        this.treeModelListeners = new LinkedList();
        ArchitectUtils.listenToHierarchy((SQLObjectListener)this, this.root);
        session.getProfileManager().addProfileChangeListener(new ProfileChangeListener(){

            public void profileListChanged(ProfileChangeEvent event) {
            }

            public void profilesAdded(ProfileChangeEvent e) {
                for (ProfileResult pr : e.getProfileResult()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Removing profile " + pr));
                    }
                    SQLObjectEvent soe = new SQLObjectEvent((SQLObject)pr.getProfiledObject(), "profile");
                    DBTreeModel.this.processSQLObjectChanged(soe);
                }
            }

            public void profilesRemoved(ProfileChangeEvent e) {
                for (ProfileResult pr : e.getProfileResult()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Removing profile " + pr));
                    }
                    SQLObjectEvent soe = new SQLObjectEvent((SQLObject)pr.getProfiledObject(), "profile");
                    DBTreeModel.this.processSQLObjectChanged(soe);
                }
            }
        });
    }

    @Override
    public Object getRoot() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DBTreeModel.getRoot: returning " + this.root));
        }
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DBTreeModel.getChild(" + parent + "," + index + ")"));
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("returning " + ((SQLObject)parent).getChild(index)));
            }
            return ((SQLObject)parent).getChild(index);
        }
        catch (Exception e) {
            SQLExceptionNode fakeChild = this.putExceptionNodeUnder((SQLObject)parent, e);
            return fakeChild;
        }
    }

    @Override
    public int getChildCount(Object parent) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DBTreeModel.getChildCount(" + parent + ")"));
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("returning " + ((SQLObject)parent).getChildCount()));
            }
            return ((SQLObject)parent).getChildCount();
        }
        catch (Exception e) {
            this.putExceptionNodeUnder((SQLObject)parent, e);
            return 1;
        }
    }

    @Override
    public boolean isLeaf(Object parent) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DBTreeModel.isLeaf(" + parent + "): returning " + !((SQLObject)parent).allowsChildren()));
        }
        return !((SQLObject)parent).allowsChildren();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("model doesn't support editting yet");
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DBTreeModel.getIndexOfChild(" + parent + "," + child + "): returning " + ((SQLObject)parent).getChildren().indexOf(child)));
            }
            return ((SQLObject)parent).getChildren().indexOf(child);
        }
        catch (ArchitectException e) {
            throw new ArchitectRuntimeException(e);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    protected void fireTreeNodesInserted(TreeModelEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Firing treeNodesInserted event: " + e));
        }
        final TreeModelEvent ev = e;
        Runnable notifier = new Runnable(){

            public void run() {
                Iterator it = DBTreeModel.this.treeModelListeners.iterator();
                while (it.hasNext()) {
                    ((TreeModelListener)it.next()).treeNodesInserted(ev);
                }
            }
        };
        notifier.run();
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Firing treeNodesRemoved event " + e));
        }
        final TreeModelEvent ev = e;
        Runnable notifier = new Runnable(){

            public void run() {
                Iterator it = DBTreeModel.this.treeModelListeners.iterator();
                while (it.hasNext()) {
                    ((TreeModelListener)it.next()).treeNodesRemoved(ev);
                }
            }
        };
        notifier.run();
    }

    protected void fireTreeNodesChanged(TreeModelEvent e) {
        final TreeModelEvent ev = e;
        Runnable notifier = new Runnable(){

            public void run() {
                Iterator it = DBTreeModel.this.treeModelListeners.iterator();
                while (it.hasNext()) {
                    ((TreeModelListener)it.next()).treeNodesChanged(ev);
                }
            }
        };
        notifier.run();
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        logger.debug((Object)("firing TreeStructuredChanged. source=" + e.getSource()));
        final TreeModelEvent ev = e;
        Runnable notifier = new Runnable(){

            public void run() {
                Iterator it = DBTreeModel.this.treeModelListeners.iterator();
                while (it.hasNext()) {
                    ((TreeModelListener)it.next()).treeStructureChanged(ev);
                }
            }
        };
        notifier.run();
    }

    public SQLObject[] getPathToNode(SQLObject node) {
        if (node instanceof SQLRelationship) {
            throw new IllegalArgumentException("This method does not work for SQLRelationship. Use getPkPathToRelationship() and getFkPathToRelationship() instead.");
        }
        LinkedList<SQLObject> path = new LinkedList<SQLObject>();
        while (node != null && node != this.root) {
            path.add(0, node);
            node = node.getParent();
        }
        path.add(0, this.root);
        return path.toArray(new SQLObject[path.size()]);
    }

    public SQLObject[] getPkPathToRelationship(SQLRelationship rel) {
        SQLObject[] pathToPkTable = this.getPathToNode(rel.getPkTable());
        SQLObject[] path = new SQLObject[pathToPkTable.length + 2];
        System.arraycopy(pathToPkTable, 0, path, 0, pathToPkTable.length);
        path[path.length - 2] = rel.getPkTable().getExportedKeysFolder();
        path[path.length - 1] = rel;
        return path;
    }

    public SQLObject[] getFkPathToRelationship(SQLRelationship rel) {
        SQLObject[] pathToFkTable = this.getPathToNode(rel.getFkTable());
        SQLObject[] path = new SQLObject[pathToFkTable.length + 2];
        System.arraycopy(pathToFkTable, 0, path, 0, pathToFkTable.length);
        path[path.length - 2] = rel.getFkTable().getImportedKeysFolder();
        path[path.length - 1] = rel;
        return path;
    }

    protected SQLExceptionNode putExceptionNodeUnder(SQLObject parent, Throwable ex) {
        logger.info((Object)("Adding exception node under " + parent), ex);
        String message = ex.getMessage();
        Throwable cause = ex;
        while (cause.getCause() != null) {
            if ((cause = cause.getCause()).getMessage() == null || cause.getMessage().length() <= 0) continue;
            message = cause.getMessage();
        }
        if (message == null || message.length() == 0) {
            message = "Check application log for details";
        }
        SQLExceptionNode excNode = new SQLExceptionNode(ex, message);
        excNode.setParent(parent);
        try {
            parent.getChildCount();
        }
        catch (ArchitectException e) {
            logger.error((Object)"Couldn't populate parent node of exception");
        }
        try {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                parent.removeChild(0);
            }
            parent.addChild(excNode);
        }
        catch (ArchitectException e) {
            logger.error((Object)("Couldn't add SQLExceptionNode \"" + excNode.getName() + "\" to tree model:"), (Throwable)e);
            JOptionPane.showMessageDialog(null, "Failed to add SQLExceptionNode:\n" + e.getMessage());
        }
        return excNode;
    }

    @Override
    public void dbChildrenInserted(SQLObjectEvent e) {
        TreeModelEvent tme;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dbChildrenInserted. source=" + e.getSource() + " indices: " + Arrays.asList(new int[][]{e.getChangedIndices()}) + " children: " + Arrays.asList(e.getChildren())));
        }
        if (logger.isDebugEnabled()) {
            if (e.getSQLSource() instanceof SQLRelationship) {
                SQLRelationship r = (SQLRelationship)e.getSQLSource();
                logger.debug((Object)("dbChildrenInserted SQLObjectEvent: " + e + "; pk path=" + Arrays.asList(this.getPkPathToRelationship(r)) + "; fk path=" + Arrays.asList(this.getFkPathToRelationship(r))));
            } else {
                logger.debug((Object)("dbChildrenInserted SQLObjectEvent: " + e + "; tree path=" + Arrays.asList(this.getPathToNode(e.getSQLSource()))));
            }
        }
        try {
            SQLObject[] newEventSources = e.getChildren();
            for (int i = 0; i < newEventSources.length; ++i) {
                ArchitectUtils.listenToHierarchy((SQLObjectListener)this, newEventSources[i]);
            }
        }
        catch (ArchitectException ex) {
            logger.error((Object)"Error listening to added object", (Throwable)ex);
        }
        if (!SwingUtilities.isEventDispatchThread() && !this.testMode) {
            logger.debug((Object)"Not refiring because this is not the EDT.");
            return;
        }
        if (e.getSQLSource() instanceof SQLRelationship) {
            tme = new TreeModelEvent((Object)this, this.getPkPathToRelationship((SQLRelationship)e.getSQLSource()), e.getChangedIndices(), (Object[])e.getChildren());
            this.fireTreeNodesInserted(tme);
            tme = new TreeModelEvent((Object)this, this.getFkPathToRelationship((SQLRelationship)e.getSQLSource()), e.getChangedIndices(), (Object[])e.getChildren());
            this.fireTreeNodesInserted(tme);
        } else {
            tme = new TreeModelEvent((Object)this, this.getPathToNode(e.getSQLSource()), e.getChangedIndices(), (Object[])e.getChildren());
            this.fireTreeNodesInserted(tme);
        }
    }

    @Override
    public void dbChildrenRemoved(SQLObjectEvent e) {
        TreeModelEvent tme;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dbchildrenremoved. source=" + e.getSource() + " indices: " + Arrays.asList(new int[][]{e.getChangedIndices()}) + " children: " + Arrays.asList(e.getChildren())));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dbChildrenRemoved SQLObjectEvent: " + e));
        }
        try {
            SQLObject[] oldEventSources = e.getChildren();
            for (int i = 0; i < oldEventSources.length; ++i) {
                ArchitectUtils.unlistenToHierarchy((SQLObjectListener)this, oldEventSources[i]);
            }
        }
        catch (ArchitectException ex) {
            logger.error((Object)"Error unlistening to removed object", (Throwable)ex);
        }
        if (!SwingUtilities.isEventDispatchThread() && !this.testMode) {
            logger.debug((Object)"Not refiring because this is not the EDT.");
            return;
        }
        if (e.getSQLSource() instanceof SQLRelationship) {
            tme = new TreeModelEvent((Object)this, this.getPkPathToRelationship((SQLRelationship)e.getSQLSource()), e.getChangedIndices(), (Object[])e.getChildren());
            this.fireTreeNodesRemoved(tme);
            tme = new TreeModelEvent((Object)this, this.getFkPathToRelationship((SQLRelationship)e.getSQLSource()), e.getChangedIndices(), (Object[])e.getChildren());
            this.fireTreeNodesRemoved(tme);
        } else {
            tme = new TreeModelEvent((Object)this, this.getPathToNode(e.getSQLSource()), e.getChangedIndices(), (Object[])e.getChildren());
            this.fireTreeNodesRemoved(tme);
        }
    }

    @Override
    public void dbObjectChanged(SQLObjectEvent e) {
        logger.debug((Object)("dbObjectChanged. source=" + e.getSource()));
        if (!SwingUtilities.isEventDispatchThread() && !this.testMode) {
            logger.debug((Object)"Not refiring because this is not the EDT.");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dbObjectChanged SQLObjectEvent: " + e));
        }
        this.processSQLObjectChanged(e);
    }

    private void processSQLObjectChanged(SQLObjectEvent e) {
        SQLObject source;
        if (e.getPropertyName().equals("name") && !e.getNewValue().equals(e.getSQLSource().getName())) {
            logger.error((Object)("Name change event has wrong new value. new=" + e.getNewValue() + "; real=" + e.getSQLSource().getName()));
        }
        if ((source = e.getSQLSource()) instanceof SQLRelationship) {
            SQLRelationship r = (SQLRelationship)source;
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.getPkPathToRelationship(r)));
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.getFkPathToRelationship(r)));
        } else {
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.getPathToNode(source)));
        }
    }

    @Override
    public void dbStructureChanged(SQLObjectEvent e) {
        logger.debug((Object)("dbStructureChanged. source=" + e.getSource()));
        try {
            ArchitectUtils.listenToHierarchy((SQLObjectListener)this, e.getSQLSource());
        }
        catch (ArchitectException ex) {
            logger.error((Object)("Couldn't listen to hierarchy rooted at " + e.getSQLSource()), (Throwable)ex);
        }
        if (!SwingUtilities.isEventDispatchThread() && !this.testMode) {
            logger.debug((Object)"Not refiring because this is not the EDT.");
            return;
        }
        TreeModelEvent tme = new TreeModelEvent((Object)this, this.getPathToNode(e.getSQLSource()));
        this.fireTreeStructureChanged(tme);
    }

    public void setTestMode(boolean v) {
        this.testMode = v;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DBTreeRoot
    extends SQLObject {
        public DBTreeRoot() {
            this.children = new LinkedList();
        }

        @Override
        public SQLObject getParent() {
            return null;
        }

        @Override
        protected void setParent(SQLObject newParent) {
        }

        @Override
        public String getName() {
            return this.getShortDisplayName();
        }

        @Override
        public String getShortDisplayName() {
            return "Database Connections";
        }

        @Override
        public boolean allowsChildren() {
            return true;
        }

        @Override
        public void populate() throws ArchitectException {
        }

        @Override
        public boolean isPopulated() {
            return true;
        }

        public String toString() {
            return this.getShortDisplayName();
        }

        @Override
        public Class<? extends SQLObject> getChildType() {
            return SQLDatabase.class;
        }
    }
}

