/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectDataSourceType;
import ca.sqlpower.architect.DataSourceCollection;
import ca.sqlpower.architect.swingui.ArchitectDataSourceTypeListCellRenderer;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.PlatformSpecificConnectionOptionPanel;
import ca.sqlpower.architect.swingui.TextPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class DBCSPanel
extends JPanel
implements ArchitectPanel {
    private static final Logger logger = Logger.getLogger(DBCSPanel.class);
    private ArchitectDataSource dbcs;
    private TextPanel form;
    private JTextField dbNameField;
    private JComboBox dataSourceTypeBox;
    private PlatformSpecificConnectionOptionPanel platformSpecificOptions;
    private JTextField dbUrlField;
    private JTextField dbUserField;
    private JPasswordField dbPassField;
    private JTextField plSchemaField;
    private JTextField plDbTypeField;
    private JTextField odbcDSNField;

    public DBCSPanel(DataSourceCollection dsCollection) {
        this.setLayout(new BorderLayout());
        List<ArchitectDataSourceType> dataSourceTypes = dsCollection.getDataSourceTypes();
        dataSourceTypes.add(0, new ArchitectDataSourceType());
        this.dataSourceTypeBox = new JComboBox<Object>(dataSourceTypes.toArray());
        this.dataSourceTypeBox.setRenderer(new ArchitectDataSourceTypeListCellRenderer());
        this.dataSourceTypeBox.setSelectedIndex(0);
        this.dbNameField = new JTextField();
        this.dbNameField.setName("dbNameField");
        this.dbUrlField = new JTextField();
        this.platformSpecificOptions = new PlatformSpecificConnectionOptionPanel(this.dbUrlField);
        JComponent[] jComponentArray = new JComponent[9];
        jComponentArray[0] = this.dbNameField;
        jComponentArray[1] = this.dataSourceTypeBox;
        jComponentArray[2] = this.platformSpecificOptions.getPanel();
        jComponentArray[3] = this.dbUrlField;
        this.dbUserField = new JTextField();
        jComponentArray[4] = this.dbUserField;
        this.dbPassField = new JPasswordField();
        jComponentArray[5] = this.dbPassField;
        this.plSchemaField = new JTextField();
        jComponentArray[6] = this.plSchemaField;
        this.plDbTypeField = new JTextField();
        jComponentArray[7] = this.plDbTypeField;
        this.odbcDSNField = new JTextField();
        jComponentArray[8] = this.odbcDSNField;
        JComponent[] fields = jComponentArray;
        String[] labels = new String[]{"Connection Name", "Database Type", "Connect Options", "JDBC URL", "Username", "Password", "PL Schema Owner", "Database Type", "ODBC Data Source Name"};
        char[] mnemonics = new char[]{'n', 'd', 'o', 'u', 'r', 'p', 's', 't', 'b'};
        int[] widths = new int[]{40, 40, 40, 40, 40, 40, 40, 40, 40};
        String[] tips = new String[]{"Your nickname for this database", "The database type (set up in user preferences)", "Connection parameters specific to this driver", "Vendor-specific JDBC URL", "Username for this database", "Password for this database", "Qualifier to put before references to PL system tables", "The Power*Loader type code for this database", "The ODBC data source name for this database"};
        this.dataSourceTypeBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ArchitectDataSourceType parentType = (ArchitectDataSourceType)DBCSPanel.this.dataSourceTypeBox.getSelectedItem();
                DBCSPanel.this.platformSpecificOptions.setTemplate(parentType.getJdbcUrl());
                DBCSPanel.this.plDbTypeField.setText(parentType.getPlDbType());
            }
        });
        this.form = new TextPanel(fields, labels, mnemonics, widths, tips);
        this.add((Component)this.form, "Center");
    }

    public boolean applyChanges() {
        String name = this.dbNameField.getText();
        this.dbcs.setName(name);
        this.dbcs.setDisplayName(name);
        this.dbcs.setParentType((ArchitectDataSourceType)this.dataSourceTypeBox.getSelectedItem());
        this.dbcs.setUrl(this.dbUrlField.getText());
        this.dbcs.setUser(this.dbUserField.getText());
        this.dbcs.setPass(new String(this.dbPassField.getPassword()));
        this.dbcs.setPlSchema(this.plSchemaField.getText());
        this.dbcs.setPlDbType(this.plDbTypeField.getText());
        this.dbcs.setOdbcDsn(this.odbcDSNField.getText());
        return true;
    }

    public void discardChanges() {
    }

    public void setDbcs(ArchitectDataSource dbcs) {
        this.dbNameField.setText(dbcs.getName());
        if (dbcs.isParentSet()) {
            System.out.println("A PARENT! setting selected item to: \"" + dbcs.getParentType() + "\"");
            this.dataSourceTypeBox.setSelectedItem(dbcs.getParentType());
        } else {
            System.out.println("NO PARENT! setting selected item to: \"" + dbcs + "\"");
            this.dataSourceTypeBox.setSelectedItem(dbcs);
        }
        this.dbUrlField.setText(dbcs.getUrl());
        this.dbUserField.setText(dbcs.getUser());
        this.dbPassField.setText(dbcs.getPass());
        this.plSchemaField.setText(dbcs.getPlSchema());
        this.plDbTypeField.setText(dbcs.getPlDbType());
        this.odbcDSNField.setText(dbcs.getOdbcDsn());
        this.dbcs = dbcs;
    }

    public ArchitectDataSource getDbcs() {
        return this.dbcs;
    }

    public JPanel getPanel() {
        return this;
    }
}

