/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.CommonCloseAction;
import ca.sqlpower.architect.swingui.JDefaultButton;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ArchitectPanelBuilder {
    static Logger logger = Logger.getLogger(ArchitectPanelBuilder.class);
    public static final String OK_BUTTON_LABEL = "OK";
    public static final String CANCEL_BUTTON_LABEL = "Cancel";

    public static JDialog makeOwnedDialog(Component owningComponent, String title) {
        Window owner = SwingUtilities.getWindowAncestor(owningComponent);
        if (owner instanceof Frame) {
            return new JDialog((Frame)owner, title);
        }
        if (owner instanceof Dialog) {
            return new JDialog((Dialog)owner, title);
        }
        JDialog d = new JDialog();
        d.setTitle(title);
        d.setAlwaysOnTop(true);
        return d;
    }

    public static JDialog createArchitectPanelDialog(ArchitectPanel arch, Window dialogParent, String dialogTitle, String actionButtonTitle, Action okAction, Action cancelAction) {
        JDialog d;
        if (dialogParent == null) {
            d = new JDialog();
            ArchitectPanelBuilder.warnAboutNullParentedDialog();
        } else if (dialogParent instanceof Frame) {
            d = new JDialog((Frame)dialogParent, dialogTitle);
        } else if (dialogParent instanceof Dialog) {
            d = new JDialog((Dialog)dialogParent, dialogTitle);
        } else {
            throw new IllegalArgumentException("The dialogParent you gave me is not a Frame or Dialog (it is a " + dialogParent.getClass().getName() + ")");
        }
        JComponent panel = arch.getPanel();
        JDefaultButton okButton = new JDefaultButton(okAction);
        okButton.setText(actionButtonTitle);
        Action closeAction = new CommonCloseAction(d);
        if (cancelAction != null) {
            closeAction = cancelAction;
        } else {
            logger.debug((Object)"WARNING using a null cancel action.  You probably want to use action so you can cleanup");
        }
        okButton.addActionListener(closeAction);
        ASUtils.makeJDialogCancellable(d, closeAction);
        okButton.addActionListener(new CommonCloseAction(d));
        JDefaultButton cancelButton = new JDefaultButton(cancelAction);
        cancelButton.setText(CANCEL_BUTTON_LABEL);
        cancelButton.addActionListener(closeAction);
        cancelButton.addActionListener(new CommonCloseAction(d));
        d.getRootPane().setDefaultButton(okButton);
        JPanel cp = new JPanel(new BorderLayout());
        cp.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        cp.add((Component)panel, "Center");
        cp.add((Component)ButtonBarFactory.buildOKCancelBar((JButton)okButton, (JButton)cancelButton), "South");
        cp.setBorder(Borders.DIALOG_BORDER);
        d.setContentPane(cp);
        d.pack();
        return d;
    }

    private static void warnAboutNullParentedDialog() {
        if (logger.isDebugEnabled()) {
            JOptionPane.showMessageDialog(null, "This action called createArchitectPanelDialog with DialogParent == null!");
        }
    }

    public static JDialog createArchitectPanelDialog(final ArchitectPanel arch, Window dialogParent, String dialogTitle, String actionButtonTitle) {
        AbstractAction okAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                arch.applyChanges();
            }
        };
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                arch.discardChanges();
            }
        };
        return ArchitectPanelBuilder.createArchitectPanelDialog(arch, dialogParent, dialogTitle, actionButtonTitle, okAction, cancelAction);
    }

    public static JDialog createSingleButtonArchitectPanelDialog(final ArchitectPanel arch, Window dialogParent, String dialogTitle, String actionButtonTitle) {
        AbstractAction okAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                arch.applyChanges();
            }
        };
        return ArchitectPanelBuilder.createSingleButtonArchitectPanelDialog(arch, dialogParent, dialogTitle, actionButtonTitle, okAction);
    }

    public static JDialog createSingleButtonArchitectPanelDialog(ArchitectPanel arch, Window dialogParent, String dialogTitle, String actionButtonTitle, Action okAction) {
        JDialog d;
        if (dialogParent == null) {
            d = new JDialog();
            ArchitectPanelBuilder.warnAboutNullParentedDialog();
        } else if (dialogParent instanceof Frame) {
            d = new JDialog((Frame)dialogParent, dialogTitle);
        } else if (dialogParent instanceof Dialog) {
            d = new JDialog((Dialog)dialogParent, dialogTitle);
        } else {
            throw new IllegalArgumentException("The dialogParent you gave me is not a Frame or Dialog (it is a " + dialogParent.getClass().getName() + ")");
        }
        JComponent panel = arch.getPanel();
        JDefaultButton okButton = new JDefaultButton(okAction);
        okButton.setText(actionButtonTitle);
        CommonCloseAction closeAction = new CommonCloseAction(d);
        okButton.addActionListener(closeAction);
        ASUtils.makeJDialogCancellable(d, closeAction);
        okButton.addActionListener(new CommonCloseAction(d));
        d.getRootPane().setDefaultButton(okButton);
        JPanel cp = new JPanel(new BorderLayout());
        cp.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        cp.add((Component)panel, "Center");
        cp.add((Component)ButtonBarFactory.buildCenteredBar((JButton)okButton), "South");
        cp.setBorder(Borders.DIALOG_BORDER);
        d.setContentPane(cp);
        d.pack();
        return d;
    }
}

