/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.LockedColumnException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLTable;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLRelationship
extends SQLObject
implements Serializable {
    private static Logger logger = Logger.getLogger(SQLRelationship.class);
    public static final int ZERO = 1;
    public static final int ONE = 2;
    public static final int MANY = 4;
    public static final int PKCOLUMN = 4;
    public static final int FKCOLUMN = 5;
    protected SQLTable pkTable;
    protected SQLTable fkTable;
    protected int updateRule;
    protected int deleteRule;
    protected int deferrability;
    protected int pkCardinality;
    protected int fkCardinality;
    protected boolean identifying;
    protected String physicalName;
    protected RelationshipManager fkColumnManager;
    private int parentCount;

    public SQLRelationship() {
        this.children = new LinkedList();
        this.pkCardinality = 2;
        this.fkCardinality = 7;
        this.fkColumnManager = new RelationshipManager();
    }

    private static String generateUniqueColumnName(SQLColumn column, SQLTable table) {
        return column.getParentTable().getName() + "_" + column.getName();
    }

    public RelationshipManager getRelationshipManager() {
        return this.fkColumnManager;
    }

    private void attachListeners() throws ArchitectException {
        ArchitectUtils.listenToHierarchy((SQLObjectListener)this.fkColumnManager, this.pkTable);
        ArchitectUtils.listenToHierarchy((SQLObjectListener)this.fkColumnManager, this.fkTable);
    }

    private void detachListeners() throws ArchitectException {
        if (this.pkTable != null) {
            ArchitectUtils.unlistenToHierarchy((SQLObjectListener)this.fkColumnManager, this.pkTable);
        }
        if (this.fkTable != null) {
            ArchitectUtils.unlistenToHierarchy((SQLObjectListener)this.fkColumnManager, this.fkTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachRelationship(SQLTable pkTable, SQLTable fkTable, boolean autoGenerateMapping) throws ArchitectException {
        if (pkTable == null) {
            throw new NullPointerException("Null pkTable not allowed");
        }
        if (fkTable == null) {
            throw new NullPointerException("Null fkTable not allowed");
        }
        SQLTable oldPkt = this.pkTable;
        SQLTable oldFkt = this.fkTable;
        this.detachListeners();
        try {
            this.pkTable = pkTable;
            this.fkTable = fkTable;
            this.fireDbObjectChanged("pkTable", oldPkt, pkTable);
            this.fireDbObjectChanged("fkTable", oldFkt, fkTable);
            fkTable.getColumnsFolder().setMagicEnabled(false);
            fkTable.getImportedKeysFolder().setMagicEnabled(false);
            pkTable.addExportedKey(this);
            fkTable.addImportedKey(this);
            if (autoGenerateMapping) {
                SQLColumn pkCol;
                ArrayList<SQLColumn> pkColListCopy = new ArrayList<SQLColumn>(pkTable.getColumns().size());
                pkColListCopy.addAll(pkTable.getColumns());
                Iterator i$ = pkColListCopy.iterator();
                while (i$.hasNext() && (pkCol = (SQLColumn)i$.next()).getPrimaryKeySeq() != null) {
                    SQLColumn fkCol;
                    SQLColumn match = fkTable.getColumnByName(pkCol.getName());
                    if (match != null) {
                        if (match.getType() == pkCol.getType() && match.getPrecision() == pkCol.getPrecision() && match.getScale() == pkCol.getScale()) {
                            fkCol = match;
                        } else {
                            fkCol = new SQLColumn(pkCol);
                            fkCol.setName(SQLRelationship.generateUniqueColumnName(pkCol, fkTable));
                            fkCol.setPrimaryKeySeq(null);
                        }
                    } else {
                        fkCol = new SQLColumn(pkCol);
                        fkCol.setPrimaryKeySeq(null);
                    }
                    this.addMapping(pkCol, fkCol);
                }
            }
            this.realizeMapping();
            this.attachListeners();
        }
        finally {
            if (fkTable != null) {
                fkTable.getColumnsFolder().setMagicEnabled(true);
                fkTable.getImportedKeysFolder().setMagicEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realizeMapping() throws ArchitectException {
        for (ColumnMapping m : this.getMappings()) {
            SQLColumn fkCol = m.getFkColumn();
            try {
                fkCol.setMagicEnabled(false);
                if (fkCol.getReferenceCount() == 0) {
                    fkCol.addReference();
                }
                int insertIdx = this.identifying ? (fkCol.getPrimaryKeySeq() == null ? this.fkTable.getPkSize() : fkCol.getPrimaryKeySeq().intValue()) : (fkCol.getPrimaryKeySeq() != null ? fkCol.getPrimaryKeySeq().intValue() : this.fkTable.getColumns().size());
                this.fkTable.addColumn(insertIdx, fkCol);
                logger.debug((Object)("Added column '" + fkCol.getName() + "' at index " + insertIdx));
                if (fkCol.getReferenceCount() <= 0) {
                    throw new IllegalStateException("Created a column with 0 references!");
                }
                if (!this.identifying || fkCol.getPrimaryKeySeq() != null) continue;
                fkCol.setPrimaryKeySeq(new Integer(this.fkTable.getPkSize()));
            }
            finally {
                fkCol.setMagicEnabled(true);
            }
        }
    }

    static void addImportedRelationshipsToTable(SQLTable table) throws ArchitectException {
        SQLDatabase db = table.getParentDatabase();
        if (!db.isPopulated()) {
            throw new ArchitectException("relationship.unpopulatedTargetDatabase");
        }
        Connection con = null;
        ResultSet rs = null;
        try {
            con = db.getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            SQLRelationship r2 = null;
            LinkedList<SQLRelationship> newKeys = new LinkedList<SQLRelationship>();
            logger.debug((Object)("scarch relationship for table:" + table.getCatalogName() + "." + table.getSchemaName() + "." + table.getName()));
            rs = dbmd.getImportedKeys(table.getCatalogName(), table.getSchemaName(), table.getName());
            while (rs.next()) {
                int currentKeySeq = rs.getInt(9);
                if (currentKeySeq == 1) {
                    r2 = new SQLRelationship();
                    newKeys.add(r2);
                }
                ColumnMapping m = new ColumnMapping();
                m.parent = r2;
                r2.children.add(m);
                r2.pkTable = db.getTableByName(rs.getString(1), rs.getString(2), rs.getString(3));
                if (r2.pkTable == null) {
                    logger.error((Object)("addImportedRelationshipsToTable: Couldn't find exporting table " + rs.getString(1) + "." + rs.getString(2) + "." + rs.getString(3) + " in target database!"));
                    continue;
                }
                logger.debug((Object)("Looking for pk column '" + rs.getString(4) + "' in table '" + r2.pkTable + "'"));
                m.pkColumn = r2.pkTable.getColumnByName(rs.getString(4));
                if (m.pkColumn == null) {
                    throw new ArchitectException("relationship.populate.nullPkColumn");
                }
                r2.fkTable = db.getTableByName(rs.getString(5), rs.getString(6), rs.getString(7));
                if (r2.fkTable != table) {
                    throw new IllegalStateException("fkTable did not match requested table");
                }
                m.fkColumn = r2.fkTable.getColumnByName(rs.getString(8));
                if (m.fkColumn == null) {
                    throw new ArchitectException("relationship.populate.nullFkColumn");
                }
                r2.updateRule = rs.getInt(10);
                r2.deleteRule = rs.getInt(11);
                r2.setName(rs.getString(12));
                r2.deferrability = rs.getInt(14);
            }
            for (SQLRelationship r2 : newKeys) {
                r2.attachRelationship(r2.pkTable, r2.fkTable, false);
            }
        }
        catch (SQLException e) {
            throw new ArchitectException("relationship.populate", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.warn((Object)"Couldn't close resultset", (Throwable)e);
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                logger.warn((Object)"Couldn't close connection", (Throwable)e);
            }
        }
    }

    public ColumnMapping getMappingByPkCol(SQLColumn pkcol) {
        for (ColumnMapping m : this.children) {
            if (m.pkColumn != pkcol) continue;
            return m;
        }
        return null;
    }

    public boolean containsPkColumn(SQLColumn col) {
        return this.getMappingByPkCol(col) != null;
    }

    public ColumnMapping getMappingByFkCol(SQLColumn fkcol) {
        for (ColumnMapping m : this.children) {
            if (m.fkColumn != fkcol) continue;
            return m;
        }
        return null;
    }

    public boolean containsFkColumn(SQLColumn col) {
        return this.getMappingByFkCol(col) != null;
    }

    public List<ColumnMapping> getMappings() {
        this.populate();
        return Collections.unmodifiableList(this.children);
    }

    public String printKeyColumns(int keyType) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        for (ColumnMapping cm : this.children) {
            if (i++ > 0) {
                s.append(",");
            }
            if (keyType == 4) {
                s.append(cm.getPkColumn().getName());
                continue;
            }
            s.append(cm.getFkColumn().getName());
        }
        return s.toString();
    }

    public void addMapping(SQLColumn pkColumn, SQLColumn fkColumn) throws ArchitectException {
        ColumnMapping cmap = new ColumnMapping();
        cmap.setPkColumn(pkColumn);
        cmap.setFkColumn(fkColumn);
        logger.debug((Object)("add column mapping: " + pkColumn.getParentTable() + "." + pkColumn.getName() + " to " + fkColumn.getParentTable() + "." + fkColumn.getName()));
        this.addChild(cmap);
    }

    public String toString() {
        return this.getShortDisplayName();
    }

    @Override
    public SQLObject getParent() {
        return this.pkTable.getExportedKeysFolder();
    }

    @Override
    protected void setParent(SQLObject newParent) {
        logger.info((Object)("Setting parent of " + this + " to " + newParent));
        try {
            if (newParent == null) {
                if (--this.parentCount == 0) {
                    this.detachListeners();
                }
            } else {
                if (this.pkTable != null && newParent != this.pkTable.exportedKeysFolder && this.fkTable != null && newParent != this.fkTable.importedKeysFolder) {
                    throw new IllegalArgumentException("You can't change the parent of a SQLRelationship this way");
                }
                this.attachListeners();
                ++this.parentCount;
            }
        }
        catch (ArchitectException ae) {
            throw new ArchitectRuntimeException(ae);
        }
    }

    @Override
    public String getShortDisplayName() {
        return this.getName();
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    @Override
    public void populate() {
    }

    @Override
    public boolean isPopulated() {
        return true;
    }

    public int getUpdateRule() {
        return this.updateRule;
    }

    public void setUpdateRule(int argUpdateRule) {
        int oldUpdateRule = this.updateRule;
        this.updateRule = argUpdateRule;
        this.fireDbObjectChanged("updateRule", oldUpdateRule, argUpdateRule);
    }

    public int getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(int argDeleteRule) {
        int oldDeleteRule = this.deleteRule;
        this.deleteRule = argDeleteRule;
        this.fireDbObjectChanged("deleteRule", oldDeleteRule, argDeleteRule);
    }

    public int getDeferrability() {
        return this.deferrability;
    }

    public void setDeferrability(int argDeferrability) {
        int oldDefferability = this.deferrability;
        this.deferrability = argDeferrability;
        this.fireDbObjectChanged("deferrability", oldDefferability, argDeferrability);
    }

    public int getPkCardinality() {
        return this.pkCardinality;
    }

    public void setPkCardinality(int argPkCardinality) {
        int oldPkCardinality = this.pkCardinality;
        this.pkCardinality = argPkCardinality;
        this.fireDbObjectChanged("pkCardinality", oldPkCardinality, argPkCardinality);
    }

    public int getFkCardinality() {
        return this.fkCardinality;
    }

    public void setFkCardinality(int argFkCardinality) {
        this.startCompoundEdit("Modify the Foreign key cardinality");
        int oldFkCardinality = this.fkCardinality;
        this.fkCardinality = argFkCardinality;
        this.fireDbObjectChanged("fkCardinality", oldFkCardinality, argFkCardinality);
        this.endCompoundEdit("Modify the Foreign key cardinality");
    }

    public boolean isIdentifying() {
        return this.identifying;
    }

    public void setIdentifying(boolean argIdentifying) throws ArchitectException {
        block4: {
            boolean oldIdentifying = this.identifying;
            if (this.identifying == argIdentifying) break block4;
            this.identifying = argIdentifying;
            this.fireDbObjectChanged("identifying", oldIdentifying, argIdentifying);
            if (this.identifying) {
                for (ColumnMapping m : this.getChildren()) {
                    if (m.getFkColumn().getPrimaryKeySeq() != null) continue;
                    m.getFkColumn().setPrimaryKeySeq(new Integer(this.fkTable.getPkSize()));
                }
            } else {
                for (ColumnMapping m : this.getChildren()) {
                    if (m.getFkColumn().getPrimaryKeySeq() == null) continue;
                    m.getFkColumn().setPrimaryKeySeq(null);
                }
            }
        }
    }

    public SQLTable getPkTable() {
        return this.pkTable;
    }

    public void setPkTable(SQLTable pkt) throws ArchitectException {
        SQLTable oldPkt = this.pkTable;
        if (this.pkTable != null) {
            this.detachListeners();
        }
        this.pkTable = pkt;
        this.attachListeners();
        this.fireDbObjectChanged("pkTable", oldPkt, pkt);
    }

    public SQLTable getFkTable() {
        return this.fkTable;
    }

    public void setFkTable(SQLTable fkt) throws ArchitectException {
        SQLTable oldFkt = this.fkTable;
        if (this.fkTable != null) {
            this.detachListeners();
        }
        this.fkTable = fkt;
        this.attachListeners();
        this.fireDbObjectChanged("fkTable", oldFkt, fkt);
    }

    @Override
    public Class<? extends SQLObject> getChildType() {
        return null;
    }

    public void checkColumnLocked(SQLColumn col) throws LockedColumnException {
        for (ColumnMapping cm : this.getMappings()) {
            if (cm.getFkColumn() != col) continue;
            throw new LockedColumnException(this, col);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnMapping
    extends SQLObject {
        protected SQLRelationship parent;
        protected SQLColumn pkColumn;
        protected SQLColumn fkColumn;

        public ColumnMapping() {
            this.children = Collections.EMPTY_LIST;
        }

        public SQLColumn getPkColumn() {
            return this.pkColumn;
        }

        public void setPkColumn(SQLColumn argPkColumn) {
            this.pkColumn = argPkColumn;
        }

        public SQLColumn getFkColumn() {
            return this.fkColumn;
        }

        public void setFkColumn(SQLColumn argFkColumn) {
            this.fkColumn = argFkColumn;
        }

        public String toString() {
            return this.getShortDisplayName();
        }

        @Override
        public SQLObject getParent() {
            return this.parent;
        }

        @Override
        protected void setParent(SQLObject newParent) {
            this.parent = (SQLRelationship)newParent;
        }

        @Override
        public String getName() {
            return "Column Mapping";
        }

        @Override
        public String getShortDisplayName() {
            String pkTableName = null;
            if (this.pkColumn.getParentTable() != null) {
                pkTableName = this.pkColumn.getParentTable().getName();
            }
            return this.fkColumn.getName() + " - " + pkTableName + "." + this.pkColumn.getName();
        }

        @Override
        public boolean allowsChildren() {
            return false;
        }

        @Override
        public void populate() throws ArchitectException {
        }

        @Override
        public boolean isPopulated() {
            return true;
        }

        @Override
        public Class<? extends SQLObject> getChildType() {
            return null;
        }
    }

    protected class RelationshipManager
    implements SQLObjectListener {
        protected RelationshipManager() {
        }

        public void dbChildrenInserted(SQLObjectEvent e) {
            if (!e.getSQLSource().isMagicEnabled()) {
                logger.debug((Object)("Magic disabled ignoring sqlobjectEvent " + e));
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dbChildrenInserted event! parent=" + e.getSource() + ";" + " children=" + Arrays.asList(e.getChildren())));
            }
            try {
                SQLTable.Folder f;
                SQLRelationship.this.startCompoundEdit("Children Inserted Secondary Effect");
                for (SQLObject so : e.getChildren()) {
                    ArchitectUtils.listenToHierarchy((SQLObjectListener)this, so);
                }
                if (e.getSQLSource() instanceof SQLTable.Folder && (f = (SQLTable.Folder)e.getSource()) == SQLRelationship.this.pkTable.getColumnsFolder()) {
                    SQLObject[] cols = e.getChildren();
                    for (int i = 0; i < cols.length; ++i) {
                        SQLColumn col = (SQLColumn)cols[i];
                        try {
                            if (col.getPrimaryKeySeq() != null) {
                                this.ensureInMapping(col);
                                continue;
                            }
                            this.ensureNotInMapping(col);
                            continue;
                        }
                        catch (ArchitectException ex) {
                            logger.warn((Object)"Couldn't add/remove mapped FK columns", (Throwable)ex);
                        }
                    }
                }
            }
            catch (ArchitectException ex) {
                throw new ArchitectRuntimeException(ex);
            }
            finally {
                SQLRelationship.this.endCompoundEdit("End children inserted handler");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dbChildrenRemoved(SQLObjectEvent e) {
            block23: {
                if (!e.getSQLSource().isMagicEnabled()) {
                    logger.debug((Object)("Magic disabled ignoring sqlobjectEvent " + e));
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("dbChildrenRemoved event! parent=" + e.getSource() + ";" + " children=" + Arrays.asList(e.getChildren())));
                }
                try {
                    for (SQLObject so : e.getChildren()) {
                        ArchitectUtils.unlistenToHierarchy((SQLObjectListener)this, so);
                    }
                    if (!(e.getSQLSource() instanceof SQLTable.Folder)) break block23;
                    SQLTable.Folder f = (SQLTable.Folder)e.getSource();
                    if (f == SQLRelationship.this.pkTable.getExportedKeysFolder()) {
                        SQLObject[] removedRels = e.getChildren();
                        int size = removedRels.length;
                        for (int i = 0; i < size; ++i) {
                            SQLRelationship r = (SQLRelationship)removedRels[i];
                            if (r != SQLRelationship.this) continue;
                            try {
                                SQLRelationship.this.startCompoundEdit("Children removed secondary effect");
                                try {
                                    r.getFkTable().getImportedKeysFolder().setMagicEnabled(false);
                                    r.getFkTable().removeImportedKey(r);
                                }
                                finally {
                                    r.getFkTable().getImportedKeysFolder().setMagicEnabled(true);
                                }
                                logger.debug((Object)("Removing references for mappings: " + SQLRelationship.this.getMappings()));
                                for (ColumnMapping cm : r.getMappings()) {
                                    logger.debug((Object)("Removing reference to fkcol " + cm.getFkColumn()));
                                    try {
                                        SQLRelationship.this.fkTable.getColumnsFolder().setMagicEnabled(false);
                                        cm.getFkColumn().setMagicEnabled(false);
                                        cm.getFkColumn().removeReference();
                                    }
                                    finally {
                                        cm.getFkColumn().setMagicEnabled(true);
                                        SQLRelationship.this.fkTable.getColumnsFolder().setMagicEnabled(true);
                                    }
                                }
                                continue;
                            }
                            finally {
                                SQLRelationship.this.endCompoundEdit("End children removed handler");
                                SQLRelationship.this.detachListeners();
                            }
                        }
                        break block23;
                    }
                    if (f != SQLRelationship.this.pkTable.getColumnsFolder()) break block23;
                    SQLObject[] cols = e.getChildren();
                    try {
                        SQLRelationship.this.startCompoundEdit("Remove mapped fk columns");
                        for (int i = 0; i < cols.length; ++i) {
                            SQLColumn col = (SQLColumn)cols[i];
                            this.ensureNotInMapping(col);
                        }
                    }
                    catch (ArchitectException ex) {
                        logger.warn((Object)"Couldn't remove mapped FK columns", (Throwable)ex);
                    }
                    finally {
                        SQLRelationship.this.endCompoundEdit("End remove mapped fk columns");
                    }
                }
                catch (ArchitectException ex) {
                    throw new ArchitectRuntimeException(ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dbObjectChanged(SQLObjectEvent e) {
            block37: {
                if (!e.getSQLSource().isMagicEnabled()) {
                    logger.debug((Object)("Magic disabled ignoring sqlobjectEvent " + e));
                    return;
                }
                String prop = e.getPropertyName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Property changed!\n source=" + e.getSource() + "\n property=" + prop + "\n old=" + e.getOldValue() + "\n new=" + e.getNewValue()));
                }
                try {
                    SQLRelationship.this.startCompoundEdit("Object change");
                    if (e.getSource() instanceof SQLColumn) {
                        SQLColumn col = (SQLColumn)e.getSource();
                        if (col.getParentTable() != SQLRelationship.this.pkTable) break block37;
                        if (prop.equals("primaryKeySeq")) {
                            try {
                                if (col.getPrimaryKeySeq() != null) {
                                    this.ensureInMapping(col);
                                } else {
                                    this.ensureNotInMapping(col);
                                }
                            }
                            catch (ArchitectException ae) {
                                throw new ArchitectRuntimeException(ae);
                            }
                            return;
                        }
                        ColumnMapping m = SQLRelationship.this.getMappingByPkCol(col);
                        if (m == null) {
                            logger.debug((Object)("Ignoring change for column " + col + " parent " + col.getParentTable()));
                            return;
                        }
                        if (m.getPkColumn() == null) {
                            throw new NullPointerException("Missing pk column in mapping");
                        }
                        if (m.getFkColumn() == null) {
                            throw new NullPointerException("Missing fk column in mapping");
                        }
                        if (prop == null || prop.equals("parent")) break block37;
                        if (prop.equals("remarks")) {
                            break block37;
                        }
                        if (prop.equals("sourceColumn")) {
                            m.getFkColumn().setSourceColumn(m.getPkColumn().getSourceColumn());
                            break block37;
                        }
                        if (prop.equals("name")) {
                            if (!m.getFkColumn().getName().equalsIgnoreCase((String)e.getOldValue())) break block37;
                            try {
                                m.getFkColumn().setMagicEnabled(false);
                                m.getFkColumn().setName(m.getPkColumn().getName());
                                break block37;
                            }
                            finally {
                                m.getFkColumn().setMagicEnabled(true);
                            }
                        }
                        if (prop.equals("type")) {
                            m.getFkColumn().setType(m.getPkColumn().getType());
                        } else if (prop.equals("sourceDataTypeName")) {
                            m.getFkColumn().setSourceDataTypeName(m.getPkColumn().getSourceDataTypeName());
                        } else if (prop.equals("scale")) {
                            m.getFkColumn().setScale(m.getPkColumn().getScale());
                        } else if (prop.equals("precision")) {
                            m.getFkColumn().setPrecision(m.getPkColumn().getPrecision());
                        } else if (prop.equals("nullable")) {
                            m.getFkColumn().setNullable(m.getPkColumn().getNullable());
                        } else if (prop.equals("defaultValue")) {
                            m.getFkColumn().setDefaultValue(m.getPkColumn().getDefaultValue());
                        } else if (prop.equals("autoIncrement")) {
                            m.getFkColumn().setAutoIncrement(m.getPkColumn().isAutoIncrement());
                        } else {
                            logger.warn((Object)("Warning: unknown column property " + prop + " changed while monitoring pkTable"));
                        }
                        break block37;
                    }
                    if ((e.getSource() == SQLRelationship.this.fkTable || e.getSource() == SQLRelationship.this.pkTable) && prop.equals("parent") && e.getNewValue() == null) {
                        SQLRelationship.this.pkTable.removeExportedKey(SQLRelationship.this);
                    }
                }
                finally {
                    SQLRelationship.this.endCompoundEdit("End Object change handler");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dbStructureChanged(SQLObjectEvent e) {
            if (!e.getSQLSource().isMagicEnabled()) {
                logger.debug((Object)("Magic disabled ignoring sqlobjectEvent " + e));
                return;
            }
            logger.debug((Object)"Received a dbStructure changed event");
            try {
                SQLRelationship.this.startCompoundEdit("Structure Change");
                for (SQLColumn col : SQLRelationship.this.pkTable.getColumns()) {
                    if (col.getPrimaryKeySeq() != null) {
                        this.ensureInMapping(col);
                        continue;
                    }
                    this.ensureNotInMapping(col);
                }
            }
            catch (ArchitectException ex) {
                logger.warn((Object)"Coulnd't re-scan table as a result of dbStructureChanged", (Throwable)ex);
            }
            finally {
                SQLRelationship.this.endCompoundEdit("End structure changed handler");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void ensureInMapping(SQLColumn pkcol) throws ArchitectException {
            if (!SQLRelationship.this.containsPkColumn(pkcol)) {
                SQLColumn fkcol;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("ensureInMapping(" + SQLRelationship.this.getName() + "): Adding " + pkcol.getParentTable().getName() + "." + pkcol.getName() + " to mapping"));
                }
                if ((fkcol = SQLRelationship.this.fkTable.getColumnByName(pkcol.getName())) == null) {
                    fkcol = new SQLColumn(pkcol);
                }
                try {
                    int insertIdx;
                    SQLRelationship.this.fkTable.setMagicEnabled(false);
                    fkcol.setMagicEnabled(false);
                    if (SQLRelationship.this.identifying) {
                        insertIdx = SQLRelationship.this.fkTable.getPkSize();
                        fkcol.setPrimaryKeySeq(new Integer(insertIdx));
                    } else {
                        insertIdx = SQLRelationship.this.fkTable.getColumns().size();
                        fkcol.setPrimaryKeySeq(null);
                    }
                    logger.debug((Object)("ensureInMapping(" + SQLRelationship.this.getName() + "): adding fkcol at index " + insertIdx + " (rel is identifying? " + SQLRelationship.this.identifying + ", pkseq=" + fkcol.getPrimaryKeySeq() + ")"));
                    SQLRelationship.this.fkTable.addColumn(insertIdx, fkcol);
                }
                finally {
                    SQLRelationship.this.fkTable.setMagicEnabled(true);
                    fkcol.setMagicEnabled(true);
                }
                SQLRelationship.this.addMapping(pkcol, fkcol);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void ensureNotInMapping(SQLColumn pkcol) throws ArchitectException {
            logger.debug((Object)("Removing " + pkcol.getParentTable() + "." + pkcol + " from mapping"));
            if (SQLRelationship.this.containsPkColumn(pkcol)) {
                ColumnMapping m = SQLRelationship.this.getMappingByPkCol(pkcol);
                SQLRelationship.this.removeChild(m);
                try {
                    m.getFkColumn().setMagicEnabled(false);
                    m.getFkColumn().removeReference();
                }
                finally {
                    m.getFkColumn().setMagicEnabled(true);
                }
            }
        }

        public String toString() {
            return "RelManager of " + SQLRelationship.this.toString();
        }
    }
}

