/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchitectDataSourceType {
    static final Logger logger = Logger.getLogger(ArchitectDataSourceType.class);
    private static Map<String, Integer> classLoadCounts = new HashMap<String, Integer>();
    public static final String JDBC_DRIVER = "JDBC Driver Class";
    public static final String JDBC_URL = "JDBC URL";
    public static final String JDBC_JAR_BASE = "JDBC JAR";
    public static final String JDBC_JAR_COUNT = "JDBC JAR Count";
    public static final String TYPE_NAME = "Name";
    public static final String PARENT_TYPE_NAME = "Parent Type";
    public static final String PL_DB_TYPE = "PL Type";
    public static final String COMMENT = "Comment";
    public static final String DDL_GENERATOR = "DDL Generator";
    private ArchitectDataSourceType parentType;
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private ClassLoader classLoader = new JDBCClassLoader();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public String getComment() {
        return this.getProperty(COMMENT);
    }

    public void setComment(String comment) {
        this.putPropertyImpl("comment", COMMENT, comment);
    }

    public String getPlDbType() {
        return this.getProperty(PL_DB_TYPE);
    }

    public void setPlDbType(String type) {
        this.putPropertyImpl("plDbType", PL_DB_TYPE, type);
    }

    public String getJdbcDriver() {
        return this.getProperty(JDBC_DRIVER);
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.putPropertyImpl("jdbcDriver", JDBC_DRIVER, jdbcDriver);
    }

    public List<String> getJdbcJarList() {
        return Collections.unmodifiableList(this.makeModifiableJdbcJarList());
    }

    private List<String> makeModifiableJdbcJarList() {
        int count = this.getJdbcJarCount();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String key = "JDBC JAR_" + i;
            String value = this.getProperty(key);
            logger.debug((Object)("Found jar \"" + value + "\" under key \"" + key + "\""));
            list.add(value);
        }
        return list;
    }

    public void setJdbcJarList(List<String> jdbcJarList) {
        int count = jdbcJarList.size();
        this.setJdbcJarCount(count);
        int i = 0;
        for (String jar : jdbcJarList) {
            this.properties.put("JDBC JAR_" + i, jar);
            ++i;
        }
    }

    public void addJdbcJar(String jarPath) {
        int count = this.getJdbcJarCount();
        this.properties.put("JDBC JAR_" + count, jarPath);
        this.setJdbcJarCount(count + 1);
    }

    private void setJdbcJarCount(int count) {
        this.putPropertyImpl("jdbcJarCount", JDBC_JAR_COUNT, String.valueOf(count));
    }

    private int getJdbcJarCount() {
        String jarCountString = this.getProperty(JDBC_JAR_COUNT);
        if (jarCountString == null) {
            return 0;
        }
        return Integer.parseInt(jarCountString);
    }

    public String getJdbcUrl() {
        return this.getProperty(JDBC_URL);
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.putPropertyImpl("jdbcUrl", JDBC_URL, jdbcUrl);
    }

    public String getName() {
        return this.getProperty(TYPE_NAME);
    }

    public void setName(String name) {
        this.putPropertyImpl("name", TYPE_NAME, name);
    }

    public String getDDLGeneratorClass() {
        return this.getProperty(DDL_GENERATOR);
    }

    public void setDDLGeneratorClass(String className) {
        this.putPropertyImpl("DDLGeneratorClass", DDL_GENERATOR, className);
    }

    public ArchitectDataSourceType getParentType() {
        return this.parentType;
    }

    public void setParentType(ArchitectDataSourceType parentType) {
        this.parentType = parentType;
    }

    Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    void putProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public ClassLoader getJdbcClassLoader() {
        return this.classLoader;
    }

    public String getProperty(String key) {
        String value = this.properties.get(key);
        if (value != null) {
            return value;
        }
        if (this.parentType != null) {
            return this.parentType.getProperty(key);
        }
        return null;
    }

    public void removeJdbcJar(String path) {
        List<String> jdbcJars = this.makeModifiableJdbcJarList();
        jdbcJars.remove(path);
        this.setJdbcJarList(jdbcJars);
    }

    public String toString() {
        return "DataSourceType: " + this.properties;
    }

    public void checkConnectPrereqs() throws SQLException {
        if (this.getJdbcDriver() == null || this.getJdbcDriver().trim().length() == 0) {
            throw new SQLException("Data Source Type \"" + this.getName() + "\" has no JDBC Driver class specified.");
        }
    }

    private void putPropertyImpl(String javaPropName, String plPropName, String propValue) {
        String oldValue = this.properties.get(plPropName);
        this.properties.put(plPropName, propValue);
        this.firePropertyChange(javaPropName, oldValue, propValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.pcs.firePropertyChange(evt);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public class JDBCClassLoader
    extends ClassLoader {
        protected JDBCClassLoader() {
            super(JDBCClassLoader.class.getClassLoader());
            logger.debug((Object)("Created new JDBC Classloader @" + System.identityHashCode(this)));
            Policy.setPolicy(new Policy(){

                public PermissionCollection getPermissions(CodeSource codesource) {
                    Permissions perms = new Permissions();
                    perms.add(new AllPermission());
                    return perms;
                }

                public void refresh() {
                }
            });
        }

        public Class findClass(String name) throws ClassNotFoundException {
            if (logger.isDebugEnabled()) {
                Integer count = (Integer)classLoadCounts.get(name);
                count = count == null ? new Integer(1) : Integer.valueOf(count + 1);
                classLoadCounts.put(name, count);
                logger.debug((Object)("JDBC Classloader @" + System.identityHashCode(this) + ": Looking for class " + name + " (count = " + count + ")"));
            }
            for (String jarFileName : ArchitectDataSourceType.this.getJdbcJarList()) {
                try {
                    int offs;
                    logger.debug((Object)("checking file " + jarFileName));
                    File listedFile = ArchitectUtils.jarSpecToFile(jarFileName, this.getParent());
                    if (!listedFile.exists()) {
                        logger.debug((Object)("Skipping non-existant JAR file " + listedFile.getPath()));
                        continue;
                    }
                    JarFile jf = new JarFile(listedFile);
                    ZipEntry ent = jf.getEntry(name.replace('.', '/') + ".class");
                    if (ent == null) {
                        jf.close();
                        continue;
                    }
                    byte[] buf = new byte[(int)ent.getSize()];
                    InputStream is = jf.getInputStream(ent);
                    int n = 0;
                    for (offs = 0; (n = is.read(buf, offs, buf.length - offs)) >= 0 && offs < buf.length; offs += n) {
                    }
                    int total = offs;
                    if ((long)total != ent.getSize()) {
                        logger.warn((Object)("What gives?  ZipEntry " + ent.getName() + " is " + ent.getSize() + " bytes long, but we only read " + total + " bytes!"));
                    }
                    jf.close();
                    return this.defineClass(name, buf, 0, buf.length);
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("IO Exception reading class from jar file", ex);
                }
            }
            throw new ClassNotFoundException("Could not locate class " + name + " in any of the JDBC Driver JAR files " + ArchitectDataSourceType.this.getJdbcJarList());
        }

        protected URL findResource(String name) {
            logger.debug((Object)("Looking for resource " + name));
            for (String jarName : ArchitectDataSourceType.this.getJdbcJarList()) {
                File listedFile = new File(jarName);
                try {
                    if (!listedFile.exists()) {
                        logger.debug((Object)("Skipping non-existant JAR file " + listedFile.getPath()));
                        continue;
                    }
                    JarFile jf = new JarFile(listedFile);
                    if (jf.getEntry(name) == null) continue;
                    URI jarUri = listedFile.toURI();
                    return new URL("jar:" + jarUri.toURL() + "!/" + name);
                }
                catch (IOException ex) {
                    logger.warn((Object)("IO Exception while searching " + listedFile.getPath() + " for resource " + name + ". Continuing..."), (Throwable)ex);
                }
            }
            return null;
        }
    }
}

