<?php
	/**
	 * Print ItemModule
	 * Currently only mail is supported by this module
	 *
	 * @author Michael Erkens <m.erkens@connectux.com>
	 */
	class PrintItemModule extends ItemModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function PrintItemModule($id, $data)
		{		
			$store = $GLOBALS["mapisession"]->openMessageStore(hex2bin($data[0]["store"]));
			$message = mapi_msgstore_openentry($store,hex2bin($data[0]["entryid"]));
			$props = mapi_getprops($message,Array(PR_MESSAGE_CLASS));
			switch($props[PR_MESSAGE_CLASS]){
				case "IPM.Task":
					$this->properties = $GLOBALS["properties"]->getTaskProperties();
					break;
				case "IPM.Appointment":
					$this->properties = $GLOBALS["properties"]->getAppointmentProperties();
					break;
				case "IPM.Contact":
					$this->properties = $GLOBALS["properties"]->getContactProperties();
					break;
				case "IPM.StickyNote":
					$this->properties = $GLOBALS["properties"]->getStickyNoteProperties();
					break;
				case "IPM.DistList":
					$this->properties = $GLOBALS["properties"]->getDistListProperties();
					break;
				case "IPM.Note":
				default:
					$this->properties = $GLOBALS["properties"]->getMailProperties();
			}
			parent::ItemModule($id, $data);
		}
	}
?>
