<?php
	/**
	 * Journal Module
	 * @author Michael Erkens <m.erkens@zarafa.com>
	 */
	class JournalListModule extends ListModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function JournalListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getMailProperties();
			
			$this->tablecolumns = array();
			$this->addColumn($this->tablecolumns, "importance", false, 0, _("Priority"), _("Sort On Priority"));
			$this->addColumn($this->tablecolumns, "icon_index", true, 1, _("Icon"), _("Sort On Icon"));
			$this->addColumn($this->tablecolumns, "hasattach", true, 2, _("Attachments"), _("Sort On Attachments"));
			$this->addColumn($this->tablecolumns, "subject", true, 4, _("Subject"), _("Sort On Subject"), PERCENTAGE);
			$this->addColumn($this->tablecolumns, "message_size", false, 6, _("Size"), _("Sort On Size"), 80);
			$this->addColumn($this->tablecolumns, "flag_status", false, 7, _("Flag Status"), _("Sort On Flag Status"));
			$this->addColumn($this->tablecolumns, "categories", false, 8, _("Categories"), _("Sort On Categories"));
			$this->addColumn($this->tablecolumns, "sent_representing_name", true, 3, _("From"), _("Sort On Sender"));
			$this->addColumn($this->tablecolumns, "message_delivery_time", true, 5, _("Received"), _("Sort On Received Date"));
			$this->addColumn($this->tablecolumns, "display_to", false, 3, _("To"), _("Sort On Recipient"));
			$this->addColumn($this->tablecolumns, "client_submit_time", false, 5, _("Sent"), _("Sort On Sent Date"));

			parent::ListModule($id, $data, array(OBJECT_SAVE, TABLE_SAVE, TABLE_DELETE));

			$this->sort = array();
			$this->sort[$this->properties["message_delivery_time"]] = TABLE_SORT_DESCEND;
			
			$this->start = 0;
		}
	}
?>
