<?php
	/**
	 * Date Picker Module
	 * @author Johnny Biemans <j.biemans@connectux.com>
	 */
	
	require_once("mapi/class.recurrence.php");
	
	class DatePickerListModule extends ListModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function DatePickerListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getAppointmentProperties();
			parent::ListModule($id, $data, array(TABLE_SAVE, TABLE_DELETE));
		}
		
		/**
		 * Function which retrieves a list of appointments in a calendar folder.
		 * @param object $store MAPI Message Store Object
		 * @param string $entryid entryid of the folder
		 * @param array $action the action data, sent by the client
		 * @return boolean true on success or false on failure		 		 
		 */
		function messageList($store, $entryid, $action)
		{
			$result = false;
			
			if($store && $entryid) {
				$type = false;
				$startdate = false;
				$enddate = false;
				
				$startdate = mktime();
				if(isset($action["restriction"])) {	
					if(isset($action["restriction"]["startdate"])) {
						$startdate = (int) $action["restriction"]["startdate"];
					}
				}
				
				$data = array();
				$data["attributes"] = array("type" => "list");
				$data["item"] = $this->getCalendarItems($store, $entryid, $startdate, $startdate + (31*24*60*60));

				array_push($this->responseData["action"], $data);
				$GLOBALS["bus"]->addData($this->responseData);
			}
			
			return $result;
		}
		
		/**
		 * Function to return all Calendar items in a given timeframe. This
		 * function also takes recurring items into account.
		 * @author Steve Hardy & Johnny Biemans
		 * @param Object $store message store
		 * @param Object $calendar folder
		 * @param Date $start startdate of the interval
		 * @param Date $end enddate of the interval
		 */
		function getCalendarItems($store, $entryid, $start, $end)
		{
			$items = Array();
		
			$restriction = 
						// OR
						// (item[end] >= start && item[start] <= end) ||
						Array(RES_OR,
								 Array(
									   Array(RES_AND,
											 Array(
												   Array(RES_PROPERTY,
														 Array(RELOP => RELOP_GE,
															   ULPROPTAG => $this->properties["duedate"],
															   VALUE => $start
															   )
														 ),
												   Array(RES_PROPERTY,
														 Array(RELOP => RELOP_LE,
															   ULPROPTAG => $this->properties["startdate"],
															   VALUE => $end
															   )
														 )
												   )
											 ),
									   // OR
									   Array(RES_OR,
											 Array(
												   // OR
												   // (EXIST(recurrence_enddate_property) && item[isRecurring] == true && (item[end] < item[start] || item[end] >= start))
												   Array(RES_AND,
														 Array(
															   Array(RES_EXIST,
																	 Array(ULPROPTAG => $this->properties["enddate_recurring"],
																		   )
																	 ),
															   Array(RES_PROPERTY,
																	 Array(RELOP => RELOP_EQ,
																		   ULPROPTAG => $this->properties["recurring"],
																		   VALUE => true
																		   )
																	 ),
															   Array(RES_OR,
															   		// This is a hack. If we can see that the enddate_recurring is BEFORE the startdate, 
															   		// then the enddate_recurring is bogus and we should ignore it!
															   		Array(
																		Array(RES_COMPAREPROPS,
																			Array(RELOP => RELOP_LT,
																				ULPROPTAG1 => $this->properties["enddate_recurring"],
																				ULPROPTAG2 => $this->properties["startdate"]
																			)
																		),
																	
																		
																	   Array(RES_PROPERTY,
																			 Array(RELOP => RELOP_GE,
																				   ULPROPTAG => $this->properties["enddate_recurring"],
																				   VALUE => $start
																				   )
																			 )
																		)
																	)
															   )
														 ),
												   // OR
												   // (!EXIST(recurrence_enddate_property) && item[isRecurring] == true && item[start] <= end)

												   Array(RES_AND,
														 Array(
															   Array(RES_NOT,
																	 Array(
																		   Array(RES_EXIST,
																				 Array(ULPROPTAG => $this->properties["enddate_recurring"]
																					   )
																				 )
																		   )
																	 ),
															   Array(RES_PROPERTY,
																	 Array(RELOP => RELOP_LE,
																		   ULPROPTAG => $this->properties["startdate"],
																		   VALUE => $end
																		   )
																	 ),
															   Array(RES_PROPERTY,
																	 Array(RELOP => RELOP_EQ,
																		   ULPROPTAG => $this->properties["recurring"],
																		   VALUE => true
																		   )
																	 )
															   )
														 )
												   )
											 ) // EXISTS OR
									   )
								 );		// global OR

            // We only need a few properties for the datepicker
            $rowproperties = array("subject" => $this->properties["subject"],
                                   "startdate" => $this->properties["startdate"],
                                   "duedate" => $this->properties["duedate"],
                                   "location" => $this->properties["location"],
                                   "entryid" => $this->properties["entryid"],
                                   "recurring" => $this->properties["recurring"],
                                   "timezone_data" => $this->properties["timezone_data"],
                                   "recurring_data" => $this->properties["recurring_data"]);

			$folder = mapi_msgstore_openentry($store, $entryid);
			$table = mapi_folder_getcontentstable($folder);
			$calendaritems = mapi_table_queryallrows($table, $rowproperties, $restriction);
		
			foreach($calendaritems as $calendaritem)
			{
				if (isset($calendaritem[$this->properties["recurring"]]) && $calendaritem[$this->properties["recurring"]]) {
					$recurrence = new Recurrence($store, $calendaritem);
					$recuritems = $recurrence->getItems($start, $end);
					
					foreach($recuritems as $recuritem)
					{
						array_push($items, Conversion::mapMAPI2XML($rowproperties, $recuritem));
					}
				} else {
					array_push($items, Conversion::mapMAPI2XML($rowproperties, $calendaritem));
				} 
			} 
			
			return $items;
		} 
	}
?>
