<?php
	/**
	* XML serialiser class
	*
	* This class builds an XML string. It receives an associative array, which 
	* will be converted to a XML string. The data in the associative array is
	* assumed to hold UTF-8 strings, and the output XML is output as UTF-8 also;
	* no charset processing is performed.
	*
	* @package core
	*/
	
	class XMLBuilder
	{
		/**
		 * @var string this string the builded XML
		 */	
		var $xml;
		
		/**
		 * @var integer this variable is used for indenting (DEBUG)
		 */ 		 		
		var $depth;
		
		function XMLBuilder()
		{
			
		} 

		/**
		 * Builds the XML using the given associative array
		 * @param array $data The data which should be converted to a XML string
		 * @return string The serialised XML string
		 */		 		
		function build($data)
		{
			$this->depth = 1;
			$this->xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?" . ">\n<zarafa>\n";
			$this->addData($data);
			$this->xml .= "</zarafa>";
			return $this->xml;
		}

		/**
		 * Add data to serialised XML string
		 *
		 * The type of data is autodetected and forwarded to the correct add*() function
		 *
		 * @access private
		 * @param array $data array of data which should be converted to a XML string		 
		 */ 		 				
		function addData($data)
		{
			if(is_array($data)) {
				foreach($data as $tagName => $tagValue)
				{
					if(is_assoc_array($tagValue)) {
						$this->addAssocArray($tagName, $tagValue);
					} else if(is_array($tagValue)) {
						$this->addArray($tagName, $tagValue);
					} else {
						$this->addNode($tagName, $tagValue);
					}
				}
			}
		}

		/**
		 * Adds a non-associated array to the XML string.
		 * @access private
		 * @param string $parentTag the parent tag of all items in the array
		 * @param array $data array of data
		 */ 		 				
		function addArray($parentTag, $data)
		{
			foreach($data as $tagValue)
			{
				$this->addAssocArray($parentTag, $tagValue);
			}
		}

		/**
		 * Adds an associative array to the XML string.
		 * @access private
		 * @param string $parentTag the parent tag		 
		 * @param array $data array of data 		 
		 */ 		 				
		function addAssocArray($parentTag, $data)
		{
			$attributes = $this->getAttributes($data);
			$this->xml .= str_repeat("\t",$this->depth). "<" . $parentTag . $attributes . ">";

			if(is_array($data)) {

				if(isset($data["_content"])) {
					if (!is_array($data["_content"])){
						$this->xml .= xmlentities($data["_content"]);
					}else{
						$this->depth++; 
						$this->xml .= "\n";
						$this->addData($data["_content"]);
						$this->depth--;
						$this->xml .= str_repeat("\t",$this->depth);
					}
				} else {
					$this->depth++; 
					$this->xml .= "\n";
					$this->addData($data);
					$this->depth--;
					$this->xml .= str_repeat("\t",$this->depth);
				}
			} else {
				$this->xml .= xmlentities($data);
			}
				
			$this->xml .= "</" . $parentTag . ">\n";
		}
		
		/**
		 * Add a node to the XML string.
		 * @access private
		 * @param string $tagName the tag		 
		 * @param string $value the value of the tag 		 
		 */
		function addNode($tagName, $value)
		{
			$this->xml .= str_repeat("\t",$this->depth)."<" . $tagName . ">" . xmlentities($value) . "</" . $tagName . ">\n";
		}
		
		/**
		 * Verify if there are any attributes in the given array.
		 * It returns a string with the attributes, which will be added to the
		 * XML string.
		 * @access private
		 * @param array $data the array which be checked
		 * @return string a string with the attributes		  		 		 		 
		 */		 		
		function getAttributes(&$data)
		{
			$attributes = "";
			
			if(isset($data["attributes"]) && is_array($data["attributes"])) {
				$attributes = "";
				
				foreach($data["attributes"] as $attribute => $value)
				{
					$attributes .= " ".$attribute . "=\"" . xmlentities($value) . "\"";
				}
				
				unset($data["attributes"]);
			}
			
			return $attributes;
		}
	}
?>
