<?php

function compose_settings_title(){
	return _("Compose mail");
}

function compose_settings_order(){
	return 1;
}

function compose_settings_html(){ ?>
	<fieldset>
		<legend><?=_("General")?></legend>
		<table class="textinput">
			<tr>
				<th><label for="compose_replyto"><?=_("Reply-to address")?></label></th>
				<td><input id="compose_replyto" type="text" class="text"></td>
			</tr>
		</table>
		<table class="options">
			<tr>
				<th><label for="compose_format"><?=_("Compose mail in this format")?></label></th>
				<td>
					<select id="compose_format">
						<option value="html"><?=_("HTML")?></option>
						<option value="plain"><?=_("Plain text")?></option>
					</select>
				</td>
			</tr>
			

			<tr>
				<th colspan="2"><input id="compose_close_on_reply" type="checkbox" class="checkbox"><label for="compose_close_on_reply"><?=_("Close original message on reply or forward")?></label></th>
			</tr>
			
			<tr>
				<th colspan="2"><input id="compose_readreceipt" type="checkbox" class="checkbox"><label for="compose_readreceipt"><?=_("Always request a read receipt")?></label></th>
			</tr>
			<tr>
				<th colspan="2"><input id="compose_autosave" type="checkbox" class="checkbox"><label for="compose_autosave"><?=_("AutoSave unsent every:")?></label> <input id="compose_autosave_interval" type="text" class="text" style="width: 25px;"> <?=_('minutes')?></th>
			</tr>

			<tr>
				<th><label for="compose_cursorposition"><?=_("Cursor position when replying")?></label></th>
				<td>
					<select id="compose_cursorposition">
						<option value="start"><?=_("Start of body")?></option>
						<option value="end"><?=_("End of body")?></option>
					</select>
				</td>
			</tr>

		</table>
	</fieldset>

	<fieldset>
		<legend><?=_("From Email Addresses")?></legend>
		<table class="textinput">
			<tr>
				<th><label for="compose_email_from_address"><?=_("Set FROM email addresses")?></label>
				<td>
					<table>
						<tr>
							<td style="width:425px"><select id="compose_email_from_address" class="input_text" multiple="multiple" size="5"></select></td>
							<td style="width:20px">
								<span class="menubutton icon icon_insert" id="compose_email_add_from" onclick="webclient.openModalDialog(-1, 'addemail', DIALOG_URL+'task=emailaddress_modal', 300,150, compose_addCallBack);" title="<?=_("Add address")?>"></span>
								<span class="menubutton icon icon_remove" style="clear: both;" id="compose_email_del_from" onclick="compose_delFromAddress();" title="<?=_("Remove address")?>"></span>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</fieldset>

	<fieldset>
		<legend><?=_("Signature")?></legend>
		<table class="options">
			<tr>
				<th colspan="2">
					<input type="button" onclick="openEditSignatures();" value="<?=_('Edit signatures')?>..." class="inline_button"/>
				</th>
			</tr>
		</table>
	</fieldset>
<?php } 


?>
