<?php

function getDialogTitle() {
	return _("Attachments");
}

function getJavaScript_onload(){ ?>
					if(parentwindow.module) {
						var filelist = dhtml.getElementById("filelist");
						
						/**
						 * NOTE: We do not want to send attachments of original mail
						 * when we are replying to that mail. But new attachments 
						 * can be sent with that mail.
						 */						
						if (parentwindow.module && parentwindow.module.messageAction){ 
							if (parentwindow.module.messageAction == "reply" || parentwindow.module.messageAction == "replyall"){
								parentwindow.module.attachments = "";
							}
						}
						
						var deletedattachments = new Object();
						
						<?
							if(isset($_SESSION["deleteattachment"]) && isset($_SESSION["deleteattachment"][$_REQUEST["dialog_attachments"]])) {
								foreach($_SESSION["deleteattachment"][$_REQUEST["dialog_attachments"]] as $attach_num)
								{
						?>
							deletedattachments["<?=$attach_num?>"] = "deleted";
						<?
								}
							}
						?>
						
						var attachments = parentwindow.module.attachments;
						for(var i = 0; i < attachments.length; i++)
						{
							var attachment = attachments[i];
							
							if(typeof(deletedattachments[attachment["attach_num"]]) == "undefined") {
								var option = dhtml.addElement(filelist, "option");
								option.value = attachment["attach_num"];
								option.text = attachment["name"];
							}
						}

						var newattachments = new Array();
						<?
							if(isset($_SESSION["files"]) && isset($_SESSION["files"][$_REQUEST["dialog_attachments"]])) {
								foreach($_SESSION["files"][$_REQUEST["dialog_attachments"]] as $tmpname => $file)
								{
						?>
							var option = dhtml.addElement(filelist, "option");
							option.value = "<?=urlencode($tmpname)?>";
							option.text = "<?=windows1252_to_utf8($file["name"])?>";
							
							var attachment = new Object();
							attachment["attach_num"] = "<?=urlencode($tmpname)?>"
							attachment["name"] = "<?=windows1252_to_utf8($file["name"])?>";
							attachment["size"] = <?=$file["size"]?>;
							newattachments.push(attachment);
						<?
								}
							}
						?>
						
						parentwindow.module.deletedattachments = deletedattachments;
						parentwindow.module.newattachments = newattachments;
						parentwindow.module.setAttachments();
					}
<?php } // getJavaScript_onload						

function getBody(){ ?>
		<div id="attachments">
			<form id="upload" action="<?=$_SERVER["REQUEST_URI"]?>" method="POST" enctype="multipart/form-data">
				<fieldset>
					<legend><?=_("Add attachments")?></legend>
					<dl>
						<dt><label for="attachment"><?=_("Filename")?>:</label></dt>
						<dd><input type="file" id="attachment" name="attachments[]" onchange="dhtml.getElementById('upload').submit();" /></dd>
						<dd> (<?= _("max filesize") ?>: <?= getMaxUploadSize(true) ?>)</dd>
					</dl>
	
					<input type="hidden" name="MAX_FILE_SIZE" value="<?= getMaxUploadSize(false) ?>" />
					<input type="hidden" name="dialog_attachments" value="<?=$_REQUEST["dialog_attachments"]?>" />
				</fieldset>
			</form>

			<fieldset id="files">
				<legend><?=_("Files currently attached")?></legend>
				<form id="action" action="<?=$_SERVER["REQUEST_URI"]?>" method="POST">
					<select id="filelist" size="10" onchange="attachmentSelect();">
					</select>
	
					<input id="delete" class="button_delete" type="button" value="<?=_("Delete")?>" title="<?=_("Delete selected file")?>" onclick="dhtml.getElementById('action').submit();" />
					<input id="save" class="button_save" type="button" value="<?=_("Download")?>" title="<?=_("Download selected file")?>" onclick="location.href='index.php?load=download_attachment&store=<?=htmlentities($_GET["store"])?>&entryid=<?=htmlentities($_GET["entryid"])?>&attachNum=' + dhtml.getElementById('filelist').options[dhtml.getElementById('filelist').selectedIndex].value + '&openType=attachment&dialog_attachments=<?=htmlentities($_REQUEST["dialog_attachments"])?>'" />
					<input type="hidden" name="dialog_attachments" value="<?=$_REQUEST["dialog_attachments"]?>" />
					<input id="deleteattachment" type="hidden" name="deleteattachment" value="" />
					<input id="type" type="hidden" name="type" value="" />
				</form>
			</fieldset>
			
			<?=createCloseButton("window.close();")?>
		</div>
<?php } // getBody
?>
