<?php

function getModuleName() { 
	return "addressbooklistmodule"; 
}

function getModuleType() {
	return "list"; 
}

function getDialogTitle() {
	return _("Address Book");
}

function getIncludes(){
	return array(
			"client/modules/".getModuleName().".js",
			"client/layout/js/addressbook.js"
		);
}

function getJavaScript_onload(){ ?>
					var data = new Object();
					data["storeid"] = <?=get("storeid","false", "'")?>;
					data["dest"] = "<?=get("dest","anonymous", false)?>";
					data["type"] = "<?=get("type","fullemail", false)?>";
					data["source"] = "<?=get("source", "all", false)?>"; // possible values: all, gab
					data["groups"] = "<?=get("groups", "expand", false)?>"; // possible values: expand, yes, no

					module.init(moduleID, dhtml.getElementById("items"), false, data);
					module.setData(data);
					module.retrieveHierarchy();

					dhtml.addEvent(module.id, dhtml.getElementById("name"), "keypress", addressBookSearchKeyInput);
					// Put focus on search field
					dhtml.getElementById("name").focus();

					changeAddressBookFolder();
<?
					// Get the array of items that should be shown at the bottom of the screen (To, Cc, Bcc, etc)
					$recipients = array();
					if (isset($_GET["fields"]) && is_array($_GET["fields"])){
						$recipients = $_GET["fields"];
					}
					
					echo "fields = new Array();\n";
					foreach($recipients as $key=>$value){
						echo "fields.push('".addslashes($key)."');\n";
					}

					echo "module.addEventHandler('openitem', false, onOpenItem);\n";
?>
					getAddressBookRecipients(fields);
<?php } // getJavaScript_onload						

function getJavaScript_other(){ ?>
	var fields;
	
	
<?php } // getJavaScript_other

function getBody(){ ?>
		<div id="addressbook">
			<table id="search" width="100%" border="0" cellspacing="0" cellpadding="0">
				<tr>
					<td class="propertybold" colspan="2" nowrap><?=_("Type Name")?>:</td>
					<td class="propertybold" nowrap><?=_("Show names from the")?>:</td>
				</tr>
				<tr>
					<td width="150">
						<input id="name" class="fieldsize" type="text" value="" size="29">
					</td>
					<td width="200">
						<div class="searchbutton" onmouseover="this.className+=' searchbuttonover';" onmouseout="this.className='searchbutton';" onclick="searchAddressBook();">&nbsp;</div>
					</td>
					<td>
						<select id="addressbookfolders" class="comboboxwidth" onchange="changeAddressBookFolder(this);">
						</select>
					</td>
				</tr>
			</table>
			
			<div id="items" onmousedown="return false;">
				
			</div>
			
			<table width="100%" cellspacing="0" cellpadding="1">
				<?	
					$recipients = array();
					if (isset($_GET["fields"]) && is_array($_GET["fields"])){
						$fields = $_GET["fields"];
						foreach($fields as $key=>$value){
							$recipients[$key] = $value;
						}
					}else{
						$recipients = array("anonymous" => "anonymous");
					}


					foreach($recipients as $key => $recipient)
					{
					    if($key != "anonymous") {
				?>
					<tr>
						<td class="propertynormal propertywidth" align="center">
							<input class="button" type="button" value="<?=htmlentities($recipient, ENT_QUOTES, 'UTF-8')?>..." onclick="addSelectedContacts('<?=addslashes($key)?>');">
						</td>
						<td>
							<input id="<?=htmlentities($key, ENT_QUOTES, 'UTF-8')?>" class="field" type="text">
						</td>
					</tr>
				<?
				        } else {
				            ?>
				            <input id="<?=htmlentities($key, ENT_QUOTES, 'UTF-8')?>" class="field" type="hidden">
				            <?
                        }
					}
				?>
			</table>
			
			<?=createConfirmButtons("addressBookSubmit();window.close();")?>
		</div>
<?php } // getBody
?>
