<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1375 $
 * $Id: EditPolicyGroup.php 1375 2007-11-01 23:24:56Z ipso $
 * $Date: 2007-11-01 16:24:56 -0700 (Thu, 01 Nov 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('policy_group','enabled')
		OR !( $permission->Check('policy_group','edit') OR $permission->Check('policy_group','edit_own') ) ) {
	$permission->Redirect( FALSE ); //Redirect
}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Policy Group')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'data'
												) ) );

$pgf = new PolicyGroupFactory();

$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		//Debug::setVerbosity(11);

		$pgf->StartTransaction();

		$pgf->setId( $data['id'] );
		$pgf->setCompany( $current_company->getId() );
		$pgf->setName( $data['name'] );
		$pgf->setMealPolicyID( $data['meal_policy_id'] );
		$pgf->setExceptionPolicyControlID( $data['exception_policy_control_id'] );
		$pgf->setHolidayPolicyID( $data['holiday_policy_id'] );

		if ( $pgf->isValid() ) {
			$pgf->Save(FALSE);

			if ( isset($data['user_ids'] ) ) {
				$pgf->setUser( $data['user_ids'] );
			} else {
				$pgf->setUser( array() );
			}

			if ( isset($data['over_time_policy_ids'] ) ) {
				$pgf->setOverTimePolicy( $data['over_time_policy_ids'] );
			} else {
				$pgf->setOverTimePolicy( array() );
			}

			if ( isset($data['premium_policy_ids'] ) ) {
				$pgf->setPremiumPolicy( $data['premium_policy_ids'] );
			} else {
				$pgf->setPremiumPolicy( array() );
			}

			if ( isset($data['round_interval_policy_ids']) ) {
				$pgf->setRoundIntervalPolicy( $data['round_interval_policy_ids'] );
			} else {
				$pgf->setRoundIntervalPolicy( array() );
			}

			if ( isset($data['accrual_policy_ids']) ) {
				$pgf->setAccrualPolicy( $data['accrual_policy_ids'] );
			} else {
				$pgf->setAccrualPolicy( array() );
			}

			if ( $pgf->isValid() ) {
				$pgf->Save();
				$pgf->CommitTransaction();

				Redirect::Page( URLBuilder::getURL( NULL, 'PolicyGroupList.php') );

				break;
			}


		}
		$pgf->FailTransaction();

	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$pglf = new PolicyGroupListFactory();
			$pglf->getById($id);

			foreach ($pglf as $pg_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$data = array(
									'id' => $pg_obj->getId(),
									'name' => $pg_obj->getName(),
									'meal_policy_id' => $pg_obj->getMealPolicyID(),
									'holiday_policy_id' => $pg_obj->getHolidayPolicyID(),
									'exception_policy_control_id' => $pg_obj->getExceptionPolicyControlID(),
									'user_ids' => $pg_obj->getUser(),
									'over_time_policy_ids' => $pg_obj->getOverTimePolicy(),
									'premium_policy_ids' => $pg_obj->getPremiumPolicy(),
									'round_interval_policy_ids' => $pg_obj->getRoundIntervalPolicy(),
									'accrual_policy_ids' => $pg_obj->getAccrualPolicy(),
									'created_date' => $pg_obj->getCreatedDate(),
									'created_by' => $pg_obj->getCreatedBy(),
									'updated_date' => $pg_obj->getUpdatedDate(),
									'updated_by' => $pg_obj->getUpdatedBy(),
									'deleted_date' => $pg_obj->getDeletedDate(),
									'deleted_by' => $pg_obj->getDeletedBy()
								);
			}
		}

		$none_array_option = array('0' => TTi18n::gettext('-- None --') );

		$ulf = new UserListFactory();
		$user_options = $ulf->getByCompanyIDArray( $current_company->getId(), FALSE, TRUE );

		$otplf = new OverTimePolicyListFactory();
		$over_time_policy_options = Misc::prependArray( $none_array_option, $otplf->getByCompanyIDArray( $current_company->getId(), FALSE ) );

		$pplf = new PremiumPolicyListFactory();
		$premium_policy_options = Misc::prependArray( $none_array_option, $pplf->getByCompanyIDArray( $current_company->getId(), FALSE ) );

		$riplf = new RoundIntervalPolicyListFactory();
		$round_interval_policy_options = Misc::prependArray( $none_array_option, $riplf->getByCompanyIDArray( $current_company->getId(), FALSE ) );

		$mplf = new MealPolicyListFactory();
		$meal_options = Misc::prependArray( $none_array_option, $mplf->getByCompanyIdArray( $current_company->getId(), FALSE ) );

		$epclf = new ExceptionPolicyControlListFactory();
		$exception_options = Misc::prependArray( $none_array_option, $epclf->getByCompanyIdArray( $current_company->getId(), FALSE ) );

		$hplf = new HolidayPolicyListFactory();
		$holiday_options = Misc::prependArray( $none_array_option, $hplf->getByCompanyIdArray( $current_company->getId(), FALSE ) );

		$aplf = new AccrualPolicyListFactory();
		$aplf->getByCompanyIdAndTypeID( $current_company->getId(), array(20, 30) ); //Calendar and Hour based.
		$accrual_options = Misc::prependArray( $none_array_option, $aplf->getArrayByListFactory( $aplf, FALSE ) );

		//Select box options;
		$data['user_options'] = $user_options;
		$data['over_time_policy_options'] = $over_time_policy_options;
		$data['premium_policy_options'] = $premium_policy_options;
		$data['round_interval_policy_options'] = $round_interval_policy_options;
		$data['accrual_policy_options'] = $accrual_options;
		$data['meal_options'] = $meal_options;
		$data['exception_options'] = $exception_options;
		$data['holiday_options'] = $holiday_options;

		if ( isset($data['user_ids']) AND is_array($data['user_ids']) ) {
			$tmp_user_options = $user_options;
			foreach( $data['user_ids'] as $user_id ) {
				if( isset($tmp_user_options[$user_id]) ) {
					$filter_user_options[$user_id] = $tmp_user_options[$user_id];
				}
			}
			unset($user_id);
		}
		$smarty->assign_by_ref('filter_user_options', $filter_user_options);

		$smarty->assign_by_ref('data', $data);

		break;
}

$smarty->assign_by_ref('pgf', $pgf);

$smarty->display('policy/EditPolicyGroup.tpl');
?>