<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1969 $
 * $Id: EditOverTimePolicy.php 1969 2008-07-10 14:55:56Z ipso $
 * $Date: 2008-07-10 07:55:56 -0700 (Thu, 10 Jul 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('over_time_policy','enabled')
		OR !( $permission->Check('over_time_policy','edit') OR $permission->Check('over_time_policy','edit_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Overtime Policy')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'data'
												) ) );

if ( isset($data['trigger_time'] ) ) {
	$data['trigger_time'] = TTDate::parseTimeUnit($data['trigger_time']);
}

$otpf = new OverTimePolicyFactory();

$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$otpf->setId( $data['id'] );
		$otpf->setCompany( $current_company->getId() );
		$otpf->setName( $data['name'] );
		$otpf->setType( $data['type_id'] );
		//$otpf->setLevel( $data['level'] );
		$otpf->setTriggerTime( $data['trigger_time'] );
		$otpf->setRate( $data['rate'] );
		$otpf->setAccrualPolicyId( $data['accrual_policy_id'] );
		$otpf->setAccrualRate( $data['accrual_rate'] );
		$otpf->setPayStubEntryAccountId( $data['pay_stub_entry_account_id'] );

		if ( $otpf->isValid() ) {
			$otpf->Save();

			Redirect::Page( URLBuilder::getURL( NULL, 'OverTimePolicyList.php') );

			break;
		}

	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$otplf = new OverTimePolicyListFactory();
			$otplf->getById($id);

			foreach ($otplf as $otp_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$data = array(
									'id' => $otp_obj->getId(),
									'name' => $otp_obj->getName(),
									'type_id' => $otp_obj->getType(),
									//'level' => $otp_obj->getLevel(),
									'trigger_time' => $otp_obj->getTriggerTime(),
									'rate' => $otp_obj->getRate(),
									'accrual_rate' => $otp_obj->getAccrualRate(),
									'accrual_policy_id' => $otp_obj->getAccrualPolicyID(),
									'pay_stub_entry_account_id' => $otp_obj->getPayStubEntryAccountId(),
									'created_date' => $otp_obj->getCreatedDate(),
									'created_by' => $otp_obj->getCreatedBy(),
									'updated_date' => $otp_obj->getUpdatedDate(),
									'updated_by' => $otp_obj->getUpdatedBy(),
									'deleted_date' => $otp_obj->getDeletedDate(),
									'deleted_by' => $otp_obj->getDeletedBy()
								);
			}
		} elseif ( $action != 'submit') {
			$data = array( 'trigger_time' => 0, 'rate' => '1.00', 'accrual_rate' => '1.00' );
		}

		$aplf = new AccrualPolicyListFactory();
		$accrual_options = $aplf->getByCompanyIDArray( $current_company->getId(), TRUE );

		$psealf = new PayStubEntryAccountListFactory();
		$pay_stub_entry_options = $psealf->getByCompanyIdAndStatusIdAndTypeIdArray( $current_company->getId(), 10, array(10,20,30,50) );

		//Select box options;
		$data['type_options'] = $otpf->getOptions('type');
		//$data['level_options'] = $otpf->getOptions('level');
		$data['accrual_options'] = $accrual_options;
		$data['pay_stub_entry_options'] = $pay_stub_entry_options;

		$smarty->assign_by_ref('data', $data);

		break;
}

$smarty->assign_by_ref('otpf', $otpf);

$smarty->display('policy/EditOverTimePolicy.tpl');
?>