<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditPayStubEntryNameAccount.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('pay_stub','enabled')
		OR !$permission->Check('pay_stub','view') ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'General Ledger Accounts')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'name_account_data'
												) ) );

$psenalf = new PayStubEntryNameAccountListFactory();

switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$psenaf = new PayStubEntryNameAccountFactory();

		$psenaf->StartTransaction();
		foreach($name_account_data as $pay_stub_entry_name_id => $value_arr){
			Debug::Text('Pay Stub Entry Name ID: '. $pay_stub_entry_name_id, __FILE__, __LINE__, __METHOD__,10);

			if ( ( isset($value_arr['debit_account'])  AND $value_arr['debit_account'] != '' )
					OR ( isset($value_arr['credit_account']) AND $value_arr['credit_account'] != '' )
					OR ( isset($value_arr['id']) AND $value_arr['id'] != '' )
				) {

				Debug::Text('Pay Stub Entry Name ID: '. $pay_stub_entry_name_id .' ID: '. $value_arr['id'] .'Debit Account: '. $value_arr['debit_account'] .' Credit Account: '. $value_arr['credit_account'], __FILE__, __LINE__, __METHOD__,10);

				if ( isset($value_arr['id']) AND $value_arr['id'] != '' ) {
					$psenaf->setId( $value_arr['id'] );
				}
				$psenaf->setCompany( $current_company->getId() );
				$psenaf->setPayStubEntryNameId( $pay_stub_entry_name_id  );
				$psenaf->setDebitAccount( $value_arr['debit_account'] );
				$psenaf->setCreditAccount( $value_arr['credit_account'] );
				if ( $psenaf->isValid() ) {
					$psenaf->Save();
				}
			} elseif ( ( isset($value_arr['id']) AND $value_arr['id'] != '' )
						AND $value_arr['debit_account'] == '' AND $value_arr['credit_account'] == '') {
				Debug::Text('Delete: ', __FILE__, __LINE__, __METHOD__,10);
			}
		}

		//$psenaf->FailTransaction();
		$psenaf->CommitTransaction();

		Redirect::Page( URLBuilder::getURL(NULL, Environment::getBaseURL().'/pay_stub/EditPayStubEntryNameAccount.php') );

		break;
	default:
		if ( !isset($action) ) {
			BreadCrumb::setCrumb($title);

			$psenalf = new PayStubEntryNameAccountListFactory();
			$psenalf->getByCompanyId( $current_company->getId() );

			foreach ($psenalf as $name_account_obj) {
				//Debug::Arr($department,'Department', __FILE__, __LINE__, __METHOD__,10);

				$name_account_data[$name_account_obj->getPayStubEntryNameId()] = array(
											'id' => $name_account_obj->getId(),
											'pay_stub_entry_name_id' => $name_account_obj->getPayStubEntryNameId(),
											'debit_account' => $name_account_obj->getDebitAccount(),
											'credit_account' => $name_account_obj->getCreditAccount(),
											'created_date' => $name_account_obj->getCreatedDate(),
											'created_by' => $name_account_obj->getCreatedBy(),
											'updated_date' => $name_account_obj->getUpdatedDate(),
											'updated_by' => $name_account_obj->getUpdatedBy(),
											'deleted_date' => $name_account_obj->getDeletedDate(),
											'deleted_by' => $name_account_obj->getDeletedBy()
								);
			}

			//Get all accounts
			$psenlf = new PayStubEntryNameListFactory();
			$psenlf->getAll();

			$type_options  = $psenlf->getOptions('type');

			$i=0;
			foreach($psenlf as $entry_name_obj) {
				$display_type = FALSE;
				if ( $i == 0 ) {
					$display_type = TRUE;
				} else {
					if ( $entry_name_obj->getType() != $prev_type_id) {
						$display_type = TRUE;
					}
				}
				$name_account_data[$entry_name_obj->getId()]['pay_stub_entry_description'] = $entry_name_obj->getDescription();
				$name_account_data[$entry_name_obj->getId()]['pay_stub_entry_name_id'] = $entry_name_obj->getId();
				$name_account_data[$entry_name_obj->getId()]['type_id'] = $entry_name_obj->getType();
				$name_account_data[$entry_name_obj->getId()]['type'] = $type_options[$entry_name_obj->getType()];

				$name_account_data[$entry_name_obj->getId()]['display_type'] = $display_type;

				$data[] = $name_account_data[$entry_name_obj->getId()];

				$prev_type_id = $entry_name_obj->getType();
				$i++;
			}


		}

		$smarty->assign_by_ref('name_account_data', $data);
		break;
}

$smarty->assign_by_ref('psenalf', $psenalf);
//$smarty->assign_by_ref('current_time', TTDate::getDate('TIME') );

$smarty->display('pay_stub/EditPayStubEntryNameAccount.tpl');
?>