<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: InstallSchema_Base.class.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */

/**
 * @package Module_Install
 */
class InstallSchema_Base {

	protected $schema_sql_file_name = NULL;
	protected $version = NULL;
	protected $db = NULL;
	protected $is_upgrade = FALSE;

	function setDatabaseConnection( $db ) {
		$this->db = $db;
	}

	function getDatabaseConnection() {
		return $this->db;
	}

	function setIsUpgrade( $val ) {
		$this->is_upgrade = (bool)$val;
	}
	function getIsUpgrade() {
		return $this->is_upgrade;
	}

	function setVersion($value) {
		$this->version = $value;
	}
	function getVersion() {
		return $this->version;
	}

	function setSchemaSQLFilename($file_name) {
		$this->schema_sql_file_name = $file_name;
	}
	function getSchemaSQLFilename() {
		return $this->schema_sql_file_name;
	}

	function getSchemaGroup() {
		$schema_group = substr( $this->getVersion(), -1,1 );
		Debug::text('Schema: '. $this->getVersion() .' Group: '. $schema_group, __FILE__, __LINE__, __METHOD__,9);

		return strtoupper($schema_group);
	}


	//load Schema file data
	function getSchemaSQLFileData() {
		//Read SQL data into memory
		if ( is_readable( $this->getSchemaSQLFilename() ) ) {
			Debug::text('Schema SQL File is readable: '. $this->getSchemaSQLFilename(), __FILE__, __LINE__, __METHOD__,9);
			$contents = file_get_contents( $this->getSchemaSQLFilename() );

			Debug::Arr($contents, 'SQL File Data: ', __FILE__, __LINE__, __METHOD__,9);
			return $contents;
		}

		Debug::text('Schema SQL File is NOT readable, or is empty!', __FILE__, __LINE__, __METHOD__,9);

		return FALSE;
	}

	private function _InstallSchema() {
		//Run the actual SQL queries here

		$sql = $this->getSchemaSQLFileData();
		if ( $sql == FALSE ) {
			return FALSE;
		}

		if ( $sql !== FALSE AND strlen($sql) > 0 ) {
			Debug::text('Schema SQL has data, executing commands!', __FILE__, __LINE__, __METHOD__,9);

			//Split into individual SQL queries, as MySQL apparently doesn't like more then one query
			//in a single query() call.
			$split_sql = explode(';', $sql);
			if ( is_array($split_sql) ) {

				foreach( $split_sql as $sql_line ) {
				
					if ( trim($sql_line) != '' ) {

						$retval = $this->getDatabaseConnection()->Execute( $sql_line );

						if ( $retval == FALSE ) {
							return FALSE;
						}
					}
				}
			}
		}

		Debug::text('Schema SQL does not have data, not executing commands, continuing...', __FILE__, __LINE__, __METHOD__,9);
		return TRUE;
	}

	private function _postPostInstall() {
		Debug::text('Modify Schema version in system settings table!', __FILE__, __LINE__, __METHOD__,9);
		//Modify schema version in system_settings table.

		$sslf = new SystemSettingListFactory();
		$sslf->getByName('schema_version_group_'. $this->getSchemaGroup() );
		if ( $sslf->getRecordCount() == 1 ) {
			$obj = $sslf->getCurrent();
		} else {
			$obj = new SystemSettingListFactory();
		}

		$obj->setName( 'schema_version_group_'. $this->getSchemaGroup() );
		$obj->setValue( $this->getVersion() );
		if ( $obj->isValid() ) {
			Debug::text('Setting Schema Version to: '. $this->getVersion() .' Group: '. $this->getSchemaGroup() , __FILE__, __LINE__, __METHOD__,9);
			$obj->Save();

			return TRUE;
		}

		return FALSE;
	}

	function InstallSchema() {

		$this->getDatabaseConnection()->StartTrans();

		Debug::text('Installing Schema Version: '. $this->getVersion(), __FILE__, __LINE__, __METHOD__,9);
		if ( $this->preInstall() == TRUE ) {
			if ( $this->_InstallSchema() == TRUE ) {
				if ( $this->postInstall() == TRUE ) {
					$retval = $this->_postPostInstall();
					if ( $retval == TRUE ) {

						$this->getDatabaseConnection()->CompleteTrans();

						return $retval;
					}

				}
			}
		}

		$this->getDatabaseConnection()->FailTrans();

		return FALSE;
	}
}
?>
