<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: HelpGroupControlFactory.class.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */

/**
 * @package Module_Help
 */
class HelpGroupControlFactory extends Factory {
	protected $table = 'help_group_control';
	protected $pk_sequence_name = 'help_group_control_id_seq'; //PK Sequence name
	function getScriptName() {
		return $this->data['script_name'];
	}
	function setScriptName($value) {
		$value = trim($value);

		if (	$this->Validator->isLength(	'script_name',
											$value,
											TTi18n::gettext('Incorrect Script Name'),
											2,255) ) {

			$this->data['script_name'] = $value;

			return FALSE;
		}

		return FALSE;
	}

	function getName() {
		return $this->data['name'];
	}
	function setName($value) {
		$value = trim($value);

		if (	$value == ''
				OR
				$this->Validator->isLength(	'name',
											$value,
											TTi18n::gettext('Incorrect Name'),
											2,255) ) {

			$this->data['name'] = $value;

			return FALSE;
		}

		return FALSE;
	}

	function getHelp() {
		$hglf = new HelpGroupListFactory();
		$hglf->getByHelpGroupControlId( $this->getId() );
		foreach ($hglf as $help_group_obj) {
			$help_list[] = $help_group_obj->getHelp();
		}

		if ( isset($help_list) ) {
			return $help_list;
		}

		return FALSE;
	}
	function setHelp($ids) {
		//If needed, delete mappings first.
		$hglf = new HelpGroupListFactory();
		$hglf->getByHelpGroupControlId( $this->getId() );

		$help_ids = array();
		foreach ($hglf as $help_group_entry) {
			$help_id = $help_group_entry->getHelp();
			Debug::text('Help ID: '. $help_group_entry->getHelp(), __FILE__, __LINE__, __METHOD__, 10);

			//Delete all items first.				
			$help_group_entry->Delete();
		}
		
		if (is_array($ids) and count($ids) > 0) {

			//Insert new mappings.
			$hgf = new HelpGroupFactory();
			$i=0;
			foreach ($ids as $id) {
				//if ( !in_array($id, $help_ids) ) {
					$hgf->setHelpGroupControl( $this->getId() );
					$hgf->setOrder( $i );
					$hgf->setHelp( $id );
					

					if ($this->Validator->isTrue(		'help',
														$hgf->Validator->isValid(),
														TTi18n::gettext('Incorrect Help Entry'))) {
						$hgf->save();
					}
				//}
				$i++;
			}

			//return TRUE;
		}

		return TRUE;
	}

}
?>
