<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only tranlates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release 


$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Links/Commands" => "連結/命令",
"Create a tag for the current wiki" => "為目前的 wiki 產生一個標籤",
"create tag" => "產生 tag",
"Restore the wiki" => "回復此 wiki",
"Tag Name" => "標籤名稱",
"remove" => "移除",
"Anonymous users can edit pages" => "允許匿名使用者編輯頁面",
"Wiki_Tiki_Title" => "Wiki_Tiki_Title",
"Ranking" => "排名",
"Like pages" => "相似頁面",
"User versions" => "使用者版本",
"change" => "更改",
"name" => "名稱",
"assign" => "指定",
"preview" => "預覽",
"save" => "儲存",
"TextFormattingRules" => "文字格式化原則",
"Emphasis" => "字型樣式",
"italics" => "斜體",
"both" => "粗斜體",
"References" => "參考",
"JoinCapitalizedWords" => "連在一起的大寫字",
"or use square brackets for an" => "或使用方括號表示",
"link_description" => "連結描述",
"make_headings" => "建立標題",
"Title_bar" => "標題列",
"img" => "img",
"printable" => "友善列印",
"remove page" => "移除頁面",
"unlock" => "解除鎖定",
"lock" => "鎖定",
"permissions" => "權限",
"history" => "歷程記錄",
"backlinks" => "反向連結",
"like pages" => "相似頁面",
"History of" => "歷程紀錄",
"Actual_version" => "實際版本",
"current_version" => "目前版本",
"all" => "全部",
"All pages" => "所有頁面",
"version" => "版本",
"Rollback_page" => "復原頁面",
"register" => "註冊",
"last_login" => "上次登入",
"delete" => "刪除",
"assign group" => "指定群組",
"Create or edit a gallery using this form" => "使用此表單產生或編輯一個圖庫",
"edit/create" => "編輯/產生",
"versions" => "版本",
"Current permissions for this page" => "本頁面權限設定",
"Perm" => "權限",
"No individual permissions global permissions to all pages apply" => "不採用個別頁面權限,套用全體權限至所有頁面",
"Assign permissions to thispage" => "指定此頁面的權限",
"last changes" => "最近變動",
"ranking" => "排名",
"list_pages" => "列出頁面",
"my galleries" => "我的圖庫",
"upload image" => "上傳影像",
"admin" => "管理者",
"groups" => "群組",
"cache" => "快取",
"upload" => "上傳",
"You can include the image in an HTML/Tiki page using" => "你可以將此影像包含在HTML/Tiki的頁面中使用",
"edit gallery" => "編輯圖庫",
"rebuild thumbnails" => "重建縮圖",
"list gallery" => "列出圖庫",
"hits" => "點擊數",
"return to gallery" => "返回圖庫",
"move" => "移動",
"You can include the image in an HTML or Tiki page using" => "你可以包含影像在HTML或Tiki頁面中使用",
"assign module" => "指定模組",
"left modules" => "左模組",
"right modules" => "右模組",
"clear cache" => "清除快取",
"order" => "順序",
"rows" => "列",
"down" => "下",
"up" => "上",
"create/edit" => "建立/編輯",
"url" => "url",
"browse gallery" => "瀏覽圖庫",
"search" => "搜尋",
"modules" => "模組",
"links" => "連結",
"system gallery" => "系統圖庫",
"The passwords dont match" => "密碼錯誤",
"Anonymous users cannot edit pages" => "匿名使用者無法編輯頁面",
"Unexistant version" => "不存在版本",
"Unexistant user" => "不存在的使用者",
"Permission denied you cannot assign permissions for this page" => "權限不足, 你無法指定此頁面的權限",
"Permission denied you cannot browse this gallery" => "你沒有瀏覽這個圖庫的權限",
"view info" => "檢視資訊",
"reads" => "閱讀",
"HasImg" => "有影像",
"UseImg" => "使用影像",
"posts" => "佈告數",
"visits" => "瀏覽數",
"User preferences screen" => "使用者偏好畫面",
"create" => "建立",
"The SandBox is a page where you can practice your editing skills, use the preview feature\n\nto preview the appearance of the page, no versions are stored for this page." => "沙池是一個用來讓你練習編輯技巧的頁面, 使用預覽功能\n\n可以觀看頁面的外觀, 但是不會儲存任何版本變動.",
"HomePage" => "首頁",
"set" => "設定",
"Change your password" => "更改你的密碼",
"Configure this page" => "設定本頁面",
"hotwords" => "熱門單字",
"list pages" => "列出頁面",
"user preferences" => "使用者偏好",
"You cannot edit this page because it is a user personal page" => "你無法編輯此頁面, 因為這是使用者個人頁面",
"cannot process upload" => "無法進行上傳",
"You have to provide a name to the image" => "你必須為此影像取個名字",
"No image uploaded" => "沒有上傳影像",
"The passwords didn't match" => "密碼不符",
"galleries" => "圖庫",
"images" => "影像",
"blog posts" => "blog 佈告",
"articles" => "文章",
"create new block" => "建立新區塊",
"Current version" => "目前版本",
"Next version" => "下一個版本",
"Programmed versions" => "計劃的版本",
"Old versions" => "舊版本",
"Edit desc" => "編輯描述",
"Index page" => "索引頁面",
"Set prefs" => "設定偏好",
"create zone" => "建立區域",
"save the banner" => "儲存大標題",
">Remove Zones (you lose entered info for the banner)" => ">移除區域 (會失去此標題的資訊)",
">Block description: " => ">區塊描述: ",
"Admin content" => "管理內容",
"go" => "衝",
"You do not have permission to write the template" => "權限不足, 你無法寫入模板",
"position" => "位置",
"files" => "檔案",
"Wiki comments settings" => "Wiki 評論設定",
"Warn on edit" => "編輯警告",
"Show comments" => "顯示評論",
"Hide comments" => "隱藏評論",
"post" => "發表",
"reply to this" => "回覆這篇",
"Comments below your current threshold" => "目前起算點以下的評論",
"Create or edit a file gallery using this form" => "使用此表單建立或編輯一個檔案庫",
"upload file" => "上傳檔案",
"Top Files" => "最熱門檔案",
"Unexistant link" => "不存在的連結",
"Cannot get file from URL" => "無法由URL取得檔案",
"Unexistant gallery" => "檔案庫不存在",
"You cant download files" => "你無法下傳檔案",
"No file" => "沒有檔案",
"Create/edit Forums" => "建立/編輯論壇",
"Moderator" => "板主",
"topics" => "主題",
"coms" => "coms",
"age" => "年齡",
"ppd" => "每日發表數",
"last post" => "最近發表佈告",
"perms" => "權限",
"Comm" => "Comm",
"Cms" => "Cms",
"Assign user" => "指定使用者",
"to groups" => "給群組",
"prev image" => "前一個影像",
"next image" => "下一個影像",
"There are inddividual permissions set for this gallery" => "此圖庫有獨立的權限設定",
" modified" => " 變更",
"permission" => "權限",
"Assign permissions to this page" => "指定權限給此頁面",
"Show Post Form" => "顯示發表表單",
"Hide Post Form" => "隱藏發表表單",
"smileys" => "表情符號",
"score" => "分數",
"author" => "作者",
"Simple box" => "簡單方塊",
"site" => "網站",
"path" => "路徑",
"send" => "發送",
"clear" => "清除",
"Edit received page" => "編輯收到的頁面",
"accept" => "接受",
"Edit or add category" => "編輯或增加分類",
"add" => "增加",
"sub categories" => "子類別",
"There are inddividual permissions set for this blog" => "這個 blog 有獨立的權限設定",
"Layout options" => "版面配置選項",
"polls" => "投票",
"features" => "功能",
"cms" => "cms",
"CMS settings" => "CMS設定",
"Poll settings" => "投票設定",
"image galleries" => "影像圖庫",
"Blog settings" => "Blog設定",
"general" => "一般",
"Set home forum" => "設定首頁論壇",
"file galleries" => "檔案總覽",
"rss" => "rss",
"Set feeds" => "設定 feeds",
"use poll" => "使用投票",
"use dynamic  content" => "使用動態內容",
"use rss module" => "使用 rss 模組",
"use banner zone" => "使用大標題區域",
"There are inddividual permissions set for this file gallery" => "這個檔案庫有獨立權限設定",
"half a second" => "半秒",
"refresh" => "更新",
"Create/edit RSS module" => "建立/編輯 RSS 模組",
"Create/edit Menus" => "建立/編輯 選單",
"options" => "選項",
"section" => "區段",
"back" => "返回",
"Admin chat" => "管理閒談",
"Permission denied you cant view this section" => "權限不足, 你無法觀看這個區段",
"File gals" => "檔案庫",
"Image gals" => "圖庫",
"Comparing versions" => "比較版本",
"Quicklinks" => "快速連結",
"use square brackets for an" => "使用方括號表示",
"Will display using the indicated HTML color" => "會使用指定的 HTML 色彩顯示",
"Center" => "置中",
"Will display the text centered" => "會置中顯示文字",
"add article" => "加入文章",
"deep" => "deep",
"Allowed HTML:" => "允許 HTML:",
"undo" => "回復",
"Users can configure modules" => "允許使用者設定模組",
"Remind passwords by email" => "用email提示密碼",
"FAQs settings" => "FAQs 設定",
"FAQ comments" => "FAQ 評論",
"Configure modules" => "設定模組",
"to insert a random tagline" => "插入隨機的tagline",
"Use (:name:) for smileys" => "使用 (:名稱:) 表示表情符號",
"Restoring a backup" => "回存一個備份",
"Warning!" => "警告!",
"Restoring a backup destoys all the data in your Tiki database.\n\nAll your tables will be replaced with the information in the backup." => "回存備份將會毀掉現有 Tiki 資料庫的全部資料.\n\n所有表格中的資料都會被備份中的資料取代",
"Click here to confirm restoring" => "點選這裡以確定回存",
"Create new backup" => "建立新備份",
"Creating backups may take a long time. If the process is not completed you will\n\nsee a blank screen. If so you need to increment the maximum script execution time\n\nfrom your php.ini file" => "建立備份可能花費許多時間。如果備份程序未完成，會出現空白\n\n頁面。你必須從 php.ini 中調整最大命令執行時間以避免發生此現象。\n\n",
"Click here to create a new backup" => "點選這裡以建立新備份",
"Upload a backup" => "上傳一個備份",
"Upload backup" => "上傳備份",
"Flash binary (.sqf or .dcr)" => "Flash 檔案(.sqf 或 .dcr)",
"Create/edit Faq" => "建立/增加 FAQ",
"questions" => "問題",
"new question" => "新問題",
"use" => "使用",
"FAQ Questions" => "FAQ 問題",
"FAQ Answers" => "FAQ 答案",
"print" => "列印",
">I forgot my password" => ">忘記密碼",
"send me my password" => "寄給我密碼",
"column" => "行",
"Show chart for the last " => "顯示排行榜於最近 ",
"days (0=all)" => "天 (0=全部)",
"dispay" => "dispay",
"user bookmarks" => "使用者書籤",
"stats" => "統計",
"Admin Cookies" => "管理 Cookies",
"No attachments for this page" => "此頁面無附檔",
"Entire site" => "整個網站",
"content templates" => "內容模板",
"shoutbox" => "shoutbox",
"drawings" => "繪圖",
"assigned" => "指定",
"edit image" => "編輯影像",
"Hotwords in new window" => "熱門字眼於新視窗中",
"Allow smileys" => "允許表情符號",
"use gallery" => "使用圖庫",
"use menu" => "使用選單",
"cancel edit" => "取消編輯",
"list quizzes" => "列出測驗",
"quiz stats" => "測驗統計",
"admin quizzes" => "管理測驗",
"results" => "結果",
"edit this quiz" => "編輯這個測驗",
"Reuse question" => "重覆使用問題",
"send answers" => "送出答案",
"clear stats" => "清除統計",
"time" => "時間",
"result" => "結果",
"suggested" => "建議",
"wiki link" => "wiki 連結",
"heading2" => "標題2",
"heading3" => "標題3",
"approve" => "核准",
"Show suggested questions/suggest a question" => "顯示建議的問題/建議一個問題",
"Hide suggested questions" => "隱藏建議的問題",
"Create/edit templates" => "建立/編輯模板",
"use in cms" => "使用於 cms",
"use in wiki" => "使用於 wiki",
"use in HTML pages" => "使用於 HTML 頁面",
"last modif" => "最近修改",
"sections" => "區段",
"use admin email" => "使用管理者電子郵件",
"event" => "事件",
"categorize" => "類別",
"show categories" => "顯示類別",
"underlines text" => "文字加底線",
"Create/edit HTML pages" => "建立/編輯 HTML 頁面",
"Admin HTML page dynamic zones" => "管理 HTML 頁面動態區域",
"Edit this HTML page" => "編輯此 HTML 頁面",
"searched" => "搜尋",
"last" => "最近",
"Quiz time limit excedeed quiz cannot be computed" => "測驗時間限制已超過,測驗不列入計算",
"You do not have permission to edit messages" => "你沒有編輯訊息的權限",
"feat" => "feat",
"Full Text Search" => "全文搜尋",
"Server name (for absolute URIs)" => "伺服器名稱 (絕對 URI 使用)",
"Server time zone" => "伺服器時區",
"Require HTTP Basic authentication" => "需要 HTTP 基本認證",
"HTTP server name" => "HTTP 伺服器名稱",
"HTTP URL prefix" => "HTTP URL 前置",
"HTTPS server name" => "HTTPS 伺服器名稱",
"HTTPS URL prefix" => "HTTPS URL 前置",
"Wiki Page Names" => "Wiki 頁面名稱",
"full" => "完整",
"strict" => "嚴謹",
"gral" => "gral",
"file gls" => "檔案總覽",
"trckrs" => "trckrs",
"frms" => "frms",
"img gls" => "img gls",
"webmail" => "webmail",
"Allow viwing HTML mails?" => "允許觀看 HTML 郵件?",
"use in newsletters" => "使用於電子報",
"list newsletters" => "列出電子報",
"admin newsletters" => "管理電子報",
"send newsletters" => "寄送電子報",
"Add all your site users to this newsletter (broadcast)" => "加入你所有的使用者至此電子報 (廣播)",
"Add users" => "增加使用者",
"Users can subscribe any email addresss" => "允許使用者以任何 email 訂閱",
"editions" => "版本",
"last sent" => "上次寄出",
"survey stats" => "調查結果",
"edit this survey" => "編輯這個調查",
"admin surveys" => "管理調查",
"list surveys" => "列出調查",
"Create/edit surveys" => "建立/編輯 調查",
"Options (separated by commas used in dropdowns only)" => "選項 (僅用於下拉選單, 使用逗號分開)",
"There are inddividual permissions set for this tracker" => "這個追蹤有獨立權限設定",
"Show status when listing tracker items?" => "當列出追蹤項目時顯示狀態?",
"items" => "項目",
"search category" => "搜尋類別",
"Prevents parsing data" => "防止分析資料",
"b" => "b",
"i" => "i",
"ul" => "ul",
"tbl" => "tbl",
"a" => "a",
"h1" => "h1",
"h2" => "h2",
"h3" => "h3",
"dcs" => "dcs",
"center" => "center",
"img nc" => "img nc",
"chars" => "chars",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appeareance of the page, no versions are stored for this page." => "沙池是一個用來讓你練習編輯技巧的頁面, 使用預覽功能可以觀看頁面的外觀, 但是不會儲存任何版本變動.",
"Import pages from a PHPWiki Dump" => "由 PHPWiki 傾印來匯入頁面",
"Path to where the dumped files are" => "傾印檔案的路徑",
"ver" => "版本",
"Thanks for your subscription. You will receive an email soon to confirm your subscription.\n\nNo newsletters will be sent to you until the subscription is confirmed." => "感謝你的訂閱. 你會收到一封信件以確認你的訂閱.\n\n在訂閱確認前不會收到電子報.",
"similar" => "相似",
"slides" => "幻燈片",
"export" => "匯出",
"cancel" => "取消",
"Average posts pero weblog" => "每 weblog 平均佈告數",
"view comments" => "觀看評論",
"Tracker Items" => "追蹤項目",
"Filters" => "過濾器",
"checked" => "勾選的",
"unchecked" => "未勾選的",
"Editing tracker item" => "編輯追蹤項目",
"Mark as Flagged" => "設為已標記",
"ok" => "ok",
"add contacts" => "增加到通訊錄",
"Wiki Import dump" => "Wiki 匯入傾印",
"standard" => "標準",
"secure" => "安全",
"stay in ssl mode" => "保留在 ssl 模式",
"Bookmakrs" => "書籤",
"You cant use the same password again" => "你不能再次使用相同的密碼",
"You have to provide a name to the file" => "你必須為這個檔案取一個名稱",
"parent" => "parent",
"userfiles" => "使用者檔案",
"Only for users" => "僅用於使用者",
"Users and admins" => "使用者與管理者",
"Remove a tag" => "移除一個標記",
"Cache wiki pages" => "快取 wiki 頁面",
"Users can save pages to notepad" => "允許使用者儲存頁面至記事本",
"\n for rows" => "\n 表示一列",
"Forum settings" => "論壇設定",
"Allow wiki markup" => "允許 wiki 標記語言",
"Describe topics in listing" => "描述主題於列表",
"Allow viewing HTML mails" => "允許觀看 HTML 郵件",
"new window" => "新的視窗",
"subs" => "subs",
"objs" => "objs",
"Admin content templates" => "管理內容模版",
"Edit drawings &amp; pictures" => "編輯繪圖和圖片",
"\n\n<b>Note 1</b>: if you allow your users to configure modules then assigned\n\nmodules won't be reflected in the screen until you configure them\n\nfrom MyTiki->modules.<br/>\n\n<b>Note 2</b>: If you assign modules to groups make sure that you\n\nhave turned off the option 'display modules to all groups always'\n\nfrom Admin->General\n\n" => "\n\n<b>注意事項 1</b>: 如果你允許使用者自行調整模組的設定, 設定的模組\n\n將不會反應到畫面上, 必須到 我的Tiki->模組 中設定.<br/>\n\n<b>注意事項 2</b>: 如果你指定模組至群組中, 請確定你有到 管理->一般選項 中把\n\n「所有的模組都顯示群組」選項給關閉",
"left" => "左",
"right" => "右",
"Edit/Create user module" => "編輯/建立 使用者模組",
"assign_perms" => "指定權限",
"update" => "更新",
"Content Templates" => "內容模版",
"assgn" => "指定",
"List of available backups" => "列出現有的備份",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "回復備份會摧毀你所有tiki資料庫的資料, 全部的表格將會被備份中的資料所取代",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "建立新的備份需要蠻長的時間,如果你未執行完畢, 請增加你php.ini檔中最大執行時間的設定",
"view blog" => "觀看 blog",
"list blogs" => "列出 blogs",
"original size" => "原始大小",
"rotate left" => "向左旋轉",
"Klick to enlarge" => "點擊放大",
"smaller" => "縮小",
"bigger" => "放大",
"browse" => "瀏覽",
"related" => "相關",
"validate" => "確認",
"Add or edit a category" => "增加或編輯一個分類",
"list articles" => "列出文章",
"view articles" => "顯示文章",
"In parent page" => "在父頁面中",
"create page" => "建立頁面",
"list submissions" => "列出submission",
"Add scaled images size X x Y" => "增加影像尺度大小 X x Y",
"Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)" => "傾印檔案所在的路徑 (tiki目錄的相對路徑加上斜線 例如: dump/)",
"edit new article" => "編輯新文章",
"edit blog" => "編輯 blog",
"edit new submission" => "建立新的意見",
"rename" => "更名",
"Diff to version" => "Diff 至版本",
"source" => "來源",
"Assign permissions to page" => "指定權限到頁面",
"Send email notifications when this page changes to" => "頁面變動時寄出 email 提醒",
"add email" => "增加email",
"Notifications" => "提醒",
"wiki pages" => "wiki 頁面",
"display" => "顯示",
"use filename" => "使用檔案名稱",
"unassign" => "未指定",
"Use dbl click to edit pages" => "雙按滑鼠編輯頁面",
"replies" => "回答",
"quote" => "quote",
"All tasks" => "所有任務",
"mark as done" => "標記為已完成",
"open tasks" => "開啟任務",
"Add or edit a task" => "建立或編輯一個任務",
"Start date" => "開始日期",
"add a site" => "增加一個站臺",
"Mailin accounts" => "Mailin 帳號",
"Return to messages" => "返回訊息列表",
"Unflagg" => "解除標記",
"Newss from" => "News 來自",
"Control by Object" => "由物件控制",
"Admin ephemerides" => "管理日曆",
"All ephemerides" => "所有日曆",
"Control by category" => "由分類控制",
"add topic" => "增加主題",
"topic" => "主題",
"Create/edit extwiki" => "建立/編輯 外部wiki",
"extwiki" => "外部wiki",
"dsn" => "dsn",
"Admin (click!)" => "管理 (點擊!)",
"new message" => "件新訊息",
"Mus enter a name to add a site" => "增加站臺時必須輸入名稱",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory" => "無法存取 URL, URL 錯誤或站臺不存在, 無法加入目錄",
"The user has choosen to make his information private" => "此用戶選擇保密個人資訊",
"Users can vote only one item from this chart per period" => "使用者每一單位時間只能從這個排行榜中票選一項",
"Prevent users from voting same item more than one time" => "防止使用者票選相同項目一次以上",
"You will receive an email with your password soon" => "你很快就會收到含有密碼的 email",
"Batch upload (CSV file)" => "批次上傳 (CSV 檔案)",
"Displays a snippet of code.\n\nSet optional paramater -+ln+- to 1 if you need line numbering feature." => "顯示一段程式碼.\n\n如果需要行號功能, 請設定選擇性參數 -+ln+- 為 1.",
"Renders a graph" => "產生圖",
"PluginsHelp" => "Plugins說明",
"Wiki quick help" => "Wiki 快速說明",
"create new empty structure" => "建立新的空結構",
"Create structure from tree" => "由樹系建立結構",
"tree" => "樹系",
"Admin structures" => "管理結構",
"Click twice if once is not enough !" => "如果一次不夠, 請點擊兩次!",
"Toggle display of comment zone" => "開關註解區域的顯示",
"In blog listing show user as" => "在 blog 列表中顯示使用者為",
"creation date" => "建立日期",
"last modification time" => "最後修改時間",
"Articles listing configuration" => "文章列表設定",
"Edit css" => "編輯 css",
"Use PHPOpenTracker" => "使用 PHPOpenTracker",
"User watches" => "自訂監視",
"LDAP Group Atribute" => "LDAP 群組屬性",
"PDF Export" => "輸出為 PDF",
"Wiki page list configuration" => "Wiki 頁面列表設定",
"Enable Feature" => "啟用功能",
"loc" => "位置",
"cat" => "類別",
"lang" => "語系",
"prio" => "重要性",
"edit chart" => "編輯排行榜",
"Edit drawings" => "編輯繪圖",
"Threads can be voted" => "討論串可投票",
"Forward messages to this forum to this email" => "轉發此論壇的訊息至此 email",
"avatar" => "頭像",
"flag" => "國旗",
"user level" => "使用者等級",
"online" => "線上",
"Directory (include trailing slash)" => "目錄 (包含結尾的/)",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "使用 {literal}{{/literal}ed id=name} 或 {literal}{{/literal}ted id=name}以加入動態區域",
"export pages" => "匯出頁面",
"dump tree" => "傾印樹系",
"stat" => "狀態",
"Added users" => "加入的使用者",
"ExtWikis" => "外部 Wiki",
"save and exit" => "儲存並離開",
"popup window" => "蹦現視窗",
"Calendars Panel" => "行事曆控制面板",
"Navigation Panel" => "導覽面板",
"Hide Panels" => "隱藏面板",
"hide from display" => "不顯示",
"Tiki Calendars" => "Tiki 行事曆",
"today" => "今日",
"+1d" => "+1天",
"+7d" => "+7天",
"+1m" => "+1月",
"browse by" => "瀏覽單位",
"If you change the calendar selection, please refresh to get the appropriated list in Category, Location and people (if applicable to the calendar you choose)." => "如果你更改了行事曆選項, 請重新整理以取得正確的類別, 地點, 以及人名列表(如果適用於你所選的行事曆類型)",
"or create a new category" => "或建立新類別",
"or create a new location" => "或建立新地點",
"comma separated usernames" => "以逗點分隔的用戶名稱",
"from the list" => "從列表",
"choose" => "選擇",
"comma separated username:role" => "以逗點分隔的 用戶名稱:角色",
"Chair" => "席位",
"Optional" => "非必須",
"with roles" => "附帶角色",
"You should first ask that a calendar is created, so you can create events attached to it." => "你必須在建立行事曆時先詢問, 以便建立要附加上去的事件",
"Font" => "字型",
"Textheight" => "文字高度",
"Height of top Heading" => "最上層標題大小",
"Height of mid Heading" => "中層標題大小",
"Height of inner Heading" => "內層標題大小",
"tbheight" => "表格大小",
"imagescale" => "影像比率",
"save a custom copy" => "另存自訂備份",
"try" => "測試",
"use ...page... to separate pages" => "使用 ...頁面... 分隔頁面",
"heading" => "標題",
"horizontal ruler" => "水平尺標",
"create new gallery" => "建立新圖庫",
"configure listing" => "設定列表",
"save and approve" => "儲存並核可",
"new topic" => "新主題",
"reject" => "駁回",
"adm" => "adm",
"switch" => "轉換",
"add new" => "新增加",
"add role" => "增加角色",
"new minor" => "new minor",
"new major" => "new major",
"Swicth construct" => "Swicth construct",
"admin processes" => "admin processes",
"admin activities" => "admin activities",
"admin roles" => "admin roles",
"edit this process" => "edit this process",
"monitor" => "monitor",
"act status" => "act status",
"running" => "running",
"Activs" => "Activs",
"Ins" => "Ins",
"stop" => "stop",
"send instance" => "send instance",
"create new blog" => "建立新 blog",
"Edit a file using this form" => "使用此表單編輯檔案",
"delete selected files" => "刪除選擇的檔案",
"set as operator" => "設為服務員",
"op" => "op",
"wiki create" => "wiki 建立",
"wiki overwrite" => "wiki 覆寫",
"discuss" => "討論",
"attachments" => "附件",
"create pdf" => "建立 pdf",
"monitor this page" => "監視此頁面",
"stop monitoring this page" => "停止監控此頁面",
"last modification" => "最後修改",
"click here" => "點擊此處",
"move to right column" => "移至右行",
"move to left column" => "移至左行",
"remove folder" => "移除資料夾",
"remove bookmark" => "移除書籤",
"refresh cache" => "重新整理快取",
"stop monitoring this blog" => "停止監控此 blog",
"edit items" => "編輯項目",
"list charts" => "列出排行榜",
"last chart" => "最末張排行榜",
"perm" => "權限",
"item" => "項目",
"Tiki forums" => "Tiki 論壇",
"monitor this forum" => "監控此論壇",
"stop monitoring this forum" => "停止監控此論壇",
"delete selected topics" => "刪除選擇的主題",
"mot" => "mot",
"stop monitoring this topic" => "停止監控此主題",
"send email to user" => "發送 email 至使用者",
"delete selected" => "刪除選擇項目",
"this post was reported" => "本文章已被回報",
"report this post" => "回報此文章",
"someone from" => "某人來自",
"requested a reminder of the password for the" => "要求寄送密碼提示",
"since this is your registered email address we inform that the" => "由於這是你的註冊 email 地址, 我們就寄送至此",
"password for this account is" => "此帳號的密碼是",
"If you want to be a registered user in this site you will have to use" => "如果你想成為本站的註冊使用者, 你必須使用",
"the following link to login for the first time" => "以下的連結來進行第一次登入",
"new messages" => "新訊息",
"More info about" => "更多資訊:",
"idle" => "發呆",
"MyTiki (click!)" => "我的Tiki (點擊!)",
"You do not have permission to use this feature." => "你沒有權限使用此功能.",
"blog_ranking_top_blogs" => "blog_ranking_top_blogs",
"blog_ranking_last_posts" => "blog_ranking_last_posts",
"blog_ranking_top_active_blogs" => "blog_ranking_top_active_blogs",
"filegal_ranking_top_galleries" => "filegal_ranking_top_galleries",
"filegal_ranking_top_files" => "filegal_ranking_top_files",
"filegal_ranking_last_files" => "filegal_ranking_last_files",
"gal_ranking_top_galleries" => "gal_ranking_top_galleries",
"gal_ranking_top_images" => "gal_ranking_top_images",
"gal_ranking_last_images" => "gal_ranking_last_images",
"updated by the phpwiki import process" => "由 phpwiki 匯入程序所更新",
"created from phpwiki import" => "由 phpwiki 匯入所建立",
"Wiki page" => "Wiki 頁面",
"Your Tiki account information for" => "你的 Tiki 帳號資訊",
"A password reminder email has been sent " => "已寄出密碼提示信件 ",
"A new password has been sent " => "新密碼已經寄出 ",
"Permission denied you cannot upload files" => "權限不足, 你無法上傳檔案",
"Cannot read file" => "無法讀取檔案",
" new topic:" => " 新主題:",
"topic:" => "主題:",
"forum topic" => "論壇主題",
"Your email address has been removed from the list of addresses monitoring this tracker" => "你的 email 地址已經從監控此追蹤的列表中移除",
"Your email address has been added to the list of addresses monitoring this tracker" => "你的 email 地址已經加入監控此追蹤的列表",
"Cancel monitoring" => "取消監控",
"Your email address has been removed from the list of addresses monitoring this item" => "你的 email 地址已經從監控此項目的列表中移除",
"Your email address has been added to the list of addresses monitoring this item" => "你的 email 地址已經加入監控此項目的列表",
"Current page:" => "目前頁面:",
"version %s" => "版本 %s",
"last modified on %s" => "最後修改於 %s",
"by %s" => "由 %s",
"Archived page:" => "儲存的頁面:",
"Diff of %s." => "%s 的差異.",
"no description" => "無描述",
" tags. Example: {tr}The newsletter was sent to {\$sent} email addresses" => " 標籤. 範例: {tr}本電子報寄送至 {\$sent} email 地址",
"New article submitted at " => "新文章發表於 ",
"uploaded by" => "上傳自",
"not specified" => "未指定",
"Welcome to " => "歡迎來到 ",
" at " => " 在 ",
"Bye bye from " => "Bye bye from ",
"There is an error in the plugin data" => "外掛模組資料發生錯誤",
"Posted comments" => "已發表評論",
"PHPOpenTracker" => "PHPOpenTracker",
"User can Configure Modules" => "允許使用者設定模組",
"Time Zone" => "時區",
"Time Zone Map" => "時區對應",
"Enable watch by default for author" => "作者預設啟動監視",
"Enable watches when I am the editor" => "當我是編輯者時啟動監視",
"create new" => "建立新的",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br/>\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>注意事項 1</b>: 如果你允許使用者自行調整模組的設定, 設定的模組\n將不會反應到畫面上, 必須到 我的Tiki->模組 中設定.<br/>\n<b>注意事項 2</b>: 如果你指定模組至群組中, 請確定你有到 管理->一般選項 中把\n「所有的模組都顯示群組」選項給關閉",
"Create New Survey:" => "建立新調查:",
"Add New Group" => "建立新群組",
"Edit this group:" => "編輯此群組:",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "注意: 如果你要使用影像請先儲存文章之後\n才能編輯/發表影像。在文字區域中使用\n&lt;img&gt; 片段表示上傳的影像。或使\n用 WYSIWYG 編輯器插入影像 URL。 ",
"with role" => "以角色",
"wiki help" => "wiki 說明",
"add comment" => "增加評論",
"attach file" => "附加檔案",
"The cord" => "The cord",
"Change your email" => "更改你的 email",
"change email" => "更改 email",
"change password" => "更改密碼",
"Information:" => "資訊:",
"New blog post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "新 blog 佈告: {\$mail_title} 由 {\$mail_user} 發表於 {\$mail_date|tiki_short_datetime}",
"You can edit the page following this link:" => "你可以使用此連結編輯頁面:",
"Diff:" => "差異:",
"The new page content is:" => "新的頁面內容:",
"cached" => "已快取",
"back to homepage" => "回到首頁",
"Please" => "請",
"log in" => "登入",
"to access full functionalities" => "以使用完整功能",
"xx" => "xx",
"xxx" => "xxx",
"pageviews" => "瀏覽數",
"Upload was not successful (maybe a duplicate file)" => "上傳不成功 (可能是檔案重複)",
"Invalid password.  You current password is required to change your email address." => "密碼錯誤. 請輸入正確的密碼才能更改你的 email 地址.",
"New message arrived from " => "收到新訊息: ",
"with checked" => "with checked",
"pdf" => "pdf",
"at tracker" => "at tracker",
"UTC" => "UTC",
"<b>Feed</b>" => "<b>Feed</b>",
"Feed for Articles" => "Feed for Articles",
"Feed for Weblogs" => "Feed for Weblogs",
"Feed for the Wiki" => "Feed for the Wiki",
"activate" => "activate",
"graph" => "graph",
"active process" => "active process",
"invalid" => "invalid",
"invalid process" => "invalid process",
"valid process" => "valid process",
"activities" => "activities",
"aborted" => "aborted",
"value" => "value",
"proc" => "proc",
"exceptions" => "exceptions",
"Com" => "Com",
"pre" => "pre",
"pop" => "pop",
"new image uploaded by" => "新影像上傳自",
"new subscriptions" => "新訂閱",
"new item in tracker" => "追蹤系統中有新項目",
"message" => "訊息",
"comment" => "評論",
"filter" => "過濾器",
"no such file" => "無此檔案",
"downloads" => "下傳數",
"attach" => "附檔",
"monitor this blog" => "監控此 blog",
"hide categories" => "隱藏類別",
"Admin categories" => "管理類別",
"reply" => "回覆",
"monitor this topic" => "監控此主題",
"Dls" => "下傳數",
"move selected files" => "移動選擇的檔案",
"Thank you for you registration. You may log in now." => "感謝你的註冊. 你現在可以登入了.",
"compare" => "比較",
"diff" => "比對差異",
"del" => "清除",
"Create pdf" => "建立 pdf",
"1 file attached" => "1 個附加檔案",
"categories" => "分類",
"check / uncheck all" => "全選/全取消",
"Tiki sections and features" => "Tiki 區段與功能",
"please read" => "請閱讀",
"yes" => "是",
"Local" => "本地",
"private" => "私人",
"<b>enable/disable</b>" => "<b>開啟/關閉</b>",
"<b>Max number of items</b>" => "<b>最大項目數</b>",
"Feed for Image Galleries" => "Feed for 影像圖庫",
"Feed for File Galleries" => "Feed for 檔案庫",
"Feed for individual Image Galleries" => "Feed for 獨立的影像圖庫",
"Feed for individual File Galleries" => "Feed for 獨立的檔案庫",
"Feed for individual weblogs" => "Feed for 獨立的 weblogs",
"Feed for individual forums" => "Feed for 獨立論壇",
"PDF generation" => "產生 PDF",
"Use in CMS" => "使用於 cms",
"Use in Wiki" => "使用於 wiki",
"Use in newsletters" => "使用於電子報",
"Use in HTML pages" => "使用於 HTML 頁面",
"Refresh rate (if dynamic) [secs]" => "更新頻率 (如果為動態) [秒]",
"Create/edit newsletters" => "建立/編輯電子報",
"subscriptions" => "訂閱",
"Use Admin Email" => "使用管理者電子郵件",
"Edit or add poll options" => "編輯或加入投票選項",
"Create/edit Polls" => "建立/編輯 投票",
"Rss channels" => "Rss頻道",
"Admin tracker" => "管理追蹤",
"Edit this tracker" => "編輯此追蹤",
"View this tracker items" => "瀏覽此追蹤項目",
"Edit tracker fields" => "編輯追蹤欄位",
"fields" => "欄位",
"Create/edit trackers" => "建立/編輯追蹤",
"Add a new group" => "增加新群組",
"Edit item" => "編輯項目",
"Add a new user" => "增加使用者",
"Popup Window" => "蹦現視窗",
"details" => "細節",
"No individual permissions global permissions apply" => "不採用單獨的權限設定,採用全體權限設定",
"Welcome to the Tiki Chat Rooms" => "歡迎來到 Tiki 聊天室",
"Please select a chat channel" => "請選擇一個聊天頻道",
"enter chat room" => "進入聊天室",
"Chatroom" => "聊天室",
"Active Channels" => "活動中頻道",
"Users in this channel" => "頻道中的使用者",
"Channel Information" => "頻道資訊",
"Channel" => "頻道",
"Ratio" => "比率",
"Use :nickname:message for private messages" => "用 :暱稱:訊息 來發送個人訊息",
"Use [URL|description] or [URL] for links" => "使用 [URL|描述] 或 [URL] 表示連結",
"Create PDF" => "建立 PDF",
"PDF Settings" => "PDF 設定",
"Select Wiki Pages" => "選擇 Wiki 頁面",
"Remove Page" => "移除頁面",
"Add or edit a site" => "增加或編輯站臺",
"sites" => "站臺",
"cool sites" => "酷站臺",
"Use ...page... to separate pages in a multi-page article" => "使用 ...頁面... 將頁面分隔為多重頁面",
"Create Zone" => "建立區域",
"translate" => "翻譯",
"Create or edit content" => "建立或編輯內容",
"this quiz stats" => "這個測驗的統計",
"answer" => "答案",
"Edit FAQ questions" => "編輯 FAQ 問題",
"Edit this file gallery:" => "編輯此檔案庫:",
"icon" => "圖示",
"Other users can upload files to this gallery" => "允許其他使用者上傳檔案到此檔案庫",
"Available File Galleries" => "現有檔案庫",
"start" => "開始",
"end" => "結束",
"roles" => "角色",
"Add role" => "增加角色",
"rollback" => "回復",
"Create or edit content block" => "建立或編輯內容區塊",
"Listing Gallery" => "列出檔案庫",
"Gallery Files" => "檔案庫檔案",
"Last ver" => "最近版本",
"Vers" => "版本",
"Subscribe to newsletter" => "訂閱電子報",
"Add or edit a news server" => "增加或編輯 news 伺服器",
"Print Wiki Pages" => "列印 Wiki 頁面",
"add page" => "增加頁面",
"Total threads" => "總討論串數",
"Average threads per topic" => "主題平均討論串數",
"You can include the file in an HTML/Tiki page using" => "你可以包含這個檔案在一個 HTML/Tiki 頁面中使用",
"Now enter the file URL" => "輸入這個檔案的 URL",
" or upload a local file from your disk" => "或由你的磁碟上傳一個本地的檔案",
"Add or edit folder" => "增加或編輯資料夾",
"Add or edit a URL" => "增加或編輯一個URL",
"priority" => "重要性",
"previous chart" => "前一排行榜",
"next chart" => "下一張排行榜",
"pos" => "排名",
"avg" => "平均",
"post new comment" => "發表新評論",
"Post New Comment" => "發表新評論",
"HTML tags are not allowed inside comments" => "不允許評論中使用 HTML 標籤",
"moderator actions" => "板主命令",
"move selected topics" => "移動選擇的主題",
"unlock selected topics" => "解鎖選擇的主題",
"lock selected topics" => "鎖定選擇的主題",
"merge" => "合併",
"merge selected topics" => "合併選擇的主題",
"reported messages:" => "回報的訊息:",
"queued messages:" => "佇列中訊息:",
"Insert new item" => "插入新項目",
"View item" => "觀看項目",
"Add a comment" => "增加一個評論",
"account" => "帳號",
"Group doesnt exist" => "群組不存在",
"User doesnt exist" => "使用者不存在",
"Event without Name" => "無名事件",
"Invalid old password" => "舊密碼錯誤",
"No channel indicated" => "未指定頻道",
"No nickname indicated" => "未指定暱稱",
"Permision denied" => "權限不足",
"cc" => "cc",
"bcc" => "bcc",
"sender" => "寄件者",
"subject" => "主題",
"date" => "日期",
"flagged" => "已標記",
"mark" => "標計",
"replied" => "已回覆",
"posted by" => "發表自",
"email this post" => "email 此文章",
"MultiPrint" => "多重列印",
"Pictures" => "圖片",
"Use page description" => "使用頁面描述",
"Show page title" => "顯示頁面標題",
"Footnotes" => "註腳",
"Users can lock pages (if perm)" => "允許使用者鎖定頁面 (如果有權限)",
"Use WikiWords" => "使用 WikiWords",
"Automonospaced text" => "自動使用固定寬度文字",
"Tables syntax" => "表格語法",
"Page creators are admin of their pages" => "頁面建立者也是頁面管理者",
"Maximum number of versions for history" => "歷程記錄中版本最大數目",
"Never delete versions younger than days" => "永不刪除少於幾天的版本",
"Enable watches on comments" => "啟動對評論的監視",
"Old vers" => "舊版本",
"Add or edit event" => "建立或編輯事件",
"merge selected notes into" => "合併選擇的記事至",
"Faq Stats" => "Faq 統計",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "你的訊息已排入等待核可, 板主核可之後\n就會發佈.",
"settings" => "設定",
"mailbox" => "郵件夾",
"compose" => "新郵件",
"contacts" => "通訊錄",
"clip" => "迴紋針",
"back to mailbox" => "返回郵件夾",
"full headers" => "完整標頭",
"normal headers" => "一般標頭",
"reply all" => "全部回覆",
"forward" => "轉寄",
"select from address book" => "由通訊錄中選擇",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "Your post has not been posted" => "Your post has not been posted",
// "Cookies must be allowed to vote" => "Cookies must be allowed to vote",
// "You have mistyped the anti-bot verification code; please try again." => "You have mistyped the anti-bot verification code; please try again.",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "A contribution is mandatory" => "A contribution is mandatory",
// "This script cannot be called directly" => "This script cannot be called directly",
// "Copyright management" => "Copyright management",
// "This feature is for admins only" => "This feature is for admins only",
// "Uploaded" => "Uploaded",
// "Last editor" => "Last editor",
// "Explorer" => "Explorer",
// "The text in RED is" => "The text in RED is",
// "character(s) too long - please edit it." => "character(s) too long - please edit it.",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Albania" => "Albania",
// "Algeria" => "Algeria",
// "American Samoa" => "American Samoa",
// "Andorra" => "Andorra",
// "Angola" => "Angola",
// "Anguilla" => "Anguilla",
// "Antarctica" => "Antarctica",
// "Antigua" => "Antigua",
// "Argentina" => "Argentina",
// "Armenia" => "Armenia",
// "Aruba" => "Aruba",
// "Australia" => "Australia",
// "Austria" => "Austria",
// "Azerbaijan" => "Azerbaijan",
// "Bahamas" => "Bahamas",
// "Bahrain" => "Bahrain",
// "Bangladesh" => "Bangladesh",
// "Barbados" => "Barbados",
// "Belarus" => "Belarus",
// "Belgium" => "Belgium",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bermuda" => "Bermuda",
// "Bhutan" => "Bhutan",
// "Bolivia" => "Bolivia",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "Brazil" => "Brazil",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "Brunei" => "Brunei",
// "Bulgaria" => "Bulgaria",
// "Burkina Faso" => "Burkina Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Canada" => "Canada",
// "Cape Verde" => "Cape Verde",
// "Catalan Countries" => "Catalan Countries",
// "Cayman Islands" => "Cayman Islands",
// "Central African Republic" => "Central African Republic",
// "Chad" => "Chad",
// "Chile" => "Chile",
// "China" => "China",
// "Christmas Island" => "Christmas Island",
// "Cocos Islands" => "Cocos Islands",
// "Colombia" => "Colombia",
// "Comoros" => "Comoros",
// "Congo" => "Congo",
// "Congo Democratic" => "Congo Democratic",
// "Cook Islands" => "Cook Islands",
// "Costa Rica" => "Costa Rica",
// "Croatia" => "Croatia",
// "Cuba" => "Cuba",
// "Cyprus" => "Cyprus",
// "Czech Republic" => "Czech Republic",
// "Denmark" => "Denmark",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Dominican Republic" => "Dominican Republic",
// "Ecuador" => "Ecuador",
// "Egypt" => "Egypt",
// "El Salvador" => "El Salvador",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Eritrea" => "Eritrea",
// "Estonia" => "Estonia",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Faroe Islands" => "Faroe Islands",
// "Federated States of Micronesia" => "Federated States of Micronesia",
// "Fiji" => "Fiji",
// "Finland" => "Finland",
// "France" => "France",
// "French Guiana" => "French Guiana",
// "French Polynesia" => "French Polynesia",
// "French Southern Territories" => "French Southern Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Germany" => "Germany",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greece" => "Greece",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guam" => "Guam",
// "Guatemala" => "Guatemala",
// "Guernsey" => "Guernsey",
// "Guinea" => "Guinea",
// "Guinea Bissau" => "Guinea Bissau",
// "Guyana" => "Guyana",
// "Haiti" => "Haiti",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Honduras" => "Honduras",
// "Hong Kong" => "Hong Kong",
// "Hungary" => "Hungary",
// "Iceland" => "Iceland",
// "India" => "India",
// "Indonesia" => "Indonesia",
// "Iran" => "Iran",
// "Iraq" => "Iraq",
// "Ireland" => "Ireland",
// "Isle of Man" => "Isle of Man",
// "Israel" => "Israel",
// "Italy" => "Italy",
// "Ivory Coast" => "Ivory Coast",
// "Jamaica" => "Jamaica",
// "Japan" => "Japan",
// "Jersey" => "Jersey",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kenya" => "Kenya",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Latvia" => "Latvia",
// "Lebanon" => "Lebanon",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Lithuania" => "Lithuania",
// "Luxemburg" => "Luxemburg",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Malawi" => "Malawi",
// "Malaysia" => "Malaysia",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Malta" => "Malta",
// "Marshall Islands" => "Marshall Islands",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mauritius" => "Mauritius",
// "Mayotte" => "Mayotte",
// "Mexico" => "Mexico",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Nauru" => "Nauru",
// "Nepal" => "Nepal",
// "Netherlands" => "Netherlands",
// "Netherlands Antilles" => "Netherlands Antilles",
// "New Caledonia" => "New Caledonia",
// "New Zealand" => "New Zealand",
// "Nicaragua" => "Nicaragua",
// "Niger" => "Niger",
// "Nigeria" => "Nigeria",
// "Niue" => "Niue",
// "Norfolk Island" => "Norfolk Island",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "North Korea" => "North Korea",
// "Norway" => "Norway",
// "Oman" => "Oman",
// "Other" => "Other",
// "Pakistan" => "Pakistan",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Panama" => "Panama",
// "Papua New Guinea" => "Papua New Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto Rico" => "Puerto Rico",
// "Quatar" => "Quatar",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Reunion" => "Reunion",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "Samoa" => "Samoa",
// "San Marino" => "San Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Saudi Arabia" => "Saudi Arabia",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon Islands" => "Solomon Islands",
// "Somalia" => "Somalia",
// "South Africa" => "South Africa",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "South Korea" => "South Korea",
// "Spain" => "Spain",
// "Sri Lanka" => "Sri Lanka",
// "St Vincent Grenadines" => "St Vincent Grenadines",
// "Sudan" => "Sudan",
// "Surinam" => "Surinam",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Swaziland" => "Swaziland",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Syria" => "Syria",
// "Taiwan" => "Taiwan",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Thailand" => "Thailand",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tonga" => "Tonga",
// "Trinidad Tobago" => "Trinidad Tobago",
// "Tunisia" => "Tunisia",
// "Turkey" => "Turkey",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Tuvalu" => "Tuvalu",
// "Uganda" => "Uganda",
// "Ukraine" => "Ukraine",
// "United Arab Emirates" => "United Arab Emirates",
// "United Kingdom" => "United Kingdom",
// "United Nations Organization" => "United Nations Organization",
// "United States" => "United States",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "Uruguay" => "Uruguay",
// "US Virgin Islands" => "US Virgin Islands",
// "Uzbekistan" => "Uzbekistan",
// "Vanuatu" => "Vanuatu",
// "Vatican" => "Vatican",
// "Venezuela" => "Venezuela",
// "Viet Nam" => "Viet Nam",
// "Wales" => "Wales",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Western Sahara" => "Western Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "Simplified Chinese" => "Simplified Chinese",
// "Chinese" => "Chinese",
// "Czech" => "Czech",
// "Danish" => "Danish",
// "German" => "German",
// "English" => "English",
// "English British" => "English British",
// "Spanish" => "Spanish",
// "Greek" => "Greek",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "French" => "French",
// "Galician" => "Galician",
// "Hebrew" => "Hebrew",
// "Croatian" => "Croatian",
// "Italian" => "Italian",
// "Japanese" => "Japanese",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Dutch" => "Dutch",
// "Norwegian" => "Norwegian",
// "Polish" => "Polish",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Russian" => "Russian",
// "Pijin Solomon" => "Pijin Solomon",
// "Slovak" => "Slovak",
// "Serbian" => "Serbian",
// "Serbian Latin" => "Serbian Latin",
// "Swedish" => "Swedish",
// "Tuvaluan" => "Tuvaluan",
// "Traditional Chinese" => "Traditional Chinese",
// "Ukrainian" => "Ukrainian",
// "This instance of activity is already complete" => "This instance of activity is already complete",
// "Fatal error: cannot execute automatic activity \$activityId" => "Fatal error: cannot execute automatic activity \$activityId",
// "Fatal error: setting next activity to an unexisting activity" => "Fatal error: setting next activity to an unexisting activity",
// "Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Fatal error: nextActivity does not match any candidate in autorouting switch activity",
// "Fatal error: non-deterministic decision for autorouting activity" => "Fatal error: non-deterministic decision for autorouting activity",
// "Fatal error: trying to send an instance to an activity but no transition found" => "Fatal error: trying to send an instance to an activity but no transition found",
// "Cannot add transition only split activities can have more than one outbound transition" => "Cannot add transition only split activities can have more than one outbound transition",
// "Circular reference found some activity has a transition leading to itself" => "Circular reference found some activity has a transition leading to itself",
// "Process does not have a start activity" => "Process does not have a start activity",
// "Process does not have exactly one end activity" => "Process does not have exactly one end activity",
// "End activity is not reachable from start activity" => "End activity is not reachable from start activity",
// " is interactive but has no role assigned" => " is interactive but has no role assigned",
// " is non-interactive and non-autorouted but has no role assigned" => " is non-interactive and non-autorouted but has no role assigned",
// " is standalone but has transitions" => " is standalone but has transitions",
// " is not mapped" => " is not mapped",
// "Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Activity '.\$res['name'].' is standalone and is using the \$instance object",
// "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method",
// "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method",
// "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method",
// "Process %d has been activated" => "Process %d has been activated",
// "Process %d has been deactivated" => "Process %d has been deactivated",
// "Process %s %s imported" => "Process %s %s imported",
// "Process %s removed" => "Process %s removed",
// "Process %s has been updated" => "Process %s has been updated",
// "Process %s has been created" => "Process %s has been created",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "Administration:" => "Administration:",
// "tracker" => "tracker",
// "file gallery" => "file gallery",
// "image gallery" => "image gallery",
// "newsletter" => "newsletter",
// "survey" => "survey",
// "wiki page" => "wiki page",
// "Cannot write to this file: " => "Cannot write to this file: ",
// "(not registered)" => "(not registered)",
// "Use this thread to discuss the %s page." => "Use this thread to discuss the %s page.",
// "Line:" => "Line:",
// "Lines:" => "Lines:",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to:" => "Select a Wiki page to link to:",
// "Link" => "Link",
// "Cannot open this file:" => "Cannot open this file:",
// "Continue" => "Continue",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "Contributions" => "Contributions",
// "Query point:" => "Query point:",
// "layer:" => "layer:",
// "Record:" => "Record:",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "User Map Generated in:" => "User Map Generated in:",
// "Image Map Generated in:" => "Image Map Generated in:",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it." => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it.",
// "menu" => "menu",
// "File %s not found" => "File %s not found",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "section edit" => "section edit",
// "This poll is closed." => "This poll is closed.",
// "Forums last posts" => "Forums last posts",
// "The passwords do not match" => "The passwords do not match",
// "The registration mail can't be sent. Contact the administrator" => "The registration mail can't be sent. Contact the administrator",
// "Feed provided by %s. Click to visit." => "Feed provided by %s. Click to visit.",
// "See other user's profile" => "See other user's profile",
// "Have your profile seen" => "Have your profile seen",
// "Make friends" => "Make friends",
// "Receive message" => "Receive message",
// "Read an article" => "Read an article",
// "Publish an article" => "Publish an article",
// "Have your article read" => "Have your article read",
// "Create new file gallery" => "Create new file gallery",
// "Upload new file to gallery" => "Upload new file to gallery",
// "Download other user's file" => "Download other user's file",
// "Have your file downloaded" => "Have your file downloaded",
// "Create a new image gallery" => "Create a new image gallery",
// "Upload new image to gallery" => "Upload new image to gallery",
// "See other user's gallery" => "See other user's gallery",
// "See other user's image" => "See other user's image",
// "Have your gallery seen by other user" => "Have your gallery seen by other user",
// "Have your image seen" => "Have your image seen",
// "Create new blog" => "Create new blog",
// "Post in a blog" => "Post in a blog",
// "Read other user's blog" => "Read other user's blog",
// "Have your blog read" => "Have your blog read",
// "Create a new wiki page" => "Create a new wiki page",
// "Edit an existing page" => "Edit an existing page",
// "Unknown" => "Unknown",
// "Trackeritem" => "Trackeritem",
// "Directory category" => "Directory category",
// "Tracker item" => "Tracker item",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "Help page:" => "Help page:",
// "View tpl:" => "View tpl:",
// "Edit Template" => "Edit Template",
// "Admin Feature" => "Admin Feature",
// "The text is" => "The text is",
// "Date Selector" => "Date Selector",
// "phplayers are not available on this site" => "phplayers are not available on this site",
// "Invert Sort" => "Invert Sort",
// "sec" => "sec",
// "Text cut here" => "Text cut here",
// "Task" => "Task",
// "Start date:" => "Start date:",
// "End date:" => "End date:",
// "Friend" => "Friend",
// "km" => "km",
// "Last seen on " => "Last seen on ",
// "(idle for %s seconds)" => "(idle for %s seconds)",
// "User information - Click for more info" => "User information - Click for more info",
// "More info about \$other_user" => "More info about \$other_user",
// "(idle for \$idletime seconds)" => "(idle for \$idletime seconds)",
// "Use this tree to copy the structure" => "Use this tree to copy the structure",
// "created from structure" => "created from structure",
// "Table of contents" => "Table of contents",
// "unknown error" => "unknown error",
// "cannot be found" => "cannot be found",
// "An error occured in a database query!" => "An error occured in a database query!",
// "img-g" => "img-g",
// "file-g" => "file-g",
// "arts" => "arts",
// "Click to edit dynamic variable" => "Click to edit dynamic variable",
// "Update variables" => "Update variables",
// "Edit Section" => "Edit Section",
// "index" => "index",
// "Show" => "Show",
// "Hide" => "Hide",
// "You are not allowed to upload this type of file." => "You are not allowed to upload this type of file.",
// "The file you are trying upload was only partially uploaded." => "The file you are trying upload was only partially uploaded.",
// "You must select a file." => "You must select a file.",
// "Altering database table failed" => "Altering database table failed",
// "%d points" => "%d points",
// "Removed" => "Removed",
// "__WARNING__: No such module \$plugin! " => "__WARNING__: No such module \$plugin! ",
// "Create page:" => "Create page:",
// "Unknown language" => "Unknown language",
// "Click here to confirm your action" => "Click here to confirm your action",
// "Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) detected. Operation blocked.",
// "Status:" => "Status:",
// "Upload was not successful. Duplicate file content ?" => "Upload was not successful. Duplicate file content ?",
// "(unchanged)" => "(unchanged)",
// "Item Modification" => "Item Modification",
// "Item creation" => "Item creation",
// "Field is not numeric" => "Field is not numeric",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "Textarea options: quicktags,width,height,max,listmax,wordmax - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax is the maximum number of characters that are displayed in list mode, wordmax>0 alert if word count exceeded, wordmax<0 display word count." => "Textarea options: quicktags,width,height,max,listmax,wordmax - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax is the maximum number of characters that are displayed in list mode, wordmax>0 alert if word count exceeded, wordmax<0 display word count.",
// "Checkbox options: put 1 if you need that next field is on the same row." => "Checkbox options: put 1 if you need that next field is on the same row.",
// "numeric field" => "numeric field",
// "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "Dropdown options: list of items separated with commas." => "Dropdown options: list of items separated with commas.",
// "Default value is specified by having the value indicated twice consecutively" => "Default value is specified by having the value indicated twice consecutively",
// "drop down with other textfield" => "drop down with other textfield",
// "radio buttons" => "radio buttons",
// "Radio buttons options: list of items separated with commas." => "Radio buttons options: list of items separated with commas.",
// "User Selector options: automatic field feeding,email - feeding=1 for author login or feeding=2 for modificator login - email=1 to send an email to the user if the tracker is modified" => "User Selector options: automatic field feeding,email - feeding=1 for author login or feeding=2 for modificator login - email=1 to send an email to the user if the tracker is modified",
// "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered.",
// "IP selector" => "IP selector",
// "IP Selector: use options for automatic field feeding : you can use 1 for author IP or 2 for modificator IP." => "IP Selector: use options for automatic field feeding : you can use 1 for author IP or 2 for modificator IP.",
// "country selector" => "country selector",
// "Country Selector options: name/flag, sortorder - name/flag is 0,1 or 2 where 1 shows only country name, 2 shows only country flag, 0 shows both (default). sortorder is 0 or 1 where 0 sorts according to translated text (default) and 1 sorts according to english country names even if country names are translated" => "Country Selector options: name/flag, sortorder - name/flag is 0,1 or 2 where 1 shows only country name, 2 shows only country flag, 0 shows both (default). sortorder is 0 or 1 where 0 sorts according to translated text (default) and 1 sorts according to english country names even if country names are translated",
// "Date Time options: date_time,year0,year1 where date_time=d|dt(default), d displays only date, year0 is the first year, year1 the last" => "Date Time options: date_time,year0,year1 where date_time=d|dt(default), d displays only date, year0 is the first year, year1 the last",
// "jscalendar" => "jscalendar",
// "Jscalendar options: date_time where date_time=d|dt(default), d displays only date" => "Jscalendar options: date_time where date_time=d|dt(default), d displays only date",
// "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels.",
// "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test",
// "header" => "header",
// "static text" => "static text",
// "Static text options: Wikisyntax,listmax - Use Wikisyntax is 1 or 0, listmax is the maximum number of characters that are displayed in list mode." => "Static text options: Wikisyntax,listmax - Use Wikisyntax is 1 or 0, listmax is the maximum number of characters that are displayed in list mode.",
// "Category options: parentId,d|m|radio|checkbox(default),1|0(default) to have a select all button, d for dropdown, m for multiple drop down" => "Category options: parentId,d|m|radio|checkbox(default),1|0(default) to have a select all button, d for dropdown, m for multiple drop down",
// "item link" => "item link",
// "Item Link options: trackerId,fieldId,linkToItem,displayedfieldslist links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing.  Display displayedfieldslist(separate with |) instead of the target item" => "Item Link options: trackerId,fieldId,linkToItem,displayedfieldslist links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing.  Display displayedfieldslist(separate with |) instead of the target item",
// "items list" => "items list",
// "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing",
// "dynamic items list" => "dynamic items list",
// "dynamic items list options: trackerId, filterFieldIdThere, filterFieldIdHere, listFieldIdThere, statusThere insert the list of listFieldIdThere from item in tracker trackerId where filterFieldIdThere matches filterFieldIdHere where status is statusThere." => "dynamic items list options: trackerId, filterFieldIdThere, filterFieldIdHere, listFieldIdThere, statusThere insert the list of listFieldIdThere from item in tracker trackerId where filterFieldIdThere matches filterFieldIdHere where status is statusThere.",
// "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto.",
// "multimedia" => "multimedia",
// " 0|1|2|3|4|5 0,xsize,ysize. First record :0 for URL in file gal of MP3 only, 1 for URL of FLV in file gal video only , 2 for URL of MP3 or Video in file gal, 3 donwload MP3 only, 4 donwload FLV video only, 5 download FLV or MP3 (default is 0). Second record : X size of flash applet(default is 200) , Y size of flash applet (default is 100) " => " 0|1|2|3|4|5 0,xsize,ysize. First record :0 for URL in file gal of MP3 only, 1 for URL of FLV in file gal video only , 2 for URL of MP3 or Video in file gal, 3 donwload MP3 only, 4 donwload FLV video only, 5 download FLV or MP3 (default is 0). Second record : X size of flash applet(default is 200) , Y size of flash applet (default is 100) ",
// "auto-increment" => "auto-increment",
// "Sequential auto-increment number:initial_value,prepend,append,itemId: initial_value default is 1, prepend will be displayed before the field, append will be displayed just after, itemId will use the item Id" => "Sequential auto-increment number:initial_value,prepend,append,itemId: initial_value default is 1, prepend will be displayed before the field, append will be displayed just after, itemId will use the item Id",
// "user subscription" => "user subscription",
// "Allow registered user to subscribe to an item. They can add a number of friends." => "Allow registered user to subscribe to an item. They can add a number of friends.",
// "Google Maps" => "Google Maps",
// "Use Google Maps." => "Use Google Maps.",
// "system" => "system",
// "computed field" => "computed field",
// "Formula for computation, using # for indicating fields and +,*,/,- and parenthesis for operations." => "Formula for computation, using # for indicating fields and +,*,/,- and parenthesis for operations.",
// "user preference" => "user preference",
// "listview=nst, n to see name/t to see type/s to see type/u to see user in list mode" => "listview=nst, n to see name/t to see type/s to see type/u to see user in list mode",
// "pending" => "pending",
// "Added:" => "Added:",
// "Removed:" => "Removed:",
// "Remaining:" => "Remaining:",
// "Old:" => "Old:",
// "New:" => "New:",
// "No extra information for that attached file. " => "No extra information for that attached file. ",
// "The administrator has not yet validated your account. Please wait." => "The administrator has not yet validated your account. Please wait.",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "Personal Phone" => "Personal Phone",
// "Personal Mobile" => "Personal Mobile",
// "Personal Fax" => "Personal Fax",
// "Work Phone" => "Work Phone",
// "Work Mobile" => "Work Mobile",
// "Work Fax" => "Work Fax",
// "Company" => "Company",
// "Organization" => "Organization",
// "Department" => "Department",
// "Division" => "Division",
// "Job Title" => "Job Title",
// "Street Address" => "Street Address",
// "City" => "City",
// "State" => "State",
// "Zip Code" => "Zip Code",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// " where Id is the blog Id and Items is the max number of posts to display" => " where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Lists files in a directory" => "Lists files in a directory",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Takes regex expressions and parses the content between the REGEX tags and replaces the text.",
// "one data per line" => "one data per line",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace.",
// "This data is put in a CODE caption." => "This data is put in a CODE caption.",
// "Missing url parameter for SNARF plugin." => "Missing url parameter for SNARF plugin.",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Displays browser client info" => "Displays browser client info",
// "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor",
// "linktext" => "linktext",
// "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor",
// "Save changes to annotations" => "Save changes to annotations",
// "Creates an annotation block for an image." => "Creates an annotation block for an image.",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading." => "Id is optional. If not given, last article is used. Default field is heading.",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc)}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc)}{ARTICLES}~/np~",
// "No such attachment on this page" => "No such attachment on this page",
// "Displays an attachment or a list of them" => "Displays an attachment or a list of them",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description" => "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "List all pages which link to specific pages" => "List all pages which link to specific pages",
// "No pages links to" => "No pages links to",
// "One page links to" => "One page links to",
// "pages link to" => "pages link to",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "Displays a snippet of code" => "Displays a snippet of code",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "and" => "and",
// "Insert a division block on wiki page" => "Insert a division block on wiki page",
// "Creates a definition list" => "Creates a definition list",
// "one definition per line" => "one definition per line",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "equation" => "equation",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "cells" => "cells",
// "heads and cells separated by ~|~" => "heads and cells separated by ~|~",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Displays a SWF on the wiki page" => "Displays a SWF on the wiki page",
// "Formula" => "Formula",
// "No formula specified." => "No formula specified.",
// "Impossible to render the graphic." => "Impossible to render the graphic.",
// "View graphic" => "View graphic",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "Include a page" => "Include a page",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Displays the text only if the language matchs" => "Displays the text only if the language matchs",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "List wiki pages." => "List wiki pages.",
// "Displays a map" => "Displays a map",
// "Displays an miniquiz" => "Displays an miniquiz",
// "Displays a SWF myspace mp3 playlist on the wiki page" => "Displays a SWF myspace mp3 playlist on the wiki page",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Provides a list of plugins on this wiki." => "Provides a list of plugins on this wiki.",
// "No arguments indicated" => "No arguments indicated",
// "Displays the output of a poll, fields are indicated with numeric ids." => "Displays the output of a poll, fields are indicated with numeric ids.",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// "blogId is mandatory" => "blogId is mandatory",
// "Includes blog posts listing into a wiki page" => "Includes blog posts listing into a wiki page",
// "~np~{POSTS(max=>5, blogId=>id)}{POSTS}~/np~" => "~np~{POSTS(max=>5, blogId=>id)}{POSTS}~/np~",
// " wrote:" => " wrote:",
// "Quote:" => "Quote:",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect:" => "RSS Id incorrect:",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "Automatically creates a link to the appropriate SourceForge object" => "Automatically creates a link to the appropriate SourceForge object",
// "TikiSheet" => "TikiSheet",
// "Sheet Heading" => "Sheet Heading",
// "Edit Sheet" => "Edit Sheet",
// "List wiki pages" => "List wiki pages",
// "Last modified by" => "Last modified by",
// "Clickable Skype link" => "Clickable Skype link",
// "Split a page into rows and columns" => "Split a page into rows and columns",
// "row1col1" => "row1col1",
// "row1col2" => "row1col2",
// "row2col1" => "row2col1",
// "row2col2" => "row2col2",
// "Run a sql query" => "Run a sql query",
// "sql query" => "sql query",
// "Displays text in subscript." => "Displays text in subscript.",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Missing parameter" => "Missing parameter",
// "Incorrect param" => "Incorrect param",
// "Displays text in superscript." => "Displays text in superscript.",
// "Displays text between an html tag" => "Displays text between an html tag",
// "Displays the thumbnail for an image" => "Displays the thumbnail for an image",
// "Search the titles of all pages in this wiki" => "Search the titles of all pages in this wiki",
// "No pages found for title search" => "No pages found for title search",
// "One page found for title search" => "One page found for title search",
// " pages found for title search" => " pages found for title search",
// "List top scoring users" => "List top scoring users",
// "Translate a string" => "Translate a string",
// "Incorrect fieldId:" => "Incorrect fieldId:",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Other:" => "Other:",
// "Select All" => "Select All",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Fields marked with a * are mandatory." => "Fields marked with a * are mandatory.",
// "Filters the items of a tracker, fields are indicated with numeric ids." => "Filters the items of a tracker, fields are indicated with numeric ids.",
// "missing parameters" => "missing parameters",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Wiki text" => "Wiki text",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)." => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker).",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays the output of a tracker content, fields are indicated with numeric ids." => "Displays the output of a tracker content, fields are indicated with numeric ids.",
// "Error in tracker ID" => "Error in tracker ID",
// "No field indicated" => "No field indicated",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields." => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields.",
// "Displays some stat of a tracker content, fields are indicated with numeric ids." => "Displays some stat of a tracker content, fields are indicated with numeric ids.",
// "incorrect fieldId" => "incorrect fieldId",
// "Links to a translated content" => "Links to a translated content",
// "Displays the number of registered users" => "Displays the number of registered users",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored." => "A wildcard pattern of originating pages to be ignored.",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated." => "The character, by which ignored patterns are separated.",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list." => "Whether to include external wikis in the list.",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column." => "Collect either originating or wanted pages in a cell and display them in the second column.",
// "Switch-on debug output with details about the items." => "Switch-on debug output with details about the items.",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell." => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex." => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.",
// "A custom filter for wanted pages to be listed (only used when level=>custom)." => "A custom filter for wanted pages to be listed (only used when level=>custom).",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "External Wiki" => "External Wiki",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output." => "End of debug output.",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "failed" => "failed",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "Removed last version" => "Removed last version",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Sent box is full. Archive or delete some sent messages first if you want to send more messages.",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Archive is full. Delete some messages from archive first." => "Archive is full. Delete some messages from archive first.",
// "Tiki Calendar" => "Tiki Calendar",
// "list topics with links to the articles" => "list topics with links to the articles",
// "Article Topics" => "Article Topics",
// "Categorize %s in %s" => "Categorize %s in %s",
// "Please provide an Id" => "Please provide an Id",
// "no object here yet" => "no object here yet",
// "This module requires parameters trackerId and name set" => "This module requires parameters trackerId and name set",
// "Changes" => "Changes",
// "Changes since" => "Changes since",
// "new posts" => "new posts",
// "new articles" => "new articles",
// "new submissions" => "new submissions",
// "new FAQs" => "new FAQs",
// "new blogs" => "new blogs",
// "new blog posts" => "new blog posts",
// "new image galleries" => "new image galleries",
// "new file galleries" => "new file galleries",
// "new polls" => "new polls",
// "new tracker items" => "new tracker items",
// "new calendar events" => "new calendar events",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Admin live support system" => "Admin live support system",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Autovalidate suggestions" => "Autovalidate suggestions",
// "Can  receive tasks from other users" => "Can  receive tasks from other users",
// "Can abort a process instance" => "Can abort a process instance",
// "Can access site when closed" => "Can access site when closed",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can admin any mypage" => "Can admin any mypage",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can admin blogs" => "Can admin blogs",
// "Can admin categories" => "Can admin categories",
// "Can admin charts" => "Can admin charts",
// "Can admin contributions" => "Can admin contributions",
// "Can admin cookies" => "Can admin cookies",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Can admin drawings" => "Can admin drawings",
// "Can admin faqs" => "Can admin faqs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can admin forums" => "Can admin forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin games" => "Can admin games",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can admin newsletters" => "Can admin newsletters",
// "Can admin polls" => "Can admin polls",
// "Can admin public tasks" => "Can admin public tasks",
// "Can admin quicktags" => "Can admin quicktags",
// "Can admin quizzes" => "Can admin quizzes",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can admin rss modules" => "Can admin rss modules",
// "Can admin sheet" => "Can admin sheet",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can admin surveys" => "Can admin surveys",
// "Can admin the cms" => "Can admin the cms",
// "Can admin the directory" => "Can admin the directory",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can admin the wiki" => "Can admin the wiki",
// "Can admin trackers" => "Can admin trackers",
// "Can admin users" => "Can admin users",
// "Can admin workflow processes" => "Can admin workflow processes",
// "Can approve submissions" => "Can approve submissions",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can assign perms to mypage" => "Can assign perms to mypage",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Can ban users or ips" => "Can ban users or ips",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can browse freetags" => "Can browse freetags",
// "Can browse the calendar" => "Can browse the calendar",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can change tracker items" => "Can change tracker items",
// "Can clean cache" => "Can clean cache",
// "Can configure modules" => "Can configure modules",
// "Can create a blog" => "Can create a blog",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can create and edit structures" => "Can create and edit structures",
// "Can create file galleries" => "Can create file galleries",
// "Can create image galleries" => "Can create image galleries",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can create new mapfile" => "Can create new mapfile",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can declare an instance as exception" => "Can declare an instance as exception",
// "Can delete comments" => "Can delete comments",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can edit all comments" => "Can edit all comments",
// "Can edit any mypage" => "Can edit any mypage",
// "Can edit articles" => "Can edit articles",
// "Can edit content templates" => "Can edit content templates",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit drawings" => "Can edit drawings",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can edit items in categories" => "Can edit items in categories",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit object permissions" => "Can edit object permissions",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can edit pages" => "Can edit pages",
// "Can edit site templates" => "Can edit site templates",
// "Can edit submissions" => "Can edit submissions",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can execute workflow activities" => "Can execute workflow activities",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can list file galleries" => "Can list file galleries",
// "Can list image galleries" => "Can list image galleries",
// "Can list mypages" => "Can list mypages",
// "Can list registered users" => "Can list registered users",
// "Can list trackers" => "Can list trackers",
// "Can lock pages" => "Can lock pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can play games" => "Can play games",
// "Can post in forums" => "Can post in forums",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can post new comments" => "Can post new comments",
// "Can post to a blog" => "Can post to a blog",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can read article headings" => "Can read article headings",
// "Can read articles" => "Can read articles",
// "Can read blogs" => "Can read blogs",
// "Can read comments" => "Can read comments",
// "Can read forums" => "Can read forums",
// "Can remove" => "Can remove",
// "Can remove articles" => "Can remove articles",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can remove submissions" => "Can remove submissions",
// "Can rename pages" => "Can rename pages",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can rollback pages" => "Can rollback pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can search" => "Can search",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send instances after completion" => "Can send instances after completion",
// "Can send newsletters" => "Can send newsletters",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can start threads in forums" => "Can start threads in forums",
// "Can submit articles" => "Can submit articles",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can suggest items" => "Can suggest items",
// "Can tag objects" => "Can tag objects",
// "Can take quizzes" => "Can take quizzes",
// "Can take surveys" => "Can take surveys",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload files" => "Can upload files",
// "Can upload images" => "Can upload images",
// "Can upload personal files" => "Can upload personal files",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can use content templates" => "Can use content templates",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can use Directoy Batch Load" => "Can use Directoy Batch Load",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can use live support system" => "Can use live support system",
// "Can use tasks" => "Can use tasks",
// "Can use the chat system" => "Can use the chat system",
// "Can use the directory" => "Can use the directory",
// "Can use the messaging system" => "Can use the messaging system",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the newsreader" => "Can use the newsreader",
// "Can use the notepad" => "Can use the notepad",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can use webmail" => "Can use webmail",
// "Can validate submited links" => "Can validate submited links",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view any mypage" => "Can view any mypage",
// "Can view categories" => "Can view categories",
// "Can view categorized items" => "Can view categorized items",
// "Can view charts" => "Can view charts",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can view events details" => "Can view events details",
// "Can view faqs" => "Can view faqs",
// "Can view file galleries" => "Can view file galleries",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view HTML pages" => "Can view HTML pages",
// "Can view image galleries" => "Can view image galleries",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view page/pages" => "Can view page/pages",
// "Can view poll results" => "Can view poll results",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can view referer stats" => "Can view referer stats",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can view shoutbox" => "Can view shoutbox",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can view survey stats" => "Can view survey stats",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can view user quiz results" => "Can view user quiz results",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view/edit only one's own mypages" => "Can view/edit only one's own mypages",
// "Can vote" => "Can vote",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can vote comments" => "Can vote comments",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can vote polls" => "Can vote polls",
// "Can watch structure" => "Can watch structure",
// "Can watch tracker" => "Can watch tracker",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Submited links are valid" => "Submited links are valid",
// "Anti-Bot verification code" => "Anti-Bot verification code",
// "Enter the code you see above" => "Enter the code you see above",
// "Download" => "Download",
// "more info" => "more info",
// "Watched by categories" => "Watched by categories",
// "Categorize" => "Categorize",
// "Tip" => "Tip",
// "Hold down CTRL to select multiple categories" => "Hold down CTRL to select multiple categories",
// "Uncheck the above checkbox to uncategorize this page/object" => "Uncheck the above checkbox to uncategorize this page/object",
// "Admin Categories" => "Admin Categories",
// "Browse Category" => "Browse Category",
// "posts:" => "posts:",
// "top of page" => "top of page",
// "Reply" => "Reply",
// "Report this post" => "Report this post",
// "Style" => "Style",
// "Plain" => "Plain",
// "Threaded" => "Threaded",
// "Headers Only" => "Headers Only",
// "Newest first" => "Newest first",
// "Oldest first" => "Oldest first",
// "below your current threshold" => "below your current threshold",
// "New Reply" => "New Reply",
// "Editing reply" => "Editing reply",
// "Reply to the selected post" => "Reply to the selected post",
// "Post new message" => "Post new message",
// "Comment on the selected post" => "Comment on the selected post",
// "Quicktags" => "Quicktags",
// "Reply to parent post" => "Reply to parent post",
// "Post new reply" => "Post new reply",
// "Enter your name" => "Enter your name",
// "Post as Anonymous" => "Post as Anonymous",
// "Posting replies" => "Posting replies",
// "HTML tags are not allowed inside posts" => "HTML tags are not allowed inside posts",
// "Type of contribution:" => "Type of contribution:",
// "Contributors" => "Contributors",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate perms" => "Duplicate perms",
// "View inserted gallery" => "View inserted gallery",
// "Display Properties" => "Display Properties",
// "required field for podcasts" => "required field for podcasts",
// "any file" => "any file",
// "podcast (audio)" => "podcast (audio)",
// "podcast (video)" => "podcast (video)",
// "This Gallery is Public" => "This Gallery is Public",
// "The files can be locked at download:" => "The files can be locked at download:",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "unlimited" => "unlimited",
// "Parent gallery" => "Parent gallery",
// "Owner of the gallery" => "Owner of the gallery",
// "Default sort order" => "Default sort order",
// "descending" => "descending",
// "ascending" => "ascending",
// "Perhaps you were looking for:" => "Perhaps you were looking for:",
// "There are no wiki pages similar to '{\$page}'" => "There are no wiki pages similar to '{\$page}'",
// "You are not logged in." => "You are not logged in.",
// "Go to Login Page" => "Go to Login Page",
// "Create this page" => "Create this page",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Close Window" => "Close Window",
// "Go to" => "Go to",
// "Private Gallery" => "Private Gallery",
// "Active Perms" => "Active Perms",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Download and lock" => "Download and lock",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Both" => "Both",
// "Show an icon in a column" => "Show an icon in a column",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "any category" => "any category",
// "Show php error messages" => "Show php error messages",
// "Last update from SVN" => "Last update from SVN",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together." => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together.",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "Edit this page!" => "Edit this page!",
// "RSS Wiki" => "RSS Wiki",
// "RSS Blogs" => "RSS Blogs",
// "RSS Articles" => "RSS Articles",
// "RSS Image Galleries" => "RSS Image Galleries",
// "RSS File Galleries" => "RSS File Galleries",
// "RSS Forums" => "RSS Forums",
// "RSS Maps" => "RSS Maps",
// "RSS Directories" => "RSS Directories",
// "RSS Calendars" => "RSS Calendars",
// "Loading" => "Loading",
// "\\074span class=\"shortcut\"\\076C\\074/span\\076lose" => "\\074span class=\"shortcut\"\\076C\\074/span\\076lose",
// "\\074span class=\"shortcut\"\\076N\\074/span\\076ext" => "\\074span class=\"shortcut\"\\076N\\074/span\\076ext",
// "\\074span class=\"shortcut\"\\076P\\074/span\\076revious" => "\\074span class=\"shortcut\"\\076P\\074/span\\076revious",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Fullscreen" => "Fullscreen",
// "Information" => "Information",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Perform action with checked:" => "Perform action with checked:",
// "Are you sure you want to delete the selected files?" => "Are you sure you want to delete the selected files?",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link:" => "To validate your account and login to the site, please click on the following link:",
// "The administrator approved your account." => "The administrator approved your account.",
// "Confirm your email at %s" => "Confirm your email at %s",
// "Author:" => "Author:",
// "New topic:" => "New topic:",
// "Topic:" => "Topic:",
// "Contribution" => "Contribution",
// "You sent a request with the subject:" => "You sent a request with the subject:",
// "Use the subject to indicate the operation to apply:" => "Use the subject to indicate the operation to apply:",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in auto-reply." => "Tiki mail-in auto-reply.",
// "Page not found:" => "Page not found:",
// "New message arrived from %s" => "New message arrived from %s",
// "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now.",
// "To login with your username and password, please follow this link:" => "To login with your username and password, please follow this link:",
// "Tiki User Account Activated" => "Tiki User Account Activated",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "has requested an account on" => "has requested an account on",
// "To validate that account, please follow the link:" => "To validate that account, please follow the link:",
// "best regards" => "best regards",
// "your Tikiwiki" => "your Tikiwiki",
// "Tiki User Registration Request" => "Tiki User Registration Request",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "You're invited to join my network of friends!" => "You're invited to join my network of friends!",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in.",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above." => "Important: The old password remains active if you don't click the link above.",
// "Your Tiki account information for %s" => "Your Tiki account information for %s",
// "New article submitted at %s" => "New article submitted at %s",
// "Look at this link:" => "Look at this link:",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "View the tracker item at:" => "View the tracker item at:",
// "Download the file at:" => "Download the file at:",
// "Tracker was modified at" => "Tracker was modified at",
// "Please visit this link before login again:" => "Please visit this link before login again:",
// "Confirm your account at %s" => "Confirm your account at %s",
// "Your account request have been stored and will be activated by the admin as soon as possible." => "Your account request have been stored and will be activated by the admin as soon as possible.",
// "You'll receive email notification once your account is activated." => "You'll receive email notification once your account is activated.",
// "Please do not attempt to login until you receive the email notification." => "Please do not attempt to login until you receive the email notification.",
// "New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "View the article at:" => "View the article at:",
// "New article post at %s" => "New article post at %s",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "New blog post at %s" => "New blog post at %s",
// "View item calendar at:" => "View item calendar at:",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "Removed by" => "Removed by",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "Old" => "Old",
// "updated" => "updated",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}:" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}:",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the updated map following this link:" => "You can view the updated map following this link:",
// "You can edit the map following this link:" => "You can edit the map following this link:",
// "An object was added to category" => "An object was added to category",
// "Added by" => "Added by",
// "Object type" => "Object type",
// "An object was removed from category" => "An object was removed from category",
// "A page has been added to your watched sub-structure:" => "A page has been added to your watched sub-structure:",
// "A page has been removed from your watched sub-structure:" => "A page has been removed from your watched sub-structure:",
// "A page has been promoted out your watched sub-structure:" => "A page has been promoted out your watched sub-structure:",
// "A page has been demoted to your watched structure:" => "A page has been demoted to your watched structure:",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the page by following this link:" => "You can view the page by following this link:",
// "You can view a diff back to the previous version by following this link:" => "You can view a diff back to the previous version by following this link:",
// "The changes in this version follow below, followed after by the current full page text." => "The changes in this version follow below, followed after by the current full page text.",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "The new page content follows below." => "The new page content follows below.",
// "Wiki page %s changed" => "Wiki page %s changed",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Thank you for your registration. You may log in now." => "Thank you for your registration. You may log in now.",
// "click on the map to zoom or pan, do not drag" => "click on the map to zoom or pan, do not drag",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Scale" => "Scale",
// "Zoom out" => "Zoom out",
// "Query" => "Query",
// "Pan" => "Pan",
// "Zoom in" => "Zoom in",
// "Redraw" => "Redraw",
// "select zoom/pan/query and image size" => "select zoom/pan/query and image size",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Click on the map or click redraw" => "Click on the map or click redraw",
// "Overview" => "Overview",
// "Legend" => "Legend",
// "Layer Manager" => "Layer Manager",
// "Layer" => "Layer",
// "On" => "On",
// "Label" => "Label",
// "Download Layer" => "Download Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "you have requested to download the layer:" => "you have requested to download the layer:",
// "from the mapfile:" => "from the mapfile:",
// "Here are the files to download, do not forget to rename them:" => "Here are the files to download, do not forget to rename them:",
// "Mapfiles" => "Mapfiles",
// "Mapfile" => "Mapfile",
// "Available mapfiles" => "Available mapfiles",
// "hits last 7 days" => "hits last 7 days",
// "monitor this map" => "monitor this map",
// "Stop Monitoring this Map" => "Stop Monitoring this Map",
// "Create a new mapfile" => "Create a new mapfile",
// "Mapfile listing" => "Mapfile listing",
// "Reload" => "Reload",
// "You can view this map in your browser using" => "You can view this map in your browser using",
// "Zoom out x2" => "Zoom out x2",
// "Zoom in x2" => "Zoom in x2",
// "Mapfile History" => "Mapfile History",
// "Comparing version {\$old.version} with version {\$new.version}" => "Comparing version {\$old.version} with version {\$new.version}",
// "Version:" => "Version:",
// "Legend:" => "Legend:",
// "v=view" => "v=view",
// "c=compare" => "c=compare",
// "d=diff" => "d=diff",
// "Full side-by-side diff" => "Full side-by-side diff",
// "Unified diff" => "Unified diff",
// "Side-by-side view" => "Side-by-side view",
// "Older Version" => "Older Version",
// "Directories" => "Directories",
// "back to" => "back to",
// "Upload From Disk:" => "Upload From Disk:",
// "Upload Files" => "Upload Files",
// "Bytes maximum" => "Bytes maximum",
// "Create Directory:" => "Create Directory:",
// "index file (.shp):" => "index file (.shp):",
// "files to index (regexp):" => "files to index (regexp):",
// "Message Archive" => "Message Archive",
// "Edit template" => "Edit template",
// "messages" => "messages",
// "Archive is full!" => "Archive is full!",
// "Message Broadcast" => "Message Broadcast",
// "Compose Message" => "Compose Message",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences." => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences.",
// "ERROR" => "ERROR",
// "Separate multiple usernames with a comma (&nbsp;,&nbsp;)." => "Separate multiple usernames with a comma (&nbsp;,&nbsp;).",
// "No messages to download" => "No messages to download",
// "Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Mailbox is full! Delete or archive some messages if you want to receive more messages.",
// "is reply to" => "is reply to",
// "Find replied message" => "Find replied message",
// "Archive" => "Archive",
// "Sent" => "Sent",
// "Auto-archive age for read messages:" => "Auto-archive age for read messages:",
// "Return to mailbox" => "Return to mailbox",
// "Unflag" => "Unflag",
// "Return to archive" => "Return to archive",
// "Return to outbox" => "Return to outbox",
// "Sent Messages" => "Sent Messages",
// "Replied" => "Replied",
// "Not replied" => "Not replied",
// "move to archive" => "move to archive",
// "receiver" => "receiver",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "Move module up" => "Move module up",
// "Move module down" => "Move module down",
// "Move module to opposite side" => "Move module to opposite side",
// "opp side" => "opp side",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module?" => "Are you sure you want to unassign this module?",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "\$tpl_module_title" => "\$tpl_module_title",
// "QuickTags" => "QuickTags",
// "Shoutbox Words" => "Shoutbox Words",
// "Import PHPWiki Dump" => "Import PHPWiki Dump",
// "System Admin" => "System Admin",
// "Security Admin" => "Security Admin",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number !" => "You forgot your Google ad_client number !",
// "MyTiki home" => "MyTiki home",
// "FriendsMenu" => "FriendsMenu",
// "Community" => "Community",
// "User list" => "User list",
// "Friendship Network" => "Friendship Network",
// "Send pages" => "Send pages",
// "New article" => "New article",
// "Admin types" => "Admin types",
// "Create/Edit blog" => "Create/Edit blog",
// "Browse directory" => "Browse directory",
// "Maps" => "Maps",
// "Layer management" => "Layer management",
// "List quizzes" => "List quizzes",
// "ShtMenu" => "ShtMenu",
// "Events" => "Events",
// "Send events" => "Send events",
// "Admin events" => "Admin events",
// "Ephemerides Admin" => "Ephemerides Admin",
// "Charts Admin" => "Charts Admin",
// "Admin home" => "Admin home",
// "Debugger console" => "Debugger console",
// "Integrator" => "Integrator",
// "Mods Admin" => "Mods Admin",
// "\$module_title" => "\$module_title",
// "More..." => "More...",
// "Tikiwiki Assistant" => "Tikiwiki Assistant",
// "Thank you for installing Tikiwiki" => "Thank you for installing Tikiwiki",
// "To configure your Tiki" => "To configure your Tiki",
// "Admin Home" => "Admin Home",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as the Admin" => "as the Admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://www.tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://www.tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://www.tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://www.tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "Last `\$module_rows` blog comments" => "Last `\$module_rows` blog comments",
// "Last blog comments" => "Last blog comments",
// " on blogpost " => " on blogpost ",
// "\$modcattitle" => "\$modcattitle",
// "Last `\$module_rows` Sites" => "Last `\$module_rows` Sites",
// "Top \$module_rows Sites" => "Top \$module_rows Sites",
// "Current events" => "Current events",
// "Top `\$module_rows` topics" => "Top `\$module_rows` topics",
// "Last `\$module_rows` forum posts" => "Last `\$module_rows` forum posts",
// "Last forum posts" => "Last forum posts",
// "Last `\$module_rows` forum topics" => "Last `\$module_rows` forum topics",
// "Folksonomy" => "Folksonomy",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "More Like This" => "More Like This",
// "Most popular tags" => "Most popular tags",
// "List everything tagged" => "List everything tagged",
// "My prefered tags" => "My prefered tags",
// "Last `\$module_rows` actions" => "Last `\$module_rows` actions",
// "Last actions" => "Last actions",
// "Last `\$module_rows` articles" => "Last `\$module_rows` articles",
// "Last articles" => "Last articles",
// "Last `\$module_rows` blog posts" => "Last `\$module_rows` blog posts",
// "\$type" => "\$type",
// "Last `\$module_rows` Created blogs" => "Last `\$module_rows` Created blogs",
// "Last `\$module_rows` Created FAQs" => "Last `\$module_rows` Created FAQs",
// "Last `\$module_rows` Created Quizzes" => "Last `\$module_rows` Created Quizzes",
// "Last `\$module_rows` modified file galleries" => "Last `\$module_rows` modified file galleries",
// "Last `\$module_rows` Files" => "Last `\$module_rows` Files",
// "Last `\$module_rows` galleries" => "Last `\$module_rows` galleries",
// "Last `\$module_rows` Images" => "Last `\$module_rows` Images",
// "Last Images" => "Last Images",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "Last `\$module_rows` modified events" => "Last `\$module_rows` modified events",
// "Last modifed events" => "Last modifed events",
// "Last `\$module_rows` changes" => "Last `\$module_rows` changes",
// "more" => "more",
// "Last `\$module_rows` Modified Items" => "Last `\$module_rows` Modified Items",
// "Last `\$module_rows` Modified blogs" => "Last `\$module_rows` Modified blogs",
// "Last `\$module_rows` submissions" => "Last `\$module_rows` submissions",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "Last `\$module_rows` Items" => "Last `\$module_rows` Items",
// "Last `\$module_rows` visitors" => "Last `\$module_rows` visitors",
// "Last Visitors" => "Last Visitors",
// "No avatar." => "No avatar.",
// "You" => "You",
// "Logged in as" => "Logged in as",
// "Switch User" => "Switch User",
// "Paramaters" => "Paramaters",
// "applicable for this item" => "applicable for this item",
// "Switch user" => "Switch user",
// "Login through CAS" => "Login through CAS",
// "Login as admin" => "Login as admin",
// "Login through Shibboleth" => "Login through Shibboleth",
// "Login as" => "Login as",
// "Click here to register" => "Click here to register",
// "Click here if you've forgotten your password" => "Click here if you've forgotten your password",
// "Click here to login using the default security protocol" => "Click here to login using the default security protocol",
// "Click here to login using a secure protocol" => "Click here to login using a secure protocol",
// "local account" => "local account",
// "OpenID Login" => "OpenID Login",
// "What is OpenID?" => "What is OpenID?",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "RSS Feeds" => "RSS Feeds",
// "Wiki RSS" => "Wiki RSS",
// "Blogs RSS" => "Blogs RSS",
// "Articles RSS" => "Articles RSS",
// "Image Galleries RSS" => "Image Galleries RSS",
// "File Galleries RSS" => "File Galleries RSS",
// "Forums RSS" => "Forums RSS",
// "Maps RSS" => "Maps RSS",
// "Calendars" => "Calendars",
// "New Tracker Items" => "New Tracker Items",
// "New Calendar Events" => "New Calendar Events",
// "`\$slvn_info.label`" => "`\$slvn_info.label`",
// "Nothing has changed" => "Nothing has changed",
// "click to show/hide" => "click to show/hide",
// "Site Language:" => "Site Language:",
// "Site default" => "Site default",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "Top `\$module_rows` articles" => "Top `\$module_rows` articles",
// "Top `\$module_rows` File Galleries" => "Top `\$module_rows` File Galleries",
// "Top `\$module_rows` files" => "Top `\$module_rows` files",
// "Top files" => "Top files",
// "Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
// "Top Forum Posters" => "Top Forum Posters",
// "Top `\$module_rows` games" => "Top `\$module_rows` games",
// "Top `\$module_rows` galleries" => "Top `\$module_rows` galleries",
// "Top `\$module_rows` Images" => "Top `\$module_rows` Images",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Top `\$module_rows` Pages" => "Top `\$module_rows` Pages",
// "Top `\$module_rows` Quizzes" => "Top `\$module_rows` Quizzes",
// "Most `\$module_rows` visited blogs" => "Most `\$module_rows` visited blogs",
// "Top `\$module_rows` Visited FAQs" => "Top `\$module_rows` Visited FAQs",
// "Page translation" => "Page translation",
// "There are no translations of this page." => "There are no translations of this page.",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Set your preferred languages." => "Set your preferred languages.",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "The Next Event" => "The Next Event",
// "No Upcoming Events" => "No Upcoming Events",
// "click to view" => "click to view",
// "Public tasks" => "Public tasks",
// "select" => "select",
// "User informations" => "User informations",
// "Group informations" => "Group informations",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Top users" => "Top users",
// "More" => "More",
// "Whats related" => "Whats related",
// "on host" => "on host",
// "Last `\$module_rows` wiki comments" => "Last `\$module_rows` wiki comments",
// "Last wiki comments" => "Last wiki comments",
// " on page " => " on page ",
// "Changes that need to be reproduced are highlighted below." => "Changes that need to be reproduced are highlighted below.",
// "Click to see the ratings" => "Click to see the ratings",
// "[-]" => "[-]",
// "Errors" => "Errors",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "Structures:" => "Structures:",
// "show structures" => "show structures",
// "hide structures" => "hide structures",
// "Manage structures" => "Manage structures",
// "Are you sure you want to remove this module?" => "Are you sure you want to remove this module?",
// "Powered by" => "Powered by",
// "Execution time" => "Execution time",
// "Memory usage" => "Memory usage",
// "database queries used" => "database queries used",
// "Server load" => "Server load",
// "page id" => "page id",
// "3d browser" => "3d browser",
// "Parent page" => "Parent page",
// "Child" => "Child",
// "Last edited by" => "Last edited by",
// "based on work by" => "based on work by",
// "Page last modified on" => "Page last modified on",
// "Contributors to this page" => "Contributors to this page",
// "Created by:" => "Created by:",
// "Last Modification:" => "Last Modification:",
// "For" => "For",
// "Jump to Content" => "Jump to Content",
// "Report to Webmaster" => "Report to Webmaster",
// "Made with" => "Made with",
// "powered by" => "powered by",
// "database queries used in " => "database queries used in ",
// "star" => "star",
// "half star" => "half star",
// "Send a link" => "Send a link",
// "close" => "close",
// "Location : " => "Location : ",
// "Show/Hide Left Menus" => "Show/Hide Left Menus",
// "Show/Hide Right Menus" => "Show/Hide Right Menus",
// "Email this page" => "Email this page",
// "User List" => "User List",
// "Homework" => "Homework",
// "Assignments" => "Assignments",
// "{|} Files Attached" => "{|} Files Attached",
// "Member list" => "Member list",
// "The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page.",
// "My Footnotes" => "My Footnotes",
// "Edit Summary" => "Edit Summary",
// "RSS Trackers" => "RSS Trackers",
// "left/right" => "left/right",
// "Unassign module" => "Unassign module",
// "Edit mapfiles" => "Edit mapfiles",
// "Language: " => "Language: ",
// "Note: if you want to use images please save the post first and you\n\twill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\n\tor use the image URL to include images using the WYSIWYG editor. " => "Note: if you want to use images please save the post first and you\n\twill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\n\tor use the image URL to include images using the WYSIWYG editor. ",
// "Mark entry as private:" => "Mark entry as private:",
// "Tiki community" => "Tiki community",
// "Show/Hide Left Modules" => "Show/Hide Left Modules",
// "Show/Hide Right Modules" => "Show/Hide Right Modules",
// "Last update from CVS" => "Last update from CVS",
// "Translate in" => "Translate in",
// "babelfish it" => "babelfish it",
// "Welcome to" => "Welcome to",
// "Design by" => "Design by",
// "Enlarge area height" => "Enlarge area height",
// "Reduce area height" => "Reduce area height",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Calendar View" => "Calendar View",
// "List View" => "List View",
// "Tiki Action Calendar" => "Tiki Action Calendar",
// "Apply" => "Apply",
// "Reset" => "Reset",
// "Site Ads and Banners" => "Site Ads and Banners",
// "Test" => "Test",
// "Meta Tags" => "Meta Tags",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "Freetags" => "Freetags",
// "i18n" => "i18n",
// "Wysiwyg editor" => "Wysiwyg editor",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Look &amp; Feel" => "Look &amp; Feel",
// "Text area" => "Text area",
// "Multimedia" => "Multimedia",
// "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or",
// "Trackbacks Pings" => "Trackbacks Pings",
// "Post level trackback pings" => "Post level trackback pings",
// "Not Installed" => "Not Installed",
// "Blogs have a custom heading" => "Blogs have a custom heading",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Title length" => "Title length",
// "Creation date" => "Creation date",
// "Last modification time" => "Last modification time",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "Group calendar sticky popup" => "Group calendar sticky popup",
// "Group calendar item view tab" => "Group calendar item view tab",
// "Default view mode" => "Default view mode",
// "Day" => "Day",
// "Quarter" => "Quarter",
// "Semester" => "Semester",
// "Calendar manual selection of time/date" => "Calendar manual selection of time/date",
// "JsCalendar" => "JsCalendar",
// "First day of the week" => "First day of the week",
// "Depends user language" => "Depends user language",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "15 minutes" => "15 minutes",
// "30 minutes" => "30 minutes",
// "First year in the dropdown, either year number, or relative to current year (+/- N)" => "First year in the dropdown, either year number, or relative to current year (+/- N)",
// "if no jscalendar" => "if no jscalendar",
// "Last year in the dropdown, either year number, or relative to current year (+/- N)" => "Last year in the dropdown, either year number, or relative to current year (+/- N)",
// "Change settings" => "Change settings",
// "Use categories to regroup various Tiki objects" => "Use categories to regroup various Tiki objects",
// "Link to" => "Link to",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Exclude These Category IDs from Path (comma delimited)" => "Exclude These Category IDs from Path (comma delimited)",
// "Search may show forbidden results. Much better performance though." => "Search may show forbidden results. Much better performance though.",
// "Ignore category viewing restrictions" => "Ignore category viewing restrictions",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Categories browse uses PhpLayers" => "Categories browse uses PhpLayers",
// "The feature must be activated" => "The feature must be activated",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Print article" => "Print article",
// "Can specify notification emails when creating an article" => "Can specify notification emails when creating an article",
// "Settings for page articles home" => "Settings for page articles home",
// "Fields to display on page" => "Fields to display on page",
// "Expire Date" => "Expire Date",
// "Visible" => "Visible",
// "Batch upload (CSV file):" => "Batch upload (CSV file):",
// "User identity features" => "User identity features",
// "Show user's info on mouseover" => "Show user's info on mouseover",
// "Picture" => "Picture",
// "Number of friends" => "Number of friends",
// "E-mail" => "E-mail",
// "Distance" => "Distance",
// "Users sort order" => "Users sort order",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "Enable Feature for Wiki" => "Enable Feature for Wiki",
// "Enable Feature for Articles" => "Enable Feature for Articles",
// "Enable Feature for Blogues" => "Enable Feature for Blogues",
// "Enable Feature for Faqs" => "Enable Feature for Faqs",
// "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or",
// "enable cool sites" => "enable cool sites",
// "Show Country Flag" => "Show Country Flag",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site." => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site.",
// "No tabs" => "No tabs",
// "Main" => "Main",
// "Global Features" => "Global Features",
// "More Functionality" => "More Functionality",
// "Technology" => "Technology",
// "UI Enhancements" => "UI Enhancements",
// "Extra Stuff &amp; Fun" => "Extra Stuff &amp; Fun",
// "Content Related" => "Content Related",
// "Main Features" => "Main Features",
// "Site Global Features" => "Site Global Features",
// "Action Log" => "Action Log",
// "Action log setting" => "Action log setting",
// "Feature documentation links" => "Feature documentation links",
// "Help System (Feature documentation links)" => "Help System (Feature documentation links)",
// "Additional Features" => "Additional Features",
// "Spreadsheet" => "Spreadsheet",
// "Tiki Sheet" => "Tiki Sheet",
// "Copyright System" => "Copyright System",
// "Copyright system" => "Copyright system",
// "Tell a Friend" => "Tell a Friend",
// "Allow to post comments as Anonymous" => "Allow to post comments as Anonymous",
// "Technical Features" => "Technical Features",
// "Search engine friendly url" => "Search engine friendly url",
// "Swffix" => "Swffix",
// "Ajax" => "Ajax",
// "HTML Purifier" => "HTML Purifier",
// "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)" => "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)",
// "User interface enhancement features" => "User interface enhancement features",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "PHPLayers" => "PHPLayers",
// "PhpLayers Dynamic menus" => "PhpLayers Dynamic menus",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "required" => "required",
// "Mootools" => "Mootools",
// "Experimental Features" => "Experimental Features",
// "Friendship" => "Friendship",
// "Mobile" => "Mobile",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Use File Galleries for images inclusion" => "Use File Galleries for images inclusion",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Action Calendar" => "Action Calendar",
// "Tiki action calendar" => "Tiki action calendar",
// "Contact Us (Anonymous)" => "Contact Us (Anonymous)",
// "Redirect On Error" => "Redirect On Error",
// "TikiTests" => "TikiTests",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "User Contacts" => "User Contacts",
// "User Watches Translations" => "User Watches Translations",
// "User Levels" => "User Levels",
// "To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "To add/remove file galleries, go to \"File Galleries\" on the application menu, or",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory.",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Home Gallery" => "Home Gallery",
// "Allow download limit per file" => "Allow download limit per file",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "File author" => "File author",
// "For not registered author" => "For not registered author",
// "Allow same file to be uploaded more than once" => "Allow same file to be uploaded more than once",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "The server must be able to read/write the directory." => "The server must be able to read/write the directory.",
// "The directory can be outside the web space." => "The directory can be outside the web space.",
// "PodCast directory (must be web accessible):" => "PodCast directory (must be web accessible):",
// "Directory Batch Loading" => "Directory Batch Loading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "Enable directory batch loading" => "Enable directory batch loading",
// "Batch loading directory" => "Batch loading directory",
// "The server must be able to read the directory." => "The server must be able to read the directory.",
// "Change configuration" => "Change configuration",
// "File galleries search indexing" => "File galleries search indexing",
// "Leave command blank to delete handler" => "Leave command blank to delete handler",
// "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)",
// "Enable auto indexing on file upload or change" => "Enable auto indexing on file upload or change",
// "MIME Type" => "MIME Type",
// "System command" => "System command",
// "Reindex all files for search" => "Reindex all files for search",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Home Forum" => "Home Forum",
// "Forums features" => "Forums features",
// "Enable topics archiving" => "Enable topics archiving",
// "Allow first posts of a thread to have an empty body (will be a thread title)" => "Allow first posts of a thread to have an empty body (will be a thread title)",
// "Reply posts are empty" => "Reply posts are empty",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Search some forums by name (on \"forum list\")" => "Search some forums by name (on \"forum list\")",
// "Search some forums by content on \"forum list\" (needs feature_search activated)" => "Search some forums by content on \"forum list\" (needs feature_search activated)",
// "Search in topics content on forum page (needs feature_search activated)" => "Search in topics content on forum page (needs feature_search activated)",
// "Search method when searching in content: Tiki search local to a forum" => "Search method when searching in content: Tiki search local to a forum",
// "Search method when searching in content: Non-Tiki search local to a forum" => "Search method when searching in content: Non-Tiki search local to a forum",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "Threads default preferences" => "Threads default preferences",
// "Allow to manage thread defaults in each forum configuration" => "Allow to manage thread defaults in each forum configuration",
// "Display thread configuration bar to override defaults" => "Display thread configuration bar to override defaults",
// "Configuration bar settings are kept for all forums during the user session:" => "Configuration bar settings are kept for all forums during the user session:",
// "Default thread style" => "Default thread style",
// "Default thread sort mode" => "Default thread sort mode",
// "Freetags rock!" => "Freetags rock!",
// "Freetag Browsing" => "Freetag Browsing",
// "Show Tag Cloud" => "Show Tag Cloud",
// "Random tag cloud colors (separated by comma)" => "Random tag cloud colors (separated by comma)",
// "Preload freetag random search when arriving on <a href=\"tiki-browse_freetags.php\">freetag search grid</a>" => "Preload freetag random search when arriving on <a href=\"tiki-browse_freetags.php\">freetag search grid</a>",
// "Number of Tags to show in Cloud" => "Number of Tags to show in Cloud",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Only accept alphanumeric ASCII freetags (no accents or special chars)" => "Only accept alphanumeric ASCII freetags (no accents or special chars)",
// "Accept all" => "Accept all",
// "Only accept lowercase freetags" => "Only accept lowercase freetags",
// "Handle multilingual freetags" => "Handle multilingual freetags",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "cleanup" => "cleanup",
// "More Like This/Get Similar Module" => "More Like This/Get Similar Module",
// "More Like This algorithm" => "More Like This algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Basic algorithm - Minimum amount of tags in common" => "Basic algorithm - Minimum amount of tags in common",
// "6" => "6",
// "7" => "7",
// "8" => "8",
// "9" => "9",
// "Freetag 3D Browser Configuration" => "Freetag 3D Browser Configuration",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Browser width" => "Browser width",
// "Browser height" => "Browser height",
// "Graph appearance" => "Graph appearance",
// "Navigation depth" => "Navigation depth",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Spring (connection) size" => "Spring (connection) size",
// "Node color" => "Node color",
// "Camera settings" => "Camera settings",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Camera distance" => "Camera distance",
// "Field of view" => "Field of view",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Physics engine" => "Physics engine",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "You can upload images of a size of " => "You can upload images of a size of ",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "Uses Slideshow" => "Uses Slideshow",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below." => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below.",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Default scale size" => "Default scale size",
// "pixels" => "pixels",
// "Exterminator" => "Exterminator",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Tikiwiki version" => "Tikiwiki version",
// "Use group homepages" => "Use group homepages",
// "Go to group homepage only if login from default homepage" => "Go to group homepage only if login from default homepage",
// "PHP error reporting level:" => "PHP error reporting level:",
// "No error reporting" => "No error reporting",
// "Report all PHP errors" => "Report all PHP errors",
// "Report all errors except notices" => "Report all errors except notices",
// "visible to admin only" => "visible to admin only",
// "smarty notice reporting" => "smarty notice reporting",
// "Log Mail in Tiki Logs:" => "Log Mail in Tiki Logs:",
// "Log SQL:" => "Log SQL:",
// "Default charset for sending mail:" => "Default charset for sending mail:",
// "Mail end of line:" => "Mail end of line:",
// "(standard)" => "(standard)",
// "(some Unix MTA)" => "(some Unix MTA)",
// "Disallow access to the site (except for those with permission)" => "Disallow access to the site (except for those with permission)",
// "Message to display when site is closed" => "Message to display when site is closed",
// "Disallow access when load is above the threshold (except for those with permission)" => "Disallow access when load is above the threshold (except for those with permission)",
// "Max average server load threshold in the last minute" => "Max average server load threshold in the last minute",
// "Message to display when server is too busy" => "Message to display when server is too busy",
// "output compression is active." => "output compression is active.",
// "compression is handled by" => "compression is handled by",
// "Allow anonymous users to \"Contact Us\"" => "Allow anonymous users to \"Contact Us\"",
// "Store session data in database" => "Store session data in database",
// "Session lifetime in minutes" => "Session lifetime in minutes",
// "Use proxy" => "Use proxy",
// "Proxy Host" => "Proxy Host",
// "Proxy port" => "Proxy port",
// "Help System" => "Help System",
// "Help URL" => "Help URL",
// "Please expect not found help-pages with the default-URL." => "Please expect not found help-pages with the default-URL.",
// "Any help with the documentation is welcome." => "Any help with the documentation is welcome.",
// "Release check" => "Release check",
// "Check frequency" => "Check frequency",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "Release checks are made when you browse admin main page only" => "Release checks are made when you browse admin main page only",
// "Force immediate check" => "Force immediate check",
// "Default timezone" => "Default timezone",
// "Fields display order" => "Fields display order",
// "When possible, show the real user name instead of login:" => "When possible, show the real user name instead of login:",
// "Locations separator" => "Locations separator",
// "Examples" => "Examples",
// "Choices separator" => "Choices separator",
// "Preference syntax" => "Preference syntax",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Internationalization" => "Internationalization",
// "I18n setup" => "I18n setup",
// "Default Language" => "Default Language",
// "Multilingual" => "Multilingual",
// "Multilingual structures" => "Multilingual structures",
// "Show pages in user's preferred language" => "Show pages in user's preferred language",
// "Detect browser language" => "Detect browser language",
// "Restrict supported languages" => "Restrict supported languages",
// "Available languages (Ctrl+Click to select multiple languages):" => "Available languages (Ctrl+Click to select multiple languages):",
// "Quantify change size" => "Quantify change size",
// "Show Babelfish Translation URLs" => "Show Babelfish Translation URLs",
// "Show Babelfish Translation Logo" => "Show Babelfish Translation Logo",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// " as master" => " as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "IP" => "IP",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Wysiwyg" => "Wysiwyg",
// "Text Area" => "Text Area",
// "Admin Groups" => "Admin Groups",
// "Admin Users" => "Admin Users",
// "Tiki and PAM" => "Tiki and PAM",
// "CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
// "Shibboleth" => "Shibboleth",
// "OpenID and Tiki" => "OpenID and Tiki",
// "... but need admin validation" => "... but need admin validation",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>",
// "Create a group for each user <br />(with the same name as the user)" => "Create a group for each user <br />(with the same name as the user)",
// "Use tracker for more user information" => "Use tracker for more user information",
// "Use tracker for more group information" => "Use tracker for more group information",
// " - Php GD library required" => " - Php GD library required",
// "Use login as email" => "Use login as email",
// "Validate user email server" => "Validate user email server",
// "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email",
// "Crypt passwords method" => "Crypt passwords method",
// "tikihash (old)" => "tikihash (old)",
// "Reg users can change password" => "Reg users can change password",
// "Restrict available themes" => "Restrict available themes",
// "Available styles:" => "Available styles:",
// "Restrict available languages" => "Restrict available languages",
// "Available languages:" => "Available languages:",
// "Minimum username length" => "Minimum username length",
// "Maximum username length" => "Maximum username length",
// "Force lowercase username" => "Force lowercase username",
// "-1 for never" => "-1 for never",
// "Re-validate user by email after days" => "Re-validate user by email after days",
// "Re-validate user by email after unsuccessful logins" => "Re-validate user by email after unsuccessful logins",
// "Generate a password option" => "Generate a password option",
// "HTTPS login" => "HTTPS login",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are in always in HTTPS, but do not check" => "Consider we are in always in HTTPS, but do not check",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "User's choice" => "User's choice",
// "Always" => "Always",
// "year" => "year",
// "Remember me name" => "Remember me name",
// "Remember me domain" => "Remember me domain",
// "Remember me path" => "Remember me path",
// "Protect against CSRF with a confirmation step" => "Protect against CSRF with a confirmation step",
// "Protect against CSRF with a ticket" => "Protect against CSRF with a ticket",
// "Highlight Group" => "Highlight Group",
// "choose a group ..." => "choose a group ...",
// "User can choose beyond these groups at registration time" => "User can choose beyond these groups at registration time",
// "Specify the fields that will be asked in admin->groups" => "Specify the fields that will be asked in admin->groups",
// "Displays user's contribution in the user information page" => "Displays user's contribution in the user information page",
// "Displays UserTracker information in user information page. Format: trackerId, fieldId1, fieldId2, …" => "Displays UserTracker information in user information page. Format: trackerId, fieldId1, fieldId2, …",
// "Deactivate login autocomplete (do not remember login and password)" => "Deactivate login autocomplete (do not remember login and password)",
// "On permission denied, display login box for anonymous:" => "On permission denied, display login box for anonymous:",
// "On permission denied, send to this url:" => "On permission denied, send to this url:",
// "LDAP" => "LDAP",
// "LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(if set, this will override the Host and Port below)",
// "LDAP Group Attribute" => "LDAP Group Attribute",
// "LDAP Version" => "LDAP Version",
// "LDAP Realname Attribute" => "LDAP Realname Attribute",
// "PAM" => "PAM",
// "PAM service" => "PAM service",
// "Currently unused" => "Currently unused",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/.",
// "CAS server version" => "CAS server version",
// "Version 1.0" => "Version 1.0",
// "Version 2.0" => "Version 2.0",
// "CAS server hostname" => "CAS server hostname",
// "CAS server port" => "CAS server port",
// "CAS server path" => "CAS server path",
// "Change CAS preferences" => "Change CAS preferences",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "Valid Affiliations (separated by commas)" => "Valid Affiliations (separated by commas)",
// "Create with default group?" => "Create with default group?",
// "Default group: " => "Default group: ",
// "Change Shibboleth preferences" => "Change Shibboleth preferences",
// "Users Defaults" => "Users Defaults",
// "Users Default Preferences" => "Users Default Preferences",
// "Does your mail reader need a special charset" => "Does your mail reader need a special charset",
// "default" => "default",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "Use double-click to edit pages" => "Use double-click to edit pages",
// "Note author when reading his mail" => "Note author when reading his mail",
// "Auto-archive read messages after x days" => "Auto-archive read messages after x days",
// "never" => "never",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "My workflow" => "My workflow",
// "Change users defaults" => "Change users defaults",
// "General Layout" => "General Layout",
// "Use transition style sheet from version" => "Use transition style sheet from version",
// "Never use transition css" => "Never use transition css",
// "Use @version:x.x specified in theme css or none if not specified" => "Use @version:x.x specified in theme css or none if not specified",
// "Use @version:x.x specified in theme css or 1.8 if not specified" => "Use @version:x.x specified in theme css or 1.8 if not specified",
// "Use @version:x.x specified in theme css or 1.9 if not specified" => "Use @version:x.x specified in theme css or 1.9 if not specified",
// "Template Viewing" => "Template Viewing",
// "Tiki Template Viewing" => "Tiki Template Viewing",
// "Site Identity" => "Site Identity",
// "Required for all the following features" => "Required for all the following features",
// "Custom Site Header" => "Custom Site Header",
// "Site Logo" => "Site Logo",
// "Site logo source (image path)" => "Site logo source (image path)",
// "Site logo background color" => "Site logo background color",
// "Site logo background style" => "Site logo background style",
// "Site logo alignment" => "Site logo alignment",
// "on left side" => "on left side",
// "on center" => "on center",
// "on right side" => "on right side",
// "Site logo title (on mouse over)" => "Site logo title (on mouse over)",
// "Alt. description (e.g. for text browsers)" => "Alt. description (e.g. for text browsers)",
// "Site Search Bar" => "Site Search Bar",
// "Site Login Bar" => "Site Login Bar",
// "Top Bar" => "Top Bar",
// "Site menu bar" => "Site menu bar",
// "Note: This feature also requires PHPLayers to be turned on in " => "Note: This feature also requires PHPLayers to be turned on in ",
// "Menu ID" => "Menu ID",
// "Current Version" => "Current Version",
// "Custom code" => "Custom code",
// "Users can Flip Columns" => "Users can Flip Columns",
// "always" => "always",
// "user decides" => "user decides",
// "Site Breadcrumbs" => "Site Breadcrumbs",
// "Site location bar" => "Site location bar",
// "at top of page" => "at top of page",
// "at top of center column" => "at top of center column",
// "Prefix breadcrumbs with 'Location : ' " => "Prefix breadcrumbs with 'Location : ' ",
// "Larger font for" => "Larger font for",
// "entire location" => "entire location",
// "page name" => "page name",
// "Use page description:" => "Use page description:",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Left blank to use the default sender email" => "Left blank to use the default sender email",
// "Custom Site Footer" => "Custom Site Footer",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item:" => "Max. number of links around the current item:",
// "Max. number of links after the first or before the last item:" => "Max. number of links after the first or before the last item:",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Use Icons" => "Use Icons",
// "Use Tabs" => "Use Tabs",
// "Other options" => "Other options",
// "Use context menus for actions (icons) (only in file galleries yet)" => "Use context menus for actions (icons) (only in file galleries yet)",
// "Use context menus for actions (text) (only in file galleries yet)" => "Use context menus for actions (text) (only in file galleries yet)",
// "Favicon icon file name:" => "Favicon icon file name:",
// "Favicon icon MIME type:" => "Favicon icon MIME type:",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "full path to mapfiles" => "full path to mapfiles",
// "default mapfile" => "default mapfile",
// "Wiki Page for Help" => "Wiki Page for Help",
// "Wiki Page for Comments" => "Wiki Page for Comments",
// "Full path to gdaltindex" => "Full path to gdaltindex",
// "Full path to ogr2ogr" => "Full path to ogr2ogr",
// "Map Zone" => "Map Zone",
// "Generate User Map" => "Generate User Map",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Maximum mailbox size (messages, 0=unlimited)" => "Maximum mailbox size (messages, 0=unlimited)",
// "Maximum mail archive size (messages, 0=unlimited)" => "Maximum mail archive size (messages, 0=unlimited)",
// "Maximum sent box size (messages, 0=unlimited)" => "Maximum sent box size (messages, 0=unlimited)",
// "Meta Keywords" => "Meta Keywords",
// "Insert freetags in keyword list" => "Insert freetags in keyword list",
// "Use the thread title in Forum pages instead" => "Use the thread title in Forum pages instead",
// "Use the image title in Image gallery pages instead" => "Use the image title in Image gallery pages instead",
// "Meta Description" => "Meta Description",
// "Meta Author" => "Meta Author",
// "Geourl" => "Geourl",
// "geo.position" => "geo.position",
// "geo.region" => "geo.region",
// "geo.placename" => "geo.placename",
// "Robots" => "Robots",
// "meta robots" => "meta robots",
// "revisit after" => "revisit after",
// "Right &amp; left boxes" => "Right &amp; left boxes",
// "Administer modules" => "Administer modules",
// "Show Module Controls" => "Show Module Controls",
// "Users can Configure Modules" => "Users can Configure Modules",
// "Users can Shade Modules" => "Users can Shade Modules",
// "module decides" => "module decides",
// "Hide anonymous-only modules from registered users" => "Hide anonymous-only modules from registered users",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Lenght" => "Flash Lenght",
// "Flash Heigth" => "Flash Heigth",
// "Video Lenght" => "Video Lenght",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Allow Anonymous Poll Voting" => "Allow Anonymous Poll Voting",
// "Show categories" => "Show categories",
// "Show objects" => "Show objects",
// "Tikiwiki Profiles" => "Tikiwiki Profiles",
// "Configuration" => "Configuration",
// "Profile repositories" => "Profile repositories",
// "Profiles can be installed from multiple repositories. Enter one repository URL per line." => "Profiles can be installed from multiple repositories. Enter one repository URL per line.",
// "Profile repository status" => "Profile repository status",
// "Profile list" => "Profile list",
// "Repository" => "Repository",
// "Profile" => "Profile",
// "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS modules</strong> menu option, or" => "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS modules</strong> menu option, or",
// "Feed for articles" => "Feed for articles",
// "Feature is disabled." => "Feature is disabled.",
// "Enable now" => "Enable now",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Feed for maps" => "Feed for maps",
// "Map files" => "Map files",
// "Defaults" => "Defaults",
// "Default RDF version" => "Default RDF version",
// "Specification" => "Specification",
// "Documentation" => "Documentation",
// "Editor" => "Editor",
// "Webmaster" => "Webmaster",
// "Image Path" => "Image Path",
// "Caching time:" => "Caching time:",
// "seconds (0 = cache inactive)" => "seconds (0 = cache inactive)",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public." => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public.",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "Admin modules" => "Admin modules",
// "Expiration" => "Expiration",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Referer Search Highlighting" => "Referer Search Highlighting",
// "Parse the result (can be slow)" => "Parse the result (can be slow)",
// "Database Search using MySQL 'Full-Text' Feature" => "Database Search using MySQL 'Full-Text' Feature",
// "Activate MySQL Full-Text feature" => "Activate MySQL Full-Text feature",
// "Activate MySQL 'Full-Text' feature" => "Activate MySQL 'Full-Text' feature",
// "Performance issues" => "Performance issues",
// "Ignore individual object permissions" => "Ignore individual object permissions",
// "Database Independent Full Text Search or Tiki Search" => "Database Independent Full Text Search or Tiki Search",
// "This is activated by default if MySQL 'Full-Text' feature is not activated above" => "This is activated by default if MySQL 'Full-Text' feature is not activated above",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "Search features" => "Search features",
// "Settings for searching content" => "Settings for searching content",
// "Search refresh mode" => "Search refresh mode",
// "Search refresh rate" => "Search refresh rate",
// "0 for no refresh" => "0 for no refresh",
// "Minimum length of search word" => "Minimum length of search word",
// "Max. number of words containing a syllable" => "Max. number of words containing a syllable",
// "Max. age in hours of syllable search cache" => "Max. age in hours of syllable search cache",
// "LRU list purging rate" => "LRU list purging rate",
// "LRU list length" => "LRU list length",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "AutoLinks" => "AutoLinks",
// "Show quicktags over textareas (instead on left side)" => "Show quicktags over textareas (instead on left side)",
// "Default number of rows (wiki)" => "Default number of rows (wiki)",
// "Default number of rows (comments)" => "Default number of rows (comments)",
// "Default number of rows (forum)" => "Default number of rows (forum)",
// "Default number of rows (forum replies)" => "Default number of rows (forum replies)",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Trackers attachments preferences" => "Trackers attachments preferences",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Validate choice" => "Validate choice",
// "Trackers attachments" => "Trackers attachments",
// "Storage" => "Storage",
// "No records" => "No records",
// "Change all to db" => "Change all to db",
// "Change all to file" => "Change all to file",
// "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or",
// "Create a Tag for the Current Wiki" => "Create a Tag for the Current Wiki",
// "Tag name:" => "Tag name:",
// "Restore the Wiki" => "Restore the Wiki",
// "Remove a Tag" => "Remove a Tag",
// "Wiki Comments Settings" => "Wiki Comments Settings",
// "Default number of comments per page:" => "Default number of comments per page:",
// "List displayed by default" => "List displayed by default",
// "Wiki attachments:" => "Wiki attachments:",
// "Use database to store files:" => "Use database to store files:",
// "Use a directory to store files:" => "Use a directory to store files:",
// "Path:" => "Path:",
// "Manage attachments" => "Manage attachments",
// "Wiki Administration" => "Wiki Administration",
// "Forums are disabled." => "Forums are disabled.",
// "Forum for discussion:" => "Forum for discussion:",
// "No forums" => "No forums",
// "Wiki Link Format" => "Wiki Link Format",
// "Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>.",
// "complete" => "complete",
// "latin" => "latin",
// "english" => "english",
// "Page name display stripper: choose a character that will be used as a delimiter to strip a final part of the page name (only concerns display)" => "Page name display stripper: choose a character that will be used as a delimiter to strip a final part of the page name (only concerns display)",
// "Wiki Page Staging and Approval" => "Wiki Page Staging and Approval",
// "Use wiki page staging and approval:" => "Use wiki page staging and approval:",
// "Unique page name prefix to indicate staging copy:" => "Unique page name prefix to indicate staging copy:",
// "Hide page name prefix:" => "Hide page name prefix:",
// "Category for staging pages:" => "Category for staging pages:",
// "Category for approved pages:" => "Category for approved pages:",
// "Category for pages out of sync:" => "Category for pages out of sync:",
// "Force bounce of editing of approved pages to staging:" => "Force bounce of editing of approved pages to staging:",
// "Categorize approved pages with categories of staging copy on approval:" => "Categorize approved pages with categories of staging copy on approval:",
// "Replace freetags with that of staging pages on approval:" => "Replace freetags with that of staging pages on approval:",
// "Add new freetags of approved copy (into tags field) when editing staging pages:" => "Add new freetags of approved copy (into tags field) when editing staging pages:",
// "Delete staging pages at approval:" => "Delete staging pages at approval:",
// "If not in the group, edit is always redirected to the staging page edit:" => "If not in the group, edit is always redirected to the staging page edit:",
// "Wiki Page List Configuration" => "Wiki Page List Configuration",
// "Name length:" => "Name length:",
// "Comment length:" => "Comment length:",
// "Description length:" => "Description length:",
// "Categories path" => "Categories path",
// "Default sort order:" => "Default sort order:",
// "Wiki 3D Browser Configuration" => "Wiki 3D Browser Configuration",
// "Enable wiki 3D browser:" => "Enable wiki 3D browser:",
// "Load page on navigation:" => "Load page on navigation:",
// "Browser width:" => "Browser width:",
// "Browser height:" => "Browser height:",
// "Navigation depth:" => "Navigation depth:",
// "Node size:" => "Node size:",
// "Text size:" => "Text size:",
// "Spring (connection) size:" => "Spring (connection) size:",
// "Existing page node color:" => "Existing page node color:",
// "Missing page node color:" => "Missing page node color:",
// "Camera distance adjusted relative to nearest node:" => "Camera distance adjusted relative to nearest node:",
// "Camera distance:" => "Camera distance:",
// "Field of view:" => "Field of view:",
// "Feed animation interval (milisecs):" => "Feed animation interval (milisecs):",
// "Friction constant:" => "Friction constant:",
// "Elastic constant:" => "Elastic constant:",
// "Eletrostatic constant:" => "Eletrostatic constant:",
// "Node mass:" => "Node mass:",
// "Node charge:" => "Node charge:",
// "Sandbox:" => "Sandbox:",
// "Anonymous editors must input anti-bot code:" => "Anonymous editors must input anti-bot code:",
// "Last changes:" => "Last changes:",
// "Dump:" => "Dump:",
// "Export:" => "Export:",
// "Rating:" => "Rating:",
// "History:" => "History:",
// "View source:" => "View source:",
// "List pages:" => "List pages:",
// "Backlinks:" => "Backlinks:",
// "Similar:" => "Similar:",
// "Rankings:" => "Rankings:",
// "Undo:" => "Undo:",
// "Save Draft:" => "Save Draft:",
// "MultiPrint:" => "MultiPrint:",
// "Comments:" => "Comments:",
// "Spellchecking:" => "Spellchecking:",
// "Use templates:" => "Use templates:",
// "Warn on edit conflict:" => "Warn on edit conflict:",
// "Edit idle timeout:" => "Edit idle timeout:",
// "Pictures:" => "Pictures:",
// "Show page title:" => "Show page title:",
// "Show page ID:" => "Show page ID:",
// "Cache wiki pages (global):" => "Cache wiki pages (global):",
// "Individual cache:" => "Individual cache:",
// "Footnotes:" => "Footnotes:",
// "Users can lock pages (if perm):" => "Users can lock pages (if perm):",
// "Use WikiWords:" => "Use WikiWords:",
// "Accept dashes and underscores in WikiWords:" => "Accept dashes and underscores in WikiWords:",
// "Link plural WikiWords to their singular forms:" => "Link plural WikiWords to their singular forms:",
// "Use Wiki paragraph formatting:" => "Use Wiki paragraph formatting:",
// "But still create line breaks within paragraphs:" => "But still create line breaks within paragraphs:",
// "Automonospaced text:" => "Automonospaced text:",
// "Tables syntax:" => "Tables syntax:",
// "\\n for rows" => "\\n for rows",
// "Uses Slideshow:" => "Uses Slideshow:",
// "Open page as structure:" => "Open page as structure:",
// "Make structure from page:" => "Make structure from page:",
// "Categorize structure pages together:" => "Categorize structure pages together:",
// "Create webhelp from structure:" => "Create webhelp from structure:",
// "Use external link icons:" => "Use external link icons:",
// "User's Page:" => "User's Page:",
// "UserPage prefix:" => "UserPage prefix:",
// "Page creators are admin of their pages:" => "Page creators are admin of their pages:",
// "Import HTML:" => "Import HTML:",
// "Import Page:" => "Import Page:",
// "Protect email against spam:" => "Protect email against spam:",
// "When viewing a page, if it doesn't exist and has one like page, automatic redirection to this like page:" => "When viewing a page, if it doesn't exist and has one like page, automatic redirection to this like page:",
// "Show/hide heading icon displayed before the heading:" => "Show/hide heading icon displayed before the heading:",
// "Force and limit categorization to within subtree of:" => "Force and limit categorization to within subtree of:",
// "Print Page:" => "Print Page:",
// "Allow HTML:" => "Allow HTML:",
// "Show page version:" => "Show page version:",
// "Page navigation bar position (displayed when page break '...page...' are used):" => "Page navigation bar position (displayed when page break '...page...' are used):",
// "Wiki actions bar position (e.g. Save, Preview, Cancel, ...):" => "Wiki actions bar position (e.g. Save, Preview, Cancel, ...):",
// "Regex search and replace:" => "Regex search and replace:",
// "Edit section:" => "Edit section:",
// "Log bytes changes (+/-) in Action Logs (slows each page modifications)" => "Log bytes changes (+/-) in Action Logs (slows each page modifications)",
// "Maximum number of versions for history:" => "Maximum number of versions for history:",
// "Never delete versions younger than days:" => "Never delete versions younger than days:",
// "IP address displayed in history:" => "IP address displayed in history:",
// "Diff style:" => "Diff style:",
// "Only with last version" => "Only with last version",
// "Any 2 versions" => "Any 2 versions",
// "History only for data, description, comment change" => "History only for data, description, comment change",
// "Create watch for author on page creation:" => "Create watch for author on page creation:",
// "Enable watch events when I am the editor:" => "Enable watch events when I am the editor:",
// "Enable watches on comments:" => "Enable watches on comments:",
// "Watch minor:" => "Watch minor:",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Toolbar content" => "Toolbar content",
// "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>." => "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>.",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "More Links" => "More Links",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Administration features" => "Administration features",
// "Security" => "Security",
// "System" => "System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look &amp; feel" => "Look &amp; feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "Stats &amp; banners" => "Stats &amp; banners",
// "View tpl" => "View tpl",
// "Admin Groups Template" => "Admin Groups Template",
// "Report" => "Report",
// "Setting" => "Setting",
// "Please select some actions to view." => "Please select some actions to view.",
// "Group:" => "Group:",
// "Category:" => "Category:",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot:" => "Group Bar Plot:",
// "Accumulated Bar Plot:" => "Accumulated Bar Plot:",
// "Background color:" => "Background color:",
// "Legend background color:" => "Legend background color:",
// "Save graphs to image gallery:" => "Save graphs to image gallery:",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Edit Contribution" => "Edit Contribution",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "recorded" => "recorded",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Help on Banning System" => "Help on Banning System",
// "Admin banning tpl" => "Admin banning tpl",
// "Configure/Options" => "Configure/Options",
// "Subscription" => "Subscription",
// "Perso" => "Perso",
// "Custom Participants" => "Custom Participants",
// "Custom URL" => "Custom URL",
// "Custom Subscription List" => "Custom Subscription List",
// "Personal Calendar" => "Personal Calendar",
// "Start of day" => "Start of day",
// "End of day" => "End of day",
// "Custom foreground color" => "Custom foreground color",
// "Custom background color" => "Custom background color",
// "Delete events older than:" => "Delete events older than:",
// "Admin Categories tpl" => "Admin Categories tpl",
// "browse the category system" => "browse the category system",
// "Current Category ID:" => "Current Category ID:",
// "Edit permissions for this category" => "Edit permissions for this category",
// "Assign Permissions" => "Assign Permissions",
// "Perms inherited from closest parent if possible or from global perms" => "Perms inherited from closest parent if possible or from global perms",
// "Assign permissions automatically" => "Assign permissions automatically",
// "recommended for best performance" => "recommended for best performance",
// "Remove from this Category" => "Remove from this Category",
// "No records found." => "No records found.",
// "View template" => "View template",
// "Admin Charts Template" => "Admin Charts Template",
// "Users can vote for only one item from this chart per period" => "Users can vote for only one item from this chart per period",
// "Prevent users from voting for the same item more than once" => "Prevent users from voting for the same item more than once",
// "Chat Admin" => "Chat Admin",
// "Chat Admin tpl" => "Chat Admin tpl",
// "Half a second" => "Half a second",
// "Admin Content Templates" => "Admin Content Templates",
// "Admin Content Templates Template" => "Admin Content Templates Template",
// "Use in" => "Use in",
// "No features are configured to use templates." => "No features are configured to use templates.",
// "Admin Contributions" => "Admin Contributions",
// "Edit the contribution:" => "Edit the contribution:",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "Admin FortuneCookie tpl" => "Admin FortuneCookie tpl",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}.",
// "Help on Drawings" => "Help on Drawings",
// "Admin Drawings tpl" => "Admin Drawings tpl",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link.",
// "Admin DSN" => "Admin DSN",
// "tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
// "Use Admin DSN to define the database to be used by the SQL plugin." => "Use Admin DSN to define the database to be used by the SQL plugin.",
// "Admin External Wikis" => "Admin External Wikis",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "Create/Edit External Wiki" => "Create/Edit External Wiki",
// "Admin Forums Template" => "Admin Forums Template",
// "Create new forum" => "Create new forum",
// "Duplicate forum" => "Duplicate forum",
// "View this forum" => "View this forum",
// "Import forums" => "Import forums",
// "Only allow replies to the first message (flat forum)" => "Only allow replies to the first message (flat forum)",
// "Posts can be rated" => "Posts can be rated",
// "Display last post titles" => "Display last post titles",
// "no display" => "no display",
// "Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address",
// "Send mails even when the post is generated by inbound mail" => "Send mails even when the post is generated by inbound mail",
// "Append a reply link to outbound mails" => "Append a reply link to outbound mails",
// "Originating e-mail address for mails from this forum" => "Originating e-mail address for mails from this forum",
// "Max:" => "Max:",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "show threads preferences" => "show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate" => "Duplicate",
// "List Forums" => "List Forums",
// "..." => "...",
// "Admin Hotwords Template" => "Admin Hotwords Template",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Admin Html Pages" => "Admin Html Pages",
// "Admin Html Pages Template" => "Admin Html Pages Template",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "Tiki integrator" => "Tiki integrator",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature.",
// "Edit Repository:" => "Edit Repository:",
// "Create New Repository" => "Create New Repository",
// "List Repositories" => "List Repositories",
// "New Repository" => "New Repository",
// "View Repository" => "View Repository",
// "Human readable repository name" => "Human readable repository name",
// "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')",
// "File name of start page" => "File name of start page",
// "Start page" => "Start page",
// "CSS file to load when browse this repository" => "CSS file to load when browse this repository",
// "CSS file" => "CSS file",
// "Is repository visible to users" => "Is repository visible to users",
// "Can files from repository be cached" => "Can files from repository be cached",
// "Cacheable" => "Cacheable",
// "Are files from repository can be cached" => "Are files from repository can be cached",
// "Clear all cached pages of this repository" => "Clear all cached pages of this repository",
// "Clear cache" => "Clear cache",
// "Seconds count 'till cached page will be expired" => "Seconds count 'till cached page will be expired",
// "Cache expiration" => "Cache expiration",
// "Human readable text description of repository" => "Human readable text description of repository",
// "Available Repositories" => "Available Repositories",
// "CSS File" => "CSS File",
// "Edit rules" => "Edit rules",
// "Edit Rules for Repository:" => "Edit Rules for Repository:",
// "Configure Repositories" => "Configure Repositories",
// "Configure this Repository" => "Configure this Repository",
// "View this Repository" => "View this Repository",
// "Add new rule" => "Add new rule",
// "New Rule" => "New Rule",
// "view/hide copy rules dialog" => "view/hide copy rules dialog",
// "Copy Rules" => "Copy Rules",
// "Source repository" => "Source repository",
// "Copy" => "Copy",
// "According this order rules will be applied ('0' or empty = auto)" => "According this order rules will be applied ('0' or empty = auto)",
// "Rule order" => "Rule order",
// "Text to search for" => "Text to search for",
// "Text to replace" => "Text to replace",
// "Replace" => "Replace",
// "Is this regular expression or simple search/replacer" => "Is this regular expression or simple search/replacer",
// "Regex" => "Regex",
// "Is case sensitive (for simple replacer)" => "Is case sensitive (for simple replacer)",
// "Case sensitive" => "Case sensitive",
// "subset of chars: imsxeADSXUu, which is regex modifiers" => "subset of chars: imsxeADSXUu, which is regex modifiers",
// "Regex modifiers" => "Regex modifiers",
// "Human readable text description of rule" => "Human readable text description of rule",
// "Check to enable this rule" => "Check to enable this rule",
// "Enabled" => "Enabled",
// "Preview options" => "Preview options",
// "Apply all rules or just this to generate preview" => "Apply all rules or just this to generate preview",
// "Apply all rules" => "Apply all rules",
// "View source code after rules applied" => "View source code after rules applied",
// "Code preview" => "Code preview",
// "Generate HTML preview" => "Generate HTML preview",
// "HTML preview" => "HTML preview",
// "Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
// "Preview Results" => "Preview Results",
// "Rules List" => "Rules List",
// "Case" => "Case",
// "Admin Featured Links" => "Admin Featured Links",
// "Admin Featured Links Template" => "Admin Featured Links Template",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>.",
// "Mail-in accounts" => "Mail-in accounts",
// "Admin Webmail" => "Admin Webmail",
// "Admin Mailing Template" => "Admin Mailing Template",
// "Account" => "Account",
// "Add new Mail-in account" => "Add new Mail-in account",
// "Edit Mail-in account" => "Edit Mail-in account",
// "article-put" => "article-put",
// "Article Topic" => "Article Topic",
// "Article Type" => "Article Type",
// "Allow anonymous acces" => "Allow anonymous acces",
// "Allow attachments" => "Allow attachments",
// "Discard to the end from" => "Discard to the end from",
// "Check Mail-in accounts" => "Check Mail-in accounts",
// "Check automatically" => "Check automatically",
// "mn" => "mn",
// "Show Quick Urls" => "Show Quick Urls",
// "Hide Quick Urls" => "Hide Quick Urls",
// "For wiki page, use ((PageName))." => "For wiki page, use ((PageName)).",
// "Separate multiple sections with a comma ( , )." => "Separate multiple sections with a comma ( , ).",
// "Separate multiple permissions with a comma ( , )." => "Separate multiple permissions with a comma ( , ).",
// "Use Ctrl+Click to select multiple groups." => "Use Ctrl+Click to select multiple groups.",
// "Level" => "Level",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "separator" => "separator",
// "Choose" => "Choose",
// "Number of lines" => "Number of lines",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'." => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'.",
// "Admin Menu Builder" => "Admin Menu Builder",
// "Admin Menus Template" => "Admin Menus Template",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu." => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu.",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format: " => "To use a menu in a tiki format: ",
// "To use menu in a css/suckerfish format: " => "To use menu in a css/suckerfish format: ",
// "Path to the folder icon for close sections" => "Path to the folder icon for close sections",
// "Example:" => "Example:",
// "Provide also a folder icon for open sections with the same name with the letter 'o' before in the same directory (ex: folder.png and ofolder.png)" => "Provide also a folder icon for open sections with the same name with the letter 'o' before in the same directory (ex: folder.png and ofolder.png)",
// "Default:" => "Default:",
// "Admin Modules Template" => "Admin Modules Template",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme'). Separator between params:'&'. E.g. maxlen=15&nonums=y." => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme'). Separator between params:'&'. E.g. maxlen=15&nonums=y.",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups." => "setting will override your selection of specific groups.",
// "Visibility" => "Visibility",
// "Displayed now for all eligible users even with personal assigned modules" => "Displayed now for all eligible users even with personal assigned modules",
// "Displayed for the eligible users with no personal assigned modules" => "Displayed for the eligible users with no personal assigned modules",
// "Displayed now, can't be unassigned" => "Displayed now, can't be unassigned",
// "Not displayed until a user chooses it" => "Not displayed until a user chooses it",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// " or " => " or ",
// "to make sure users will notice any newly assigned modules." => "to make sure users will notice any newly assigned modules.",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site." => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site.",
// "Must be wiki parsed" => "Must be wiki parsed",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "phpLayersMenus" => "phpLayersMenus",
// "Use phplayermenu" => "Use phplayermenu",
// "Use Wiki Structure" => "Use Wiki Structure",
// "You can add several email addresses by separating them with commas." => "You can add several email addresses by separating them with commas.",
// "Add email:" => "Add email:",
// "Add user:" => "Add user:",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Admin Newsletters Template" => "Admin Newsletters Template",
// "Users can subscribe/unsubscribe to this list" => "Users can subscribe/unsubscribe to this list",
// "Users can subscribe any email address" => "Users can subscribe any email address",
// "Add unsubscribe instructions to each newsletter" => "Add unsubscribe instructions to each newsletter",
// "Validate email addresses" => "Validate email addresses",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Drafts" => "Drafts",
// "Send Newsletter" => "Send Newsletter",
// "EMail notifications" => "EMail notifications",
// "Admin Email Notifications" => "Admin Email Notifications",
// "Admin Notifications Template" => "Admin Notifications Template",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications." => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications.",
// "Alert" => "Alert",
// "Any wiki page is changed" => "Any wiki page is changed",
// "Any wiki page is changed, even minor changes" => "Any wiki page is changed, even minor changes",
// "A comment in a wiki page is posted or edited" => "A comment in a wiki page is posted or edited",
// "PHP error" => "PHP error",
// "Preload Admin Account" => "Preload Admin Account",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Admin Polls Template" => "Admin Polls Template",
// "Configure Polls" => "Configure Polls",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Add poll to pages" => "Add poll to pages",
// "Wiki pages" => "Wiki pages",
// "Use Ctrl+Click to select multiple pages." => "Use Ctrl+Click to select multiple pages.",
// "Lock the pages" => "Lock the pages",
// "Admin Quicktags" => "Admin Quicktags",
// "tiki admin quicktags template" => "tiki admin quicktags template",
// "Create/Edit QuickTags" => "Create/Edit QuickTags",
// "Quicktags category filter" => "Quicktags category filter",
// "Insert (use 'text' for figuring the selection)" => "Insert (use 'text' for figuring the selection)",
// "Path to the tag icon" => "Path to the tag icon",
// "Admin RSS Modules" => "Admin RSS Modules",
// "Admin RSSmodules Template" => "Admin RSSmodules Template",
// "Tips" => "Tips",
// "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed.",
// "show feed title" => "show feed title",
// "show publish date" => "show publish date",
// "RSS channels" => "RSS channels",
// "Show Title?" => "Show Title?",
// "Show Date?" => "Show Date?",
// "View feed" => "View feed",
// "Score System" => "Score System",
// "security admin" => "security admin",
// "security admin tpl" => "security admin tpl",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>.",
// "PHP settings" => "PHP settings",
// "PHP variable" => "PHP variable",
// "Risk Factor" => "Risk Factor",
// "Explanation" => "Explanation",
// "Tikiwiki settings" => "Tikiwiki settings",
// "Tiki variable" => "Tiki variable",
// "Security checks" => "Security checks",
// "Check all tiki files" => "Check all tiki files",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini.",
// "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database.",
// "File checks" => "File checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments." => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments.",
// "See end of table for detailed explanations." => "See end of table for detailed explanations.",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results?" => "What to do with these check results?",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"." => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\".",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content." => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content.",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information." => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information.",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes!" => "Inodes that are not files or directories are not part of tiki. Review these Inodes!",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod." => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod.",
// "Admin Shoutbox Words" => "Admin Shoutbox Words",
// "Admin Shoutbox Words Template" => "Admin Shoutbox Words Template",
// "Add Banned Word" => "Add Banned Word",
// "Are you sure you want to delete this word?" => "Are you sure you want to delete this word?",
// "Admin structures template" => "Admin structures template",
// "The structure" => "The structure",
// "has just been created." => "has just been created.",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict:" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict:",
// "The following pages have automatically been categorized with the same categories as the structure:" => "The following pages have automatically been categorized with the same categories as the structure:",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent:" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent:",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent:" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent:",
// "Structure ID" => "Structure ID",
// "Edit structure" => "Edit structure",
// "PDF" => "PDF",
// "Create WebHelp" => "Create WebHelp",
// "View WebHelp" => "View WebHelp",
// "Alias" => "Alias",
// "Note" => "Note",
// "Create New Structure" => "Create New Structure",
// "Wiki textaera" => "Wiki textaera",
// "Rate" => "Rate",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value." => "For a rate, you can give the maximum value.",
// "administer surveys template" => "administer surveys template",
// "Create New Survey" => "Create New Survey",
// "system admin" => "system admin",
// "system admin tpl" => "system admin tpl",
// "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)." => "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed).",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Empty" => "Empty",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save:" => "Directories to save:",
// "Templates compiler" => "Templates compiler",
// "Compile" => "Compile",
// "Advanced feature" => "Advanced feature",
// "Fix UTF-8 Errors in Tables" => "Fix UTF-8 Errors in Tables",
// "Warning: Make a backup of your Database before using this function!" => "Warning: Make a backup of your Database before using this function!",
// "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!",
// "This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "This function converts ISO-8859-1 encoded strings in your tables to UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "Table" => "Table",
// "Field" => "Field",
// "Investigate" => "Investigate",
// "Fix it" => "Fix it",
// "Admin Topics Template" => "Admin Topics Template",
// "Remove with articles" => "Remove with articles",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "Active Permissions" => "Active Permissions",
// "admin Tracker fields tpl" => "admin Tracker fields tpl",
// "New tracker field" => "New tracker field",
// "Select list items that will be displayed:" => "Select list items that will be displayed:",
// "Multilingual content" => "Multilingual content",
// "Column is searchable?" => "Column is searchable?",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "Field is hidden?" => "Field is hidden?",
// "not hidden" => "not hidden",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by:" => "Visible by:",
// "Editable by:" => "Editable by:",
// "Field is mandatory?" => "Field is mandatory?",
// "Error message:" => "Error message:",
// "Searchable" => "Searchable",
// "Hidden" => "Hidden",
// "Mandatory" => "Mandatory",
// "Import/Export Trackers Fields" => "Import/Export Trackers Fields",
// "Export fieldId also" => "Export fieldId also",
// "Admin Trackers tpl" => "Admin Trackers tpl",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "Edit Tracker" => "Edit Tracker",
// "Import/Export" => "Import/Export",
// "Create Trackers" => "Create Trackers",
// "Duplicate Tracker" => "Duplicate Tracker",
// "with" => "with",
// "Description text is tiki-parsed:" => "Description text is tiki-parsed:",
// "Use Ratings:" => "Use Ratings:",
// "with values" => "with values",
// "and display rating results in listing?" => "and display rating results in listing?",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL",
// "Show status" => "Show status",
// "Default status displayed in list mode" => "Default status displayed in list mode",
// "Show status to tracker admin only" => "Show status to tracker admin only",
// "Send copies of all activity in this tracker to this e-mail address" => "Send copies of all activity in this tracker to this e-mail address",
// "Use simplified e-mail format" => "Use simplified e-mail format",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "New items are created with status" => "New items are created with status",
// "Authoritative status for modified items" => "Authoritative status for modified items",
// "No change" => "No change",
// "Item creator can modify his items?" => "Item creator can modify his items?",
// "The tracker needs a user field with the option 1" => "The tracker needs a user field with the option 1",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Member of the default group of creator can modify items?" => "Member of the default group of creator can modify items?",
// "The tracker needs a group field with the option 1" => "The tracker needs a group field with the option 1",
// "Format if not the default short one:" => "Format if not the default short one:",
// "Show creation date when viewing tracker item?" => "Show creation date when viewing tracker item?",
// "Show lastModif date when viewing tracker item?" => "Show lastModif date when viewing tracker item?",
// "What field is used for default sort?" => "What field is used for default sort?",
// "LastModif" => "LastModif",
// "ItemId" => "ItemId",
// "What is default sort order in list?" => "What is default sort order in list?",
// "Tracker items allow ratings?" => "Tracker items allow ratings?",
// "and display comments in listing?" => "and display comments in listing?",
// "and display attachments in listing?" => "and display attachments in listing?",
// "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)",
// "Filetype" => "Filetype",
// "LongDesc" => "LongDesc",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "After:" => "After:",
// "Before:" => "Before:",
// "Do not show empty fields in item view?" => "Do not show empty fields in item view?",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items?" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items?",
// "Import/export trackers" => "Import/export trackers",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Separator" => "Separator",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse" => "Parse",
// "Info" => "Info",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "or list of fields separated by comma" => "or list of fields separated by comma",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Edit group" => "Edit group",
// "Members" => "Members",
// "User Choice" => "User Choice",
// "Only directly included" => "Only directly included",
// "will have all the permissions of the included groups" => "will have all the permissions of the included groups",
// "Group Homepage" => "Group Homepage",
// "Use wiki page name or full URL" => "Use wiki page name or full URL",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)." => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>).",
// "Enable now." => "Enable now.",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker ..." => "choose a group tracker ...",
// "choose a field ..." => "choose a field ...",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker ..." => "choose a users tracker ...",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Group tracker item not found" => "Group tracker item not found",
// "Create item" => "Create item",
// "Members List" => "Members List",
// "Remove from Group" => "Remove from Group",
// "users in group" => "users in group",
// "Download CSV export" => "Download CSV export",
// "Charset encoding:" => "Charset encoding:",
// "Assign users to group:" => "Assign users to group:",
// "User must already exist." => "User must already exist.",
// "To create users and assign them to groups, got to admin->users" => "To create users and assign them to groups, got to admin->users",
// "CSV File" => "CSV File",
// "Admin Users Template" => "Admin Users Template",
// "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions",
// "Updated users" => "Updated users",
// "Edit user" => "Edit user",
// "More Criteria" => "More Criteria",
// "Group (direct)" => "Group (direct)",
// "Change user preferences" => "Change user preferences",
// "Edit Account Settings" => "Edit Account Settings",
// "Need to validate email" => "Need to validate email",
// "Assign Group" => "Assign Group",
// "Edit Included Group" => "Edit Included Group",
// "Remove Users and their Userpages" => "Remove Users and their Userpages",
// "Manage Group Assignments" => "Manage Group Assignments",
// "Set Default Groups" => "Set Default Groups",
// "Assign selected to" => "Assign selected to",
// "Remove selected from" => "Remove selected from",
// "the following groups:" => "the following groups:",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "Assign to Groups" => "Assign to Groups",
// "Use the email as username" => "Use the email as username",
// "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master",
// "Warning: changing the username will require the user to change his password" => "Warning: changing the username will require the user to change his password",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth." => "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth.",
// "User must change his password at first login" => "User must change his password at first login",
// "Registration" => "Registration",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "Don't overwrite" => "Don't overwrite",
// "Overwrite groups:" => "Overwrite groups:",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "Loading..." => "Loading...",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Admin Article Types" => "Admin Article Types",
// "Article Types tpl" => "Article Types tpl",
// "show help" => "show help",
// "Shows up in the drop down list of article types" => "Shows up in the drop down list of article types",
// "Allow ratings by the author" => "Allow ratings by the author",
// "Show before publish date" => "Show before publish date",
// "non-admins can view before the publish date" => "non-admins can view before the publish date",
// "Show after expire date" => "Show after expire date",
// "non-admins can view after the expire date" => "non-admins can view after the expire date",
// "Heading only" => "Heading only",
// "No article body, heading only" => "No article body, heading only",
// "Allow comments for this type" => "Allow comments for this type",
// "Comment Can Rate Article" => "Comment Can Rate Article",
// "Allow comments to include a rating value" => "Allow comments to include a rating value",
// "Show image" => "Show image",
// "Show topic or own image" => "Show topic or own image",
// "Show avatar" => "Show avatar",
// "Show author's avatar" => "Show author's avatar",
// "Show author" => "Show author",
// "Show author name" => "Show author name",
// "Show publish date" => "Show publish date",
// "Show expire date" => "Show expire date",
// "Show reads" => "Show reads",
// "Show the number of times the article was read" => "Show the number of times the article was read",
// "Show size" => "Show size",
// "Show the size of the article" => "Show the size of the article",
// "Show topline" => "Show topline",
// "Show a small title over the title" => "Show a small title over the title",
// "Show subtitle" => "Show subtitle",
// "Show the subtitle" => "Show the subtitle",
// "Show source" => "Show source",
// "Show link to source after article body" => "Show link to source after article body",
// "Show Image Caption" => "Show Image Caption",
// "Show a legend under the image" => "Show a legend under the image",
// "Show Language" => "Show Language",
// "Show the language" => "Show the language",
// "Creator can edit" => "Creator can edit",
// "The person who submits an article of this type can edit it" => "The person who submits an article of this type can edit it",
// "Delete this type" => "Delete this type",
// "List of types" => "List of types",
// "Show lang" => "Show lang",
// "Classified" => "Classified",
// "Create a new type" => "Create a new type",
// "Help for Assigning Permissions" => "Help for Assigning Permissions",
// "Edit Article Tpl" => "Edit Article Tpl",
// "level configuration" => "level configuration",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Assign User {\$assign_user} to Groups" => "Assign User {\$assign_user} to Groups",
// "Default Group" => "Default Group",
// "Assign Perms to this Group" => "Assign Perms to this Group",
// "Assign User to Group" => "Assign User to Group",
// "Directory batch upload" => "Directory batch upload",
// "available images" => "available images",
// "width" => "width",
// "height" => "height",
// "Remove File Extension from Image Name" => "Remove File Extension from Image Name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "convert the last sub directory to a sub gallery" => "convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Select a Gallery" => "Select a Gallery",
// "Browse file gallery" => "Browse file gallery",
// "Please do not use this feature to upload data into the database." => "Please do not use this feature to upload data into the database.",
// "available files" => "available files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "The TikiWiki community" => "The TikiWiki community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "Admin the Category System" => "Admin the Category System",
// "Admin Category" => "Admin Category",
// "Watch Only This Category" => "Watch Only This Category",
// "Watch This Category and Their Descendants" => "Watch This Category and Their Descendants",
// "Stop Watching Only This Category" => "Stop Watching Only This Category",
// "Stop Watching This Category and Their Descendants" => "Stop Watching This Category and Their Descendants",
// "Browse in" => "Browse in",
// "Trackers Items" => "Trackers Items",
// "Sheets" => "Sheets",
// "in the current category - and its subcategories: " => "in the current category - and its subcategories: ",
// "Hide subcategories objects" => "Hide subcategories objects",
// "Show subcategories objects" => "Show subcategories objects",
// "Upper level" => "Upper level",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Sort:" => "Sort:",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "results found" => "results found",
// "List Galleries" => "List Galleries",
// "Directory batch" => "Directory batch",
// "All Images" => "All Images",
// "Monitor this Gallery" => "Monitor this Gallery",
// "Stop Monitoring this Gallery" => "Stop Monitoring this Gallery",
// "subgallery" => "subgallery",
// "Subgallery" => "Subgallery",
// "Hit" => "Hit",
// "Details" => "Details",
// "Slideshow Forward" => "Slideshow Forward",
// "Cyclic" => "Cyclic",
// "Direction" => "Direction",
// "Click to zoom" => "Click to zoom",
// "Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/decimal degrees)",
// "Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/decimal degrees)",
// "You can include the image in an HTML page using one of these lines" => "You can include the image in an HTML page using one of these lines",
// "You can include the image in a tiki page using one of these lines" => "You can include the image in a tiki page using one of these lines",
// "Add Event" => "Add Event",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Visible Calendars" => "Visible Calendars",
// "Zoom" => "Zoom",
// "Change Focus" => "Change Focus",
// "Calendar Item" => "Calendar Item",
// "Config Calendars" => "Config Calendars",
// "Edit Calendar" => "Edit Calendar",
// "View event" => "View event",
// "Edit event" => "Edit event",
// "New event" => "New event",
// "New Calendar Item" => "New Calendar Item",
// "Date and time of end" => "Date and time of end",
// "or new" => "or new",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in:" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in:",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"." => "If no role is provided, default role will be \"Chair participant\".",
// "Duplicate to" => "Duplicate to",
// "Calendar import" => "Calendar import",
// "Calendar has been updated" => "Calendar has been updated",
// "Focus:" => "Focus:",
// "Assign permissions to category" => "Assign permissions to category",
// "Categories checking is not done in the database search." => "Categories checking is not done in the database search.",
// "Current permissions for this category" => "Current permissions for this category",
// "Remove from this Category Only" => "Remove from this Category Only",
// "Remove from this Category &amp; all its Children" => "Remove from this Category &amp; all its Children",
// "Assign permissions" => "Assign permissions",
// "this category &amp; all its children" => "this category &amp; all its children",
// "this category only" => "this category only",
// "Assigning permissions for <b>all children</b> is recommended for best performance." => "Assigning permissions for <b>all children</b> is recommended for best performance.",
// "Click here to send us an email" => "Click here to send us an email",
// "Group View" => "Group View",
// "Publish this contact to groups" => "Publish this contact to groups",
// "You can browse the generated WebHelp here" => "You can browse the generated WebHelp here",
// "Top page" => "Top page",
// "You cannot add sites until Directory Categories are setup." => "You cannot add sites until Directory Categories are setup.",
// "Please contact the Site Administrator" => "Please contact the Site Administrator",
// "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>." => "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>.",
// "The following site was added, but may require validation by the admin before appearing on the lists." => "The following site was added, but may require validation by the admin before appearing on the lists.",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "URL:" => "URL:",
// "Categories:" => "Categories:",
// "Use Ctrl+Click to select multiple categories." => "Use Ctrl+Click to select multiple categories.",
// "Admin Directory tpl" => "Admin Directory tpl",
// "Edit Tpl" => "Edit Tpl",
// "Admin Directory Categories tpl" => "Admin Directory Categories tpl",
// "Admin Directory Related " => "Admin Directory Related ",
// "directory admin related tpl" => "directory admin related tpl",
// "Admin Directory Sites" => "Admin Directory Sites",
// "Admin Directory Sites tpl" => "Admin Directory Sites tpl",
// "Perform action with selected:" => "Perform action with selected:",
// "Add a Category" => "Add a Category",
// "No records." => "No records.",
// "Validate Sites" => "Validate Sites",
// "directory validate sites tpl" => "directory validate sites tpl",
// "Edit Article" => "Edit Article",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Topline" => "Topline",
// "Subtitle" => "Subtitle",
// "Image caption" => "Image caption",
// "Expiration Date" => "Expiration Date",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie URL" => "Movie URL",
// "Movie Size" => "Movie Size",
// "Pixels" => "Pixels",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "Remove Zones (you lose entered info for the banner)" => "Remove Zones (you lose entered info for the banner)",
// "Create Blog" => "Create Blog",
// "Edit Blog Tpl" => "Edit Blog Tpl",
// "A category is mandatory" => "A category is mandatory",
// "Show user avatar" => "Show user avatar",
// "For more information, please see <a href=\"{\$prefs.helpurl}Wiki Page Editor\">Wiki Page Editor</a>" => "For more information, please see <a href=\"{\$prefs.helpurl}Wiki Page Editor\">Wiki Page Editor</a>",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines." => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines.",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line." => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line.",
// "Quicktag" => "Quicktag",
// "Wiki Syntax" => "Wiki Syntax",
// "Format" => "Format",
// "Bold text" => "Bold text",
// "underscores" => "underscores",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Centered text" => "Centered text",
// "colons" => "colons",
// "Underlined text" => "Underlined text",
// "equals" => "equals",
// "Text box" => "Text box",
// "One carat" => "One carat",
// "Will display using the indicated HTML color or color name" => "Will display using the indicated HTML color or color name",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus(useful in list to continue at the same level)" => "Creates an indentation for each plus(useful in list to continue at the same level)",
// "Headings" => "Headings",
// "make headings" => "make headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "Autonumbered Headings" => "Autonumbered Headings",
// "make autonumbered headings" => "make autonumbered headings",
// "row" => "row",
// "Horizontal rule" => "Horizontal rule",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)." => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox).",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "imalign, height, width, desc, link, rel, title, usemap, class and align are optional" => "imalign, height, width, desc, link, rel, title, usemap, class and align are optional",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "to separate pages" => "to separate pages",
// "Wiki File Attachments" => "Wiki File Attachments",
// "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated.",
// "Dynamic variables" => "Dynamic variables",
// "Inserts an editable variable" => "Inserts an editable variable",
// "Prevents wiki parsing of the enclosed data." => "Prevents wiki parsing of the enclosed data.",
// "Preformated sections" => "Preformated sections",
// "\"~pp~ data ~/pp~\" Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  \"~pre~ data ~/pre~\" also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text." => "\"~pp~ data ~/pp~\" Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  \"~pre~ data ~/pre~\" also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text.",
// "\"~tc~ Tiki Comment ~/tc~\" makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  \"~hc~ HTML Comment ~/hc~\" makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar." => "\"~tc~ Tiki Comment ~/tc~\" makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  \"~hc~ HTML Comment ~/hc~\" makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar.",
// "Square Brackets" => "Square Brackets",
// "Use [[foo] to show [foo]." => "Use [[foo] to show [foo].",
// "Block Preformatting" => "Block Preformatting",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that.",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew." => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew.",
// "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Plugins" => "Plugins",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt;" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt;",
// "Plugin" => "Plugin",
// "table new" => "table new",
// "wiki link'" => "wiki link'",
// "dynamic variable" => "dynamic variable",
// "New wms Metadata" => "New wms Metadata",
// "New Class" => "New Class",
// "New Projection" => "New Projection",
// "New Query" => "New Query",
// "New Scalebar" => "New Scalebar",
// "New Layer" => "New Layer",
// "New Label" => "New Label",
// "New Reference" => "New Reference",
// "New Legend" => "New Legend",
// "New Web" => "New Web",
// "New Outputformat" => "New Outputformat",
// "New Mapfile" => "New Mapfile",
// "Add another image" => "Add another image",
// "Leave Fullscreen Edit" => "Leave Fullscreen Edit",
// "Fullscreen Edit" => "Fullscreen Edit",
// "Browse Images" => "Browse Images",
// "Upload from disk to change the image:" => "Upload from disk to change the image:",
// "Save and Go Next" => "Save and Go Next",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Admin Quizzes tpl" => "Admin Quizzes tpl",
// "Immediate feedback" => "Immediate feedback",
// "Show correct answers" => "Show correct answers",
// "Shuffle questions" => "Shuffle questions",
// "Shuffle answers" => "Shuffle answers",
// "Passing Percentage" => "Passing Percentage",
// "%" => "%",
// "Edit Quiz Questions" => "Edit Quiz Questions",
// "Edit Quiz Questions Tpl" => "Edit Quiz Questions Tpl",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character.",
// "Input" => "Input",
// "Modify Structure" => "Modify Structure",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one." => "The page already exists. The page that has been added to the structure is the existing one.",
// "The following pages added have automatically been categorized with the same categories as the structure:" => "The following pages added have automatically been categorized with the same categories as the structure:",
// "Structure Layout" => "Structure Layout",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Promote" => "Promote",
// "Demote" => "Demote",
// "Current Node" => "Current Node",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Add pages to current node" => "Add pages to current node",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "Help on Articles" => "Help on Articles",
// "Edit Submissions Tpl" => "Edit Submissions Tpl",
// "<b>*</b>=optional" => "<b>*</b>=optional",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "EditTemplates" => "EditTemplates",
// "EditTemplates tpl" => "EditTemplates tpl",
// "Save Only in the Theme:" => "Save Only in the Theme:",
// "Delete the copy in the theme:" => "Delete the copy in the theme:",
// "Edit a topic" => "Edit a topic",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "Translate:" => "Translate:",
// "Edit Translations" => "Edit Translations",
// "Edit Translations Template" => "Edit Translations Template",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "The object is already in the set of translations" => "The object is already in the set of translations",
// "Language of newly translated page" => "Language of newly translated page",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "detach" => "detach",
// "Change language for this page" => "Change language for this page",
// "Select from available options..." => "Select from available options...",
// "Change Language" => "Change Language",
// "No language is assigned to this page." => "No language is assigned to this page.",
// "Please select a language before performing translation." => "Please select a language before performing translation.",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Edit Section:" => "Edit Section:",
// "View object" => "View object",
// "Preview your changes." => "Preview your changes.",
// "Save the page." => "Save the page.",
// "Cancel the edit, you will lose your changes." => "Cancel the edit, you will lose your changes.",
// "Your edit session will expire in" => "Your edit session will expire in",
// "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits." => "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits.",
// "Update '{\$page}' based on '{\$source_page}'" => "Update '{\$page}' based on '{\$source_page}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval." => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval.",
// "This is a new staging page that has not been approved before." => "This is a new staging page that has not been approved before.",
// "The current staging copy may contain changes that have yet to be approved." => "The current staging copy may contain changes that have yet to be approved.",
// "View changes since last approval." => "View changes since last approval.",
// "You are editing the approved copy of this page." => "You are editing the approved copy of this page.",
// "There are currently changes in the staging copy that have yet to be approved." => "There are currently changes in the staging copy that have yet to be approved.",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead?" => "instead?",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Perhaps you are looking for:" => "Perhaps you are looking for:",
// "This edit session will expire in {\$edittimeout} minutes" => "This edit session will expire in {\$edittimeout} minutes",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer." => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer.",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Use rating" => "Use rating",
// "disable" => "disable",
// "There is no available poll template." => "There is no available poll template.",
// "You should ask an admin to create them." => "You should ask an admin to create them.",
// "or use" => "or use",
// "an existing poll" => "an existing poll",
// "Regex search " => "Regex search ",
// "Replace to" => "Replace to",
// "Case Insensitivity" => "Case Insensitivity",
// "Translation request" => "Translation request",
// "Send urgent translation request." => "Send urgent translation request.",
// "Import HTML" => "Import HTML",
// "Try to convert HTML to wiki" => "Try to convert HTML to wiki",
// "Lock this page" => "Lock this page",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Autodetect" => "Autodetect",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "File Galleries tpl" => "File Galleries tpl",
// "Be carefull to set the right permissions on the files you link to" => "Be carefull to set the right permissions on the files you link to",
// "Create New File Gallery" => "Create New File Gallery",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>." => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>.",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred." => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred.",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into?" => "Which Forum Do You Wish to Import this Into?",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "Configure Forum" => "Configure Forum",
// "No records to display" => "No records to display",
// "Perfom action with checked:" => "Perfom action with checked:",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag." => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag.",
// "Until then, they cannot be translated." => "Until then, they cannot be translated.",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "friends tpl" => "friends tpl",
// "Pending requests" => "Pending requests",
// "Request Time" => "Request Time",
// "Refuse" => "Refuse",
// "Waiting requests" => "Waiting requests",
// "Cancel friendship request" => "Cancel friendship request",
// "Your friends" => "Your friends",
// "break friendship" => "break friendship",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Expiration Time" => "Expiration Time",
// "Years" => "Years",
// "Months" => "Months",
// "Minutes" => "Minutes",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
// "Process Graph for" => "Process Graph for",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed.",
// "Ended" => "Ended",
// "Not Defined" => "Not Defined",
// "Not Interactive" => "Not Interactive",
// "Not Ended" => "Not Ended",
// "Executed" => "Executed",
// "Pop-up" => "Pop-up",
// "erase" => "erase",
// "Galaxia Admin Processes" => "Galaxia Admin Processes",
// "Galaxia Admin Processes tpl" => "Galaxia Admin Processes tpl",
// "Galaxia Monitor Activities" => "Galaxia Monitor Activities",
// "Galaxia Monitor Activities tpl" => "Galaxia Monitor Activities tpl",
// "Enter the name of this instance" => "Enter the name of this instance",
// "The name is not valid. Please, enter the name again" => "The name is not valid. Please, enter the name again",
// "Galaxia Monitor Instances" => "Galaxia Monitor Instances",
// "Galaxia Monitor Instances tpl" => "Galaxia Monitor Instances tpl",
// "Not ended" => "Not ended",
// "Galaxia Monitor Processes" => "Galaxia Monitor Processes",
// "Galaxia Monitor Processes tpl" => "Galaxia Monitor Processes tpl",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "My activities" => "My activities",
// "Current Activity" => "Current Activity",
// "Assigned To" => "Assigned To",
// "No activities found" => "No activities found",
// "My instances" => "My instances",
// "No instances found" => "No instances found",
// "Galaxia User Activities" => "Galaxia User Activities",
// "Galaxia User Activities tpl" => "Galaxia User Activities tpl",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "Galaxia User Instances" => "Galaxia User Instances",
// "Galaxia User Instances tpl" => "Galaxia User Instances tpl",
// "Not defined" => "Not defined",
// "Galaxia User Processes" => "Galaxia User Processes",
// "Galaxia User Processes tpl" => "Galaxia User Processes tpl",
// "galleries tpl" => "galleries tpl",
// "Geographic" => "Geographic",
// "Fields to show during browsing the gallery" => "Fields to show during browsing the gallery",
// "Creation Date" => "Creation Date",
// "XY-Size" => "XY-Size",
// "Gallery Image" => "Gallery Image",
// "Global default" => "Global default",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "Original image is default scale" => "Original image is default scale",
// "Add scaled images with bounding box of square size" => "Add scaled images with bounding box of square size",
// "Choose a filter" => "Choose a filter",
// "Make Map" => "Make Map",
// "Save clicked point" => "Save clicked point",
// "Save current view as default" => "Save current view as default",
// "Reset view to site-wide default" => "Reset view to site-wide default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal" => "Horizontal",
// "Vertical" => "Vertical",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// " To " => " To ",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "ImportingPagesPhpWikiPageAdmin" => "ImportingPagesPhpWikiPageAdmin",
// "tiki-import_phpwiki tpl" => "tiki-import_phpwiki tpl",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "body" => "body",
// "Tiki installer" => "Tiki installer",
// "Success" => "Success",
// "MultiTiki setup" => "MultiTiki setup",
// "To add a new virtual host" => "To add a new virtual host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "Please enter your database connection information" => "Please enter your database connection information",
// "Database type" => "Database type",
// "Select the type of database to use with Tiki." => "Select the type of database to use with Tiki.",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension." => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension.",
// "Host:" => "Host:",
// "Enter the hostname or IP for your database. Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Enter the hostname or IP for your database. Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "For SQLite, enter the path and filename to your database file" => "For SQLite, enter the path and filename to your database file",
// "Database name" => "Database name",
// "Enter the name of the database that Tiki will use." => "Enter the name of the database that Tiki will use.",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your\nhosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your\nhosting provider.  Normally Tiki tables won't conflict with other product names",
// "For Oracle" => "For Oracle",
// "Enter your TNS Name here and leave Host empty" => "Enter your TNS Name here and leave Host empty",
// "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field" => "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field",
// "Database User" => "Database User",
// "Enter the database user with administrator permission for the Database" => "Enter the database user with administrator permission for the Database",
// "Enter the password for the database user" => "Enter the password for the database user",
// "Connect" => "Connect",
// "Welcome to the installation{if \$tikidb_created} &amp; upgrade{/if} script!" => "Welcome to the installation{if \$tikidb_created} &amp; upgrade{/if} script!",
// "Reinstall database." => "Reinstall database.",
// "This will destroy your current database" => "This will destroy your current database",
// "Install" => "Install",
// "Create a new database (clean install) with profile" => "Create a new database (clean install) with profile",
// "No profiles available." => "No profiles available.",
// "See the documentation for <a target=\"_blank\" href=\"http://doc.tikiwiki.org/Profiles\" class=\"link\" title=\"{tr}Description of available profiles." => "See the documentation for <a target=\"_blank\" href=\"http://doc.tikiwiki.org/Profiles\" class=\"link\" title=\"{tr}Description of available profiles.",
// "Upgrade" => "Upgrade",
// "Backup your database with mysqldump, phpmyadmin, or other before upgrading." => "Backup your database with mysqldump, phpmyadmin, or other before upgrading.",
// "Update database using script" => "Update database using script",
// "No scripts available." => "No scripts available.",
// "To upgrade from" => "To upgrade from",
// "Use this script" => "Use this script",
// "Then rerun the installer using tiki_1.9to2.0." => "Then rerun the installer using tiki_1.9to2.0.",
// "See <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Upgrade+1.7+to+1.8\">Tiki database 1.7.x to 1.8x instructions" => "See <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Upgrade+1.7+to+1.8\">Tiki database 1.7.x to 1.8x instructions",
// "For information about <strong>tiki-secdb_*.sql</strong> files, please see <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Security+Admin\">http://doc.tikiwiki.org/Security+Admin" => "For information about <strong>tiki-secdb_*.sql</strong> files, please see <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Security+Admin\">http://doc.tikiwiki.org/Security+Admin",
// "Other Options" => "Other Options",
// "Do nothing and enter Tiki" => "Do nothing and enter Tiki",
// "Reset database connection settings" => "Reset database connection settings",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Installation" => "Installation",
// "Your database has been configured and Tikiwiki is ready to run!" => "Your database has been configured and Tikiwiki is ready to run!",
// "If this is your first install, your admin password is <strong>admin</strong>." => "If this is your first install, your admin password is <strong>admin</strong>.",
// "You can now log in into Tikiwiki as user <strong>admin</strong> and start configuring the application." => "You can now log in into Tikiwiki as user <strong>admin</strong> and start configuring the application.",
// "operations executed successfully" => "operations executed successfully",
// "SQL queries" => "SQL queries",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages." => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages.",
// "Important Information" => "Important Information",
// "Please read the following notes before entering Tikiwiki." => "Please read the following notes before entering Tikiwiki.",
// "Memory" => "Memory",
// "TikiWiki requires <strong>at least</strong> 16MB of PHP memory for script execution. Use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 16M) and restart your webserver" => "TikiWiki requires <strong>at least</strong> 16MB of PHP memory for script execution. Use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 16M) and restart your webserver",
// "Allocating too little memory will cause TikiWiki to display blank pages" => "Allocating too little memory will cause TikiWiki to display blank pages",
// "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu." => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu.",
// "Entering TikiWiki" => "Entering TikiWiki",
// "Change the administrator password" => "Change the administrator password",
// "Continue in installer" => "Continue in installer",
// "Go back and run another install/upgrade script" => "Go back and run another install/upgrade script",
// "Do not use your browser's Back button." => "Do not use your browser's Back button.",
// "Clear cached version and refresh cache" => "Clear cached version and refresh cache",
// "configure rules" => "configure rules",
// "Edit Repository" => "Edit Repository",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "weeks" => "weeks",
// "v" => "v",
// "List Articles Tpl" => "List Articles Tpl",
// "ExpireDate" => "ExpireDate",
// "Admin Banners" => "Admin Banners",
// "Admin Banners tpl" => "Admin Banners tpl",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone.",
// "Admin Cache" => "Admin Cache",
// "Admin Cache tpl" => "Admin Cache tpl",
// "The cache is used by:" => "The cache is used by:",
// "Orphan" => "Orphan",
// "Help on Dynamic Content" => "Help on Dynamic Content",
// "Admin DynamicContent tpl" => "Admin DynamicContent tpl",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block.",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block." => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block.",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "Future vers" => "Future vers",
// "List FAQs Tpl" => "List FAQs Tpl",
// "Create new FAQ" => "Create new FAQ",
// "SlideShow" => "SlideShow",
// "Your comment" => "Your comment",
// "optional" => "optional",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "games tpl" => "games tpl",
// "/" => "/",
// "Flash binary (.swf or .dcr)" => "Flash binary (.swf or .dcr)",
// "List Posts Tpl" => "List Posts Tpl",
// "List Quizzes Tpl" => "List Quizzes Tpl",
// "Edit Quiz Stats Tpl" => "Edit Quiz Stats Tpl",
// "Take Survey" => "Take Survey",
// "List Trackers Tpl" => "List Trackers Tpl",
// "users registered" => "users registered",
// "Distance (km)" => "Distance (km)",
// "List Movies" => "List Movies",
// "Choose a movie" => "Choose a movie",
// "Last modification" => "Last modification",
// "Page creator" => "Page creator",
// "Last ver." => "Last ver.",
// "Status of the page" => "Status of the page",
// "Vers." => "Vers.",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl." => "Backl.",
// "Page size" => "Page size",
// "Lang." => "Lang.",
// "Perform action with checked" => "Perform action with checked",
// "Admin Live Support tpl" => "Admin Live Support tpl",
// "offline" => "offline",
// "operator" => "operator",
// "For security purposes we must periodically validate your email address to allow continued access to this site." => "For security purposes we must periodically validate your email address to allow continued access to this site.",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site." => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site.",
// "Thank you" => "Thank you",
// "Mail-in feature" => "Mail-in feature",
// "User Calendar" => "User Calendar",
// "User Calendar Doc tpl" => "User Calendar Doc tpl",
// "Add event" => "Add event",
// "User Calendar Doc" => "User Calendar Doc",
// "User Calendar Preferences Doc tpl" => "User Calendar Preferences Doc tpl",
// "Tikiwiki Mods" => "Tikiwiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
// "Republish all" => "Republish all",
// "Publish all" => "Publish all",
// "Unpublish all" => "Unpublish all",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>." => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>.",
// "Attention" => "Attention",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./fixperms fix\" for example)." => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./fixperms fix\" for example).",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that permission (using \"./fixperms fix\")." => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that permission (using \"./fixperms fix\").",
// "all types" => "all types",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "licence" => "licence",
// "Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuration",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "Package Config" => "Package Config",
// "my tiki tpl" => "my tiki tpl",
// "y" => "y",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you participate:" => "To display the objects you participate:",
// "Contacts Preferences" => "Contacts Preferences",
// "My Infos" => "My Infos",
// "My Contacts" => "My Contacts",
// "My Wiki Pages" => "My Wiki Pages",
// "My Galleries" => "My Galleries",
// "My Tracker Items" => "My Tracker Items",
// "My Messages" => "My Messages",
// "My Tasks" => "My Tasks",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Errors:" => "Errors:",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "Available Newsletters" => "Available Newsletters",
// "News from" => "News from",
// "Configure Newsreader" => "Configure Newsreader",
// "configure newsreader server tpl" => "configure newsreader server tpl",
// "Read the news" => "Read the news",
// "Add a news server" => "Add a news server",
// "Edit news server" => "Edit news server",
// "View Permissions" => "View Permissions",
// "Edit Permissions" => "Edit Permissions",
// "These permissions override any global permissions or category permissions affecting this object." => "These permissions override any global permissions or category permissions affecting this object.",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>." => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>.",
// "No individual permissions, category permissions apply" => "No individual permissions, category permissions apply",
// "Current permissions for categories that this object belongs to" => "Current permissions for categories that this object belongs to",
// "These permissions do not apply. Special permissions apply." => "These permissions do not apply. Special permissions apply.",
// "No category permissions; global permissions apply" => "No category permissions; global permissions apply",
// "No category permissions; special permissions apply" => "No category permissions; special permissions apply",
// "and also to all pages of the sub-structure:" => "and also to all pages of the sub-structure:",
// "Perms Help" => "Perms Help",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier." => "However, no account is associated to the OpenID identifier.",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts." => "Your identity gives you access to multiple user accounts.",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "Rollback to this version" => "Rollback to this version",
// "Source of version" => "Source of version",
// "s=source" => "s=source",
// "b=rollback" => "b=rollback",
// "HTML diff" => "HTML diff",
// "Side-by-side diff" => "Side-by-side diff",
// "Side-by-side diff by characters" => "Side-by-side diff by characters",
// "Inline diff" => "Inline diff",
// "Inline diff by characters" => "Inline diff by characters",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "Avatar:" => "Avatar:",
// "no avatar" => "no avatar",
// "icons" => "icons",
// "(Only .gif images, and aproximately 45px x 45px)" => "(Only .gif images, and aproximately 45px x 45px)",
// "Any" => "Any",
// "Items found:" => "Items found:",
// "atts" => "atts",
// "List Attachments" => "List Attachments",
// "View Results" => "View Results",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Average:" => "Average:",
// "List Votes" => "List Votes",
// "Note: Remember that this is only a preview, and has not yet been saved!" => "Note: Remember that this is only a preview, and has not yet been saved!",
// "Permission denied. You do not have permission to read complete articles." => "Permission denied. You do not have permission to read complete articles.",
// "Selected Structures" => "Selected Structures",
// "Add Structure" => "Add Structure",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected." => "No pages selected.",
// "Edit quiz" => "Edit quiz",
// "General Options" => "General Options",
// "Name:" => "Name:",
// "Publication Date" => "Publication Date",
// "at " => "at ",
// "Use " => "Use ",
// "randomly selected questions." => "randomly selected questions.",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)." => "&nbsp question(s).",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz." => "Allow students to store partial results and return to quiz.",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue:" => "Prologue:",
// "Epilogue:" => "Epilogue:",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "Passed" => "Passed",
// "Question:" => "Question:",
// "received articles tpl" => "received articles tpl",
// "Received Pages" => "Received Pages",
// "Help on Communication Center" => "Help on Communication Center",
// "received pages tpl" => "received pages tpl",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist." => "The highlight pages already exist.",
// "Please, change the name if you want the page to be uploaded." => "Please, change the name if you want the page to be uploaded.",
// "Received Structures" => "Received Structures",
// "Prefix the checked:" => "Prefix the checked:",
// "Postfix the checked:" => "Postfix the checked:",
// "Admin Referer Stats" => "Admin Referer Stats",
// "Admin Referer Stats tpl" => "Admin Referer Stats tpl",
// "Use your email as login" => "Use your email as login",
// "Lowercase only" => "Lowercase only",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "A valid email is mandatory to register" => "A valid email is mandatory to register",
// "Select your group" => "Select your group",
// "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter!" => "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter!",
// "Tiki site registered" => "Tiki site registered",
// "You don't have permission to use this feature." => "You don't have permission to use this feature.",
// "Please register." => "Please register.",
// "Register this site at tikiwiki.org" => "Register this site at tikiwiki.org",
// "Read this first!" => "Read this first!",
// "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites.",
// "Registering is voluntary." => "Registering is voluntary.",
// "Registering does not give you any benefits except one more link to your site." => "Registering does not give you any benefits except one more link to your site.",
// "You don't get any emails, we don't sell the data about your site." => "You don't get any emails, we don't sell the data about your site.",
// "Registering is just for us to get an overview of Tiki's usage." => "Registering is just for us to get an overview of Tiki's usage.",
// "If your site is private or inside your intranet, you should not register!" => "If your site is private or inside your intranet, you should not register!",
// "tikiwiki.org" => "tikiwiki.org",
// "Information about your site" => "Information about your site",
// "Enter your username or email." => "Enter your username or email.",
// "Request Password Reset" => "Request Password Reset",
// "Last Version" => "Last Version",
// "return to wikipage" => "return to wikipage",
// "Replicate" => "Replicate",
// "Slave" => "Slave",
// "Master" => "Master",
// "Operations" => "Operations",
// "Operations Log" => "Operations Log",
// "Search Stats" => "Search Stats",
// "search stats tpl" => "search stats tpl",
// "Faqs" => "Faqs",
// "Simple search" => "Simple search",
// "Please Confirm" => "Please Confirm",
// "Apply content template" => "Apply content template",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Save as Draft" => "Save as Draft",
// "Admin Send Objects tpl" => "Admin Send Objects tpl",
// "Send a structure" => "Send a structure",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "Debug" => "Debug",
// "sheets tpl" => "sheets tpl",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet:" => "Edit this sheet:",
// "Create New Sheet" => "Create New Sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "Header Rows" => "Header Rows",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "Admin Tiki Shoutbox" => "Admin Tiki Shoutbox",
// "Admin Tiki Shoutbox tpl" => "Admin Tiki Shoutbox tpl",
// "Change shoutbox general settings" => "Change shoutbox general settings",
// "auto-link urls" => "auto-link urls",
// "Click to Navigate" => "Click to Navigate",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page." => "the approved version of this page.",
// "Viewing of changes since last approval is possible only after first approval." => "Viewing of changes since last approval is possible only after first approval.",
// "Approve changes." => "Approve changes.",
// "Latest changes will be synchronized after approval." => "Latest changes will be synchronized after approval.",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time." => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time.",
// "{icon _id=information.png style=\"vertical-align:middle\"} Content may be out of date" => "{icon _id=information.png style=\"vertical-align:middle\"} Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages:" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages:",
// "TOC" => "TOC",
// "big grin" => "big grin",
// "confused" => "confused",
// "cry" => "cry",
// "eek" => "eek",
// "evil" => "evil",
// "lol" => "lol",
// "mr green" => "mr green",
// "razz" => "razz",
// "redface" => "redface",
// "rolleyes" => "rolleyes",
// "smile" => "smile",
// "surprised" => "surprised",
// "twisted" => "twisted",
// "arrow" => "arrow",
// "santa" => "santa",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "FAQ Stats" => "FAQ Stats",
// "Daily Usage" => "Daily Usage",
// "SysLog" => "SysLog",
// "System log help" => "System log help",
// "system logs" => "system logs",
// "system logs tpl" => "system logs tpl",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Clean" => "Clean",
// "Thank you for your submission" => "Thank you for your submission",
// "Send a link to a friend" => "Send a link to a friend",
// "The link was sent to the following addresses:" => "The link was sent to the following addresses:",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma." => "Separate multiple email addresses with a comma.",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like." => "I found an interesting page that I thought you would like.",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request:" => "Request:",
// "Element to compare (Xpath expression):" => "Element to compare (Xpath expression):",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "Notice" => "Notice",
// "PECL HTPP extension present" => "PECL HTPP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTPP and cURL extension not present. Replay of the TikiTest will not be possible." => "PECL HTPP and cURL extension not present. Replay of the TikiTest will not be possible.",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "File Name:" => "File Name:",
// "Start Recording Test" => "Start Recording Test",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "ThemeControl" => "ThemeControl",
// "ThemeControl tpl" => "ThemeControl tpl",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
// "Control by Objects" => "Control by Objects",
// "ThemeControl Objects" => "ThemeControl Objects",
// "theme control objects tpl" => "theme control objects tpl",
// "theme control sections tpl" => "theme control sections tpl",
// "Edit File:" => "Edit File:",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "Additional Info" => "Additional Info",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "Upload big files (e.g. PodCast files) here:" => "Upload big files (e.g. PodCast files) here:",
// "You locked the file" => "You locked the file",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "Unzip all zip files" => "Unzip all zip files",
// "Maximum amount of downloads" => "Maximum amount of downloads",
// "0 for no limit" => "0 for no limit",
// "Author if not the file creator" => "Author if not the file creator",
// "No gallery available." => "No gallery available.",
// "Image Gallery tpl" => "Image Gallery tpl",
// "You can include the image in an Wiki page using" => "You can include the image in an Wiki page using",
// "or use filename" => "or use filename",
// "Note: Maximum image size is limited to" => "Note: Maximum image size is limited to",
// "User Assigned Modules" => "User Assigned Modules",
// "User Assigned Modules tpl" => "User Assigned Modules tpl",
// "User Bookmarks tpl" => "User Bookmarks tpl",
// "a folder" => "a folder",
// "a URL" => "a URL",
// "User Contacts Preferences" => "User Contacts Preferences",
// "Edit User Contacts Preferences" => "Edit User Contacts Preferences",
// "Manage Fields" => "Manage Fields",
// "Default view" => "Default view",
// "Gender" => "Gender",
// "Homepage" => "Homepage",
// "Users HomePage" => "Users HomePage",
// "Personal Wiki Page" => "Personal Wiki Page",
// "Create page" => "Create page",
// "This user is your friend" => "This user is your friend",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Request friendship from this user" => "Request friendship from this user",
// "Forum comments" => "Forum comments",
// "Toggle options" => "Toggle options",
// "Toggle" => "Toggle",
// "UserPreferences tpl" => "UserPreferences tpl",
// "Personal Information" => "Personal Information",
// "Use Google Map locator" => "Use Google Map locator",
// "Your personal tracker information" => "Your personal tracker information",
// "View extra information" => "View extra information",
// "Unavailable - please set your e-mail below" => "Unavailable - please set your e-mail below",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages?" => "Can you read more languages?",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language..." => "Select language...",
// "My level" => "My level",
// "Account Information" => "Account Information",
// "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password",
// "Email address" => "Email address",
// "Confirm new password" => "Confirm new password",
// "Current password (required)" => "Current password (required)",
// "Change administrative info" => "Change administrative info",
// "User Tasks tpl" => "User Tasks tpl",
// "New task" => "New task",
// "Task list" => "Task list",
// "Admin mode off" => "Admin mode off",
// "Admin mode on" => "Admin mode on",
// "Task help" => "Task help",
// "Empty Trash" => "Empty Trash",
// "Received task" => "Received task",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "Send task" => "Send task",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "Accepted by Task User and Creator" => "Accepted by Task User and Creator",
// "Accepted User and Creator" => "Accepted User and Creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "Not Accepted by One User" => "Not Accepted by One User",
// "Not Accepted User" => "Not Accepted User",
// "Task is rejected by one user" => "Task is rejected by one user",
// "Waiting for Me" => "Waiting for Me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "Waiting for Other User" => "Waiting for Other User",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "Admin Mode" => "Admin Mode",
// "Edit task" => "Edit task",
// "Red" => "Red",
// "NOT accept" => "NOT accept",
// "Remove from Trash" => "Remove from Trash",
// "Move into Trash" => "Move into Trash",
// "Task saved" => "Task saved",
// "Edit Task" => "Edit Task",
// "View Task" => "View Task",
// "Open a new task" => "Open a new task",
// "taskId" => "taskId",
// "Task user" => "Task user",
// "Only the creator can delete this task" => "Only the creator can delete this task",
// "Use start date and time" => "Use start date and time",
// "Use end date and time" => "Use end date and time",
// "Open / In Process" => "Open / In Process",
// "Waiting / Not Started" => "Waiting / Not Started",
// "Waiting" => "Waiting",
// "Shared for Group" => "Shared for Group",
// "Accepted by User" => "Accepted by User",
// "No / Rejected" => "No / Rejected",
// "Accepted by Creator" => "Accepted by Creator",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Send message with changes" => "Send message with changes",
// "Modified by" => "Modified by",
// "Marked as deleted" => "Marked as deleted",
// "Inform task user by email" => "Inform task user by email",
// "You can only view this task" => "You can only view this task",
// "%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
// "Select One" => "Select One",
// "Undo Trash" => "Undo Trash",
// "Show:" => "Show:",
// "Received" => "Received",
// "Submitted" => "Submitted",
// "Shared" => "Shared",
// "All Shared Tasks" => "All Shared Tasks",
// "completed (100%)" => "completed (100%)",
// "Public for group" => "Public for group",
// "User Watches tpl" => "User Watches tpl",
// "Use \"watches\" to monitor wiki pages or other objects." => "Use \"watches\" to monitor wiki pages or other objects.",
// "Watch new items by clicking the {icon _id=eye} button on specific pages." => "Watch new items by clicking the {icon _id=eye} button on specific pages.",
// "Add Watch" => "Add Watch",
// "watched events" => "watched events",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user edited a wiki page" => "A user edited a wiki page",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "Watch language wiki page creations" => "Watch language wiki page creations",
// "Add watch" => "Add watch",
// "Used space:" => "Used space:",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Remove Row" => "Remove Row",
// "Remove Column" => "Remove Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "Before" => "Before",
// "After" => "After",
// "expires:" => "expires:",
// "No articles." => "No articles.",
// "View FAQ Tpl" => "View FAQ Tpl",
// "Admin Menus tpl" => "Admin Menus tpl",
// "There are no questions in this FAQ." => "There are no questions in this FAQ.",
// "Answers" => "Answers",
// "Add Suggestion" => "Add Suggestion",
// "1 suggestion" => "1 suggestion",
// "suggestions" => "suggestions",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "You have {\$unread} unread private messages" => "You have {\$unread} unread private messages",
// "Your message has been queued for approval, the message will be posted after a moderator approves it." => "Your message has been queued for approval, the message will be posted after a moderator approves it.",
// "Another post with the same title and content already exists." => "Another post with the same title and content already exists.",
// "Please change your title or content then click Post." => "Please change your title or content then click Post.",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "Emot" => "Emot",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Show archived posts" => "Show archived posts",
// "Archived" => "Archived",
// "The post has been reported and will be reviewed by a moderator." => "The post has been reported and will be reviewed by a moderator.",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Show All" => "Show All",
// "Tracker:" => "Tracker:",
// "Stop Monitor" => "Stop Monitor",
// "Edit Fields" => "Edit Fields",
// "Tracker Items for" => "Tracker Items for",
// "Format : x,y,zoom - You can use Google Map Locator in the item view script." => "Format : x,y,zoom - You can use Google Map Locator in the item view script.",
// "View inserted item" => "View inserted item",
// "Tracker Item:" => "Tracker Item:",
// "Edit/Delete" => "Edit/Delete",
// "Filter Tracker Items" => "Filter Tracker Items",
// "Items list" => "Items list",
// "Remove Image" => "Remove Image",
// "Google Map Locator" => "Google Map Locator",
// "Special Operations" => "Special Operations",
// "fields marked with a * are mandatory" => "fields marked with a * are mandatory",
// "Edit mail account" => "Edit mail account",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Word Count:" => "Word Count:",
// "Number of voices" => "Number of voices",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled." => "Google Maps is not enabled.",
// "Use this thread to discuss the page:" => "Use this thread to discuss the page:",
// "Missing or incorrect trackerId parameter for the plugin." => "Missing or incorrect trackerId parameter for the plugin.",
// "Subscribe to a group" => "Subscribe to a group",
// "Show Filters" => "Show Filters",
// "Toggle display" => "Toggle display",
// "Start:" => "Start:",
// "Close:" => "Close:",
// "List authors:" => "List authors:",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
// "Business style" => "Business style",
// "Collaborative style" => "Collaborative style",
// "no (disabled)" => "no (disabled)",
// "Save the page as a partial translation." => "Save the page as a partial translation.",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation." => "Save the page as a completed translation.",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated." => "Save the page, but do not send notifications and do not count it as new content to be translated.",
// "Save the page as a draft." => "Save the page as a draft.",
// "Save Draft" => "Save Draft",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "%s enabled" => "%s enabled",
// "%s disabled" => "%s disabled",
// "Enable/disable Tiki features here, but configure them elsewhere" => "Enable/disable Tiki features here, but configure them elsewhere",
// "User registration, login and authentication" => "User registration, login and authentication",
// "Wiki Attachments" => "Wiki Attachments",
// "Article/CMS settings" => "Article/CMS settings",
// "Configuration options for all blogs on your site" => "Configuration options for all blogs on your site",
// "FAQ comments settings" => "FAQ comments settings",
// "Trackers settings" => "Trackers settings",
// "RSS settings" => "RSS settings",
// "Directory settings" => "Directory settings",
// "Maps configuration" => "Maps configuration",
// "Meta Tags settings" => "Meta Tags settings",
// "Search settings" => "Search settings",
// "Score settings" => "Score settings",
// "Community settings" => "Community settings",
// "Calendar settings" => "Calendar settings",
// "Intertiki settings" => "Intertiki settings",
// "Freetags settings" => "Freetags settings",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Current version is up to date : <b>%s</b>" => "Current version is up to date : <b>%s</b>",
// "A new %s  major release branch is available." => "A new %s  major release branch is available.",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Click here to delete the category:" => "Click here to delete the category:",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header:" => "The file does not have the required header:",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "moved %d images, %d errors occured." => "moved %d images, %d errors occured.",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Detected, Version:" => "Detected, Version:",
// "Not detected." => "Not detected.",
// "You cannot have a blank password" => "You cannot have a blank password",
// "Your admin password has been changed" => "Your admin password has been changed",
// "All Fields except gdaltindex must be filled" => "All Fields except gdaltindex must be filled",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Repository name can't be an empty" => "Repository name can't be an empty",
// "Requested action is not supported on repository" => "Requested action is not supported on repository",
// "No repository" => "No repository",
// "Search is mandatory field" => "Search is mandatory field",
// "File not found " => "File not found ",
// "Requested action in not supported on repository" => "Requested action in not supported on repository",
// "Non-existent link" => "Non-existent link",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer!" => "Frequency should be a positive integer!",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "Invalid email" => "Invalid email",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "Insert" => "Insert",
// "Icon" => "Icon",
// "unsafe" => "unsafe",
// "register_globals should be off by default. See the php manual for details." => "register_globals should be off by default. See the php manual for details.",
// "safe" => "safe",
// "session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid should be off by default. See the php manual for details.",
// "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config.",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "risky" => "risky",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off.",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code.",
// "installed" => "installed",
// "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html.",
// "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement.",
// "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory.",
// "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts.",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "File is not readable. Unable to check." => "File is not readable. Unable to check.",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous.",
// "This is a modified File. Cannot check version. Check if it is dangerous." => "This is a modified File. Cannot check version. Check if it is dangerous.",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// "You have to provide a word" => "You have to provide a word",
// "You must specify a page name, it will be created if it doesn't exist." => "You must specify a page name, it will be created if it doesn't exist.",
// "You don't have permission to use this feature" => "You don't have permission to use this feature",
// "No Errors detected" => "No Errors detected",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "User %s already exists" => "User %s already exists",
// "User login contains invalid characters" => "User login contains invalid characters",
// "New %s created with %s %s." => "New %s created with %s %s.",
// "Impossible to create new %s with %s %s." => "Impossible to create new %s with %s %s.",
// "%s %s successfully deleted." => "%s %s successfully deleted.",
// "Deleted account %s" => "Deleted account %s",
// "%s %s removed from %s %s." => "%s %s removed from %s %s.",
// "%s <b>%s</b> successfully deleted." => "%s <b>%s</b> successfully deleted.",
// "%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> assigned to %s <b>%s</b>.",
// "%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> removed from %s <b>%s</b>.",
// "group <b>%s</b> set as the default group of user <b>%s</b>." => "group <b>%s</b> set as the default group of user <b>%s</b>.",
// "%s modified successfully." => "%s modified successfully.",
// "%s modification failed." => "%s modification failed.",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "Login contains invalid characters" => "Login contains invalid characters",
// "Image annotations changed." => "Image annotations changed.",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "rss feed disabled" => "rss feed disabled",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Last articles." => "Last articles.",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s." => "Could not read image %s.",
// "Image %s upload failed." => "Image %s upload failed.",
// "Image %s uploaded successfully." => "Image %s uploaded successfully.",
// "Image %s removed from Batch directory." => "Image %s removed from Batch directory.",
// "Impossible to remove image %s from Batch directory." => "Impossible to remove image %s from Batch directory.",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images." => "Incorrect directory chosen for batch upload of images.",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator." => "Please contact the website administrator.",
// "Invalid directory name" => "Invalid directory name",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s." => "Could not read file %s.",
// "Could not write to file %s." => "Could not write to file %s.",
// "File %s upload failed." => "File %s upload failed.",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory." => "File %s removed from Batch directory.",
// "Impossible to remove file %s from Batch directory." => "Impossible to remove file %s from Batch directory.",
// "Incorrect directory chosen for batch upload of files." => "Incorrect directory chosen for batch upload of files.",
// "Tiki RSS feed for blog: " => "Tiki RSS feed for blog: ",
// "Last modifications to the blog." => "Last modifications to the blog.",
// "No blogId specified" => "No blogId specified",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs." => "Last posts to weblogs.",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache." => "You must clear your browser cache.",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "Access Denied" => "Access Denied",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string!",
// "%m/%d" => "%m/%d",
// "%H:%M %Z" => "%H:%M %Z",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Upcoming events." => "Upcoming events.",
// "End:" => "End:",
// "No category indicated" => "No category indicated",
// "Permission denied; you cannot assign permissions for this category" => "Permission denied; you cannot assign permissions for this category",
// "Invalid username or activation code. Maybe this code has already been used." => "Invalid username or activation code. Maybe this code has already been used.",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Problem. Try to log in again to receive new confirmation instructions." => "Problem. Try to log in again to receive new confirmation instructions.",
// "ERROR: you must include a subject or a message at least" => "ERROR: you must include a subject or a message at least",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "Last sites." => "Last sites.",
// "You have mistyped the anti-bot verification code; please try again. " => "You have mistyped the anti-bot verification code; please try again. ",
// "Must enter a name to add a site. " => "Must enter a name to add a site. ",
// "Must enter a url to add a site. " => "Must enter a url to add a site. ",
// "URL already added to the directory. Duplicate site? " => "URL already added to the directory. Duplicate site? ",
// "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. ",
// "Must select a category. " => "Must select a category. ",
// "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory",
// "No parent specified" => "No parent specified",
// "Last sites of directory \".\$rc[\"name\"].\" ." => "Last sites of directory \".\$rc[\"name\"].\" .",
// "You cannot download this file right now. Your score is low or file limit was reached." => "You cannot download this file right now. Your score is low or file limit was reached.",
// "Error : The file %s doesn't exist." => "Error : The file %s doesn't exist.",
// "Invalid email:" => "Invalid email:",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "Invalid structure_id or page_ref_id" => "Invalid structure_id or page_ref_id",
// "You do not have permission to write the template:" => "You do not have permission to write the template:",
// "No topic id specified" => "No topic id specified",
// "Invalid topic id specified" => "Invalid topic id specified",
// "Translation in progress." => "Translation in progress.",
// "No object indicated" => "No object indicated",
// "Page is a staging copy. Translation must begin from the approved copy." => "Page is a staging copy. Translation must begin from the approved copy.",
// "No type indicated" => "No type indicated",
// "Not enable for this type of object" => "Not enable for this type of object",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Can't import remote HTML page" => "Can't import remote HTML page",
// "Can't parse remote HTML page" => "Can't parse remote HTML page",
// "Page already exists. Go back and choose a different name." => "Page already exists. Go back and choose a different name.",
// "The translation set already contains a page in this language." => "The translation set already contains a page in this language.",
// "No questions group indicated" => "No questions group indicated",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Tiki RSS feed for file galleries" => "Tiki RSS feed for file galleries",
// "Last files uploaded to the file galleries." => "Last files uploaded to the file galleries.",
// "No galleryId specified" => "No galleryId specified",
// "Tiki RSS feed for the file gallery: " => "Tiki RSS feed for the file gallery: ",
// "Form error - no import method selected for some reason." => "Form error - no import method selected for some reason.",
// "Form error - no server-side filename entered for selected import method." => "Form error - no server-side filename entered for selected import method.",
// "Last replied forum topics" => "Last replied forum topics",
// "No forumId specified" => "No forumId specified",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums." => "Last topics in forums.",
// "Not supported yet." => "Not supported yet.",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship!" => "I have broken our friendship!",
// "You must be logged in to use this feature" => "You must be logged in to use this feature",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "I have accepted your friendship request!" => "I have accepted your friendship request!",
// "I have refused your friendship request." => "I have refused your friendship request.",
// "I have canceled my friendship request." => "I have canceled my friendship request.",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "Invalid source path" => "Invalid source path",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "You couldn't abort a instance" => "You couldn't abort a instance",
// "You couldn't exception a instance" => "You couldn't exception a instance",
// "No title indicated" => "No title indicated",
// "No comment indicated" => "No comment indicated",
// "No date indicated" => "No date indicated",
// "first uploaded image" => "first uploaded image",
// "last uploaded image" => "last uploaded image",
// "random image" => "random image",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required." => "No valid renderer found. GD or PDFLib required.",
// "No sheet specified." => "No sheet specified.",
// "You must select a renderer." => "You must select a renderer.",
// "Invalid Series for current graphic." => "Invalid Series for current graphic.",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries." => "Last images uploaded to the image galleries.",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "Only the administrator can upload language files." => "Only the administrator can upload language files.",
// "updated from structured text import" => "updated from structured text import",
// "created from structured text import" => "created from structured text import",
// "%s - Version %d of this page has been saved by %s." => "%s - Version %d of this page has been saved by %s.",
// "No repository given" => "No repository given",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Non-existent gallery" => "Non-existent gallery",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Warning: Empty file:" => "Warning: Empty file:",
// "Please re-upload your file" => "Please re-upload your file",
// "Could not upload the file" => "Could not upload the file",
// "Could not find the file requested" => "Could not find the file requested",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read file:" => "Cannot read file:",
// "Cannot read the file:" => "Cannot read the file:",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "File update was successful" => "File update was successful",
// "This gallery does not exist" => "This gallery does not exist",
// "The game file must have .swf or .dcr extension" => "The game file must have .swf or .dcr extension",
// "Please supply both files" => "Please supply both files",
// "Delete those pages:" => "Delete those pages:",
// "You have to enable cookies to be able to login to this site" => "You have to enable cookies to be able to login to this site",
// "Unable to contact remote server." => "Unable to contact remote server.",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made." => "More than %d unsuccessful login attempts have been made.",
// "An email has been sent to you with the instructions to follow." => "An email has been sent to you with the instructions to follow.",
// "Invalid password" => "Invalid password",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "You are not yet validated" => "You are not yet validated",
// "Your default nickname is already in use. A new one has to be selected." => "Your default nickname is already in use. A new one has to be selected.",
// "The selected account is not associated with your identity." => "The selected account is not associated with your identity.",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Account validated successfully." => "Account validated successfully.",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Sorry, you can't use this feature." => "Sorry, you can't use this feature.",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile: " => "An error as occured with the mapfile: ",
// "Please create a directory named '.\$prefs['map_path'].' to hold your map files." => "Please create a directory named '.\$prefs['map_path'].' to hold your map files.",
// "You do not have permissions to view the maps" => "You do not have permissions to view the maps",
// "Maps feature is not correctly setup : Maps path is missing." => "Maps feature is not correctly setup : Maps path is missing.",
// "mapfile name incorrect" => "mapfile name incorrect",
// "This mapfile already exists" => "This mapfile already exists",
// "You do not have permission to write to the mapfile" => "You do not have permission to write to the mapfile",
// "You do not have permission to delete the mapfile" => "You do not have permission to delete the mapfile",
// "I could not make a copy" => "I could not make a copy",
// "You do not have permission to read the mapfile" => "You do not have permission to read the mapfile",
// "map edit" => "map edit",
// "You dont have permission to do that" => "You dont have permission to do that",
// "Tiki RSS feed for maps" => "Tiki RSS feed for maps",
// "List of maps available." => "List of maps available.",
// "You do not have permissions to view the layers" => "You do not have permissions to view the layers",
// "You do not have permissions to delete a file" => "You do not have permissions to delete a file",
// "File not found" => "File not found",
// "You do not have permissions to create a directory" => "You do not have permissions to create a directory",
// "The Directory is not empty" => "The Directory is not empty",
// "You do not have permissions to delete a directory" => "You do not have permissions to delete a directory",
// "You do not have permissions to create an index file" => "You do not have permissions to create an index file",
// "Invalid file name" => "Invalid file name",
// "Invalid files to index" => "Invalid files to index",
// "I do not know where is gdaltindex. Set correctly the Map feature" => "I do not know where is gdaltindex. Set correctly the Map feature",
// "I could not create the index file" => "I could not create the index file",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled." => "Your PHP installation does not have zlib enabled.",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Pageviews" => "Pageviews",
// "You don't have permission to edit quizzes." => "You don't have permission to edit quizzes.",
// "Registered" => "Registered",
// "You must choose a group" => "You must choose a group",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "mail adress" => "mail adress",
// "empty" => "empty",
// "Unable to send mail. User has not configured email" => "Unable to send mail. User has not configured email",
// "Invalid or unknown email" => "Invalid or unknown email",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password." => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password.",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "A password and your IP address reminder email has been sent " => "A password and your IP address reminder email has been sent ",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email " => "to the email ",
// "last version" => "last version",
// "You cannot rename staging pages. Please rename the approved page instead." => "You cannot rename staging pages. Please rename the approved page instead.",
// "Permission denied you cannot rename this page" => "Permission denied you cannot rename this page",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "changed '%s' from '%s' to '%s'" => "changed '%s' from '%s' to '%s'",
// "Non-existent version" => "Non-existent version",
// "Error Message" => "Error Message",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "No newsletters available." => "No newsletters available.",
// "Error: " => "Error: ",
// "Notice: this variable may not be empty:" => "Notice: this variable may not be empty:",
// "Notice: invalid variable value:" => "Notice: invalid variable value:",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Quiz time limit exceeded quiz cannot be computed" => "Quiz time limit exceeded quiz cannot be computed",
// "Report to the webmaster" => "Report to the webmaster",
// "Tracker item:" => "Tracker item:",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
// "Usage" => "Usage",
// "The user has chosen to make his information private" => "The user has chosen to make his information private",
// "Password has been changed" => "Password has been changed",
// "Invalid password.  Your current password is required to change administrative information" => "Invalid password.  Your current password is required to change administrative information",
// "Email is set to %s" => "Email is set to %s",
// "The passwords did not match" => "The passwords did not match",
// "unicode" => "unicode",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "open / in process" => "open / in process",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries:" => "Task entries:",
// "Changes:" => "Changes:",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Login and click the link below" => "Login and click the link below",
// "Please read the task and work on it!" => "Please read the task and work on it!",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "Language watch" => "Language watch",
// "Non-existent user" => "Non-existent user",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again." => "You must suggest a question; please try again.",
// "You are not permitted to remove someone else\\'s post!" => "You are not permitted to remove someone else\\'s post!",
// "Incorrect thread" => "Incorrect thread",
// "A SheetId is required." => "A SheetId is required.",
// "That tracker don't use extras." => "That tracker don't use extras.",
// "Tiki RSS feed for the wiki pages" => "Tiki RSS feed for the wiki pages",
// "Last modifications to the Wiki." => "Last modifications to the Wiki.",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "TikiTests Edit" => "TikiTests Edit",
// "You are about to delete a TikiTest file, do you want to continue ?" => "You are about to delete a TikiTest file, do you want to continue ?",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"ID" => "ID",
"Role" => "Role",
"Wiki" => "Wiki",
"Blogs" => "Blogs",
"FAQs" => "FAQs",
"blog" => "blog",
"faq" => "faq",
"Anonymous" => "Anonymous",
"WikiDiff Okay: LCS = %s" => "WikiDiff Okay: LCS = %s",
"Blog" => "Blog",
"By:" => "By:",
"FAQ" => "FAQ",
"wiki" => "wiki",
"faqs" => "faqs",
"blogs" => "blogs",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
"RSS feed" => "RSS feed",
"Properties" => "Properties",
"on" => "on",
"Hi," => "Hi,",
"Hi" => "Hi",
"Bye bye!" => "Bye bye!",
"of" => "of",
"Ip" => "Ip",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"Invalid" => "Invalid",
"CC" => "CC",
"BCC" => "BCC",
"Cc" => "Cc",
"Cookies" => "Cookies",
"Mail-in" => "Mail-in",
"Shoutbox" => "Shoutbox",
"phpinfo" => "phpinfo",
"MyMenu" => "MyMenu",
"Webmail" => "Webmail",
"WfMenu" => "WfMenu",
"Admin processes" => "Admin processes",
"Monitor processes" => "Monitor processes",
"Monitor activities" => "Monitor activities",
"Monitor instances" => "Monitor instances",
"User processes" => "User processes",
"User instances" => "User instances",
"WikiMenu" => "WikiMenu",
"GalMenu" => "GalMenu",
"ForMenu" => "ForMenu",
"DirMenu" => "DirMenu",
"FileGalMenu" => "FileGalMenu",
"QuizMenu" => "QuizMenu",
"TrkMenu" => "TrkMenu",
"SrvMenu" => "SrvMenu",
"EphMenu" => "EphMenu",
"ChartMenu" => "ChartMenu",
"AdmMenu" => "AdmMenu",
"DSN" => "DSN",
"UsrMenu" => "UsrMenu",
"on:" => "on:",
"Send trackback pings to:" => "Send trackback pings to:",
"(comma separated list of URIs)" => "(comma separated list of URIs)",
"Trackback pings" => "Trackback pings",
"URI" => "URI",
"RSS" => "RSS",
"Blog level comments" => "Blog level comments",
"Post level comments" => "Post level comments",
"XMLRPC API" => "XMLRPC API",
"Unix" => "Unix",
"Windows" => "Windows",
"PEAR::Auth" => "PEAR::Auth",
"LDAP Member Is DN" => "LDAP Member Is DN",
"Value" => "Value",
"SearchStats" => "SearchStats",
"Id" => "Id",
"x" => "x",
"Url" => "Url",
"h" => "h",
"Top" => "Top",
"URL" => "URL",
"CMS" => "CMS",
"Cookie" => "Cookie",
"cookie" => "cookie",
"wiki-get" => "wiki-get",
"wiki-put" => "wiki-put",
"wiki-append" => "wiki-append",
"Valid" => "Valid",
"Email:" => "Email:",
"isMain" => "isMain",
"Tbl vis" => "Tbl vis",
"+" => "+",
"Roles" => "Roles",
"cType" => "cType",
"Own Image" => "Own Image",
"Use own image" => "Use own image",
"Own image size x" => "Own image size x",
"Own image size y" => "Own image size y",
"col" => "col",
"RSS feeds" => "RSS feeds",
"rss feed" => "rss feed",
"tagline" => "tagline",
"hr" => "hr",
"Int" => "Int",
"#" => "#",
"inter" => "inter",
"This process is invalid" => "This process is invalid",
"List of processes" => "List of processes",
"Inactive" => "Inactive",
"act" => "act",
"val" => "val",
"Activities" => "Activities",
"No processes defined yet" => "No processes defined yet",
"Process:" => "Process:",
"exception" => "exception",
"Owner" => "Owner",
"Send all to" => "Send all to",
"Don't move" => "Don't move",
"Act status" => "Act status",
"Property" => "Property",
"Add property" => "Add property",
"run instance" => "run instance",
"Add or edit a process" => "Add or edit a process",
"Process Name" => "Process Name",
"ver:" => "ver:",
"is active?" => "is active?",
"Or upload a process using this form" => "Or upload a process using this form",
"Admin process roles" => "Admin process roles",
"Add or edit a role" => "Add or edit a role",
"Process roles" => "Process roles",
"No roles defined yet" => "No roles defined yet",
"Map users to roles" => "Map users to roles",
"map" => "map",
"Map groups to roles" => "Map groups to roles",
"Operation" => "Operation",
"Warning" => "Warning",
"No roles are defined yet so no roles can be mapped" => "No roles are defined yet so no roles can be mapped",
"List of mappings" => "List of mappings",
"No mappings defined yet" => "No mappings defined yet",
"Admin process sources" => "Admin process sources",
"select source" => "select source",
"Shared code" => "Shared code",
"Set next user" => "Set next user",
"Get property" => "Get property",
"Set property" => "Set property",
"Complete" => "Complete",
"Process form" => "Process form",
"Set Next act" => "Set Next act",
"If:SetNextact" => "If:SetNextact",
"Switch construct" => "Switch construct",
"Map process roles" => "Map process roles",
"List of activities" => "List of activities",
"auto" => "auto",
"int" => "int",
"routing" => "routing",
"Instances" => "Instances",
"run" => "run",
"run activity" => "run activity",
"monitor processes" => "monitor processes",
"monitor activities" => "monitor activities",
"monitor instances" => "monitor instances",
"monitor workitems" => "monitor workitems",
"List of instances" => "List of instances",
"No instances created yet" => "No instances created yet",
"processes" => "processes",
"being run" => "being run",
"Monitor workitems" => "Monitor workitems",
"List of workitems" => "List of workitems",
"instance" => "instance",
"exception instance" => "exception instance",
"exceptions instance" => "exceptions instance",
"abort instance" => "abort instance",
"grab instance" => "grab instance",
"release instance" => "release instance",
"User Activities" => "User Activities",
"process" => "process",
"user processes" => "user processes",
"user activities" => "user activities",
"user instances" => "user instances",
"Inst Status" => "Inst Status",
"No instances defined yet" => "No instances defined yet",
"Browsing Workitem" => "Browsing Workitem",
"Workitem information" => "Workitem information",
"Tiki Shoutbox" => "Tiki Shoutbox",
"pvs" => "pvs",
"Mb" => "Mb",
"Weblogs" => "Weblogs",
"top" => "top",
"Pos" => "Pos",
"User_versions_for" => "User_versions_for",
"Q" => "Q",
"A" => "A",
"pts" => "pts",
"TOP" => "TOP",
"Activity name already exists" => "Activity name already exists",
"indicates if the process is active. Invalid processes cant be active" => "indicates if the process is active. Invalid processes cant be active",
"No instance indicated" => "No instance indicated",
"No activity indicated" => "No activity indicated",
"The process name already exists" => "The process name already exists",
"Process already exists" => "Process already exists",
"You cant execute this activity" => "You cant execute this activity",
"tiki-mobile.php" => "tiki-mobile.php",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "這個功能已經關閉",
"Permission denied you cannot view pages" => "你沒有觀看頁面的權限",
"Cannot write to this file:" => "無法寫入此檔案:",
"Cannot upload this file maximum upload size exceeded" => "無法上傳檔案, 超過最大檔案大小限制",
"Missing title or body when trying to post a comment" => "發表評論沒有標題或內文",
"You do not have permission to use this feature" => "你沒有使用此功能的權限",
"The copyright management feature is not enabled." => "版權管理功能並未啟動.",
"No page indicated" => "沒有指定頁面",
"You must supply all the information, including title and year." => "你必須提供所有資訊, 包含標題與年份.",
"Type" => "類型",
"Name" => "名稱",
"Description" => "描述",
"Size" => "大小",
"Created" => "產生",
"Last Modified" => "最近修改",
"Creator" => "建立者",
"Author" => "作者",
"Comment" => "評論",
"Files" => "檔案",
"Hits" => "點擊數",
"Locked by" => "由鎖定",
"Path" => "路徑",
"None" => "無",
"Activity" => "活動力",
"Permission denied" => "權限不足",
"The file is not a CSV file or has not a correct syntax" => "檔案不是 CSV 檔, 或是語法錯誤",
"locked" => "鎖定",
"locked by" => "由鎖定",
"in" => "於",
"continued" => "待續",
"New Image Uploaded by" => "新影像上傳自",
"New Subscriptions" => "新訂閱",
"New Item in Tracker" => "追蹤系統中有新項目",
"by" => "由",
"Image Gallery" => "影像圖庫",
"Articles" => "文章",
"Forums" => "論壇",
"Directory" => "目錄",
"File Gallery" => "檔案庫",
"Quizzes" => "測驗",
"Trackers" => "追蹤系統",
"Survey" => "調查",
"Newsletter" => "電子報",
"Charts" => "排行榜",
"article" => "文章",
"directory" => "目錄",
"forum" => "論壇",
"poll" => "投票",
"quiz" => "測驗",
"image" => "影像",
"calendar" => "行事曆",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::apply: 行數不符: %s != %s",
"WikiDiff::_check: failed" => "WikiDiff::_check: 失敗",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_check: 編輯序列並非最佳",
"Newsletter subscription information at " => "電子報註冊資訊在 ",
"Find" => "尋找",
"find" => "尋找",
"prev" => "前一個",
"Page" => "頁面",
"next" => "後一個",
"Page name" => "頁面名稱",
"Wiki Home" => "Wiki 首頁",
"Home" => "首頁",
"previous page" => "前一頁",
"next page" => "下一頁",
"posted on" => "發表於",
"Read" => "閱讀",
"List articles" => "列出文章",
"Last post" => "最新發表",
"Invalid imagename (using filters for filenames)" => "影像名稱不合法 (使用檔名過濾器)",
"Errors detected" => "偵測到錯誤",
"Upload was not successful" => "上傳失敗",
"No image yet, sorry." => "尚無影像, 抱歉.",
"unknown" => "不明",
"NONE" => "無",
"Wiki top pages" => "Wiki 首頁",
"Most relevant pages" => "最相關頁面",
"Relevance" => "相當",
"Wiki last pages" => "Wiki 末頁",
"Modified" => "已變更",
"Forums last topics" => "論壇最新話題",
"Topic date" => "主題日期",
"Forums most read topics" => "論壇最熱門話題",
"Reads" => "閱讀",
"Forums best topics" => "論壇最佳話題",
"Score" => "分數",
"Forums most visited forums" => "最熱門論壇",
"Visits" => "瀏覽數",
"Forums with most posts" => "最多文章論壇",
"Posts" => "佈告數",
"Wiki top galleries" => "Wiki 最熱門圖庫",
"Wiki top file galleries" => "Wiki 最熱門檔案庫",
"Wiki top images" => "Wiki 最熱門影像",
"Wiki top files" => "Wiki 最熱門檔案",
"Downloads" => "下傳數",
"Wiki last images" => "Wiki 最新影像",
"Upload date" => "上傳日期",
"Wiki last files" => "Wiki 最新檔案",
"Wiki top articles" => "Wiki 最熱門文章",
"Most visited blogs" => "最常被瀏覽 blogs",
"Most active blogs" => "最活躍 blog",
"Blogs last posts" => "Blogs 最新文章",
"Post date" => "發表日期",
"Wiki top authors" => "Wiki 最佳作者",
"Pages" => "頁面",
"Top article authors" => "文章最多作者",
"User already exists" => "使用者已經存在",
"Wrong registration code" => "註冊碼錯誤",
"Invalid username" => "不合法的使用者名稱",
"Username is too long" => "使用者名稱過長",
"Username cannot contain whitespace" => "使用者名稱不可含有空白",
"Wrong passcode you need to know the passcode to register in this site" => "passcode 錯誤, 你必須有 passcode 才能在本站註冊",
"Invalid email address. You must enter a valid email address" => "不正確的 email. 請輸入正確的 email 地址",
"Login" => "登入",
"Send message" => "發送訊息",
"Attach file" => "附加檔案",
"Tracker" => "追蹤",
"Image" => "影像",
"Article" => "文章",
"Forum" => "論壇",
"Gallery" => "圖庫",
"File" => "檔案",
"Blog post" => "Blog 佈告",
"Prev" => "前一個",
"Next" => "下一個",
"help" => "說明",
"All" => "全部",
"days" => "日",
"day" => "日",
"hours" => "小時",
"hour" => "小時",
"mins" => "分",
"min" => "分",
"secs" => "秒",
"done" => "完成",
"from" => "由",
"for" => "表示",
"Priority" => "重要性",
"You are not logged in" => "你尚未登入",
"Page cannot be found" => "找不到頁面",
"Help" => "說明",
"You are banned from" => "你被禁止使用",
"quizzes" => "測驗",
"forums" => "論壇",
"games" => "遊戲",
"picture not found" => "找不到圖片",
"drawing not found" => "找不到繪圖",
"at" => "於",
"new" => "增加",
"Item" => "項目",
"Tracker was modified at " => "追蹤修改於 ",
"text field" => "文字欄",
"size" => "大小",
"textarea" => "文字區",
"checkbox" => "核取盒",
"drop down" => "下拉選單",
"user selector" => "使用者選擇器",
"group selector" => "群組選擇器",
"date and time" => "日期和時間",
"action" => "動作",
"category" => "分類",
"email" => "電子郵件",
"attachment" => "附件",
"open" => "開放",
"closed" => "關閉",
"Message" => "訊息",
"child categories" => "子類別",
"objects in category" => "類別中的物件",
"Password should be at least" => "密碼應至少有",
"characters long" => "字元長",
"Password must contain both letters and numbers" => "密碼必須含有字母及數字",
"Country" => "國家",
"Date" => "日期",
"Title" => "標題",
"data" => "資料",
"users" => "使用者",
"Displays the user Avatar" => "顯示使用者頭像",
"username" => "使用者名稱",
"Insert theme styled box on wiki page" => "wiki 頁面上插入採用主題樣式的方塊",
"text" => "文字",
"Calendar" => "行事曆",
"Insert list of items for the current/given category into wiki page" => "插入目前/指定類別的項目列表至 wiki 頁面",
"Categories are disabled" => "類別功能已關閉",
"Display Tiki objects that have not been categorized" => "顯示尚未分類的 Tiki 物件",
"Insert the full category path for each category that this wiki page belongs to" => "插入此 wiki 頁面所屬的所有類別完整路徑",
"Centers the plugin content in the wiki page" => "plugin 內容置中於 wiki 頁面",
"Chart" => "排行榜",
"title" => "標題",
"code" => "碼",
"Insert copyright notices" => "插入版權宣告",
"Example" => "範例",
"minutes" => "分",
"seconds" => "秒",
"term" => "名詞",
"definition" => "定義",
"Upcoming events" => "近期事件",
"Displays the data using the Tikiwiki odd/even table style" => "使用 Tikiwiki 「奇/偶」表格樣式顯示資料",
"Displays a graphical GAUGE" => "顯示圖型化錶計",
"description" => "描述",
"Feature disabled" => "功能已關閉",
"Please choose a module" => "請選擇模組",
"to be used as argument" => "用為參數",
"Displays a module inlined in page" => "以 inline 方式在頁面上顯示模組",
"Sorry no such module" => "抱歉, 沒有這個模組",
"Displays the data using a monospace font" => "以定寬字顯示資料",
"No version indicated" => "未指定版本",
"Sorts the plugin content in the wiki page" => "在 wiki 頁面中排序外掛模組內容",
"Edit" => "編輯",
"Missing db param" => "缺少資料庫參數",
"Error" => "錯誤",
"Rating" => "評等",
"Filter" => "過濾器",
"valid" => "確認",
"ERROR: Either the subject or body must be non-empty" => "錯誤: 標題或內文不可以為空",
"ERROR: No valid users to send the message" => "錯誤: 沒有可發送訊息的合法使用者",
"Invalid user" => "不合法的使用者",
"Message sent to" => "訊息發送至",
"Message will be sent to: " => "訊息將發送至: ",
"No more messages" => "沒有訊息了",
"Create/Edit" => "建立/編輯",
"Quick Edit a Wiki Page" => "快速編輯 Wiki 頁面",
"new users" => "新使用者",
"Since your last visit" => "自從你上次拜訪",
"since" => "自",
"new comments" => "新評論",
"wiki pages changed" => "wiki 頁面已變動",
"new sites" => "新站臺",
"new images" => "新影像",
"new files" => "新檔案",
"Invalid username or password" => "使用者名稱或密碼錯誤",
"Random Image" => "隨機影像",
"List of attached files" => "附檔列表",
"id" => "編號",
"desc" => "描述",
"uploaded" => "已上傳",
"View" => "觀看",
"Delete" => "刪除",
"Remove" => "移除",
"Upload file" => "上傳檔案",
"Attach" => "附檔",
"Attach a file to this item" => "夾帶一個檔案至此項目",
"Version" => "版本",
"Attachments" => "附件",
"No attachments for this item" => "此項目無附件",
"debug" => "除錯",
"Fatal error" => "內部錯誤",
"Description:" => "描述:",
"Created by" => "產生自 ",
" on " => " 於 ",
"Post" => "發表佈告",
"Edit blog" => "編輯 blog",
"Monitor this Blog" => "監控此 blog",
"Stop Monitoring this Blog" => "停止監控此 blog",
"Activity=" => "活動力=",
"Actions" => "行動",
"No records found" => "查無記錄",
"Category" => "分類",
"Show Categories" => "顯示類別",
"Hide Categories" => "隱藏類別",
"categorize this object" => "分類這個物件",
"No categories defined" => "尚未定義類別",
"stars" => "星",
"User Level" => "使用者等級",
"private message" => "私人訊息",
"Send eMail to User" => "發送 email 至使用者",
"user online" => "使用者在線上",
"user offline" => "使用者已離線",
"Attachment" => "附件",
"Vote" => "投票",
"Save to notepad" => "儲存到筆記本",
"Monitor this Topic" => "監控此主題",
"Stop Monitoring this Topic" => "停止監控此主題",
"Moderator actions" => "板主命令",
"reported:" => "已回報項目:",
"queued:" => "佇列中:",
"Move to topic:" => "移動至主題:",
"Move" => "移動",
"Delete Selected" => "刪除選擇項目",
"Messages" => "訊息",
"Sort" => "排序",
"Title (desc)" => "標題 (降冪)",
"Title (asc)" => "標題 (升冪)",
"Threshold" => "起算點",
"Search" => "搜尋",
"Set" => "設定",
"Replies" => "回覆數",
"Preview" => "預覽",
"Editing comment" => "編輯評論",
"Post new comment" => "發表新評論",
"Required" => "必須",
"Smileys" => "表情符號",
"Cancel" => "取消",
"Posting comments" => "發表評論",
"Use" => "使用",
"or" => "或",
"for links" => "表示連結",
"Go back" => "回上頁",
"Return to home page" => "返回首頁",
"Copyrights" => "版權所有",
"Year" => "年",
"Authors" => "作者",
"Add" => "加入",
"Syntax" => "語法",
"Page generation debugging log" => "頁面生成除錯用紀錄",
"Features state" => "功能狀態",
"Total" => "全部",
"features matched" => "符合的功能",
"Watchlist" => "監視列表",
"duplicate" => "重複",
"There are individual permissions set for this file gallery" => "這個檔案庫有獨立的權限設定",
"Save" => "儲存",
"Gallery is visible to non-admin users?" => "允許非管理者用戶看到?",
"none" => "無",
"Max description display size" => "最大描述顯示大小",
"Max Rows per page" => "每頁最大列數",
"Listing configuration" => "列表設定",
"Perms" => "權限",
"Display" => "顯示",
"Unlock" => "解除鎖定",
"Lock" => "鎖定",
"Name-filename" => "名稱-檔名",
"Filename only" => "僅檔名",
"Number of displayed rows" => "顯示的列數",
"Move Selected Files" => "移動選擇的檔案",
"Move to" => "移動至",
"Filename" => "檔案",
"Hi {\$mail_user} has sent you this link:" => "Hi {\$mail_user} 寄給你這個連結:",
"Blog post:" => "Blog 佈告:",
"at:" => "於:",
"Somebody or you tried to subscribe this email address at our site:" => "某人或是你試圖以此 email 地址訂閱本站的電子報:",
"To the newsletter:" => "訂閱的電子報:",
"In order to confirm your subscription you must access the following URL:" => "你必須連接至以下的 URL 以確認訂閱:",
"A new message was posted to forum" => "新訊息發表於論壇",
"Tiki mail-in instructions" => "Tiki mail-in 說明",
"A new message was posted to you at {\$mail_machine}" => "有新訊息於 {\$mail_machine} 發表給你",
"From" => "由",
"Subject" => "主題",
"Enjoy the site!" => "好好享受本站的資源!",
"The user" => "使用者",
"registered at your site" => "在你的站臺註冊",
"New user registration" => "新使用者註冊",
"This email address has been removed to the list of subscriptors of:" => "此 email 地址已被移出訂閱列表:",
"Newsletter:" => "電子報:",
"You can unsubscribe from this newsletter following this link" => "你可以使用以下的連結停止訂閱本電子報",
"Welcome to our newsletter!" => "歡迎加入我們的電子報!",
"This email address has been added to the list of subscriptors of:" => "此 email 地址已被加入訂閱列表:",
"You can always cancel your subscription using:" => "你可以這樣取消你的訂閱:",
"Tiki email notification" => "Tiki email 通知",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "{\$mail_user} 傳送新文章至 {\$mail_site} 於 {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "你可以使用此連結修改送出的資料:",
"Title:" => "標題:",
"Heading:" => "標題:",
"Body:" => "本文:",
"you or someone registered this email address at" => "你或是某位註冊此 email 地址的人",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "如果你要成為本站的註冊使用者, 必須使用以下連結進行第一次登入:",
"Your Tiki information registration" => "你的 Tiki 資訊登記",
"You will receive an email with information to login for the first time into this site" => "你將會收到 email 說明初次登入本站的資訊",
"If you don't want to receive these notifications follow this link:" => "如果你不想再收到這些通知請使用此連結:",
"View the blog at:" => "檢視此 blog 於:",
"changed" => "更改",
"created" => "建立",
"New" => "增加",
"File Description" => "檔案描述",
"Object" => "物件",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "此頁面 {\$mail_page} 由 {\$mail_user} 更改於 {\$mail_date|tiki_short_datetime}",
"Comment:" => "評論:",
"New name" => "新名稱",
"Go" => "衝",
"Comments" => "評論",
"Last modification date" => "上次修改日期",
"Create" => "建立",
"History" => "歷史紀錄",
"Compare" => "比較",
"Current" => "目前",
"Versions are identical" => "版本相同",
"User" => "使用者",
"Action" => "動作",
"Diff" => "比對差異",
"Unread" => "未閱讀",
"Flagged" => "標記",
"Unflagged" => "已解除標記",
"Containing" => "包含",
"Sender" => "寄件者",
"No messages to display" => "沒有訊息可顯示",
"Broadcast message" => "廣播訊息",
"OK" => "ok",
"Group" => "群組",
"All users" => "所有使用者",
"Lowest" => "最低",
"Low" => "低",
"Normal" => "正常",
"High" => "高",
"Very High" => "非常高",
"Send" => "發送",
"Compose message" => "撰寫訊息",
"To" => "至",
"Mark as read" => "設為閱讀",
"Mark as unread" => "設為未讀",
"Mark as flagged" => "設為已標記",
"Mark as unflagged" => "設為未標記",
"Mark" => "標計",
"Mailbox" => "信件匣",
"Compose" => "編寫",
"Broadcast" => "廣播",
"Read message" => "閱讀訊息",
"replyall" => "回覆全部",
"Flag this message" => "標記此訊息",
"No" => "否",
"Up" => "上",
"Down" => "下",
"Admin Menu" => "管理選單",
"Live support" => "線上支援",
"Banning" => "禁用",
"Users" => "使用者",
"Groups" => "群組",
"Cache" => "快取",
"Modules" => "模組",
"Links" => "連結",
"Hotwords" => "熱門單字",
"RSS modules" => "RSS 模組",
"Menus" => "選單",
"Polls" => "測驗紀錄",
"Mail notifications" => "郵件通知",
"Search stats" => "搜尋統計",
"Chat" => "閒談",
"Categories" => "分類",
"Banners" => "大標題",
"Edit templates" => "編輯模板",
"Admin drawings" => "管理繪圖",
"Dynamic content" => "動態內容",
"Content templates" => "內容模板",
"HTML pages" => "HTML頁面",
"Referer stats" => "參照頁面統計",
"Admin dsn" => "管理 dsn",
"External wikis" => "外部 wikis",
"Syntax highlighting" => "語法強調",
"Menu" => "選單",
"Contact us" => "聯絡我們",
"Stats" => "狀態",
"Games" => "遊戲",
"MyTiki" => "我的Tiki",
"Preferences" => "使用偏好",
"Tasks" => "任務",
"Bookmarks" => "書籤",
"Newsreader" => "News閱讀器",
"Notepad" => "筆記本",
"My files" => "我的檔案",
"User menu" => "使用者選單",
"Mini calendar" => "迷你月曆",
"My watches" => "我的監視",
"Workflow" => "工作流程",
"User activities" => "使用者行動",
"Last changes" => "最近變動",
"Dump" => "傾印",
"Rankings" => "排名",
"List pages" => "列出頁面",
"Orphan pages" => "孤立頁面",
"Sandbox" => "沙池",
"Print" => "列印",
"Received pages" => "已接收頁面",
"Structures" => "結構",
"Image Galleries" => "影像圖庫",
"Galleries" => "圖庫",
"Upload image" => "上傳影像",
"System gallery" => "系統圖庫",
"Articles home" => "文章首頁",
"Submit article" => "傳送文章",
"View submissions" => "檢視意見",
"Send articles" => "發送文章",
"Received articles" => "已接收文章",
"Admin topics" => "管理主題",
"List blogs" => "列出 blogs",
"Admin posts" => "管理佈告",
"List forums" => "列出論壇",
"Admin forums" => "管理論壇",
"Submit a new link" => "送出新連結",
"Admin directory" => "管理目錄",
"File Galleries" => "檔案庫",
"List galleries" => "列出檔案庫",
"List FAQs" => "列出 FAQs",
"Admin FAQs" => "管理 FAQs",
"Quiz stats" => "測驗統計",
"Admin quiz" => "管理測驗",
"List trackers" => "列出追蹤",
"Admin trackers" => "管理追蹤",
"Surveys" => "調查",
"List surveys" => "列出調查",
"Admin surveys" => "管理調查",
"Newsletters" => "電子報",
"Send newsletters" => "寄出電子報",
"Admin newsletters" => "管理電子報",
"Ephemerides" => "日曆",
"Admin" => "管理",
"Theme control" => "佈景控制",
"Drawings" => "繪圖",
"Edit languages" => "編輯語言",
"Click here to manage your personal menu" => "點擊此處可管理你的個人選單",
"User Menu" => "使用者選單",
"Select" => "選擇",
"Admin Modules" => "管理模組",
"Admin Menus" => "管理選單",
"login" => "登入",
"Recently visited pages" => "最近拜訪頁面",
"January" => "一月",
"February" => "二月",
"March" => "三月",
"April" => "四月",
"May" => "五月",
"June" => "六月",
"July" => "七月",
"August" => "八月",
"September" => "九月",
"October" => "十月",
"November" => "十一月",
"December" => "十二月",
"Monday" => "星期一",
"Tuesday" => "星期二",
"Wednesday" => "星期三",
"Thursday" => "星期四",
"Friday" => "星期五",
"Saturday" => "星期六",
"Sunday" => "星期日",
"Today" => "今天",
"Received objects" => "接收的物件",
"Pages:" => "頁面:",
"Last Sites" => "最新站臺",
"Directory Stats" => "目錄狀態",
"Sites" => "站臺",
"Sites to validate" => "待確認的站臺",
"Searches" => "搜尋",
"Visited links" => "已拜訪連結",
"Top Sites" => "熱門站臺",
"Featured links" => "主打連結",
"Top topics" => "最熱門主題",
"Last forum topics" => "最新論壇主題",
"Most commented forums" => "最多評論論壇",
"Most read topics" => "最多閱讀主題",
"Most visited forums" => "最多訪客論壇",
"Google Search" => "Google 搜尋",
"Last blog posts" => "最新 blog 佈告",
"Last" => "最近",
"Last Created blogs" => "最近建立 blogs",
"Last Created FAQs" => "最近建立 FAQS",
"Last Created Quizzes" => "最近建立的測驗",
"Last modified file galleries" => "最近更新的檔案庫",
"Last Files" => "最近檔案",
"Last galleries" => "最新圖庫",
"Last Modified Items" => "上一個修改項目",
"Last Modified blogs" => "最近修改 blogs",
"Last submissions" => "最近送交文章",
"Last Items" => "上一個項目",
"Register" => "註冊",
"Open operator console" => "開啟服務員介面",
"Online users" => "線上使用者",
"We have" => "我們有",
"online users" => "線上使用者",
"Logout" => "登出",
"Switch" => "轉換",
"Email" => "電子郵件",
"eMail" => "電子郵件",
"Password" => "密碼",
"Remember me" => "記住我的身份",
"I forgot my pass" => "忘記密碼",
"I forgot my password" => "忘記密碼",
"Standard" => "標準",
"Secure" => "安全",
"Stay in ssl Mode" => "保留在 ssl 模式",
"Tiki Logo" => "Tiki 圖示",
"You have" => "你有",
"New Messages" => "新訊息",
"New Message" => "件新訊息",
"You have 0 new messages" => "你有 0 封新訊息",
"Waiting Submissions" => "等待送交文章",
"submissions waiting to be examined" => "等待檢查的文章",
"Old articles" => "舊文章",
"Send a message to" => "發送訊息至",
"Random Pages" => "隨機頁面",
"Register as a new user" => "註冊新使用者",
"Your email could not be validated; make sure you email is correct and click register below." => "你的 email 無法確認; 請確認你的 email 輸入正確並按下註冊鍵.",
"Your registration code:" => "你的註冊碼:",
"Username" => "使用者名稱",
"Passcode to register (not your user password)" => "註冊用 Passcode (並非你的使用者密碼)",
"Registration code" => "註冊碼",
"Repeat password" => "再次輸入密碼",
"Generate a password" => "產生一個密碼",
"in:" => "於:",
"Entire Site" => "整個網站",
"Wiki Pages" => "Wiki 頁面",
"Image Gals" => "影像圖庫",
"Images" => "影像",
"Blog Posts" => "Blog 佈告",
"Search Wiki PageName" => "搜尋 Wiki 頁面名稱",
"Read More" => "繼續閱讀",
"Since your last visit on" => "自從你上次拜訪由",
"New Images" => "新影像",
"Wiki Pages Changed" => "wiki 頁面已變動",
"New Files" => "新檔案",
"New Comments" => "新評論",
"New Users" => "新使用者",
"click to edit" => "點擊可編輯",
"Most Active blogs" => "最活躍 blogs",
"Top articles" => "最熱門文章",
"Top File Galleries" => "最熱門檔案庫",
"Top games" => "最熱門遊戲",
"Top galleries" => "最熱門圖庫",
"Top Images" => "最熱門影像",
"Top Pages" => "最熱門頁面",
"Top Quizzes" => "最熱門測驗",
"Top Visited FAQs" => "最熱門 FAQs",
"view" => "觀看",
"My blogs" => "我的 blogs",
"My galleries" => "我的圖庫",
"My Pages" => "我的頁面",
"User tasks" => "使用者任務",
"Done" => "完成",
"Del" => "清除",
"online user" => "線上使用者",
"Real Name" => "真實姓名",
"vote" => "投票",
"Locked" => "鎖定",
"Cached" => "已快取",
"Refresh" => "重新整理",
"Monitor this Page" => "監視此頁面",
"Stop Monitoring this Page" => "停止監控此頁面",
"Backlinks" => "反向連結",
"Previous page" => "前一頁",
"Next page" => "後一頁",
"Add Page" => "增加頁面",
"First page" => "首頁",
"page" => "頁面",
"Last page" => "末頁",
"To edit the copyright notices" => "要編輯版權宣告",
"Click Here" => "點擊此處",
"The content on this page is licensed under the terms of the" => "本頁面的內容根據以下條文授權",
"The original document is available at" => "原始文件位於",
"Translation" => "翻譯",
"Article image" => "文章圖片",
"Topic image" => "主題影像",
"Source" => "來源",
"Add Comment" => "增加評論",
"1 comment" => "1 篇評論",
"comments" => "評論",
"Rename" => "更名",
"Similar" => "相似",
"Undo" => "回復",
"Slides" => "幻燈片",
"Export" => "匯出",
"Discuss" => "討論",
"Attach File" => "附加檔案",
"1 File Attached" => "1 個附加檔案",
"{\$atts_cnt} files attached" => "{\$atts_cnt} 個附加檔案",
"Last Modification" => "最後修改",
"logged as" => "登入為",
"pass" => "密碼",
"Page generated in" => "本頁面產生花費",
"The newsletter was sent to {\$sent} email addresses" => "電子報已發送至 {\$sent} email 地址",
"This newsletter will be sent to {\$subscribers} email addresses." => "電子報已發送至 {\$subscribers} email 地址.",
"Prepare a newsletter to be sent" => "準備將要送出的電子報",
"Apply template" => "套用模板",
"Data" => "資料",
"Send Newsletters" => "送出電子報",
"Sent editions" => "送出版本",
"sent" => "送出",
"Last Changes" => "最新變動",
"Edit article" => "編輯文章",
"Backups" => "備份",
"User files" => "使用者檔案",
"Favorites" => "我的最愛",
"Watches" => "監視",
"home" => "首頁",
"chat" => "閒談",
"contact us" => "連絡我們",
"dump" => "傾印",
"rankings" => "排名",
"List Pages" => "列出頁面",
"orphan pages" => "孤立頁面",
"sandbox" => "沙池",
"received pages" => "已接收頁面",
"structures" => "結構",
"Articles Home" => "文章首頁",
"Create/Edit Blog" => "建立/編輯 Blog",
"Browse Directory" => "瀏覽目錄",
"List Quizzes" => "列出測驗",
"List Trackers" => "列出追蹤項目",
"List Surveys" => "列出調查",
"Back to Homepage" => "回到首頁",
"This page is being edited by" => "此頁面被編輯中:",
"Proceed at your own peril" => "請自己小心",
"Copyright" => "版權所有",
"Year:" => "年:",
"Authors:" => "作者:",
"Allow HTML" => "允許 HTML",
"Spellcheck" => "拼字檢查 ",
"Import page" => "匯入頁面 ",
"export all versions" => "匯出所有版本",
"Upload picture" => "上傳圖片",
"no cache" => "無快取",
"minute" => "分",
"License" => "授權",
"Important" => "重要",
"Minor" => "次要",
"Cancel Edit" => "取消編輯",
"debugger console" => "除錯器控制臺",
"Mini Calendar" => "迷你月曆",
"Quick edit a Wiki page" => "快速編輯 Wiki 頁面",
"Language" => "語言",
"Edit Post" => "編輯文章",
"Use wysiwyg editor" => "使用所見即所得編輯器",
"Use normal editor" => "使用一般編輯器",
"View Blog" => "觀看 blog",
"List Blogs" => "列出 Blogs",
"Use ...page... to separate pages in a multi-page post" => "使用 ...頁面... 將頁面分隔為多重頁面",
"Upload image for this post" => "上傳影像至此文章",
"Trash" => "垃圾桶",
"Save and Exit" => "儲存並離開",
"This is" => "這是",
"by the" => "由",
"Find:" => "尋找:",
"Sort posts by:" => "排序佈告依據:",
"read more" => "詳細閱讀",
"pages" => "頁面",
"Permalink" => "固定連結",
"View Comments" => "觀看評論",
"Email This Post" => "email 此文章",
"Viewing blog post" => "觀看 blog 佈告",
"Return to blog" => "返回 blog",
"Blog name" => "Blog 名稱",
"Tools Calendars" => "工具行事曆",
"Check / Uncheck All" => "全選/全取消",
"Activate" => "啟動",
"Content" => "內容",
"Publish" => "發表",
"General" => "一般",
"Features" => "功能",
"Module" => "模組",
"Home Blog" => "主 Blog",
"Home Blog (main blog)" => "首頁 Blog (主要 blog)",
"Blog features" => "Blog 功能",
"Spellchecking" => "拼字檢查",
"Default ordering for blog listing" => "blog列表預設順序",
"Creation date (desc)" => "建立日期 (降冪)",
"Last modification date (desc)" => "最近修改日期 (降冪)",
"Blog title (asc)" => "Blog 標題 (升冪)",
"Number of posts (desc)" => "佈告數 (降冪)",
"Visits (desc)" => "拜訪數 (降冪)",
"Activity (desc)" => "活動力 (降冪)",
"Change preferences" => "更改偏好",
"Blog listing configuration (when listing available blogs)" => "Blog 列表設定 (列出現有 blog時)",
"Disabled" => "關閉",
"Plain text" => "純文字",
"Link to user information" => "連結至使用者資訊",
"User avatar" => "使用者頭像",
"Blog comments settings" => "Blog評論設定",
"Default number of comments per page" => "預設每頁評論數目",
"Comments default ordering" => "預設評論排序",
"Points" => "分數",
"Week" => "週",
"Month" => "月",
"5 minutes" => "5 分鐘",
"Show Category Path" => "顯示類別路徑",
"Show Category Objects" => "顯示類別物件",
"CMS features" => "CMS 功能",
"Submissions" => "提交",
"Use templates" => "使用模板",
"Maximum number of articles in home" => "首頁最大文章數",
"Topic" => "主題",
"Article comments settings" => "文章評論設定",
"Publish Date" => "發表日期",
"Img" => "影像",
"Import CSV file" => "匯入 CSV 檔案",
"Import" => "匯入",
"Last login" => "最近登入",
"Set features" => "設定功能",
"Copyright Management" => "版權管理",
"License Page" => "授權頁面",
"Submit Notice" => "發送時提示",
"Number of columns per page when listing categories" => "當列出分類時每頁欄位數",
"Links per page" => "每頁連結數",
"Validate URLs" => "確認 URLs",
"Method to open directory links" => "打開目錄連結的方法",
"replace current window" => "取代目前視窗",
"New Window" => "新的視窗",
"inline frame" => "行內頁框",
"Featured Help" => "主打說明",
"Live Support" => "線上支援",
"Live support system" => "線上支援系統",
"Workflow engine" => "工作流程引擎",
"Content Features" => "內容功能",
"Edit Templates" => "編輯模板",
"Hotwords in New Windows" => "以新視窗顯示熱門單字",
"Custom Home" => "自訂首頁",
"HTML Pages" => "HTML 頁面",
"Dynamic Content System" => "動態內容系統",
"Administration Features" => "管理功能",
"Banning System" => "禁用系統",
"Banning system" => "禁用系統",
"Debugger Console" => "除錯器控制臺",
"Referer Stats" => "參照頁統計",
"Contact Us" => "連絡我們",
"Communications (send/receive objects)" => "通訊 (發送/接受 物件)",
"User Features" => "使用者功能",
"User Preferences Screen" => "使用者偏好畫面",
"User Notepad" => "使用者記事本",
"User Bookmarks" => "使用者書籤",
"User Watches" => "使用者監視",
"User Tasks" => "使用者工作",
"User Messages" => "使用者訊息",
"User Files" => "使用者檔案",
"Home Gallery (main gallery)" => "首頁圖庫 (主圖庫)",
"Galleries features" => "圖庫功能",
"Never" => "從不",
"Use database to store files" => "使用資料庫來儲存檔案",
"Use a directory to store files" => "使用資料夾來儲存檔案",
"Directory path" => "資料夾路徑",
"Uploaded filenames must match regex" => "上傳檔案名稱必須符合正規表示式",
"Uploaded filenames cannot match regex" => "上傳檔案名稱不得符合正規表示式",
"Gallery listing configuration" => "圖庫列表設定",
"File galleries comments settings" => "檔案總覽評論設定",
"Home Forum (main forum)" => "首頁論壇 (主論壇)",
"Accept wiki syntax" => "接受 wiki 語法",
"Forum quick jumps" => "論壇快速跳躍",
"Ordering for forums in the forum listing" => "在論壇列表中論壇的順序",
"Creation Date (desc)" => "建立日期 (降冪)",
"Topics (desc)" => "主題 (降冪)",
"Threads (desc)" => "討論串 (降冪)",
"Last post (desc)" => "最近發表佈告 (降冪)",
"Name (desc)" => "名稱 (降冪)",
"Name (asc)" => "名稱 (升冪)",
"Forum listing configuration" => "論壇列表設定",
"Topics" => "主題",
"Posts per day" => "每日發表數",
"Use database to store images" => "使用資料庫來儲存影像",
"Use a directory to store images" => "使用資料夾來儲存影像",
"Library to use for processing images" => "用於處理影像的程式庫",
"Uploaded image names must match regex" => "上傳影像名稱必須符合正規表示式",
"Uploaded image names cannot match regex" => "上傳影像名稱不得符合正規表示式",
"Yes" => "是",
"Images per row" => "每列影像數",
"Thumbnails size X" => "縮圖大小 X",
"Thumbnails size Y" => "縮圖大小 Y",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "移除系統圖庫中沒有用於 Wiki 頁面, 文章或 blog 佈告的影像",
"All galleries" => "所有的圖庫",
"Parent" => "父系",
"Last modified" => "最近改變",
"Image galleries comments settings" => "影像圖庫評論設定",
"General Preferences" => "一般偏好",
"Use URI as Home Page" => "使用 URI 當首頁",
"Home page" => "首頁",
"Custom home" => "自訂首頁",
"OS" => "作業系統",
"Unknown/Other" => "未知/其他",
"General Settings" => "一般設定",
"Use cache for external pages" => "快取外部頁面",
"Use cache for external images" => "快取外部影像",
"Tikiwiki.org help" => "Tikiwiki.org 說明",
"Use gzipped output" => "使用 gzipp 壓縮輸出",
"Count admin pageviews" => "計算管理頁面瀏覽數",
"Browser title" => "瀏覽器標題",
"Temporary directory" => "暫存目錄",
"Sender Email" => "發送者 Email",
"Contact user" => "聯絡使用者",
"contact feature disabled" => "聯絡功能已關閉",
"Maximum number of records in listings" => "列表中版本最大數目",
"Date and Time Formats" => "日期與時間格式",
"Long date format" => "長日期格式",
"Short date format" => "短日期格式",
"Long time format" => "長時間格式",
"Short time format" => "短時間格式",
"Date and Time Format Help" => "日期與時間格式說明",
"Change admin password" => "更改管理者密碼",
"New password" => "新密碼",
"Change password" => "更改密碼",
"Use database for translation" => "使用資料庫存放翻譯",
"Edit or ex/import Languages" => "編輯或  匯出/匯入語言",
"Record untranslated" => "記錄未翻譯項目",
"port" => "連接埠",
"Contact" => "聯絡",
"User registration and login" => "使用者註冊與登入",
"Authentication method" => "認證方式",
"Just Tiki" => "僅 Tiki",
"Web Server" => "網站伺服器",
"Tiki and PEAR::Auth" => "Tiki 與 PEAR::Auth",
"Tiki and HTTP Auth" => "Tiki 與 HTTP Auth",
"Use WebServer authentication for Tiki" => "使用網站伺服器為 Tiki 認證",
"Users can register" => "允許使用者註冊",
"Request passcode to register" => "須用 passcode 才能註冊",
"Prevent automatic/robot registration" => "防止自動/機器人註冊",
"Validate users by email" => "用email確認使用者",
"Store plaintext passwords" => "儲存明文密碼",
"Reg users can change theme" => "允許註冊使用者更改佈景",
"Reg users can change language" => "允許註冊使用者更改語言",
"Use challenge/response authentication" => "使用安全回應認證",
"Force to use chars and nums in passwords" => "強制在密碼中使用字元和數字",
"Minimum password length" => "最小密碼長度",
"Password invalid after days" => "密碼在幾天後到期",
"Allow secure (https) login" => "允許安全 (https) 登入",
"Require secure (https) login" => "需要安全 (https) 登入",
"HTTP port" => "HTTP 埠",
"HTTPS port" => "HTTPS 埠",
"Remember me feature" => "記憶登入功能",
"Duration:" => "持續時間:",
"week" => "週",
"month" => "月",
"Create user if not in Tiki?" => "如果 Tiki 中無使用者則建立帳號?",
"Create user if not in Auth?" => "如果 Auth 中無使用者則建立帳號?",
"Just use Tiki auth for admin?" => "僅 admin 帳號使用 Tiki 認證?",
"LDAP Host" => "LDAP 主機",
"LDAP Port" => "LDAP 連接埠",
"LDAP Scope" => "LDAP 領域",
"LDAP Base DN" => "LDAP 主 DN",
"LDAP User DN" => "LDAP 使用者 DN",
"LDAP User Attribute" => "LDAP 使用者屬性",
"LDAP User OC" => "LDAP 使用者 OC",
"LDAP Group DN" => "LDAP 群組 DN",
"LDAP Group OC" => "LDAP 群組 OC",
"LDAP Member Attribute" => "LDAP 成員屬性",
"LDAP Admin User" => "LDAP 管理者",
"LDAP Admin Pwd" => "LDAP 管理者密碼",
"Theme" => "佈景主題",
"Number of visited pages to remember" => "拜訪過頁面保留筆數",
"Displayed time zone" => "顯示時區",
"User information" => "使用者資訊",
"Private" => "私人",
"public" => "公開",
"Messages per page" => "每頁訊息數",
"Allow messages from other users" => "允許其他使用者的訊息",
"Send me an email for messages with priority equal or greater than" => "發送 email 通知, 當訊息重要性大於等於",
"Tasks per page" => "每頁工作數",
"My Tiki" => "我的 Tiki",
"My pages" => "我的頁面",
"My messages" => "我的訊息",
"My tasks" => "我的工作",
"My items" => "我的事項",
"Slideshows theme" => "幻燈片主題",
"Edit CSS" => "編輯 CSS",
"Theme Control" => "佈景主題控制",
"General Layout options" => "一般版面配置選項",
"Left column" => "左欄",
"Right column" => "右欄",
"Bottom bar" => "最下列",
"Use direct pagination links" => "使用直接頁數連結",
"Display menus as folders" => "用資料夾方式顯示選單",
"Layout per section" => "每區段版面配置",
"Admin layout per section" => "管理每區段的版面配置",
"Display modules to all groups always" => "所有的群組都顯示模組",
"List" => "列表",
"Image galleries" => "圖庫",
"Feed for forums" => "Feed for 論壇",
"random" => "隨機",
"Allow Smileys" => "允許表情符號",
"Open external links in new window" => "於新視窗開啟外部連結",
"dls" => "下傳數",
"Change" => "更改",
"Quota (Mb)" => "配額 (Mb)",
"Use database to store userfiles" => "使用資料庫儲存使用者檔案",
"Use a directory to store userfiles" => "使用目錄儲存使用者檔案",
"Allow viewing HTML mails?" => "允許閱讀 HTML 郵件?",
"Maximum size for each attachment" => "每個附件的最大大小",
"Unlimited" => "未限制",
"Dumps" => "傾印",
"Generate dump" => "產生傾印",
"Download last dump" => "下傳最新的傾印",
"restore" => "回復",
"Export Wiki Pages" => "匯出 Wiki 頁面",
"Wiki attachments" => "Wiki 附件",
"Remove unused pictures" => "移除未使用的圖片",
"Wiki Home Page" => "Wiki 首頁",
"Wiki Discussion" => "Wiki 討論",
"Discuss pages on forums" => "在論壇上討論頁面",
"Last version" => "最近版本",
"Status" => "狀態",
"Versions" => "版本",
"Wiki Features" => "Wiki 功能",
"|| for rows" => "|| 表示一列",
"Top bar" => "最上列",
"Wiki History" => "Wiki 歷史",
"Wiki Watch" => "Wiki 監視",
"Restore defaults" => "回復預設值",
"User:" => "使用者:",
"bytes" => "位元組",
"Statistics" => "統計",
"Days" => "數日",
"Weeks" => "數週",
"viewed" => "被瀏覽",
"Add or edit a rule" => "增加或編輯規則",
"Rule title" => "規則名稱",
"Username regex matching" => "使用者名稱符合正規表示式",
"IP regex matching" => "IP 符合正規表示式",
"Banned from sections" => "禁用下列區段",
"Rule activated by dates" => "規則依日期啟用",
"Rule active from" => "規則起始日期",
"Rule active until" => "規則結束日期",
"Custom message to the user" => "給使用者的自訂訊息",
"Rules" => "規則",
"User/IP" => "使用者/IP",
"Sections" => "區段",
"Admin Calendars" => "管理行事曆",
"List of Calendars" => "行事曆列表",
"Loc" => "位置",
"Participants" => "參與者",
"Cat" => "類別",
"Lang" => "語系",
"Prio" => "重要性",
"Permissions" => "權限",
"Create/edit Calendars" => "建立/編輯行事曆",
"Custom Locations" => "自訂位置",
"Custom Categories" => "自訂類別",
"Custom Languages" => "自訂語系",
"Custom Priorities" => "自訂重要性",
"Current category" => "目前分類",
"Child categories" => "子類別",
"Edit this category:" => "編輯此類別:",
"Create New" => "建立新的",
"Add new category" => "加入新類別",
"Objects in category" => "分類中的物件",
"Add objects to category" => "增加物件到分類中",
"image gal" => "圖庫",
"file gal" => "檔案庫",
"Poll" => "投票",
"Admin chart items" => "管理排行榜項目",
"charts" => "排行榜",
"Edit Chart" => "編輯排行榜",
"Add or edit an item" => "增加或編輯一個項目",
"Update" => "更新",
"Chart items" => "排行榜項目",
"No items defined yet" => "尚未定義項目",
"Admin charts" => "管理排行榜",
"Add or edit a chart" => "增加或編輯排行榜",
"Active" => "啟動",
"Users can suggest new items" => "使用者可以建議新選項",
"Auto validate user suggestions" => "自動確認使用者的建議",
"Ranking shows" => "顯示排行榜",
"All items" => "所有項目",
"Top 10 items" => "前 10 項",
"Top 20 items" => "前 20 項",
"Top 40 items" => "前 40 項",
"Top 50 items" => "前 50 項",
"Top 100 items" => "前 100 項",
"Top 250 items" => "前 250 項",
"Voting system" => "投票系統",
"Vote items" => "票選項目",
"Rank 1..5" => "排名 1..5",
"Rank 1..10" => "排名 1..10",
"Ranking frequency" => "排行榜頻率",
"Realtime" => "即時",
"Each 5 minutes" => "每 5 分鐘",
"Daily" => "每日",
"Weekly" => "每週",
"Monthly" => "每月",
"Show Average" => "顯示平均",
"Show Votes" => "顯示票數",
"Use Cookies for unregistered users" => "未註冊使用者使用 cookies",
"Users can vote again after" => "允許再次投票於",
"Anytime" => "隨時",
"1 day" => "1 天",
"1 week" => "1 週",
"1 month" => "1 個月",
"Items" => "項目",
"Ranks" => "排名",
"No charts defined yet" => "尚未定義排行榜",
"Chat Administration" => "閒談管理",
"Create/edit channel" => "建立/編輯 頻道",
"Refresh rate" => "更新率",
"second" => "秒",
"Chat channels" => "聊天頻道",
"Admin templates" => "管理模板",
"Edit this template:" => "編輯此模板:",
"Create new template" => "產生新模板",
"Template" => "模板",
"Templates" => "模板",
"Last Modif" => "最近修改",
"Settings" => "設定",
"Admin cookies" => "管理 cookies",
"Create/edit cookies" => "建立/編輯 cookies",
"Upload Cookies from textfile" => "由文字檔上傳 Cookies",
"Upload from disk:" => "由磁碟上傳: ",
"Upload" => "上傳",
"Remove all cookies" => "移除所有cookies",
"Available drawings" => "現存繪圖",
"Ver" => "版本",
"Create/edit dsn" => "建立/編輯 dsn",
"Admin external wikis" => "管理外部 wiki",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (在URL中使用 \$page 來取代 page, 例如: http://www.example.com/tiki-index.php?page=\$page)",
"ExtWiki" => "外部wiki",
"Admin Forums" => "管理論壇",
"Edit this Forum:" => "編輯此論壇:",
"Create New Forum" => "建立新論壇",
"There are individual permissions set for this forum" => "這個論壇有獨立權限設定",
"Show description" => "顯示描述",
"Prevent flooding" => "防止灌水",
"Minimum time between posts" => "發表佈告的最小間隔時間",
"Section" => "區段",
"Create new" => "建立新的",
"Moderator user" => "管理者帳號",
"Moderator group" => "管理者群組",
"Password protected" => "受密碼保護",
"Topics only" => "僅主題",
"All posts" => "全部文章",
"Forum password" => "論壇密碼",
"Send this forums posts to this email" => "寄送此論壇文章到這個電子郵件",
"Prune unreplied messages after" => "刪去未回覆的訊息於",
"Prune old messages after" => "刪去舊訊息於",
"Topic list configuration" => "主題列表設定",
"Add messages from this email to the forum" => "將來自此 email 的訊息增加至論壇",
"POP3 server" => "POP3 伺服器",
"Use topic smileys" => "主題可使用表情符號",
"Show topic summary" => "顯示主題統計",
"User information display" => "顯示使用者資料",
"Avatar" => "頭像",
"Flag" => "國旗",
"Online" => "線上",
"Approval type" => "核可方式",
"All posted" => "所有文章",
"Queue anonymous posts" => "保留匿名文章",
"Queue all posts" => "保留所有文章",
"No attachments" => "禁止附件",
"Everybody can attach" => "允許任何人附件",
"Only users with attach permission" => "只允許有附件權限的使用者",
"Moderators and admin can attach" => "只允許板主與管理者",
"Store attachments in:" => "儲存附件於:",
"Database" => "資料庫",
"Max attachment size (bytes)" => "最大附件大小 (bytes)",
"Default ordering for topics" => "預設主題排列順序",
"Date (desc)" => "日期 (降冪)",
"Date (asc)" => "日期 (升冪)",
"Score (desc)" => "分數 (降冪)",
"Replies (desc)" => "回覆 (降冪)",
"Reads (desc)" => "閱讀 (降冪)",
"Topics per page" => "每頁主題數",
"Default ordering for threads" => "預設討論串排列順序",
"Coms" => "coms",
"Age" => "年齡",
"PPD" => "每日發表數",
"Last Post" => "最近發表佈告",
"Admin Hotwords" => "管理熱門單字",
"Add Hotword" => "加入熱門字眼",
"Word" => "單字",
"Admin HTML pages" => "管理 HTML 頁面",
"Edit this page" => "編輯此頁面",
"View page" => "觀看頁面",
"Edit zone" => "編輯區域",
"Zone" => "區域",
"Dynamic zones" => "動態區域",
"zone" => "區域",
"content" => "內容",
"Mass update" => "大量更新",
"Create new HTML page" => "建立新 HTML 頁面",
"Edit this HTML page:" => "編輯此 HTML 頁面:",
"Dynamic" => "動態",
"Static" => "靜態",
"Start" => "開始",
"Admin layout" => "管理版面配置",
"layout options" => "版面配置選項",
"Generate positions by hits" => "由點擊數產生位置",
"List of featured links" => "列出主打連結",
"Position" => "位置",
"Add Featured Link" => "加入主打連結",
"Edit this Featured Link:" => "編輯此主打連結:",
"Create new Featured Link" => "建立新主打連結",
"disables the link" => "關閉此連結",
"Link type" => "連結類型",
"replace current page" => "取代目前頁面",
"framed" => "頁框",
"open new window" => "開啟新視窗",
"Account name" => "帳號名稱",
"POP server" => "POP 伺服器",
"Port" => "埠",
"SMTP server" => "SMTP 伺服器",
"SMTP requires authentication" => "SMTP 需要認證",
"Frequency" => "頻率",
"List menus" => "列出選單",
"Edit this menu" => "編輯此選單",
"Edit menu options" => "編輯選單項目",
"Some useful URLs" => "一些有用的 URL 們",
"option" => "選項",
"Home Page" => "首頁",
"Home Image Gal" => "主影像圖庫",
"Home Image Gallery" => "主影像圖庫",
"Home File Gal" => "主檔案庫",
"Home File Gallery" => "主檔案庫",
"User preferences" => "使用者偏好",
"User prefs" => "使用者偏好",
"List image galleries" => "列出圖庫",
"Gallery Rankings" => "圖庫排名",
"Browse a gallery" => "瀏覽圖庫",
"All articles" => "所有文章",
"Submit" => "送出",
"Create blog" => "建立 blog",
"File galleries" => "檔案總覽",
"View a forum" => "進入論壇",
"View a thread" => "檢視討論串",
"View a FAQ" => "觀看 FAQ",
"Take a quiz" => "參加測驗",
"Stats for a Quiz" => "測驗統計",
"Preview menu" => "預覽選單",
"Menu options" => "選單項目",
"Edit this Menu:" => "編輯此選單:",
"Create new Menu" => "建立新選單",
"dynamic collapsed" => "動態展開",
"dynamic extended" => "動態延伸",
"fixed" => "固定",
"Options" => "選項",
"Assign Module" => "指定模組",
"Left Modules" => "左方模組",
"Right Modules" => "右方模組",
"Edit/Create" => "編輯/產生",
"Clear Cache" => "清除快取",
"User Modules" => "使用者模組",
"Assign" => "指定",
"Assign new module" => "指定新模組",
"Edit this assigned module:" => "編輯指定的模組:",
"Module Name" => "模組名稱",
"Left" => "左",
"Right" => "右",
"Order" => "順序",
"Cache Time" => "快取時間",
"Rows" => "列",
"Parameters" => "參數",
"Assigned Modules" => "指定模組",
"Move to Right Column" => "移至右行",
"Unassign" => "未指定",
"Move to Left Column" => "移至左行",
"Create new user module" => "建立新的使用者模組",
"Edit this user module:" => "編輯此使用者模組:",
"Objects that can be included" => "允許包含的物件",
"Available polls" => "現有的投票",
"Use Poll" => "使用投票",
"Random image from" => "隨機影像 由",
"Use Gallery" => "使用圖庫",
"Dynamic content blocks" => "動態內容區塊",
"Use Dynamic Content" => "使用動態內容",
"Use RSS Module" => "使用 rss 模組",
"Use Menu" => "使用選單",
"Banner zones" => "大標題區域",
"Use Banner Zone" => "使用大標題區域",
"Admin newsletter subscriptions" => "管理電子報訂閱",
"List Newsletters" => "列出電子報",
"Admin Newsletters" => "管理電子報",
"Add a subscription newsletters" => "增加訂閱電子報",
"Subscriptions" => "訂閱",
"subscribed" => "訂閱",
"Create/Edit Newsletters" => "建立/編輯電子報",
"There are individual permissions set for this newsletter" => "此電子報有獨立的權限設定",
"Editions" => "版本",
"Last Sent" => "上次寄出",
"Add notification" => "增加通知",
"Event" => "事件",
"A user registers" => "有使用者註冊",
"A user submits an article" => "有使用者發送文章",
"Admin Polls" => "管理投票",
"List polls" => "列出投票",
"Edit this poll" => "編輯這個投票",
"Preview poll" => "閱覽這個投票",
"Option" => "選項",
"Poll options" => "投票選項",
"Votes" => "投票",
"Set last poll as current" => "設定最後一個投票為目前的投票",
"Close all polls but last" => "關閉所有投票除了最後一個",
"Activate all polls" => "啟動所有投票",
"active" => "啟動",
"current" => "目前",
"template" => "模板",
"object" => "物件",
"PublishDate" => "發表日期",
"Objects" => "物件",
"Admin RSS modules" => "管理 RSS 模組",
"Content for the feed" => "Feed 的內容",
"Edit this RSS module:" => "編輯此 RSS 模組:",
"Create new RSS module" => "建立新 RSS 模組",
"Last update" => "最近更新",
"type" => "類型",
"user" => "使用者",
"group" => "群組",
"sticky" => "置頂",
"Destroy the structure leaving the wiki pages" => "刪除結構, 保留 wiki 頁面",
"Destroy the structure and remove the pages" => "刪除結構與頁面",
"Export Pages" => "匯出頁面",
"Dump Tree" => "傾印樹系",
"Create new structure" => "建立新的結構",
"Tree" => "樹系",
"Use single spaces to indent structure levels" => "使用單一空格縮排結構層級",
"Edit survey questions" => "編輯調查問題",
"Survey Stats" => "調查結果",
"this survey stats" => "這次調查結果",
"Edit this Survey" => "編輯這個調查",
"Admin Surveys" => "管理調查",
"Create/edit questions for survey" => "建立/編輯 調查的問題",
"Question" => "問題",
"One choice" => "單一選擇",
"Multiple choices" => "多重選擇",
"Short text" => "簡短文字",
"Rate (1..5)" => "評比 (1..5)",
"Rate (1..10)" => "評比 (1..10)",
"Options (if apply)" => "選項 (如果有)",
"Questions" => "問題",
"question" => "問題",
"Edit this Survey:" => "編輯此調查:",
"There are individual permissions set for this survey" => "此調查有獨立的權限設定",
"Open" => "開放",
"Admin Topics" => "管理主題",
"Create a new topic" => "建立新主題",
"Topic Name" => "主題名稱",
"Upload Image" => "上傳影像",
"List of topics" => "主題列表",
"Active?" => "啟用中?",
"Articles (subs)" => "文章 (回應數)",
"topic image" => "主題影像",
"Deactivate" => "停止",
"Admin Tracker" => "管理追蹤",
"edit" => "編輯",
"Admin Trackers" => "管理追蹤",
"Edit This Tracker" => "編輯此追蹤",
"View This Tracker's Items" => "瀏覽此追蹤項目",
"Edit tracker field" => "編輯追蹤欄位",
"Is column visible when listing tracker items?" => "當列出追蹤項目時可否看見欄位?",
"Column links to edit/view item?" => "欄位是否連結到 編輯/觀看 項目?",
"Tracker fields" => "追蹤欄位",
"Public" => "公開",
"Found" => "找到",
"trackers" => "追蹤系統",
"Fields" => "欄位",
"Create/Edit Trackers" => "建立/編輯追蹤",
"There are individual permissions set for this tracker" => "這個追蹤項目有獨立的權限設定",
"No individual permissions. Global permissions apply." => "不採用單獨的權限設定,採用全體權限設定",
"Show creation date when listing tracker items?" => "當列出追蹤項目時追蹤建立日期?",
"Show lastModif date when listing tracker items?" => "當列出追蹤項目時顯示上次修改日期?",
"Tracker items allow comments?" => "允許對追蹤項目發表評論?",
"Tracker items allow attachments?" => "允許追蹤項目包含附件?",
"Filesize" => "檔案大小",
"status" => "狀態",
"lastModif" => "上次修改",
"Admin groups" => "管理者群組",
"Admin users" => "管理者",
"Add new group" => "增加新群組",
"Add a New Group" => "增加新群組",
"List of existing groups" => "現存群組列表",
"Includes" => "包含",
"Include" => "包含",
"Edit Item" => "編輯項目",
"Add a New User" => "增加使用者",
"Batch Upload Results" => "批次上傳結果",
"Rejected users" => "駁回的使用者",
"Reason" => "原因",
"User Information" => "使用者資訊",
"Validate" => "確認",
"Pass" => "密碼",
"Again" => "再次輸入",
"Overwrite" => "覆蓋",
"Review" => "評論",
"Assign permissions to group" => "指定權限給群組",
"Group Information" => "群組資訊",
"Desc" => "描述",
"Create level" => "建立等級",
"all permissions in level" => "本層級所有權限",
"level" => "層級",
"backlinks to" => "反向連結至",
"No backlinks to this page" => "此頁面並無反向連結",
"Browse gallery" => "瀏覽圖庫",
"Upload from disk" => "由磁碟上傳",
"Process" => "程序",
"Wiki Help" => "wiki 說明",
"Clear" => "清除",
"Browsing Gallery" => "瀏覽圖庫",
"Edit Gallery" => "編輯圖庫",
"Rebuild Thumbnails" => "重建縮圖",
"List Gallery" => "列出圖庫",
"Sort Images by" => "排列影像順序",
"Original Size" => "原始大小",
"rotate right" => "向右旋轉",
"rotate" => "旋轉",
"popup" => "蹦現",
"Browsing Image" => "瀏覽影像",
"Return to Gallery" => "返回圖庫",
"Edit Image" => "編輯影像",
"First Image" => "第一張影像",
"Prev Image" => "前一個影像",
"Smaller" => "縮小",
"Bigger" => "放大",
"Popup window" => "蹦現視窗",
"Next Image" => "下一個影像",
"Last Image" => "最末張影像",
"Stop" => "stop",
"Image Name" => "影像名稱",
"Image size" => "影像大小",
"Image Scale" => "影像比率",
"Move image" => "移動影像",
"You can view this image in your browser using" => "你可以觀看此影像在你的瀏覽器中使用",
"Group Calendars" => "群組行事曆",
"Hours" => "小時",
"Edit Calendar Item" => "編輯行事曆項目",
"End" => "結束",
"Duration" => "期間",
"Tentative" => "暫定",
"Confirmed" => "已確認",
"Cancelled" => "取消",
"Location" => "地點",
"Organized by" => "組織方式",
"import" => "匯入",
"Permission" => "權限",
"to group" => "給群組",
"Change password enforced" => "強制更改密碼",
"Old password" => "舊密碼",
"Again please" => "請再輸入一次",
"Send a message to us" => "發送訊息給我們",
"Contact us by email" => "使用email與我們聯絡",
"Contacts" => "通訊錄",
"Create/edit contacts" => "建立/編輯 通訊錄",
"First Name" => "名",
"Last Name" => "姓",
"Nickname" => "暱稱",
"Structure" => "結構",
"Tiki Debugger Console" => "Tiki 除錯器控制臺",
"Close" => "關閉",
"Current URL" => "目前的 URL",
"Command" => "命令",
"exec" => "執行",
"Type <code>help</code> to get list of available commands" => "輸入 <code>help</code> 可取得完整指令列表",
"Add a new site" => "增加新的站臺",
"Site added" => "增加的站臺",
"Is valid" => "是正確的",
"Directory Administration" => "目錄管理",
"There are" => "有",
"invalid sites" => "不正確的站臺",
"valid sites" => "正確的站臺",
"Users have visited" => "使用者已拜訪",
"sites from the directory" => "個站臺由這個目錄",
"Users have searched" => "使用者已搜尋",
"times from the directory" => "次由這個目錄",
"Admin sites" => "管理站臺",
"Admin category relationships" => "管理類別關係",
"Validate links" => "確認連結",
"Browse" => "瀏覽",
"Related" => "相關",
"Admin directory categories" => "管理目錄分類",
"Parent category" => "父分類",
"Add a directory category" => "增加目錄類別",
"Edit this directory category" => "編輯目錄類別",
"Children type" => "子型別",
"Most visited sub-categories" => "最常被拜訪的子分類",
"Category description" => "分類描述",
"Random sub-categories" => "隨機子分類",
"Maximum number of children to show" => "最大展示的分類數目",
"Allow sites in this category" => "在這個分類允許的站臺數",
"Show number of sites in this category" => "在這個分類裡展示站臺數",
"Editor group" => "編輯者群組",
"Subcategories" => "子分類",
"allow" => "允許",
"count" => "次",
"editor" => "編輯",
"relate" => "相關",
"Admin related categories" => "管理相關分類",
"Add a related category" => "加入相關類別",
"Mutual" => "共同",
"Related categories" => "相關分類",
"New Sites" => "新站臺",
"Cool Sites" => "酷站臺",
"Add a Site" => "增加一個站臺",
"any" => "任何",
"in entire directory" => "在整個目錄中",
"in current category" => "在目前分類",
"Sort by" => "排序依據",
"name (desc)" => "名稱 (降冪)",
"name (asc)" => "名稱 (升冪)",
"hits (desc)" => "點擊數 (降冪)",
"hits (asc)" => "點擊數 (升冪)",
"creation date (desc)" => "建立日期 (降冪)",
"creation date (asc)" => "建立日期 (升冪)",
"last updated (desc)" => "最後更新 (降冪)",
"last updated (asc)" => "最後更新 (升冪)",
"sort" => "排序",
"Added" => "增加",
"Last updated" => "最近修改",
"Total categories" => "所有分類",
"Total links" => "全部連結",
"Links to validate" => "待確認連結",
"Searches performed" => "搜尋已執行",
"Total links visited" => "全部被拜訪連結",
"Directory ranking" => "目錄排名",
"Search results" => "搜尋結果",
"Validate sites" => "確認站臺",
"country" => "國家",
"List Articles" => "列出文章",
"View Articles" => "顯示文章",
"Author Name" => "作者",
"Float text around image" => "文繞圖",
"Heading" => "標題",
"Body" => "內容",
"Edit or create banners" => "編輯或建立大標題",
"List banners" => "列出大標題",
"URL to link the banner" => "連結此標題的 URL",
"Client" => "用戶",
"Max impressions" => "最大次數",
"Show the banner only between these dates" => "只在這些日期顯示大標題",
"From date" => "開始日期",
"To date" => "結束日期",
"Use dates" => "使用日期",
"Show the banner only in this hours" => "只在這些時間顯示大標題",
"to" => "到",
"Show the banner only on" => "顯示大標題的日子",
"Mon" => "一",
"Tue" => "二",
"Wed" => "三",
"Thu" => "四",
"Fri" => "五",
"Sat" => "六",
"Sun" => "日",
"Select ONE method for the banner" => "選擇大標題的方式",
"Use HTML" => "使用 HTML",
"HTML code" => "HTML碼",
"Use image" => "使用影像",
"Image:" => "影像:",
"Current Image" => "目前影像",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "使用由URL產生的影像 (影像每次都會從URL索取)",
"Use text" => "使用文字",
"Text" => "文字",
"Save the Banner" => "儲存大標題",
"Edit Blog" => "編輯 Blog",
"Current heading" => "目前標題",
"There are individual permissions set for this blog" => "這個 blog 有獨立的權限設定",
"Number of posts to show" => "顯示的佈告數",
"Allow other user to post in this blog" => "允許其他使用者發表於這個 blog",
"Use titles in blog posts" => "使用 blog 文章標題",
"Allow search" => "允許搜尋",
"Allow comments" => "允許評論",
"Blog heading" => "Blog 標題",
"Edit Style Sheet" => "編輯樣式表",
"Style Sheet" => "樣式表",
"choose a stylesheet" => "選擇樣式表",
"Try" => "測試",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "檔名有附加 -{\$user} 可以修改, 其他只能做為樣本複製",
"Show Plugins Help" => "顯示外掛模組說明",
"some text" => "某些文字",
"Creates a box with the data" => "根據資料建立方塊",
"Box content" => "方塊內容",
"Title bar" => "標題列",
"creates a title bar" => "產生標題列",
"Colored text" => "著色文字",
"Lists" => "項目",
"for bullet lists" => "表示無序列表",
"for numbered lists" => "表示有序列表",
"for definiton lists" => "表示定義列表",
"Tables" => "表格",
"creates a table" => "產生表格",
"makes a horizontal rule" => "表示水平線",
"Wiki References" => "Wiki 參考",
"JoinCapitalizedWords or use" => "連在一起的大寫字或使用",
"page|desc" => "頁面|描述",
"for wiki references" => "表示 wiki 參考",
"SomeName" => "某個名稱",
"prevents referencing" => "表示不參考",
"External links" => "外部連結",
"displays an image" => "顯示影像",
"Non cacheable images" => "無可快取的影像",
"height width desc link and align are optional" => "height width desc link and align可有可無",
"creates the editable drawing foo" => "建立可編輯的暫時影像",
"Multi-page pages" => "多頁式頁面",
"displays rss feed with id=n maximum=m items" => "顯示 id=n 最大值=m 的 rss feed",
"Will be replaced by the actual value of the dynamic content block with id=n" => "將會用 id=n 的動態內容區塊實際值來取代",
"Non parsed sections" => "不分析的區段",
"Misc" => "其它",
"Show Text Formatting Rules" => "顯示文字排版規則",
"No description available" => "沒有描述",
"bold" => "粗體",
"italic" => "斜體",
"underline" => "底線",
"table" => "表格",
"external link" => "外部連結",
"heading1" => "標題1",
"title bar" => "標題列",
"box" => "盒",
"dynamic content" => "動態內容",
"center text" => "置中文字",
"colored text" => "上色文字",
"special chars" => "特殊字元",
"special characters" => "特殊字元",
"Edit successful!" => "編輯成功!",
"The following image was successfully edited" => "下列影像已成功編輯",
"Image Description" => "影像描述",
"Edit and create Languages" => "編輯或建立語言",
"Im- Export Languages" => "匯入- 匯出語言",
"Edit and create languages" => "編輯或建立語言",
"Create Language" => "建立語言",
"Shortname" => "簡稱",
"like" => "如同",
"Longname" => "完整名稱",
"Select the language to edit" => "選擇要編輯的語言",
"Add a translation" => "增加一個翻譯",
"Edit translations" => "編輯一個翻譯",
"Translate recorded" => "已記錄翻譯",
"Original" => "原始",
"Translate" => "翻譯",
"reset table" => "重設表格",
"Program dynamic content for block" => "設計區塊的動態內容",
"Create New Block" => "建立新區塊",
"Return to block listing" => "返回區塊列表",
"Block description: " => "區塊描述: ",
"You are editing block:" => "你正在編輯區塊:",
"Publishing date" => "發表日期",
"Publishing Date" => "發表日期",
"Edit question options" => "編輯問題選項",
"Quiz Stats" => "測驗統計",
"This Quiz Stats" => "這個測驗的統計",
"Edit this Quiz" => "編輯這個測驗",
"Admin Quizzes" => "管理測驗",
"Create/edit options for question" => "建立/編輯 問題的選項",
"points" => "分",
"Admin quizzes" => "管理測驗",
"Create/edit quizzes" => "增加/編輯 測驗",
"There are individual permissions set for this quiz" => "這個測驗有單獨權限設定",
"Quiz can be repeated" => "可以重覆參加測驗",
"Store quiz results" => "儲存測驗結果",
"Questions per page" => "每頁問題數",
"Quiz is time limited" => "測驗有時間限制",
"Maximum time" => "最大時間",
"canRepeat" => "允許重覆",
"timeLimit" => "時間限制",
"Results" => "結果",
"Edit quiz questions" => "編輯測驗問題",
"Create/edit questions for quiz" => "建立/編輯 測驗的選項",
"maxScore" => "最高分數",
"From Points" => "從分數",
"To Points" => "至分數",
"Answer" => "回答",
"You will remove" => "將會移除",
"and its subpages from the structure, now you have two options:" => "以及結構中的子頁面, 你有兩個選擇:",
"Remove only from structure" => "僅由結構移除",
"Remove from structure and remove page too" => "由結構移除並也移除頁面",
"Previous" => "先前排名",
"Page alias" => "頁面別名",
"After page" => "在頁面後",
"Create Page" => "建立頁面",
"Use pre-existing page" => "使用已存在的頁面",
"List Submissions" => "列出submission",
"Template listing" => "Template列表",
"Available templates" => "現有模板",
"votes" => "票",
"Admin FAQ" => "管理 FAQ",
"View FAQ" => "觀看 FAQ",
"Edit this FAQ" => "編輯這個 FAQ",
"New Question" => "新問題",
"Use a question from another FAQ" => "使用來自其它 FAQ 的問題",
"FAQ questions" => "FAQ 問題",
"Suggested questions" => "建議問題",
"Approve" => "同意",
"No suggested questions" => "無建議的問題",
"Upload File" => "上傳檔案",
"Browse Gallery" => "瀏覽圖庫",
"You can access the file gallery using the following URL" => "你可以由下列URL進入這個檔案庫",
"Message queue for" => "訊息佇列",
"back to forum" => "回到論壇",
"Edit queued message" => "編輯佇列中訊息",
"make this a thread of" => "設為討論串",
"None, this is a thread message" => "不, 這不是討論串",
"summary" => "總結",
"normal" => "正常",
"announce" => "公佈",
"hot" => "熱門",
"no feeling" => "沒感覺",
"frown" => "皺眉",
"exclaim" => "驚叫",
"idea" => "點子",
"mad" => "瘋狂",
"neutral" => "中立",
"sad" => "難過",
"happy" => "快樂",
"wink" => "眨眼",
"Save and Approve" => "儲存並核可",
"convert to topic" => "轉換至主題",
"List of messages" => "訊息列表",
"New Topic" => "新主題",
"no summary" => "無總結",
"No messages queued yet" => "尚無訊息佇列",
"Reject" => "駁回",
"Reported messages for" => "回報訊息",
"Reported by" => "回報自",
"Accept" => "接受",
"Activity completed" => "活動完畢",
"Admin process activities" => "管理程序活動",
"Add or edit an activity" => "增加或編輯活動",
"activity" => "活動力",
"split" => "分割",
"join" => "加入",
"standalone" => "獨立",
"interactive" => "互動式",
"auto routed" => "自動建立路徑",
"Add transitions" => "建立變遷",
"Add transition from:" => "建立變遷自:",
"Add transition to:" => "建立變遷至:",
"No roles associated to this activity" => "沒有與此活動相關的角色",
"Add Role" => "增加角色",
"Add New" => "新增加",
"Process activities" => "程序的活動",
"Routing" => "建立路徑",
"Interactive" => "互動式",
"Automatic" => "自動",
"Auto routed" => "自動建立路徑",
"Manual" => "人動",
"route" => "路徑",
"(no roles)" => "(無角色)",
"Code" => "碼",
"No activities defined yet" => "尚未定義活動",
"Process Transitions" => "程序的變遷",
"List of transitions" => "變遷列表",
"From:" => "自:",
"Origin" => "原始",
"No transitions defined yet" => "尚未定義變遷",
"Add a transition" => "增加變遷",
"Active Process" => "active process",
"Invalid Process" => "invalid process",
"Valid Process" => "valid process",
"New Minor" => "new minor",
"New Major" => "new major",
"Admin instance" => "管理實體",
"Instance" => "實體",
"Workitems" => "工作項目",
"completed" => "已完成",
"Aborted" => "aborted",
"Started" => "開始",
"Map" => "地圖",
"Admin Processes" => "admin processes",
"Admin Activities" => "admin activities",
"Admin Roles" => "admin roles",
"Edit this Process" => "edit this process",
"Proc" => "proc",
"Monitor" => "監控",
"Completed" => "完成",
"Exceptions" => "exceptions",
"Send Instance" => "send instance",
"Create New Gallery" => "建立新圖庫",
"Create a gallery" => "建立圖庫",
"Edit this gallery:" => "編輯此圖庫:",
"There are individual permissions set for this gallery" => "這個圖庫有獨立的權限設定",
"Image ID" => "影像 ID",
"Available scales" => "現有的比率",
"No scales available" => "沒有可用的比率",
"Other users can upload images to this gallery" => "允許其它使用者上傳影像至此圖庫",
"You can access the gallery using the following URL" => "你可以經由下列的URL進入此圖庫",
"Available Galleries" => "目前所有的圖庫",
"Imgs" => "影像",
"Im- Export languages" => "匯入-匯出語言",
"Select the language to Import" => "選擇要匯入的語言",
"Select the language to Export" => "選擇要匯出的語言",
"Overwrite existing pages if the name is the same" => "當名稱一樣時覆寫已存在的頁面",
"Previously remove existing page versions" => "事先移除已存在的頁面版本",
"excerpt" => "引用",
"Result" => "結果",
"Search by Date" => "以日期搜尋",
"LastChanges" => "最近變動",
"hist" => "歷史記錄",
"Rollback" => "回復",
"Pages like" => "相似頁面",
"No pages found" => "找不到頁面",
"Edit New Article" => "編輯新文章",
"AuthorName" => "作者名稱",
"Create banner" => "建立大標題",
"Method" => "方法",
"Use Dates?" => "使用日期?",
"Max Impressions" => "最大次數",
"Impressions" => "次數",
"Clicks" => "點擊",
"Create New Blog" => "建立新 blog",
"Dynamic content system" => "動態內容系統",
"Available content blocks" => "現有的內容區塊",
"Current ver" => "目前版本",
"Next ver" => "下一個版本",
"Program" => "方案",
"Edit this FAQ:" => "編輯此 FAQ:",
"Create New FAQ:" => "建立新 FAQ:",
"Users can suggest questions" => "允許使用者建議問題",
"Available FAQs" => "現有的 FAQs",
"Create a file gallery" => "建立檔案庫",
"Gallery Images" => "圖庫影像",
"All games are from" => "所有遊戲來自",
"visit the site for more games and fun" => "拜訪這個網站以取得更多遊戲",
"Upload a game" => "上傳一個遊戲",
"Upload a new game" => "上傳一個新遊戲",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "縮圖 (如果game的名稱為foo.swf 則縮圖必須命名為 foo.swf.gif 或 foo.swf.png 或 foo.swf.jpg)",
"Edit game" => "編輯遊戲",
"Played" => "已玩",
"times" => "次",
"If you can't see the game then you need a flash plugin for your browser" => "如果你無法看到遊戲那麼你必須在你的瀏覽器中加入 flash 外掛模組",
"Blog Title" => "Blog 標題",
"Edit New Submission" => "建立新的意見",
"Survey stats" => "調查結果",
"Last mod" => "最近修改",
"Last author" => "最近作者",
"unlocked" => "解鎖",
"Open client window" => "開啟客戶端視窗",
"Generate HTML" => "產生 HTML",
"Transcripts" => "紀錄",
"Support tickets" => "支援標籤",
"Online operators" => "線上服務員",
"Operator" => "服務員",
"Accepted requests" => "已接受要求",
"transcripts" => "紀錄",
"Offline operators" => "離線服務員",
"Add an operator to the system" => "增加系統服務員",
"Operators must be tiki users" => "服務員必須是 tiki 使用者",
"Set as Operator" => "設為服務員",
"Chat started" => "對談已開始",
"Operator:" => "服務員:",
"Live support:User window" => "線上支援:使用者視窗",
"Request live support" => "要求線上支援",
"Request support" => "要求支援",
"Open a support ticket instead" => "改為開啟要求標籤",
"Your request is being processed" => "你的要求正在處理",
"cancel request and exit" => "取消要求並離開",
"cancel request and leave a message" => "取消要求並留言",
"Live support:Console" => "線上支援:操作臺",
"be online" => "正在線上",
"be offline" => "正離線中",
"Support requests" => "支援要求",
"Requested" => "已要求",
"Join" => "加入",
"Support chat transcripts" => "支援交談紀錄",
"back to admin" => "回到管理介面",
"started" => "已開始",
"reason" => "原因",
"msgs" => "訊息",
"Transcript" => "紀錄",
"Prefs" => "個人偏好",
"Remove old events" => "移除舊事件",
"duration" => "期間",
"Mini Calendar: Preferences" => "迷你月曆: 個人偏好",
"Calendar Interval in daily view" => "每日檢視中的行事曆週期",
"Start hour for days" => "每天開始時間",
"End hour for days" => "每天結束時間",
"Reminders" => "提醒",
"no reminders" => "沒有提醒",
"Or enter path or URL" => "或 輸入路徑 或 URL",
"Add Topic" => "增加主題",
"User Pages" => "使用者頁面",
"User Galleries" => "使用者列表",
"Assigned items" => "指定項目",
"Unread Messages" => "未讀訊息",
"User Blogs" => "使用者 Blogs",
"MyFiles" => "我的檔案",
"Subscribe" => "訂閱",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "感謝你的訂閱. 你會收到一封信件以確認你的訂閱. 在訂閱確認前不會收到電子報.",
"Your email address was removed from the list of subscriptors." => "你的email地址已從訂閱者名單中移除",
"Subscription confirmed!" => "訂閱已確認!",
"Subscribe to Newsletter" => "訂閱電子報",
"Subscribe to This Newsletter" => "訂閱",
"Select news group" => "選擇 news 討論群",
"Back to servers" => "返回伺服器列表",
"Msgs" => "訊息",
"Back to groups" => "回到討論群",
"Save position" => "儲存位置",
"Reading article from" => "閱讀文章由",
"Back to list of articles" => "返回文章列表",
"First" => "第一個",
"Newsgroup" => "討論群",
"Configure news servers" => "設定 news 伺服器",
"Select a news server to browse" => "選擇要瀏覽的 news 伺服器",
"server" => "伺服器",
"News server" => "News 伺服器",
"Notes" => "備忘錄",
"Write a note" => "寫個備忘錄",
"quota" => "配額",
"No notes yet" => "尚無記事",
"Merge selected notes into" => "合併選擇的記事至",
"Reading note:" => "閱讀備忘錄:",
"List notes" => "列出備忘錄",
"Write note" => "寫備忘錄",
"Wiki Create" => "wiki 建立",
"Wiki Overwrite" => "wiki 覆寫",
"Assign permissions to " => "指定權限給",
"Back" => "返回",
"Current permissions for this object" => "此物件目前的權限",
"Assign permissions to this object" => "指定此物件的權限",
"Published" => "發表",
"Orphan Pages" => "孤兒頁面",
"Browser not supported" => "瀏覽器不支援",
"Pick your avatar" => "選擇你的頭像",
"User Preferences" => "使用者偏好",
"Your current avatar" => "你目前的頭像",
"reset" => "重新設定",
"Pick avatar from the library" => "從內建頭像中選取",
"Pick user Avatar" => "選擇使用者的頭像",
"Hide all" => "隱藏全部",
"Show all" => "顯示全部",
"Avatar Image" => "個人頭像",
"Upload your own avatar" => "上傳你自己的頭像",
"Vote poll" => "投票",
"Other Polls" => "其他投票",
"Print multiple pages" => "列印多重頁面",
"Quiz result stats" => "測驗結果統計",
"Quiz" => "測驗",
"Time" => "時間",
"User answers" => "使用者答案",
"Stats for quizzes" => "測驗統計",
"taken" => "參加過",
"Av score" => "平均分數",
"Av time" => "平均時間",
"Stats for quiz" => "測驗統計",
"Clear Stats" => "清除統計",
"Stats for this quiz Questions " => "此測驗問題統計資料 ",
"Average" => "平均",
"Top 10" => "前 10",
"Top 20" => "前 20",
"Top 50" => "前 50",
"Top 100" => "前 100",
"Received Articles" => "已接收文章",
"Edit received article" => "編輯接收的文章",
"Use Image" => "使用影像",
"Image x size" => "影像 x 大小",
"Image y size" => "影像 y 大小",
"Image name" => "影像名稱",
"Accept Article" => "接受文章",
"Site" => "網站",
"The following site was added and validation by admin may be needed before appearing on the lists" => "已加入以下站臺, 需等待管理者確認後才會顯示在列表上",
"Send me my Password" => "寄給我密碼",
"Return to HomePage" => "回首頁",
"Remove page" => "移除頁面",
"You are about to remove the page" => "你即將刪除此頁面",
"permanently" => "永久地",
"Remove all versions of this page" => "移除這個頁面的所有版本",
"Rename page" => "頁面更名",
"Rollback page" => "回復頁面",
"to_version" => "至版本",
"Searched" => "搜尋",
"Search in" => "搜尋於",
"No pages matched the search criteria" => "找不到符合條件的頁面",
"Send blog post" => "發送 blog 佈告",
"A link to this post was sent to the following addresses:" => "已經發送一個至此佈告的連結至下列位址:",
"Send post to this addresses" => "發送佈告至此位址",
"List of email addresses separated by commas" => "email 地址列表, 由逗點分隔",
"referenced by" => "參考自",
"references" => "參考",
"Send objects" => "發送物件",
"Transmission results" => "傳送結果",
"Send Wiki Pages" => "發送 Wiki 頁面",
"Send Articles" => "發送文章",
"Add Article" => "加入文章",
"Send objects to this site" => "發送物件到這個網站",
"Post or edit a message" => "發表或編輯訊息",
"cool" => "酷",
"Site Stats" => "網站統計",
"Days online" => "上線天數",
"Total pageviews" => "全部頁面瀏覽數",
"Average pageviews per day" => "每天平均頁面瀏覽數",
"Best day" => "最好的一天",
"Worst day" => "最差的一天",
"Wiki Stats" => "Wiki 統計",
"Size of Wiki Pages" => "Wiki 頁面大小",
"Average page length" => "平均頁面長度",
"Average versions per page" => "平均每頁版本數",
"Visits to wiki pages" => "wiki 頁面拜訪數",
"Average links per page" => "平均每頁連結數",
"Image galleries Stats" => "影像圖庫統計",
"Average images per gallery" => "平均圖庫影像數",
"Total size of images" => "所有影像大小",
"Average image size" => "平均影像大小",
"Visits to image galleries" => "影像庫拜訪數",
"File galleries Stats" => "檔案庫統計",
"Average files per gallery" => "檔案庫平均檔案數",
"Total size of files" => "全部檔案的總大小",
"Average file size" => "平均檔案大小",
"Visits to file galleries" => "檔案庫拜訪數",
"CMS Stats" => "CMS 統計",
"Total reads" => "全部閱讀數",
"Average reads per article" => "文章平均閱讀數",
"Total articles size" => "全部文章大小",
"Average article size" => "平均文章大小",
"Forum Stats" => "論壇統計",
"Total topics" => "全部主題",
"Average topics per forums" => "論壇平均主題數",
"Visits to forums" => "論壇拜訪數",
"Blog Stats" => "Blog 統計",
"Total posts" => "總發表佈告數",
"Average posts per weblog" => "weblog 平均發表數",
"Total size of blog posts" => "blog 佈告的總大小",
"Average posts size" => "平均佈告大小",
"Visits to weblogs" => "weblogs 拜訪數",
"Poll Stats" => "投票統計",
"Total votes" => "總票數",
"Average votes per poll" => "投票平均票數",
"Total questions" => "全部問題數",
"Average questions per FAQ" => "FAQ 平均問題數",
"User Stats" => "使用者統計",
"User bookmarks" => "使用者書籤",
"Average bookmarks per user" => "使用者平均書籤數",
"Average questions per quiz" => "每測驗平均問題數",
"Quizzes taken" => "已參加過的測驗",
"Average quiz score" => "平均測驗分數",
"Average time per quiz" => "每測驗平均回答時間",
"Usage chart" => "使用排行榜",
"Usage chart image" => "使用紀錄圖表",
"Stats for surveys" => "調查結果",
"Last taken" => "最近參加的調查",
"Stats for survey" => "調查結果",
"Stats for this survey Questions " => "這次調查問題的結果",
"Time Left" => "剩餘時間",
"Send Answers" => "送出答案",
"Your email was sent" => "email 已寄出",
"Theme Control Center: categories" => "佈景主題控制臺: 分類",
"Theme is selected as follows" => "佈景主題選擇如下",
"If a theme is assigned to the individual object that theme is used." => "如果指定單獨物件的佈景主題,則使用該主題.",
"If not then if a theme is assigned to the object's category that theme is used" => "如不成立, 那麼如果指定物件分類的佈景主題, 則使用該主題",
"If not then a theme for the section is used" => "如不成立, 則使用區塊的佈景主題",
"If none of the above was selected the user theme is used" => "如果以上都沒有設定, 則採用使用者的佈景主題",
"Finally if the user didn't select a theme the default theme is used" => "最後, 如果使用者沒有設定佈景主題, 則使用預設的佈景主題",
"Control by Sections" => "由區塊控制",
"Assign themes to categories" => "指定分類的佈景主題",
"Assigned categories" => "已指定的分類",
"theme" => "佈景主題",
"Theme Control Center: Objects" => "佈景主題控制臺: 物件",
"Control by Categories" => "由分類控制",
"Assign themes to objects" => "指定物件的佈景主題",
"Assigned objects" => "指定物件",
"Theme Control Center: sections" => "佈景主題控制臺: 區塊",
"Assign themes to sections" => "指定區塊的佈景主題",
"Assigned sections" => "指定區塊",
"The following file was successfully uploaded" => "下列的檔案已成功上傳",
"You can download this file using" => "你可以下傳這個檔案使用",
"File Title" => "檔案標題",
"Batch upload" => "批次上傳",
"You have to create a gallery first!" => "你必須先建立圖庫!",
"Upload successful!" => "上傳成功!",
"The following image was successfully uploaded" => "下列影像已成功上傳",
"Thumbnail" => "縮圖",
"Image ID thumb" => "影像 ID 縮圖",
"Now enter the image URL" => "輸入影像的 URL",
" or upload a local image from your disk" => " 或從你的磁碟上傳影像",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "縮圖 (選擇性, 覆蓋自動縮圖產生)",
"User assigned modules" => "使用者指定模組",
"Assign module" => "指定模組",
"Column" => "行",
"Current folder" => "目標資料夾",
"Folders" => "資料夾",
"Folder in" => "資料夾於",
"Remove Folder" => "移除資料夾",
"Refresh Cache" => "重新整理快取",
"Admin folders and bookmarks" => "管理資料夾與書籤",
"Send me a message" => "發送訊息給我",
"Your personal Wiki Page" => "你的個人 Wiki 頁面",
"Is email public? (uses scrambling to prevent spam)" => "公開 email? (使用擾亂法以避免spam)",
"Percentage completed" => "完成百分比",
"No tasks entered" => "尚未輸入工作",
"May need to refresh twice to see changes" => "可能需要更新兩次才看得到變動",
"Add top level bookmarks to menu" => "增加最高一層的書籤至選單",
"Mode" => "模式",
"replace window" => "取代視窗",
"Banner stats" => "大標題統計",
"Create new banner" => "建立新標題",
"Banner Information" => "大標題資訊",
"Click ratio" => "點擊率",
"Weekdays" => "工作日",
"mon" => "一",
"tue" => "二",
"wed" => "三",
"thu" => "四",
"fri" => "五",
"sat" => "六",
"sun" => "日",
"Banner raw data" => "大標題原始資料",
"This is a cached version of the page." => "這是本頁面的快取版本",
"Click here to view the Google cache of the page instead." => "點擊這裡瀏覽 Google 頁面存檔.",
"Edit Items" => "編輯項目",
"List Charts" => "列出排行榜",
"Last Chart" => "最末張排行榜",
"Previous Chart" => "前一排行榜",
"Chart created" => "排行榜已建立",
"Next Chart" => "下一張排行榜",
"Pre" => "pre",
"Permanency" => "耐久度",
"chg" => "異動",
"Avg" => "平均",
"info/vote" => "資訊/投票",
"Next chart will be generated on" => "下一排行榜將產生於",
"View or vote items not listed in the chart" => "檢視或投票項目不列在排行榜中",
"Select something to vote on" => "選擇要投的項目",
"Item information" => "項目資訊",
"Dif" => "差異",
"Best Position" => "最佳排名",
"Vote this item" => "票選此項目",
"Highest" => "最高",
"Forum List" => "論壇列表",
"Edit Forum" => "編輯論壇",
"You have to enter a title and text" => "請輸入標題與內容",
"Summary" => "總計",
"Moderator Actions" => "板主命令",
"Move Selected Topics" => "移動選擇的主題",
"Unlock Selected Topics" => "解鎖選擇的主題",
"Lock Selected Topics" => "鎖定選擇的主題",
"Delete Selected Topics" => "刪除選擇的主題",
"Merge" => "合併",
"Merge Selected Topics" => "合併選擇的主題",
"Reported Messages:" => "回報的訊息:",
"Queued Messages:" => "佇列中訊息:",
"Merge into topic" => "合併至主題",
"Announce" => "公佈",
"Hot" => "熱門",
"Sticky" => "置頂",
"No topics yet" => "尚無主題",
"Show posts" => "顯示發表數",
"Last hour" => "前 1 小時",
"Last 24 hours" => "前 24 小時",
"Last 48 hours" => "前 48 小時",
"Jump to forum" => "跳躍至論壇",
" unread private messages" => " 未讀的私人訊息",
"prev topic" => "前一主題",
"next topic" => "後一主題",
"IRC log" => "IRC 紀錄",
"Insert New Item" => "插入新項目",
"View Item" => "觀看項目",
"Add a Comment" => "增加一個評論",
"Add new mail account" => "增加新的郵件帳號",
"User accounts" => "使用者帳號",
"View All" => "觀看全部",
"Msg" => "訊息",
"Clip" => "迴紋針",
"Back To Mailbox" => "返回郵件夾",
"Full Headers" => "完整標頭",
"Normal Headers" => "一般標頭",
"Reply To All" => "全部回覆",
"Forward" => "轉寄",
"Select from address book" => "由通訊錄中選擇",
"Use HTML mail" => "使用 HTML 郵件",
"The following addresses are not in your address book" => "下列地址不在你的通訊錄中",
"Add Contacts" => "增加到通訊錄",
"Attachment 1" => "附件 1",
"Attachment 2" => "附件 2",
"Attachment 3" => "附件 3",
"Address book" => "通訊錄",
"Minor Edit" => "次要",
"Administration" => "系統管理",
"General preferences and settings" => "一般偏好設定",
"Wiki settings" => "Wiki 設定",
"Poll comments settings" => "投票評論設定",
"Forums settings" => "論壇設定",
"No chart indicated" => "未指定排行榜",
"Upload failed" => "上傳失敗",
"Tag already exists" => "標籤已經存在",
"Tag not found" => "找不到標籤",
"No menu indicated" => "未指定選單",
"No newsletter indicated" => "未指定電子報",
"No poll indicated" => "未指定投票",
"Permission denied you cannot view this page" => "權限不足, 你無法觀看此頁面",
"Permission denied you cannot edit this page" => "權限不足, 你無法編輯此頁面",
"page not added (Exists)" => "未加入頁面 (已存在)",
"No survey indicated" => "未指定調查",
"No tracker indicated" => "未指定追蹤",
"Group already exists" => "群組已經存在",
"User doesn't exist" => "使用者不存在",
"No records were found. Check the file please!" => "找不到紀錄, 請檢查檔案!",
"User login is required" => "需要使用者登入",
"Password is required" => "需要密碼",
"Email is required" => "需要 email",
"User is duplicated" => "使用者重複",
"password" => "密碼",
"Permission denied you cannot view this section" => "權限不足, 你無法觀看這個區段",
"Unknown group" => "不明群組",
"Group doesn't exist" => "群組不存在",
"Permission denied you cannot view backlinks for this page" => "權限不足, 你無法觀看此頁面的反向連結",
"The page cannot be found" => "找不到頁面",
"Permission denied you cannot post" => "權限不足, 你無法發表佈告",
"Permission denied you cannot edit this post" => "權限不足, 你無法編輯此佈告",
"You can't post in any blog maybe you have to create a blog first" => "你無法在任何 blog 中發表佈告, 請先建立一個 blog",
"Top visited blogs" => "最熱門 blog",
"Last posts" => "最新發表",
"Top active blogs" => "最活躍 blog",
"Permission denied you cannot access this gallery" => "你沒有存取這個圖庫的權限",
"No gallery indicated" => "未指定圖庫",
"Permission denied you can not view this section" => "權限不足, 你無法瀏覽這個區塊",
"Permission denied you cannot remove images from this gallery" => "你沒有刪除本圖庫中影像的權限",
"Permission denied you cannot rebuild thumbnails in this gallery" => "權限不足, 你無法建立此圖庫的縮圖",
"Permission denied you cannot rotate images in this gallery" => "權限不足, 你無法旋轉此圖庫中的影像",
"No image indicated" => "未指定影像",
"Permission denied you cannot move images from this gallery" => "你沒有移動本圖庫中檔案的權限",
"Permission denied you cannot view the calendar" => "權限不足, 你無法使用行事曆",
"event without name" => "無名事件",
"You can not use the same password again" => "請勿再使用相同的密碼",
"Top authors" => "最多產作者",
"This feature has been disabled" => "這個功能已被關閉",
"Must enter a name to add a site" => "增加站臺時必須輸入名稱",
"Must enter a url to add a site" => "增加站臺時必須輸入 URL",
"URL already added to the directory. Duplicate site?" => "已經加入過此URL了. 是否為重複站臺?",
"Must select a category" => "請選擇一個分類",
"No site indicated" => "未指定站臺",
"You can not download files" => "你無法下傳檔案",
"Article not found" => "找不到文章",
"Permission denied you cannot edit this article" => "你沒有權限編輯此文章",
"You do not have permissions to edit banners" => "權限不足, 你無法編輯blog",
"Banner not found" => "找不到大標題",
"You do not have permission to edit this banner" => "權限不足, 你無法編輯此blog",
"Permission denied you cannot create or edit blogs" => "權限不足, 你無法建立或編輯blog",
"Permission denied you cannot edit this blog" => "權限不足, 你無法編輯此 blog",
"You do not have permission to write the style sheet" => "你沒有權限寫入樣式表",
"Invalid request to edit an image" => "不正確的編輯影像請求",
"Permission denied you cannot edit images" => "權限不足, 你無法編輯影像",
"Permission denied you can edit images but not in this gallery" => "權限不足, 你可以編輯影像, 但不得編輯此圖庫",
"Failed to edit the image" => "編輯影像失敗",
"Permission denied to use this feature" => "權限不足, 無法使用本功能",
"Shortname must be 2 Characters" => "縮寫必須是兩個字元",
"You must provide a longname" => "必須提供完整名稱",
"Language created" => "語言已建立",
"No content id indicated" => "未指定內容編號",
"No question indicated" => "未指定問題",
"No quiz indicated" => "未指定測驗",
"No structure indicated" => "未指定結構",
"Permission denied you cannot send submissions" => "權限不足, 你無法送出意見",
"Permission denied you cannot edit submissions" => "權限不足, 你無法編輯意見",
"You have to create a topic first" => "你必須先建立主題",
"You do not have permission to do that" => "你沒有權限",
"You do not have permission to read the template" => "權限不足, 你無法讀取模板",
"page imported" => "匯入的頁面",
"created from import" => "從匯入建立",
"The SandBox is disabled" => "沙池功能已關閉",
"Cannot edit page because it is locked" => "無法編輯頁面, 它正被鎖定中",
"Permission denied you cannot edit this file" => "權限不足, 你無法編輯此檔案",
"Permission denied you cannot remove files from this gallery" => "權限不足, 你無法移除此檔案庫中的檔案",
"Top visited file galleries" => "最常被瀏覽圖庫",
"Most downloaded files" => "最多下傳檔案",
"Last files" => "最新檔案",
"No forum indicated" => "未指定論壇",
"Forum posts" => "論壇文章數",
"No process indicated" => "未指定程序",
"No user indicated" => "未指定使用者",
"No item indicated" => "未指定項目",
"first image" => "第一張影像",
"last image" => "最末張影像",
"Permission denied you cannot create galleries and so you cant edit them" => "權限不足, 你無法建立和編輯檔案庫",
"Permission denied you cannot edit this gallery" => "權限不足, 你無法編輯此檔案庫",
"Permission denied you cannot remove this gallery" => "權限不足, 你無法移除此檔案庫",
"Top images" => "最熱門影像",
"Last images" => "最新影像",
"overwriting old page" => "覆寫舊頁面",
"page created" => "頁面已建立",
"No name indicated for wiki page" => "尚未指定 wiki 頁面名稱",
"Permission denied you cannot view pages like this page" => "權限不足, 你無法觀看此頁面的相似頁面",
"Permission denied you cannot remove articles" => "你沒有權限刪除文章",
"Permission denied you cannot remove banners" => "權限不足, 你無法移除大標題",
"Permission denied you cannot remove this blog" => "權限不足, 你無法移除此 blog",
"Permission denied you can upload files but not to this file gallery" => "權限不足, 你可以上傳檔案, 但不能上傳至此檔案庫",
"Invalid filename (using filters for filenames)" => "不合法檔名 (使用檔名過濾器)",
"Permission denied you can't upload files so you can't edit them" => "權限不足, 你無法上傳檔案也無法編輯",
"The thumbnail name must be" => "縮圖的名稱必須是",
"You cannot admin blogs" => "你無法管理 blogs",
"Permission denied you cannot remove submissions" => "權限不足, 你無法移除意見",
"Permission denied you cannot approve submissions" => "權限不足, 你無法審核意見",
"Permission denied you cannot remove pages" => "權限不足, 你無法移除頁面",
"Must be logged to use this feature" => "必須登入才能使用此功能",
"Welcome at Hawiki" => "歡迎來到 Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "本 Tikiwiki 站臺是為了各種移動裝置設計, 例如 WAP 手機, PDA, i-mode 裝置等等.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "你可以使用移動裝置連接至以下的 URL 來瀏覽本站:",
"About" => "關於",
"You must log in to use this feature" => "你必須登入才能使用此功能",
"You do not have permission to view other users data" => "你沒有權限觀看其他使用者的資料",
"You must be logged in to subscribe to newsletters" => "你必須登入才能訂閱電子報",
"No server indicated" => "未指定伺服器",
"Cannot connect to" => "無法連接至 ",
"Missing information to read news (server,port,username,password,group) required" => "缺少讀取news所需資訊(伺服器,連接埠,使用者名稱,密碼,群組)",
"Cannot get messages" => "無法取得訊息",
"No note indicated" => "未指定備忘錄",
"merged note:" => "合併記事:",
"File is too big" => "檔案過大",
"created from notepad" => "由記事本建立",
"Page already exists" => "頁面已存在",
"Not enough information to display this page" => "沒有足夠資訊顯示此頁面",
"Permission denied you cannot browse this page history" => "你沒有觀看本頁歷程的權限",
"No article indicated" => "未指定文章",
"Article is not published yet" => "文章尚未被發表",
"No post indicated" => "未指定佈告",
"Blog not found" => "找不到 Blog",
"No pages indicated" => "未指定頁面",
"No result indicated" => "未指定結果",
"The passwords don't match" => "密碼錯誤",
"Invalid or unknown username" => "使用者名稱錯誤",
"to the registered email address for" => "至註冊的 email 地址:",
"Permission denied you cannot remove versions from this page" => "你沒有移除本頁版本的權限",
"Cannot rename page maybe new page already exists" => "無法更名頁面, 也許已存在同名頁面",
"Permission denied you cannot rollback this page" => "你無法回復這個頁面",
"Post recommendation at" => "發表建議於",
" successfully sent" => " 成功寄送",
" not sent" => " 未寄送",
"Page must be defined inside a structure to use this feature" => "頁面必須定義在結構中才能使用此功能",
"You cannot take this quiz twice" => "你不能重複參加這個測驗",
"You cannot take this survey twice" => "你不能重複參加這個調查",
"Please create a category first" => "請先建立一個類別",
"No permission to upload zipped file packages" => "沒有權限上傳 zip 壓縮的檔案包",
"Error processing zipped image package" => "處理 zip 壓縮的影像包時發生錯誤",
"No permission to upload zipped image packages" => "沒有權限上傳 zip 壓縮的影像包",
"Permission denied you cannot upload images" => "你沒有上傳影像的權限",
"Permission denied you can upload images but not to this gallery" => "你無法在此圖庫中上傳影像",
"Cannot get image from URL" => "無法由URL取得影像",
"No url indicated" => "未指定url",
"Unknown user" => "不明使用者",
"You are not logged in and no user indicated" => "你尚未登入及指定使用者",
"no" => "否",
"Cannot upload this file not enough quota" => "無法上傳檔案, 磁碟配額不足",
"No banner indicated" => "未指定大標題",
"No blog indicated" => "未指定 blog",
"Permission denied you cannot remove the post" => "權限不足, 你無法移除此佈告",
"No cache information available" => "無快取資訊",
"No faq indicated" => "未指定faq",
"Wrong password. Cannot post comment" => "密碼錯誤. 無法發表評論",
"Please wait 2 minutes between posts" => "請間隔兩分鐘再發表佈告",
"No thread indicated" => "未指定討論串",
"No subject" => "無標題",
"Top pages" => "最熱門頁面",
"Last pages" => "最新頁面",
"###end###"=>"###end###");
?>
