/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.jgraph.GPGraphpad;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.pad.actions.AbstractActionList;
import org.jgraph.pad.actions.AbstractActionListCell;
import org.jgraph.pad.resources.Translator;

public class FormatLineWidthList
extends AbstractActionListCell {
    protected static float[] widths = new float[]{1.0f, 2.0f, 3.0f, 4.0f};

    public FormatLineWidthList(GPGraphpad gPGraphpad) {
        block3: {
            super(gPGraphpad);
            String string = Translator.getString("Widths");
            if (string == null) break block3;
            try {
                String[] stringArray = AbstractActionList.tokenize(string);
                widths = new float[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    FormatLineWidthList.widths[n] = Integer.parseInt(stringArray[n]);
                    ++n;
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void fillCustomItems(Vector vector) {
        int n = 0;
        while (n < widths.length) {
            EdgeView edgeView = new EdgeView(" ", AbstractActionListCell.dummyGraph, AbstractActionListCell.dummyGraph.getGraphLayoutCache());
            Map map = GraphConstants.createMap();
            GraphConstants.setPoints(map, arrowPoints);
            GraphConstants.setLineWidth(map, widths[n]);
            GraphConstants.setLabelPosition(map, AbstractActionList.center);
            edgeView.setAttributes(map);
            vector.add(edgeView);
            ++n;
        }
    }

    protected void fillResetMap(Map map) {
        GraphConstants.setRemoveAttributes(map, new Object[]{"linewidth"});
    }

    protected void fillApplyMap(CellView cellView, Map map) {
        GraphConstants.setLineWidth(map, GraphConstants.getLineWidth(cellView.getAttributes()));
    }

    protected void selectAndFillMap(Map map) {
        block3: {
            if (this.getCurrentGraph().getSelectionCount() <= 0) break block3;
            try {
                float f = Float.parseFloat(JOptionPane.showInputDialog(Translator.getString("WidthDialog")));
                GraphConstants.setLineWidth(map, f);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                this.graphpad.error(exception.toString());
            }
        }
    }
}

