/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.Color;
import java.util.Map;
import java.util.Vector;
import javax.swing.JColorChooser;
import org.jgraph.GPGraphpad;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.pad.actions.AbstractActionList;
import org.jgraph.pad.actions.AbstractActionListCell;
import org.jgraph.pad.actions.AbstractActionListCellColor;
import org.jgraph.pad.resources.Translator;

public class FormatLineColorList
extends AbstractActionListCellColor {
    public FormatLineColorList(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
    }

    protected void fillCustomItems(Vector vector) {
        int n = 0;
        while (n < this.colors.length) {
            EdgeView edgeView = new EdgeView(" ", AbstractActionListCell.dummyGraph, AbstractActionListCell.dummyGraph.getGraphLayoutCache());
            Map map = GraphConstants.createMap();
            GraphConstants.setPoints(map, AbstractActionListCell.arrowPoints);
            GraphConstants.setLineColor(map, this.colors[n]);
            GraphConstants.setLabelPosition(map, AbstractActionList.center);
            edgeView.setAttributes(map);
            vector.add(edgeView);
            ++n;
        }
    }

    protected void fillResetMap(Map map) {
        GraphConstants.setRemoveAttributes(map, new Object[]{"linecolor"});
    }

    protected void fillApplyMap(CellView cellView, Map map) {
        GraphConstants.setLineColor(map, GraphConstants.getLineColor(cellView.getAttributes()));
    }

    protected void selectAndFillMap(Map map) {
        Color color;
        if (this.getCurrentGraph().getSelectionCount() > 0 && (color = JColorChooser.showDialog(this.graphpad.getFrame(), Translator.getString("ColorDialog"), null)) != null) {
            GraphConstants.setLineColor(map, color);
        }
    }
}

