/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.physics;

import br.arca.morcego.Config;
import br.arca.morcego.physics.PunctualBody;
import br.arca.morcego.physics.Vector3D;

public class Spring {
    private float size;
    private float elasticConstant;
    protected PunctualBody body1;
    protected PunctualBody body2;

    public Spring(PunctualBody b1, PunctualBody b2) {
        this.body1 = b1;
        this.body2 = b2;
        this.size = Config.getFloat(Config.springSize);
        this.elasticConstant = Config.getFloat(Config.elasticConstant);
    }

    public Vector3D strech() {
        Vector3D force = new Vector3D(this.body1.x - this.body2.x, this.body1.y - this.body2.y, this.body1.z - this.body2.z);
        float distance = force.module();
        if (distance > 0.0f) {
            force.resize(1.0f / distance);
        }
        force.resize((distance - this.size) * this.elasticConstant);
        return force.opposite();
    }

    public float getElasticConstant() {
        return this.elasticConstant;
    }

    public void setElasticConstant(float elasticConstant) {
        this.elasticConstant = elasticConstant;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }
}

