'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.11.1/tcllib-1.11.1/modules/struct/graphops.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2008 Alejandro Paz <vidriloco@gmail.com>
'\" Copyright (c) 2008 (docs) Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "struct::graph::op" n 0.9 struct "Tcl Data Structures"
.BS
.SH NAME
struct::graph::op \- Operation for (un)directed graph objects
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBstruct::graph::op  ?0.9?\fR
.sp
\fBstruct::graph:op::toAdjacencyMatrix\fR \fIg\fR
.sp
\fBstruct::graph:op::kruskal\fR \fIg\fR
.sp
\fBstruct::graph:op::prim\fR \fIg\fR
.sp
\fBstruct::graph:op::isBipartite?\fR \fIg\fR ?\fIbipartvar\fR?
.sp
\fBstruct::graph:op::tarjan\fR \fIg\fR
.sp
\fBstruct::graph:op::connectedComponents\fR \fIg\fR
.sp
\fBstruct::graph:op::connectedComponentOf\fR \fIg\fR \fIn\fR
.sp
\fBstruct::graph:op::isConnected?\fR \fIg\fR
.sp
\fBstruct::graph:op::isCutVertex?\fR \fIg\fR \fIn\fR
.sp
\fBstruct::graph:op::isBridge?\fR \fIg\fR \fIa\fR
.sp
\fBstruct::graph:op::isEulerian?\fR \fIg\fR ?\fItourvar\fR?
.sp
\fBstruct::graph:op::isSemiEulerian?\fR \fIg\fR ?\fIpathvar\fR?
.sp
\fBstruct::graph:op::dijkstra\fR \fIg\fR \fIstart\fR ?\fIoptions\fR...?
.sp
\fBstruct::graph:op::distance\fR \fIg\fR \fIorigin\fR \fIdestination\fR ?\fIoptions\fR...?
.sp
\fBstruct::graph:op::eccentricity\fR \fIg\fR \fIn\fR ?\fIoptions\fR...?
.sp
\fBstruct::graph:op::radius\fR \fIg\fR ?\fIoptions\fR...?
.sp
\fBstruct::graph:op::diameter\fR \fIg\fR ?\fIoptions\fR...?
.sp
.BE
.SH DESCRIPTION
.PP
The package described by this document, \fBstruct::graph::op\fR,
is a companion to the package \fBstruct::graph\fR. It provides a
series of common operations and algorithms applicable to (un)directed
graphs.
.PP
Despite being a companion the package is not directly dependent on
\fBstruct::graph\fR, only on the API defined by that
package. I.e. the operations of this package can be applied to any and
all graph objects which provide the same API as the objects created
through \fBstruct::graph\fR.
.SH OPERATIONS
.TP
\fBstruct::graph:op::toAdjacencyMatrix\fR \fIg\fR
This command takes the graph \fIg\fR and returns a nested list
containing the adjacency matrix of \fIg\fR.
.sp
The elements of the outer list are the rows of the matrix, the inner
elements are the column values in each row. The matrix has "\fBn\fR+1"
rows and columns, with the first row and column (index 0) containing
the name of the node the row/column is for. All other elements are
boolean values, \fBTrue\fR if there is an arc between the 2 nodes
of the respective row and column, and \fBFalse\fR otherwise.
.sp
Note that the matrix is symmetric. It does not represent the
directionality of arcs, only their presence between nodes. It is also
unable to represent parallel arcs in \fIg\fR.
.TP
\fBstruct::graph:op::kruskal\fR \fIg\fR
This command takes the graph \fIg\fR and returns a list containing the
names of the arcs in \fIg\fR which span up a minimum spanning tree
(MST), or, in the case of an un-connected graph, a minimum spanning
forest. Kruskal's algorithm is used to compute the tree or forest.
.sp
The command will throw an error if one or more arcs in \fIg\fR have no
weight associated with them.
.sp
A note regarding the result, the command refrains from explicitly
listing the nodes of the MST as this information is implicitly
provided in the arcs already.
.TP
\fBstruct::graph:op::prim\fR \fIg\fR
This command takes the graph \fIg\fR and returns a list containing the
names of the arcs in \fIg\fR which span up a minimum spanning tree
(MST), or, in the case of an un-connected graph, a minimum spanning
forest. Prim's algorithm is used to compute the tree or forest.
.sp
The command will throw an error if one or more arcs in \fIg\fR have no
weight associated with them.
.sp
A note regarding the result, the command refrains from explicitly
listing the nodes of the MST as this information is implicitly
provided in the arcs already.
.TP
\fBstruct::graph:op::isBipartite?\fR \fIg\fR ?\fIbipartvar\fR?
This command takes the graph \fIg\fR and returns a boolean value
indicating whether it is bipartite (\fBtrue\fR) or not
(\fBfalse\fR). If the variable \fIbipartvar\fR is specified the two
partitions of the graph are there as a list, if, and only if the graph
is bipartit. If it is not the variable, if specified, is not touched.
.TP
\fBstruct::graph:op::tarjan\fR \fIg\fR
This command computes the set of \fIstrongly connected\fR
components (SCCs) of the graph \fIg\fR. The result of the command is a
list of sets, each of which contains the nodes for one of the SCCs of
\fIg\fR. The union of all SCCs covers the whole graph, and no two SCCs
intersect with each other.
.sp
The graph \fIg\fR is \fIacyclic\fR if all SCCs in the result contain
only a single node. The graph \fIg\fR is \fIstrongly connected\fR
if the result contains only a single SCC containing all nodes of
\fIg\fR.
.TP
\fBstruct::graph:op::connectedComponents\fR \fIg\fR
This command computes the set of \fIconnected\fR components (CCs) of
the graph \fIg\fR. The result of the command is a list of sets, each
of which contains the nodes for one of the CCs of \fIg\fR. The union
of all CCs covers the whole graph, and no two CCs intersect with each
other.
.sp
The graph \fIg\fR is \fIconnected\fR if the result contains only a
single SCC containing all nodes of \fIg\fR.
.TP
\fBstruct::graph:op::connectedComponentOf\fR \fIg\fR \fIn\fR
This command computes the \fIconnected\fR component (CC) of the graph
\fIg\fR containing the node \fIn\fR. The result of the command is a
sets which contains the nodes for the CC of \fIn\fR in \fIg\fR.
.sp
The command will throw an error if \fIn\fR is not a node of the graph
\fIg\fR.
.TP
\fBstruct::graph:op::isConnected?\fR \fIg\fR
This is a convenience command determining whether the graph \fIg\fR is
\fIconnected\fR or not.  The result is a boolean value, \fBtrue\fR
if the graph is connected, and \fBfalse\fR otherwise.
.TP
\fBstruct::graph:op::isCutVertex?\fR \fIg\fR \fIn\fR
This command determines whether the node \fIn\fR in the graph \fIg\fR
is a \fIcut vertex\fR (aka \fIarticulation point\fR). The result
is a boolean value, \fBtrue\fR if the node is a cut vertex, and
\fBfalse\fR otherwise.
.sp
The command will throw an error if \fIn\fR is not a node of the graph
\fIg\fR.
.TP
\fBstruct::graph:op::isBridge?\fR \fIg\fR \fIa\fR
This command determines whether the arc \fIa\fR in the graph \fIg\fR
is a \fIbridge\fR (aka \fIcut edge\fR, or \fIisthmus\fR). The
result is a boolean value, \fBtrue\fR if the arc is a bridge, and
\fBfalse\fR otherwise.
.sp
The command will throw an error if \fIa\fR is not an arc of the graph
\fIg\fR.
.TP
\fBstruct::graph:op::isEulerian?\fR \fIg\fR ?\fItourvar\fR?
This command determines whether the graph \fIg\fR is \fIeulerian\fR
or not.  The result is a boolean value, \fBtrue\fR if the graph is
eulerian, and \fBfalse\fR otherwise.
.sp
If the graph is eulerian and \fItourvar\fR is specified then an euler
tour is computed as well and stored in the named variable. The tour is
represented by the list of arcs traversed, in the order of traversal.
.TP
\fBstruct::graph:op::isSemiEulerian?\fR \fIg\fR ?\fIpathvar\fR?
This command determines whether the graph \fIg\fR is
\fIsemi-eulerian\fR or not.  The result is a boolean value, \fBtrue\fR
if the graph is semi-eulerian, and \fBfalse\fR otherwise.
.sp
If the graph is semi-eulerian and \fIpathvar\fR is specified then an
euler path is computed as well and stored in the named variable. The
path is represented by the list of arcs traversed, in the order of
traversal.
.TP
\fBstruct::graph:op::dijkstra\fR \fIg\fR \fIstart\fR ?\fIoptions\fR...?
This command determines distances in the weighted \fIg\fR from the
node \fIstart\fR to all other nodes in the graph. The options specify
how to traverse graphs, and the format of the result.
.sp
Two options are recognized
.RS
.TP
\fB-arcmode\fR mode
The accepted mode values are \fBdirected\fR and \fBundirected\fR.
For directed traversal all arcs are traversed from source to
target. For undirected traversal all arcs are traversed in the
opposite direction as well. Undirected traversal is the default.
.TP
\fB-outputformat\fR format
The accepted format values are \fBdistances\fR and \fBtree\fR. In
both cases the result is a dictionary keyed by the names of all nodes
in the graph. For \fBdistances\fR the value is the distance of the
node to \fIstart\fR, whereas for \fBtree\fR the value is the path
from the node to \fIstart\fR, excluding the node itself, but including
\fIstart\fR. Tree format is the default.
.RE
.TP
\fBstruct::graph:op::distance\fR \fIg\fR \fIorigin\fR \fIdestination\fR ?\fIoptions\fR...?
This command determines the (un)directed distance between the two
nodes \fIorigin\fR and \fIdestination\fR in the graph \fIg\fR. It
accepts the option \fB-arcmode\fR of \fBstruct::graph:op::dijkstra\fR.
.TP
\fBstruct::graph:op::eccentricity\fR \fIg\fR \fIn\fR ?\fIoptions\fR...?
This command determines the (un)directed \fIeccentricity\fR of the
node \fIn\fR in the graph \fIg\fR. It accepts the option
\fB-arcmode\fR of \fBstruct::graph:op::dijkstra\fR.
.sp
The (un)directed \fIeccentricity\fR of a node is the maximal
(un)directed distance between the node and any other node in the
graph.
.TP
\fBstruct::graph:op::radius\fR \fIg\fR ?\fIoptions\fR...?
This command determines the (un)directed \fIradius\fR of the graph
\fIg\fR. It accepts the option \fB-arcmode\fR of \fBstruct::graph:op::dijkstra\fR.
.sp
The (un)directed \fIradius\fR of a graph is the minimal (un)directed
\fIeccentricity\fR of all nodes in the graph.
.TP
\fBstruct::graph:op::diameter\fR \fIg\fR ?\fIoptions\fR...?
This command determines the (un)directed \fIdiameter\fR of the graph
\fIg\fR. It accepts the option \fB-arcmode\fR of \fBstruct::graph:op::dijkstra\fR.
.sp
The (un)directed \fIdiameter\fR of a graph is the maximal (un)directed
\fIeccentricity\fR of all nodes in the graph.
.PP
.SH REFERENCES
.IP [1]
\fIAdjacency matrix\fR [http://en.wikipedia.org/wiki/Adjacency_matrix]
.IP [2]
\fIKruskal's algorithm\fR [http://en.wikipedia.org/wiki/Kruskal%27s_algorithm]
.IP [3]
\fIPrim's algorithm\fR [http://en.wikipedia.org/wiki/Prim%27s_algorithm]
.IP [4]
\fIBipartite graph\fR [http://en.wikipedia.org/wiki/Bipartite_graph]
.IP [5]
\fIStrongly connected components\fR [http://en.wikipedia.org/wiki/Strongly_connected_components]
.IP [6]
\fITarjan's strongly connected components algorithm\fR [http://en.wikipedia.org/wiki/Tarjan%27s_strongly_connected_components_algorithm]
.IP [7]
\fICut vertex\fR [http://en.wikipedia.org/wiki/Cut_vertex]
.IP [8]
\fIBridge\fR [http://en.wikipedia.org/wiki/Bridge_(graph_theory)]
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIstruct :: graph\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
adjacency matrix, adjacent, arc, articulation point, bipartite, bridge, connected component, cut edge, cut vertex, degree, diameter, dijkstra, distance, eccentricity, edge, graph, isthmus, loop, minimal spanning tree, neighbour, node, radius, strongly connected component, subgraph, vertex
.SH COPYRIGHT
.nf
Copyright (c) 2008 Alejandro Paz <vidriloco@gmail.com>
Copyright (c) 2008 (docs) Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi