/*MHskinshader ver. 0.9a
Author: Manuel Bastioni
Email: info@makehuman.org
Site: http://www.makehuman.org
License: GPL*/


color screen (color F; color B) {
       color W = (1,1,1);
	   color R = W - (W - F)*(W - B);
	   return R;
} 
 
 //THE SSS DIFFUSE USING SHADOW MAPS 
 color mydiffuse(normal N) { 
       color C = 0;	   
       illuminance( P, N, PI ) {
       C += Cl;	   
	   }
       return C; 
} 


 //THE WRAP DIFFUSE
 color mydiffuse2(normal N) { 
color C = 0;
illuminance( P, N, PI/2 )
C += asin(normalize(L).N)/(0.6*PI);
return C;
}

//C += Cl * asin(normalize(L).N)/(0.6*PI);	
surface MHskin (float Ka = 1;
				float Kd = 2; 
				float oil = 1;
				string colortexture = ""; 
				string ssstexture = "";
				string spectexture = ""; 
				string roughtexture = ""; 
				string alphatexture = "";
				float poresdensity = 100;
				float sss = 1.5;
				float melanin = 1.5
				)
{

    normal Nf = faceforward (normalize(N),I);
	color skin_color = Cs;
	float sss_value;
	float roughness;
	float f = (float noise((poresdensity)*P));
	float specularity;
	vector Vf = -normalize(I);
	float ill = 0;
	 
	Oi = Os;
	
	if (colortexture != "")
	    skin_color = color texture (colortexture);
	if (roughtexture != "")
	    roughness = float texture (roughtexture);
	if (ssstexture != "")
	    sss_value = float texture (ssstexture);
	if (spectexture != "")
	     specularity = f * float texture (spectexture);
	if (alphatexture != "")
	    Oi = color texture (alphatexture);
		 
	color Lambert = mydiffuse2(Nf);
    
	Ci = skin_color * Kd * screen(mydiffuse2(Nf)*.3, clamp(mydiffuse(Nf)*sss,0.2,0.6)); //clamp is used to avoid incandescence and black areas
	

	Ci -= melanin+(((color max((1-Lambert),0.7))-0.7)/6);
	color glancing_highlight = max(0,((1-(( Vf.Nf)/0.6))*comp(Ci,1)));		
	Ci += glancing_highlight;
	
	Ci *= Oi;
    Ci += Oi * Cs * Ka * ambient() + Oi * oil * specularity *specular(Nf,-normalize(I),roughness);	

	
}
