#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2000-2007  Donald N. Allingham
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# $Id: _ChildModel.py 9912 2008-01-22 09:17:46Z acraphae $

#-------------------------------------------------------------------------
#
# GTK libraries
#
#-------------------------------------------------------------------------
import gtk
import cgi

#-------------------------------------------------------------------------
#
# GRAMPS classes
#
#-------------------------------------------------------------------------
import DateHandler
from BasicUtils import name_displayer
import Utils
from ReportBase import ReportUtils
import gen.lib

#-------------------------------------------------------------------------
#
# ChildModel
#
#-------------------------------------------------------------------------
class ChildModel(gtk.ListStore):

    _HANDLE_COL = -8
    
    def __init__(self, family, db):
        self.family = family
        gtk.ListStore.__init__(self, int, str, str, str, str, str, 
                               str, str, str, str, str, str, int, int)
        self.db = db
        index = 1
        for child_ref in self.get_data():
            child = db.get_person_from_handle(child_ref.ref)
            self.append(row=[
                index, 
                child.get_gramps_id(), 
                name_displayer.display(child), 
                Utils.gender[child.get_gender()], 
                str(child_ref.get_father_relation()), 
                str(child_ref.get_mother_relation()),
                self.column_birth_day(child), 
                self.column_death_day(child), 
                self.column_birth_place(child), 
                self.column_death_place(child), 
                child.get_handle(), 
                name_displayer.sort_string(child.primary_name), 
                self.column_birth_sort(child), 
                self.column_death_sort(child),
                ])
            index += 1

    def get_data(self):
        return self.family.get_child_ref_list()

    def column_birth_day(self, data):
        birth = ReportUtils.get_birth_or_fallback(self.db, data)
        if birth:
            if birth.get_type() == gen.lib.EventType.BIRTH:
                return DateHandler.get_date(birth)
            else:
                return '<i>%s</i>' % cgi.escape(DateHandler.get_date(birth))
        else:
            return u""

    def column_birth_sort(self, data):
        event_ref = data.get_birth_ref()
        if event_ref and event_ref.ref:
            event = self.db.get_event_from_handle(event_ref.ref)
            return event.get_date_object().get_sort_value()
        else:
            return 0

    def column_death_day(self, data):
        event_ref = data.get_death_ref()
        if event_ref and event_ref.ref:
            event = self.db.get_event_from_handle(event_ref.ref)
            return DateHandler.get_date(event)
        else:
            return u""

    def column_death_sort(self, data):
        event_ref = data.get_death_ref()
        if event_ref and event_ref.ref:
            event = self.db.get_event_from_handle(event_ref.ref)
            return event.get_date_object().get_sort_value()
        else:
            return 0
        
    def column_birth_place(self, data):
        event_ref = data.get_birth_ref()
        if event_ref and event_ref.ref:
            event = self.db.get_event_from_handle(event_ref.ref)
            if event:
                place_handle = event.get_place_handle()
                if place_handle:
                    return self.db.get_place_from_handle(place_handle).get_title()
        return u""

    def column_death_place(self, data):
        event_ref = data.get_death_ref()
        if event_ref and event_ref.ref:
            event = self.db.get_event_from_handle(event_ref.ref)
            if event:
                place_handle = event.get_place_handle()
                if place_handle:
                    return self.db.get_place_from_handle(place_handle).get_title()
        return u""
