require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&HEADER_PQ_COMPAT_H)) {
    eval 'sub HEADER_PQ_COMPAT_H () {1;}' unless defined(&HEADER_PQ_COMPAT_H);
    require 'openssl/opensslconf.ph';
    require 'openssl/bn.ph';
    if((defined( &THIRTY_TWO_BIT)  && !defined( &BN_LLONG)) || defined( &SIXTEEN_BIT) || defined( &EIGHT_BIT)) {
	eval 'sub PQ_64BIT_IS_INTEGER () {0;}' unless defined(&PQ_64BIT_IS_INTEGER);
	eval 'sub PQ_64BIT_IS_BIGNUM () {1;}' unless defined(&PQ_64BIT_IS_BIGNUM);
	eval 'sub PQ_64BIT () { &BIGNUM;}' unless defined(&PQ_64BIT);
	eval 'sub PQ_64BIT_CTX () { &BN_CTX;}' unless defined(&PQ_64BIT_CTX);
	eval 'sub pq_64bit_init {
	    my($x) = @_;
    	    eval q( &BN_init($x));
	}' unless defined(&pq_64bit_init);
	eval 'sub pq_64bit_free {
	    my($x) = @_;
    	    eval q( &BN_free($x));
	}' unless defined(&pq_64bit_free);
	eval 'sub pq_64bit_ctx_new {
	    my($ctx) = @_;
    	    eval q( &BN_CTX_new());
	}' unless defined(&pq_64bit_ctx_new);
	eval 'sub pq_64bit_ctx_free {
	    my($x) = @_;
    	    eval q( &BN_CTX_free($x));
	}' unless defined(&pq_64bit_ctx_free);
	eval 'sub pq_64bit_assign {
	    my($x, $y) = @_;
    	    eval q( &BN_copy($x, $y));
	}' unless defined(&pq_64bit_assign);
	eval 'sub pq_64bit_assign_word {
	    my($x, $y) = @_;
    	    eval q( &BN_set_word($x, $y));
	}' unless defined(&pq_64bit_assign_word);
	eval 'sub pq_64bit_gt {
	    my($x, $y) = @_;
    	    eval q( &BN_ucmp($x, $y) >= 1? 1: 0);
	}' unless defined(&pq_64bit_gt);
	eval 'sub pq_64bit_eq {
	    my($x, $y) = @_;
    	    eval q( &BN_ucmp($x, $y) == 0? 1: 0);
	}' unless defined(&pq_64bit_eq);
	eval 'sub pq_64bit_add_word {
	    my($x, $w) = @_;
    	    eval q( &BN_add_word($x, $w));
	}' unless defined(&pq_64bit_add_word);
	eval 'sub pq_64bit_sub {
	    my($r, $x, $y) = @_;
    	    eval q( &BN_sub($r, $x, $y));
	}' unless defined(&pq_64bit_sub);
	eval 'sub pq_64bit_sub_word {
	    my($x, $w) = @_;
    	    eval q( &BN_sub_word($x, $w));
	}' unless defined(&pq_64bit_sub_word);
	eval 'sub pq_64bit_mod {
	    my($r, $x, $n, $ctx) = @_;
    	    eval q( &BN_mod($r, $x, $n, $ctx));
	}' unless defined(&pq_64bit_mod);
	eval 'sub pq_64bit_bin2num {
	    my($bn, $bytes, $len) = @_;
    	    eval q( &BN_bin2bn($bytes, $len, $bn));
	}' unless defined(&pq_64bit_bin2num);
	eval 'sub pq_64bit_num2bin {
	    my($bn, $bytes) = @_;
    	    eval q( &BN_bn2bin($bn, $bytes));
	}' unless defined(&pq_64bit_num2bin);
	eval 'sub pq_64bit_get_word {
	    my($x) = @_;
    	    eval q( &BN_get_word($x));
	}' unless defined(&pq_64bit_get_word);
	eval 'sub pq_64bit_is_bit_set {
	    my($x, $offset) = @_;
    	    eval q( &BN_is_bit_set($x, $offset));
	}' unless defined(&pq_64bit_is_bit_set);
	eval 'sub pq_64bit_lshift {
	    my($r, $x, $shift) = @_;
    	    eval q( &BN_lshift($r, $x, $shift));
	}' unless defined(&pq_64bit_lshift);
	eval 'sub pq_64bit_set_bit {
	    my($x, $num) = @_;
    	    eval q( &BN_set_bit($x, $num));
	}' unless defined(&pq_64bit_set_bit);
	eval 'sub pq_64bit_get_length {
	    my($x) = @_;
    	    eval q( &BN_num_bits(($x)));
	}' unless defined(&pq_64bit_get_length);
    } else {
	eval 'sub PQ_64BIT_IS_INTEGER () {1;}' unless defined(&PQ_64BIT_IS_INTEGER);
	eval 'sub PQ_64BIT_IS_BIGNUM () {0;}' unless defined(&PQ_64BIT_IS_BIGNUM);
	if(defined( &SIXTY_FOUR_BIT)) {
	    eval 'sub PQ_64BIT () { &BN_ULONG;}' unless defined(&PQ_64BIT);
	    eval 'sub PQ_64BIT_PRINT () {"%lld";}' unless defined(&PQ_64BIT_PRINT);
	}
 elsif(defined( &SIXTY_FOUR_BIT_LONG)) {
	    eval 'sub PQ_64BIT () { &BN_ULONG;}' unless defined(&PQ_64BIT);
	    eval 'sub PQ_64BIT_PRINT () {"%ld";}' unless defined(&PQ_64BIT_PRINT);
	}
 elsif(defined( &THIRTY_TWO_BIT)) {
	    eval 'sub PQ_64BIT () { &BN_ULLONG;}' unless defined(&PQ_64BIT);
	    eval 'sub PQ_64BIT_PRINT () {"%lld";}' unless defined(&PQ_64BIT_PRINT);
	}
	eval 'sub PQ_64BIT_CTX () { &void;}' unless defined(&PQ_64BIT_CTX);
	eval 'sub pq_64bit_init {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&pq_64bit_init);
	eval 'sub pq_64bit_free {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&pq_64bit_free);
	eval 'sub pq_64bit_ctx_new {
	    my($ctx) = @_;
    	    eval q(($ctx));
	}' unless defined(&pq_64bit_ctx_new);
	eval 'sub pq_64bit_ctx_free {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&pq_64bit_ctx_free);
	eval 'sub pq_64bit_assign {
	    my($x, $y) = @_;
    	    eval q((*($x) = *($y)));
	}' unless defined(&pq_64bit_assign);
	eval 'sub pq_64bit_assign_word {
	    my($x, $y) = @_;
    	    eval q((*($x) = $y));
	}' unless defined(&pq_64bit_assign_word);
	eval 'sub pq_64bit_gt {
	    my($x, $y) = @_;
    	    eval q((*($x) > *($y)));
	}' unless defined(&pq_64bit_gt);
	eval 'sub pq_64bit_eq {
	    my($x, $y) = @_;
    	    eval q((*($x) == *($y)));
	}' unless defined(&pq_64bit_eq);
	eval 'sub pq_64bit_add_word {
	    my($x, $w) = @_;
    	    eval q((*($x) = (*($x) + ($w))));
	}' unless defined(&pq_64bit_add_word);
	eval 'sub pq_64bit_sub {
	    my($r, $x, $y) = @_;
    	    eval q((*($r) = (*($x) - *($y))));
	}' unless defined(&pq_64bit_sub);
	eval 'sub pq_64bit_sub_word {
	    my($x, $w) = @_;
    	    eval q((*($x) = (*($x) - ($w))));
	}' unless defined(&pq_64bit_sub_word);
	eval 'sub pq_64bit_mod {
	    my($r, $x, $n, $ctx) = @_;
    	    eval q();
	}' unless defined(&pq_64bit_mod);
	eval 'sub pq_64bit_bin2num {
	    my($num, $bytes, $len) = @_;
    	    eval q( &bytes_to_long_long($bytes, $num));
	}' unless defined(&pq_64bit_bin2num);
	eval 'sub pq_64bit_num2bin {
	    my($num, $bytes) = @_;
    	    eval q( &long_long_to_bytes($num, $bytes));
	}' unless defined(&pq_64bit_num2bin);
	eval 'sub pq_64bit_get_word {
	    my($x) = @_;
    	    eval q(*($x));
	}' unless defined(&pq_64bit_get_word);
	eval 'sub pq_64bit_lshift {
	    my($r, $x, $shift) = @_;
    	    eval q((*($r) = (*($x) << ($shift))));
	}' unless defined(&pq_64bit_lshift);
	eval 'sub pq_64bit_set_bit {
	    my($x, $num) = @_;
    	    eval q( &do {  &PQ_64BIT  &mask = 1;  &mask =  &mask << ($num); *($x) |=  &mask; }  &while(0));
	}' unless defined(&pq_64bit_set_bit);
    }
}
1;
