require '_h2ph_pre.ph';

no warnings 'redefine';

require 'machine/cpu.ph';
require 'machine/intr.ph';
unless(defined(&_MACHINE)) {
    sub _MACHINE () {	 &hppa;}
}
unless(defined(&MACHINE)) {
    sub MACHINE () {	"hppa";}
}
unless(defined(&_MACHINE_ARCH)) {
    sub _MACHINE_ARCH () {	 &hppa;}
}
unless(defined(&MACHINE_ARCH)) {
    sub MACHINE_ARCH () {	"hppa";}
}
unless(defined(&MID_MACHINE)) {
    sub MID_MACHINE () {	 &MID_HPUX800;}
}
unless(defined(&ALIGNBYTES)) {
    sub ALIGNBYTES () {	7;}
}
unless(defined(&ALIGN)) {
    sub ALIGN {
	my($p) = @_;
	eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }
}
unless(defined(&ALIGNED_POINTER)) {
    sub ALIGNED_POINTER {
	my($p,$t) = @_;
	eval q((((($p)) & ($sizeof{$t} - 1)) == 0));
    }
}
unless(defined(&PAGE_SIZE)) {
    sub PAGE_SIZE () {	4096;}
}
unless(defined(&PAGE_MASK)) {
    sub PAGE_MASK () {	( &PAGE_SIZE-1);}
}
unless(defined(&PAGE_SHIFT)) {
    sub PAGE_SHIFT () {	12;}
}
unless(defined(&NBPG)) {
    sub NBPG () {	4096;}
}
unless(defined(&PGOFSET)) {
    sub PGOFSET () {	( &NBPG-1);}
}
unless(defined(&PGSHIFT)) {
    sub PGSHIFT () {	12;}
}
unless(defined(&KERNBASE)) {
    sub KERNBASE () {	0x;}
}
unless(defined(&DEV_BSHIFT)) {
    sub DEV_BSHIFT () {	9;}
}
unless(defined(&DEV_BSIZE)) {
    sub DEV_BSIZE () {	(1<<  &DEV_BSHIFT);}
}
unless(defined(&BLKDEV_IOSIZE)) {
    sub BLKDEV_IOSIZE () {	2048;}
}
unless(defined(&MAXPHYS)) {
    sub MAXPHYS () {	(64* 1024);}
}
unless(defined(&MACHINE_STACK_GROWS_UP)) {
    sub MACHINE_STACK_GROWS_UP () {	1;}
}
unless(defined(&USPACE)) {
    sub USPACE () {	(4*  &NBPG);}
}
unless(defined(&USPACE_ALIGN)) {
    sub USPACE_ALIGN () {	(0);}
}
unless(defined(&MSGBUFSIZE)) {
    eval 'sub MSGBUFSIZE () {2* &NBPG;}' unless defined(&MSGBUFSIZE);
}
unless(defined(&MSIZE)) {
    sub MSIZE () {	256;}
}
unless(defined(&MCLSHIFT)) {
    sub MCLSHIFT () {	11;}
}
unless(defined(&MCLBYTES)) {
    sub MCLBYTES () {	(1<<  &MCLSHIFT);}
}
unless(defined(&MCLOFSET)) {
    sub MCLOFSET () {	( &MCLBYTES - 1);}
}
unless(defined(&NMBCLUSTERS)) {
    sub NMBCLUSTERS () {	4096;}
}
unless(defined(&NKMEMPAGES_MIN_DEFAULT)) {
    sub NKMEMPAGES_MIN_DEFAULT () {	((4* 1024* 1024) >>  &PAGE_SHIFT);}
}
unless(defined(&NKMEMPAGES_MAX_DEFAULT)) {
    sub NKMEMPAGES_MAX_DEFAULT () {	((128* 1024* 1024) >>  &PAGE_SHIFT);}
}
unless(defined(&ctod)) {
    sub ctod {
	my($x) = @_;
	eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&dtoc)) {
    sub dtoc {
	my($x) = @_;
	eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&btodb)) {
    sub btodb {
	my($x) = @_;
	eval q((($x) >>  &DEV_BSHIFT));
    }
}
unless(defined(&dbtob)) {
    sub dbtob {
	my($x) = @_;
	eval q((($x) <<  &DEV_BSHIFT));
    }
}
if(defined(&_KERNEL)) {
    if(defined(&COMPAT_HPUX)) {
	eval 'sub HPMMMASK () {0xf0000000;}' unless defined(&HPMMMASK);
	eval 'sub ISHPMMADDR {
	    my($v) = @_;
    	    eval q(0);
	}' unless defined(&ISHPMMADDR);
	eval 'sub HPMMBASEADDR {
	    my($v) = @_;
    	    eval q((($v) & ~ &HPMMMASK));
	}' unless defined(&HPMMBASEADDR);
    }
}
unless(defined(&__SWAP_BROKEN)) {
    sub __SWAP_BROKEN () {	1;}
}
1;
