require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&CS4280_BA0_SIZE)) {
    sub CS4280_BA0_SIZE () {	0x2000;}
}
unless(defined(&CS4280_BA1_SIZE)) {
    sub CS4280_BA1_SIZE () {	0x40000;}
}
unless(defined(&CS4280_HISR)) {
    sub CS4280_HISR () {	0x;}
}
unless(defined(&HISR_INTENA)) {
    sub HISR_INTENA () {	0x80000000;}
}
unless(defined(&HISR_MIDI)) {
    sub HISR_MIDI () {	0x100000;}
}
unless(defined(&HISR_CINT)) {
    sub HISR_CINT () {	0x2;}
}
unless(defined(&HISR_PINT)) {
    sub HISR_PINT () {	0x1;}
}
unless(defined(&CS4280_HICR)) {
    sub CS4280_HICR () {	0x8;}
}
unless(defined(&HICR_CHGM)) {
    sub HICR_CHGM () {	0x2;}
}
unless(defined(&HICR_IEV)) {
    sub HICR_IEV () {	0x1;}
}
unless(defined(&CS4280_CLKCR1)) {
    sub CS4280_CLKCR1 () {	0x400;}
}
unless(defined(&CLKCR1_PLLSS_SPBC)) {
    sub CLKCR1_PLLSS_SPBC () {	0x;}
}
unless(defined(&CLKCR1_PLLSS_RSV)) {
    sub CLKCR1_PLLSS_RSV () {	0x4;}
}
unless(defined(&CLKCR1_PLLSS_PCI)) {
    sub CLKCR1_PLLSS_PCI () {	0x8;}
}
unless(defined(&CLKCR1_PLLSS_RSV2)) {
    sub CLKCR1_PLLSS_RSV2 () {	0xc;}
}
unless(defined(&CLKCR1_PLLP)) {
    sub CLKCR1_PLLP () {	0x10;}
}
unless(defined(&CLKCR1_SWCE)) {
    sub CLKCR1_SWCE () {	0x20;}
}
unless(defined(&CS4280_CLKCR2)) {
    sub CS4280_CLKCR2 () {	0x404;}
}
unless(defined(&CLKCR2_PDIVS_RSV)) {
    sub CLKCR2_PDIVS_RSV () {	0x2;}
}
unless(defined(&CLKCR2_PDIVS_8)) {
    sub CLKCR2_PDIVS_8 () {	0x8;}
}
unless(defined(&CLKCR2_PDIVS_16)) {
    sub CLKCR2_PDIVS_16 () {	0x;}
}
unless(defined(&CS4280_PLLM)) {
    sub CS4280_PLLM () {	0x408;}
}
unless(defined(&PLLM_STATE)) {
    sub PLLM_STATE () {	0x3a;}
}
unless(defined(&CS4280_PLLCC)) {
    sub CS4280_PLLCC () {	0x40c;}
}
unless(defined(&PLLCC_CDR_STATE)) {
    sub PLLCC_CDR_STATE () {	0x6;}
}
unless(defined(&PLLCC_LPF_STATE)) {
    sub PLLCC_LPF_STATE () {	0x78;}
}
unless(defined(&CS4280_SERMC1)) {
    sub CS4280_SERMC1 () {	0x420;}
}
unless(defined(&SERMC1_MSPE)) {
    sub SERMC1_MSPE () {	0x1;}
}
unless(defined(&SERMC1_PTC_MASK)) {
    sub SERMC1_PTC_MASK () {	0xe;}
}
unless(defined(&SERMC1_PTC_CS423X)) {
    sub SERMC1_PTC_CS423X () {	0x;}
}
unless(defined(&SERMC1_PTC_AC97)) {
    sub SERMC1_PTC_AC97 () {	0x2;}
}
unless(defined(&SERMC1_PLB_EN)) {
    sub SERMC1_PLB_EN () {	0x10;}
}
unless(defined(&SERMC1_XLB_EN)) {
    sub SERMC1_XLB_EN () {	0x20;}
}
unless(defined(&CS4280_SERC1)) {
    sub CS4280_SERC1 () {	0x428;}
}
unless(defined(&SERC1_SO1EN)) {
    sub SERC1_SO1EN () {	0x1;}
}
unless(defined(&SERC1_SO1F_MASK)) {
    sub SERC1_SO1F_MASK () {	0xe;}
}
unless(defined(&SERC1_SO1F_CS423X)) {
    sub SERC1_SO1F_CS423X () {	0x;}
}
unless(defined(&SERC1_SO1F_AC97)) {
    sub SERC1_SO1F_AC97 () {	0x2;}
}
unless(defined(&SERC1_SO1F_DAC)) {
    sub SERC1_SO1F_DAC () {	0x4;}
}
unless(defined(&SERC1_SO1F_SPDIF)) {
    sub SERC1_SO1F_SPDIF () {	0x6;}
}
unless(defined(&CS4280_SERC2)) {
    sub CS4280_SERC2 () {	0x42c;}
}
unless(defined(&SERC2_SI1EN)) {
    sub SERC2_SI1EN () {	0x1;}
}
unless(defined(&SERC2_SI1F_MASK)) {
    sub SERC2_SI1F_MASK () {	0xe;}
}
unless(defined(&SERC2_SI1F_CS423X)) {
    sub SERC2_SI1F_CS423X () {	0x;}
}
unless(defined(&SERC2_SI1F_AC97)) {
    sub SERC2_SI1F_AC97 () {	0x2;}
}
unless(defined(&SERC2_SI1F_ADC)) {
    sub SERC2_SI1F_ADC () {	0x4;}
}
unless(defined(&SERC2_SI1F_SPDIF)) {
    sub SERC2_SI1F_SPDIF () {	0x6;}
}
unless(defined(&CS4280_SERBSP)) {
    sub CS4280_SERBSP () {	0x43c;}
}
unless(defined(&SERBSP_FSP_MASK)) {
    sub SERBSP_FSP_MASK () {	0xf;}
}
unless(defined(&CS4280_SERBST)) {
    sub CS4280_SERBST () {	0x440;}
}
unless(defined(&SERBST_RRDY)) {
    sub SERBST_RRDY () {	0x1;}
}
unless(defined(&SERBST_WBSY)) {
    sub SERBST_WBSY () {	0x2;}
}
unless(defined(&CS4280_SERBCM)) {
    sub CS4280_SERBCM () {	0x444;}
}
unless(defined(&SERBCM_RDC)) {
    sub SERBCM_RDC () {	0x1;}
}
unless(defined(&SERBCM_WRC)) {
    sub SERBCM_WRC () {	0x2;}
}
unless(defined(&CS4280_SERBAD)) {
    sub CS4280_SERBAD () {	0x448;}
}
unless(defined(&CS4280_SERBWP)) {
    sub CS4280_SERBWP () {	0x450;}
}
unless(defined(&CS4280_ACCTL)) {
    sub CS4280_ACCTL () {	0x460;}
}
unless(defined(&ACCTL_RSTN)) {
    sub ACCTL_RSTN () {	0x1;}
}
unless(defined(&ACCTL_ESYN)) {
    sub ACCTL_ESYN () {	0x2;}
}
unless(defined(&ACCTL_VFRM)) {
    sub ACCTL_VFRM () {	0x4;}
}
unless(defined(&ACCTL_DCV)) {
    sub ACCTL_DCV () {	0x8;}
}
unless(defined(&ACCTL_CRW)) {
    sub ACCTL_CRW () {	0x10;}
}
unless(defined(&ACCTL_ASYN)) {
    sub ACCTL_ASYN () {	0x20;}
}
unless(defined(&ACCTL_TC)) {
    sub ACCTL_TC () {	0x40;}
}
unless(defined(&CS4280_ACSTS)) {
    sub CS4280_ACSTS () {	0x464;}
}
unless(defined(&ACSTS_CRDY)) {
    sub ACSTS_CRDY () {	0x1;}
}
unless(defined(&ACSTS_VSTS)) {
    sub ACSTS_VSTS () {	0x2;}
}
unless(defined(&ACSTS_WKUP)) {
    sub ACSTS_WKUP () {	0x4;}
}
unless(defined(&CS4280_ACOSV)) {
    sub CS4280_ACOSV () {	0x468;}
}
unless(defined(&ACOSV_SLV3)) {
    sub ACOSV_SLV3 () {	0x1;}
}
unless(defined(&ACOSV_SLV4)) {
    sub ACOSV_SLV4 () {	0x2;}
}
unless(defined(&ACOSV_SLV5)) {
    sub ACOSV_SLV5 () {	0x4;}
}
unless(defined(&ACOSV_SLV6)) {
    sub ACOSV_SLV6 () {	0x8;}
}
unless(defined(&ACOSV_SLV7)) {
    sub ACOSV_SLV7 () {	0x10;}
}
unless(defined(&ACOSV_SLV8)) {
    sub ACOSV_SLV8 () {	0x20;}
}
unless(defined(&ACOSV_SLV9)) {
    sub ACOSV_SLV9 () {	0x40;}
}
unless(defined(&ACOSV_SLV10)) {
    sub ACOSV_SLV10 () {	0x80;}
}
unless(defined(&ACOSV_SLV11)) {
    sub ACOSV_SLV11 () {	0x100;}
}
unless(defined(&ACOSV_SLV12)) {
    sub ACOSV_SLV12 () {	0x200;}
}
unless(defined(&CS4280_ACCAD)) {
    sub CS4280_ACCAD () {	0x46c;}
}
unless(defined(&CS4280_ACCDA)) {
    sub CS4280_ACCDA () {	0x470;}
}
unless(defined(&CS4280_ACISV)) {
    sub CS4280_ACISV () {	0x474;}
}
unless(defined(&ACISV_ISV3)) {
    sub ACISV_ISV3 () {	0x1;}
}
unless(defined(&ACISV_ISV4)) {
    sub ACISV_ISV4 () {	0x2;}
}
unless(defined(&ACISV_ISV5)) {
    sub ACISV_ISV5 () {	0x4;}
}
unless(defined(&ACISV_ISV6)) {
    sub ACISV_ISV6 () {	0x8;}
}
unless(defined(&ACISV_ISV7)) {
    sub ACISV_ISV7 () {	0x10;}
}
unless(defined(&ACISV_ISV8)) {
    sub ACISV_ISV8 () {	0x20;}
}
unless(defined(&ACISV_ISV9)) {
    sub ACISV_ISV9 () {	0x40;}
}
unless(defined(&ACISV_ISV10)) {
    sub ACISV_ISV10 () {	0x80;}
}
unless(defined(&ACISV_ISV11)) {
    sub ACISV_ISV11 () {	0x100;}
}
unless(defined(&ACISV_ISV12)) {
    sub ACISV_ISV12 () {	0x200;}
}
unless(defined(&CS4280_ACSAD)) {
    sub CS4280_ACSAD () {	0x478;}
}
unless(defined(&CS4280_ACSDA)) {
    sub CS4280_ACSDA () {	0x47c;}
}
unless(defined(&CS4280_GPIOR)) {
    sub CS4280_GPIOR () {	0x4b8;}
}
unless(defined(&CS4280_EGPIODR)) {
    sub CS4280_EGPIODR () {	0x4bc;}
}
unless(defined(&CS4280_EGPIOPTR)) {
    sub CS4280_EGPIOPTR () {	0x4c0;}
}
unless(defined(&CS4280_EGPIOTR)) {
    sub CS4280_EGPIOTR () {	0x4c4;}
}
unless(defined(&CS4280_EGPIOWR)) {
    sub CS4280_EGPIOWR () {	0x4c8;}
}
unless(defined(&CS4280_EGPIOSR)) {
    sub CS4280_EGPIOSR () {	0x4cc;}
}
unless(defined(&CS4280_CFGI)) {
    sub CS4280_CFGI () {	0x4b0;}
}
unless(defined(&CS4280_SERACC)) {
    sub CS4280_SERACC () {	0x4d8;}
}
unless(defined(&SERACC_CTYPE_MASK)) {
    sub SERACC_CTYPE_MASK () {	0x1;}
}
unless(defined(&SERACC_CTYPE_1_03)) {
    sub SERACC_CTYPE_1_03 () {	0x;}
}
unless(defined(&SERACC_CTYPE_2_0)) {
    sub SERACC_CTYPE_2_0 () {	0x1;}
}
unless(defined(&SERACC_TWO_CODECS)) {
    sub SERACC_TWO_CODECS () {	0x2;}
}
unless(defined(&SERACC_MDM)) {
    sub SERACC_MDM () {	0x4;}
}
unless(defined(&SERACC_HSP)) {
    sub SERACC_HSP () {	0x8;}
}
unless(defined(&CS4280_MIDCR)) {
    sub CS4280_MIDCR () {	0x490;}
}
unless(defined(&MIDCR_TXE)) {
    sub MIDCR_TXE () {	0x1;}
}
unless(defined(&MIDCR_RXE)) {
    sub MIDCR_RXE () {	0x2;}
}
unless(defined(&MIDCR_RIE)) {
    sub MIDCR_RIE () {	0x4;}
}
unless(defined(&MIDCR_TIE)) {
    sub MIDCR_TIE () {	0x8;}
}
unless(defined(&MIDCR_MLB)) {
    sub MIDCR_MLB () {	0x10;}
}
unless(defined(&MIDCR_MRST)) {
    sub MIDCR_MRST () {	0x20;}
}
unless(defined(&MIDCR_MASK)) {
    sub MIDCR_MASK () {	0x3f;}
}
unless(defined(&CS4280_MIDSR)) {
    sub CS4280_MIDSR () {	0x494;}
}
unless(defined(&MIDSR_TBF)) {
    sub MIDSR_TBF () {	0x1;}
}
unless(defined(&MIDSR_RBE)) {
    sub MIDSR_RBE () {	0x2;}
}
unless(defined(&CS4280_MIDWP)) {
    sub CS4280_MIDWP () {	0x498;}
}
unless(defined(&MIDWP_MASK)) {
    sub MIDWP_MASK () {	0xff;}
}
unless(defined(&CS4280_MIDRP)) {
    sub CS4280_MIDRP () {	0x49c;}
}
unless(defined(&MIDRP_MASK)) {
    sub MIDRP_MASK () {	0xff;}
}
unless(defined(&CS4280_JSPT)) {
    sub CS4280_JSPT () {	0x480;}
}
unless(defined(&CS4280_JSCTL)) {
    sub CS4280_JSCTL () {	0x484;}
}
unless(defined(&CS4280_JSC1)) {
    sub CS4280_JSC1 () {	0x488;}
}
unless(defined(&CS4280_JSC2)) {
    sub CS4280_JSC2 () {	0x48c;}
}
unless(defined(&CS4280_PDTC)) {
    sub CS4280_PDTC () {	0xc0;}
}
unless(defined(&PDTC_MASK)) {
    sub PDTC_MASK () {	0x3ff;}
}
unless(defined(&CS4280_MK_PDTC)) {
    sub CS4280_MK_PDTC {
	my($x) = @_;
	eval q((($x)/2- 1));
    }
}
unless(defined(&CS4280_PFIE)) {
    sub CS4280_PFIE () {	0xc4;}
}
unless(defined(&PFIE_UNSIGNED)) {
    sub PFIE_UNSIGNED () {	0x8000;}
}
unless(defined(&PFIE_SWAPPED)) {
    sub PFIE_SWAPPED () {	0x4000;}
}
unless(defined(&PFIE_MONO)) {
    sub PFIE_MONO () {	0x2000;}
}
unless(defined(&PFIE_8BIT)) {
    sub PFIE_8BIT () {	0x1000;}
}
unless(defined(&PFIE_PI_ENABLE)) {
    sub PFIE_PI_ENABLE () {	0x;}
}
unless(defined(&PFIE_PI_DISABLE)) {
    sub PFIE_PI_DISABLE () {	0x10;}
}
unless(defined(&PFIE_PI_MASK)) {
    sub PFIE_PI_MASK () {	0x3f;}
}
unless(defined(&PFIE_MASK)) {
    sub PFIE_MASK () {	0xf03f;}
}
unless(defined(&CS4280_PBA)) {
    sub CS4280_PBA () {	0xc8;}
}
unless(defined(&CS4280_PVOL)) {
    sub CS4280_PVOL () {	0xf8;}
}
unless(defined(&CS4280_PSRC)) {
    sub CS4280_PSRC () {	0x288;}
}
unless(defined(&PSRC_MASK)) {
    sub PSRC_MASK () {	0xffff0000;}
}
unless(defined(&CS4280_MK_PSRC)) {
    sub CS4280_MK_PSRC {
	my($psrc, $py) = @_;
	eval q((((($psrc) << 16) & 0xffff0000) | (($py) & 0xffff)));
    }
}
unless(defined(&CS4280_PCTL)) {
    sub CS4280_PCTL () {	0x2a4;}
}
unless(defined(&PCTL_MASK)) {
    sub PCTL_MASK () {	0xffff0000;}
}
unless(defined(&CS4280_PPI)) {
    sub CS4280_PPI () {	0x2b4;}
}
unless(defined(&CS4280_CCTL)) {
    sub CS4280_CCTL () {	0x64;}
}
unless(defined(&CCTL_MASK)) {
    sub CCTL_MASK () {	0xffff;}
}
unless(defined(&CS4280_CDTC)) {
    sub CS4280_CDTC () {	0x100;}
}
unless(defined(&CS4280_CIE)) {
    sub CS4280_CIE () {	0x104;}
}
unless(defined(&CIE_CI_ENABLE)) {
    sub CIE_CI_ENABLE () {	0x1;}
}
unless(defined(&CIE_CI_DISABLE)) {
    sub CIE_CI_DISABLE () {	0x11;}
}
unless(defined(&CIE_CI_MASK)) {
    sub CIE_CI_MASK () {	0x3f;}
}
unless(defined(&CS4280_CBA)) {
    sub CS4280_CBA () {	0x10c;}
}
unless(defined(&CS4280_CSRC)) {
    sub CS4280_CSRC () {	0x2c8;}
}
unless(defined(&CSRC_MASK)) {
    sub CSRC_MASK () {	0xffff0000;}
}
unless(defined(&CS4280_MK_CSRC)) {
    sub CS4280_MK_CSRC {
	my($csrc, $cy) = @_;
	eval q((((($csrc) << 16) & 0xffff0000) | (($cy) & 0xffff)));
    }
}
unless(defined(&CS4280_CCI)) {
    sub CS4280_CCI () {	0x2d8;}
}
unless(defined(&CCI_MASK)) {
    sub CCI_MASK () {	0xffff0000;}
}
unless(defined(&CS4280_CD)) {
    sub CS4280_CD () {	0x2e0;}
}
unless(defined(&CD_MASK)) {
    sub CD_MASK () {	0xfffc000;}
}
unless(defined(&CS4280_CPI)) {
    sub CS4280_CPI () {	0x2f4;}
}
unless(defined(&CS4280_CGL)) {
    sub CS4280_CGL () {	0x134;}
}
unless(defined(&CGL_MASK)) {
    sub CGL_MASK () {	0xffff;}
}
unless(defined(&CS4280_CNT)) {
    sub CS4280_CNT () {	0x340;}
}
unless(defined(&CS4280_CGC)) {
    sub CS4280_CGC () {	0x138;}
}
unless(defined(&CGC_MASK)) {
    sub CGC_MASK () {	0xffff;}
}
unless(defined(&CS4280_CVOL)) {
    sub CS4280_CVOL () {	0x2f8;}
}
unless(defined(&CS4280_SPCR)) {
    sub CS4280_SPCR () {	0x30000;}
}
unless(defined(&SPCR_RUN)) {
    sub SPCR_RUN () {	0x1;}
}
unless(defined(&SPCR_STPFR)) {
    sub SPCR_STPFR () {	0x2;}
}
unless(defined(&SPCR_RUNFR)) {
    sub SPCR_RUNFR () {	0x4;}
}
unless(defined(&SPCR_DRQEN)) {
    sub SPCR_DRQEN () {	0x20;}
}
unless(defined(&SPCR_RSTSP)) {
    sub SPCR_RSTSP () {	0x40;}
}
unless(defined(&CS4280_DREG)) {
    sub CS4280_DREG () {	0x30004;}
}
unless(defined(&CS4280_DSRWP)) {
    sub CS4280_DSRWP () {	0x30008;}
}
unless(defined(&CS4280_TWPR)) {
    sub CS4280_TWPR () {	0x3000c;}
}
unless(defined(&CS4280_SPWR)) {
    sub CS4280_SPWR () {	0x30010;}
}
unless(defined(&CS4280_SPCS)) {
    sub CS4280_SPCS () {	0x30028;}
}
unless(defined(&SPCS_SPRUN)) {
    sub SPCS_SPRUN () {	0x100;}
}
unless(defined(&CS4280_FRMT)) {
    sub CS4280_FRMT () {	0x30030;}
}
unless(defined(&FRMT_FTV)) {
    sub FRMT_FTV () {	0xadf;}
}
unless(defined(&CF_MONO)) {
    sub CF_MONO () {	0x1;}
}
unless(defined(&CF_8BIT)) {
    sub CF_8BIT () {	0x2;}
}
unless(defined(&CF_16BIT_STEREO)) {
    sub CF_16BIT_STEREO () {	0x;}
}
unless(defined(&CF_16BIT_MONO)) {
    sub CF_16BIT_MONO () {	0x1;}
}
unless(defined(&CF_8BIT_STEREO)) {
    sub CF_8BIT_STEREO () {	0x2;}
}
unless(defined(&CF_8BIT_MONO)) {
    sub CF_8BIT_MONO () {	0x3;}
}
unless(defined(&MIDI_BUSY_WAIT)) {
    sub MIDI_BUSY_WAIT () {	100;}
}
unless(defined(&MIDI_BUSY_DELAY)) {
    sub MIDI_BUSY_DELAY () {	100;}
}
unless(defined(&BA1_DWORD_SIZE)) {
    sub BA1_DWORD_SIZE () {	(13* 1024+ 512);}
}
unless(defined(&BA1_MEMORY_COUNT)) {
    sub BA1_MEMORY_COUNT () {	3;}
}
unless(defined(&CS4280_ICHUNK)) {
    sub CS4280_ICHUNK () {	2048;}
}
unless(defined(&CS4280_DCHUNK)) {
    sub CS4280_DCHUNK () {	4096;}
}
unless(defined(&CS4280_DALIGN)) {
    sub CS4280_DALIGN () {	4096;}
}
unless(defined(&CS4280_SAVE_REG_MAX)) {
    sub CS4280_SAVE_REG_MAX () {	0x10;}
}
unless(defined(&CS4280_POWER_DOWN_ALL)) {
    sub CS4280_POWER_DOWN_ALL () {	0x7f0f;}
}
1;
