require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_X86_INTR_H_)) {
    eval 'sub _X86_INTR_H_ () {1;}' unless defined(&_X86_INTR_H_);
    require 'machine/intrdefs.ph';
    unless(defined(&_LOCORE)) {
	require 'machine/cpu.ph';
	require 'sys/evcount.ph';
	eval 'sub IS_LEGACY () {0x1;}' unless defined(&IS_LEGACY);
	eval 'sub IS_IPI () {0x2;}' unless defined(&IS_IPI);
	eval 'sub IS_LOG () {0x4;}' unless defined(&IS_LOG);
	eval 'sub IMASK {
	    my($ci,$level) = @_;
    	    eval q(($ci)-> $ci_imask[($level)]);
	}' unless defined(&IMASK);
	eval 'sub IUNMASK {
	    my($ci,$level) = @_;
    	    eval q(($ci)-> $ci_iunmask[($level)]);
	}' unless defined(&IUNMASK);
	eval 'sub APIC_LEVEL {
	    my($l) = @_;
    	    eval q((($l) << 4));
	}' unless defined(&APIC_LEVEL);
	eval 'sub __splbarrier () {
	    eval q( &__asm  &__volatile(\\"\\":::\\"memory\\"));
	}' unless defined(&__splbarrier);
	eval 'sub splbio () {
	    eval q( &splraise( &IPL_BIO));
	}' unless defined(&splbio);
	eval 'sub splnet () {
	    eval q( &splraise( &IPL_NET));
	}' unless defined(&splnet);
	eval 'sub spltty () {
	    eval q( &splraise( &IPL_TTY));
	}' unless defined(&spltty);
	eval 'sub splaudio () {
	    eval q( &splraise( &IPL_AUDIO));
	}' unless defined(&splaudio);
	eval 'sub splclock () {
	    eval q( &splraise( &IPL_CLOCK));
	}' unless defined(&splclock);
	eval 'sub splstatclock () {
	    eval q( &splclock());
	}' unless defined(&splstatclock);
	eval 'sub splipi () {
	    eval q( &splraise( &IPL_IPI));
	}' unless defined(&splipi);
	eval 'sub spllpt () {
	    eval q( &spltty());
	}' unless defined(&spllpt);
	eval 'sub spllpt () {
	    eval q( &spltty());
	}' unless defined(&spllpt);
	eval 'sub splsoftclock () {
	    eval q( &splraise( &IPL_SOFTCLOCK));
	}' unless defined(&splsoftclock);
	eval 'sub splsoftnet () {
	    eval q( &splraise( &IPL_SOFTNET));
	}' unless defined(&splsoftnet);
	eval 'sub splsofttty () {
	    eval q( &splraise( &IPL_SOFTTTY));
	}' unless defined(&splsofttty);
	eval 'sub splvm () {
	    eval q( &splraise( &IPL_VM));
	}' unless defined(&splvm);
	eval 'sub splhigh () {
	    eval q( &splraise( &IPL_HIGH));
	}' unless defined(&splhigh);
	eval 'sub spl0 () {
	    eval q( &spllower( &IPL_NONE));
	}' unless defined(&spl0);
	eval 'sub splsched () {
	    eval q( &splraise( &IPL_SCHED));
	}' unless defined(&splsched);
	eval 'sub spllock () {
	    eval q( &splhigh());
	}' unless defined(&spllock);
	eval 'sub splx {
	    my($x) = @_;
    	    eval q( &spllower($x));
	}' unless defined(&splx);
	if(defined(&DIAGNOSTIC)) {
	    eval 'sub splassert {
	        my($__wantipl) = @_;
    		eval q( &do {  &if ( &splassert_ctl > 0) {  &splassert_check($__wantipl,  &__func__); } }  &while (0));
	    }' unless defined(&splassert);
	    eval 'sub splsoftassert {
	        my($wantipl) = @_;
    		eval q( &splassert($wantipl));
	    }' unless defined(&splsoftassert);
	} else {
	    eval 'sub splassert {
	        my($wantipl) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&splassert);
	    eval 'sub splsoftassert {
	        my($wantipl) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&splsoftassert);
	}
	eval 'sub setsoftnet () {
	    eval q( &softintr( &SIR_NET));
	}' unless defined(&setsoftnet);
	eval 'sub IPLSHIFT () {4;}' unless defined(&IPLSHIFT);
	eval 'sub IPL {
	    my($level) = @_;
    	    eval q((($level) >>  &IPLSHIFT));
	}' unless defined(&IPL);
	require 'machine/pic.ph';
	if(defined(&MULTIPROCESSOR)) {
	}
    }
    eval 'sub X86_SOFTINTR_SOFTCLOCK () {0;}' unless defined(&X86_SOFTINTR_SOFTCLOCK);
    eval 'sub X86_SOFTINTR_SOFTNET () {1;}' unless defined(&X86_SOFTINTR_SOFTNET);
    eval 'sub X86_SOFTINTR_SOFTTTY () {2;}' unless defined(&X86_SOFTINTR_SOFTTTY);
    eval 'sub X86_NSOFTINTR () {3;}' unless defined(&X86_NSOFTINTR);
    unless(defined(&_LOCORE)) {
	require 'sys/queue.ph';
	eval 'sub softintr_schedule {
	    my($arg) = @_;
    	    eval q( &do { \'struct x86_soft_intrhand\' * &__sih = ($arg); \'struct x86_soft_intr\' * &__si =  ($__sih->{sih_intrhead});  &mtx_enter(& ($__si->{softintr_lock}));  &if ( ($__sih->{sih_pending}) == 0) {  &TAILQ_INSERT_TAIL(& ($__si->{softintr_q}),  &__sih,  &sih_q);  ($__sih->{sih_pending}) = 1;  &softintr( ($__si->{softintr_ssir})); }  &mtx_leave(& ($__si->{softintr_lock})); }  &while ( 0));
	}' unless defined(&softintr_schedule);
    }
}
1;
