<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: HelpGroupFactory.class.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */

/**
 * @package Module_Help
 */
class HelpGroupFactory extends Factory {
	protected $table = 'help_group';
	protected $pk_sequence_name = 'help_group_id_seq'; //PK Sequence name
	function getHelpGroupControl() {
		return $this->data['help_group_control_id'];
	}
	function setHelpGroupControl($id) {
		$id = trim($id);
		
		$hgclf = new HelpGroupControlListFactory();
		
		if ( $this->Validator->isResultSetWithRows(	'help_group_control',
													$hgclf->getByID($id),
													TTi18n::gettext('Help Group Control is invalid')
													) ) {
			$this->data['help_group_control_id'] = $id;
		
			return TRUE;
		}

		return FALSE;
	}

	function getHelp() {
		return $this->data['help_id'];
	}
	function setHelp($id) {
		$id = trim($id);
		
		$hlf = new HelpListFactory();
		
		if ( $this->Validator->isResultSetWithRows(	'help',
													$hlf->getByID($id),
													TTi18n::gettext('Help Entry is invalid')
															) ) {
			$this->data['help_id'] = $id;
		
			return TRUE;
		}

		return FALSE;
	}
	
	function getOrder() {
		return $this->data['order_value'];
	}
	function setOrder($value) {
		$value = trim($value);
				
		if ( $this->Validator->isNumeric(	'order',
											$value,
											TTi18n::gettext('Order is invalid')
													) ) {
			$this->data['order_value'] = $value;
		
			return TRUE;
		}

		return FALSE;
	}

	//This table doesn't have any of these columns, so overload the functions.
	function getDeleted() {
		return FALSE;
	}
	function setDeleted($bool) {		
		return FALSE;
	}
	
	function getCreatedDate() {
		return FALSE;
	}
	function setCreatedDate($epoch = NULL) {
		return FALSE;		
	}
	function getCreatedBy() {
		return FALSE;
	}
	function setCreatedBy($id = NULL) {
		return FALSE;		
	}

	function getUpdatedDate() {
		return FALSE;
	}
	function setUpdatedDate($epoch = NULL) {
		return FALSE;		
	}
	function getUpdatedBy() {
		return FALSE;
	}
	function setUpdatedBy($id = NULL) {
		return FALSE;	
	}


	function getDeletedDate() {
		return FALSE;
	}
	function setDeletedDate($epoch = NULL) {		
		return FALSE;
	}
	function getDeletedBy() {
		return FALSE;
	}
	function setDeletedBy($id = NULL) {		
		return FALSE;
	}
}
?>
