%%
%% This is file `thuthesis.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% thuthesis.dtx  (with options: `cls')
%% 
%% This is a generated file.
%% 
%% Copyright (C) 2005-2008 by Xue Ruini <xueruini@gmail.com>
%% 
%% This file may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3a
%% of this license or (at your option) any later version.
%% The latest version of this license is in:
%% 
%% http://www.latex-project.org/lppl.txt
%% 
%% and version 1.3a or later is part of all distributions of LaTeX
%% version 2004/10/01 or later.
%% 
%% To produce the documentation run the original source files ending with `.dtx'
%% through LaTeX.
%% 
\NeedsTeXFormat{LaTeX2e}[1999/12/01]
\ProvidesClass{thuthesis}
[2007/11/08 4.0 Tsinghua University Thesis Template]
\hyphenation{Thu-Thesis}
\def\thuthesis{\textsc{ThuThesis}}
\def\version{4.0}
\newif\ifthu@bachelor\thu@bachelorfalse
\newif\ifthu@master\thu@masterfalse
\newif\ifthu@doctor\thu@doctorfalse
\newif\ifthu@secret\thu@secretfalse
\DeclareOption{bachelor}{\thu@bachelortrue}
\DeclareOption{master}{\thu@mastertrue}
\DeclareOption{doctor}{\thu@doctortrue}
\DeclareOption{secret}{\thu@secrettrue}
\AtEndOfClass{%
  \ifthu@bachelor\relax\else
    \ifthu@master\relax\else
      \ifthu@doctor\relax\else
        \ClassError{thuthesis}%
                   {You have to specify one of thesis options: bachelor, master or doctor.}{}
      \fi
    \fi
  \fi}
\newif\ifthu@dvips
\newif\ifthu@dvipdfm
\DeclareOption{dvips}{\thu@dvipstrue}
\DeclareOption{dvipdfm}{\thu@dvipdfmtrue}
\AtEndOfClass{%
  \ifpdf
    \ifthu@dvips
      \ClassError{thuthesis}%
                 {Please remove `dvips' if you run pdflatex.}{}
    \fi
    \ifthu@dvipdfm
      \ClassError{thuthesis}%
                 {Please remove `dvipdfm' if you run pdflatex.}{}
    \fi
  \fi}
\newif\ifthu@arial
\DeclareOption{arial}{\thu@arialtrue}
\newif\ifthu@arialtoc
\DeclareOption{arialtoc}{\thu@arialtoctrue}
\newif\ifthu@arialtitle
\DeclareOption{arialtitle}{\thu@arialtitletrue}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}
\ExecuteOptions{arialtitle}
\ProcessOptions
\ifthu@bachelor
  %\thu@arialtoctrue % hard code
  \LoadClass[12pt, a4paper, openright]{book}
\else
  \LoadClass[12pt, a4paper, openany]{book}
\fi
\RequirePackage{ifthen}
\RequirePackage{calc}
\RequirePackage{ifpdf}
\RequirePackage{amsmath, amssymb}
\RequirePackage{txfonts}
\ifthu@arial
  \IfFileExists{arial.sty}{\RequirePackage{arial}}%
                          {\ClassWarning{thuthesis}{no arial.sty availiable!}}
\fi
\RequirePackage{graphicx}
\RequirePackage[config]{subfig}
\RequirePackage{indentfirst}
\RequirePackage[neverdecrease]{paralist}
\RequirePackage{CJK, CJKnumb}
\RequirePackage{CJKpunct}
\ifpdf % We're not running pdftex
  \RequirePackage{ccmap} %  pdflatex 
\else
  % \RequirePackage{cmap}
\fi
\RequirePackage[amsmath,thmmarks,hyperref]{ntheorem}
\RequirePackage{array}
\RequirePackage{longtable}
\RequirePackage{booktabs}
\RequirePackage[numbers,super,sort&compress]{natbib}
\RequirePackage{hyperref}
\hypersetup{%
  unicode=true,
  CJKbookmarks=true,
  bookmarksnumbered=true,
  bookmarksopen=true,
  bookmarksopenlevel=1,
  breaklinks=true,
  colorlinks=false,
  plainpages=false,
  pdfpagelabels,
  pdfborder=0 0 0}
\urlstyle{same}
\RequirePackage{hypernat}
\renewcommand\frontmatter{%
  \if@openright\cleardoublepage\else\clearpage\fi
  \@mainmatterfalse
  \pagenumbering{Roman}
  \pagestyle{thu@empty}}
\renewcommand\mainmatter{%
  \if@openright\cleardoublepage\else\clearpage\fi
  \@mainmattertrue
  \pagenumbering{arabic}
  \pagestyle{thu@headings}}
\renewcommand\backmatter{%
  \if@openright\cleardoublepage\else\clearpage\fi
  %\@mainmatterfalse
  \ifthu@bachelor\pagenumbering{Roman}\fi}
\newcommand{\song}{\CJKfamily{song}}    % 
\def\songti{\song}
\newcommand{\fs}{\CJKfamily{fs}}        % 
\def\fangsong{\fs}
\newcommand{\kai}{\CJKfamily{kai}}      % 
\def\kaishu{\kai}
\newcommand{\hei}{\CJKfamily{hei}}      % 
\def\heiti{\hei}
\newcommand{\li}{\CJKfamily{li}}        % 
\def\lishu{\li}
\newcommand{\you}{\CJKfamily{you}}      % Բ
\def\youyuan{\you}
\newlength\thu@linespace
\newcommand{\thu@choosefont}[2]{%
   \setlength{\thu@linespace}{#2*\real{#1}}%
   \fontsize{#2}{\thu@linespace}\selectfont}
\def\thu@define@fontsize#1#2{%
  \expandafter\newcommand\csname #1\endcsname[1][\baselinestretch]{%
    \thu@choosefont{##1}{#2}}}
\thu@define@fontsize{chuhao}{42bp}
\thu@define@fontsize{xiaochu}{36bp}
\thu@define@fontsize{yihao}{26bp}
\thu@define@fontsize{xiaoyi}{24bp}
\thu@define@fontsize{erhao}{22bp}
\thu@define@fontsize{xiaoer}{18bp}
\thu@define@fontsize{sanhao}{16bp}
\thu@define@fontsize{xiaosan}{15bp}
\thu@define@fontsize{sihao}{14bp}
\thu@define@fontsize{banxiaosi}{13bp}
\thu@define@fontsize{xiaosi}{12bp}
\thu@define@fontsize{dawu}{11bp}
\thu@define@fontsize{wuhao}{10.5bp}
\thu@define@fontsize{xiaowu}{9bp}
\thu@define@fontsize{liuhao}{7.5bp}
\thu@define@fontsize{xiaoliu}{6.5bp}
\thu@define@fontsize{qihao}{5.5bp}
\thu@define@fontsize{bahao}{5bp}
\renewcommand\normalsize{%
  \@setfontsize\normalsize{12bp}{20bp}
  \abovedisplayskip=10bp \@plus 2bp \@minus 2bp
  \abovedisplayshortskip=10bp \@plus 2bp \@minus 2bp
  \belowdisplayskip=\abovedisplayskip
  \belowdisplayshortskip=\abovedisplayshortskip}
\AtBeginDvi{\special{papersize=\the\paperwidth,\the\paperheight}}
\AtBeginDvi{\special{!%
      \@percentchar\@percentchar BeginPaperSize: a4
      ^^Ja4^^J\@percentchar\@percentchar EndPaperSize}}
\setlength{\textwidth}{\paperwidth}
\setlength{\textheight}{\paperheight}
\setlength\marginparwidth{0cm}
\setlength\marginparsep{0cm}
\addtolength{\textwidth}{-6.4cm}
\setlength{\oddsidemargin}{3.2cm-1in}
\setlength{\evensidemargin}{\oddsidemargin}
\setlength{\headheight}{20pt}
\setlength{\topskip}{0pt}
\setlength{\skip\footins}{15pt}
\setlength{\topmargin}{2.8cm-1in}
\ifthu@bachelor
  \setlength{\footskip}{1.3cm}
  \setlength{\headsep}{0.6cm}
  \addtolength{\textheight}{-7.8cm}
\else
  \setlength{\footskip}{1.5cm}
  \setlength{\headsep}{0.5cm}
  \addtolength{\textheight}{-8.6cm}
\fi
\let\thu@cleardoublepage\cleardoublepage
\newcommand{\thu@clearemptydoublepage}{%
  \clearpage{\pagestyle{empty}\thu@cleardoublepage}}
\let\cleardoublepage\thu@clearemptydoublepage
\def\ps@thu@empty{%
  \let\@oddhead\@empty%
  \let\@evenhead\@empty%
  \let\@oddfoot\@empty%
  \let\@evenfoot\@empty}
\def\ps@thu@plain{%
  \let\@oddhead\@empty%
  \let\@evenhead\@empty%
  \def\@oddfoot{\hfil\wuhao\thepage\hfil}%
  \let\@evenfoot=\@oddfoot}
\def\ps@thu@headings{%
  \def\@oddhead{\vbox to\headheight{%
      \hb@xt@\textwidth{\hfill\wuhao\song\leftmark\ifthu@bachelor\relax\else\hfill\fi}%
      \vskip2pt\hbox{\vrule width\textwidth height0.4pt depth0pt}}}
  \def\@evenhead{\vbox to\headheight{%
      \hb@xt@\textwidth{\wuhao\song%
      \ifthu@bachelor\thu@schoolename\thu@bachelor@subtitle%
       \else\hfill\leftmark\fi\hfill}%
      \vskip2pt\hbox{\vrule width\textwidth height0.4pt depth0pt}}}
  \def\@oddfoot{\hfil\wuhao\thepage\hfil}
  \let\@evenfoot=\@oddfoot}
\renewcommand{\chaptermark}[1]{\@mkboth{\@chapapp\ ~~#1}{}}
\newlength\CJKtwospaces
\def\CJKindent{%
  \settowidth\CJKtwospaces{\CJKchar{"0A1}{"0A1}\CJKchar{"0A1}{"0A1}}%
  \parindent\CJKtwospaces}
\setlength{\parskip}{0pt \@plus2pt \@minus0pt}
\def\thu@item@space{%
  \let\itemize\compactitem
  \let\enditemize\endcompactitem
  \let\enumerate\compactenum
  \let\endenumerate\endcompactenum
  \let\description\compactdesc
  \let\enddescription\endcompactdesc}
\newcommand*\MakePerPage[2][\@ne]{%
  \expandafter\def\csname c@pchk@#2\endcsname{\c@pchk@{#2}{#1}}%
  \newcounter{pcabs@#2}%
  \@addtoreset{pchk@#2}{#2}}
\def\new@pagectr#1{\@newl@bel{pchk@#1}}
\def\c@pchk@#1#2{\z@=\z@
  \begingroup
  \expandafter\let\expandafter\next\csname pchk@#1@\arabic{pcabs@#1}\endcsname
  \addtocounter{pcabs@#1}\@ne
  \expandafter\ifx\csname pchk@#1@\arabic{pcabs@#1}\endcsname\next
  \else \setcounter{#1}{#2}\fi
  \protected@edef\next{%
    \string\new@pagectr{#1}{\arabic{pcabs@#1}}{\noexpand\thepage}}%
  \protected@write\@auxout{}{\next}%
  \endgroup\global\z@}
\MakePerPage{footnote}
\def\thu@textcircled#1{%
  \ifnum \value{#1} <10 \textcircled{\xiaoliu\arabic{#1}}
  \else\ifnum \value{#1} <100 \textcircled{\qihao\arabic{#1}}\fi
  \fi}
\renewcommand{\thefootnote}{\thu@textcircled{footnote}}
\renewcommand{\thempfootnote}{\thu@textcircled{mpfootnote}}
\def\footnoterule{\vskip-3\p@\hrule\@width0.3\textwidth\@height0.4\p@\vskip2.6\p@}
\let\thu@footnotesize\footnotesize
\renewcommand\footnotesize{\thu@footnotesize\xiaowu[1.5]}
\def\@makefnmark{\textsuperscript{\hbox{\normalfont\@thefnmark}}}
\long\def\@makefntext#1{
    \bgroup
      \setbox\@tempboxa\hbox{%
        \hb@xt@ 2em{\@thefnmark\hss}}
      \leftmargin\wd\@tempboxa
      \rightmargin\z@
      \linewidth \columnwidth
      \advance \linewidth -\leftmargin
      \parshape \@ne \leftmargin \linewidth
      \footnotesize
      \@setpar{{\@@par}}%
      \leavevmode
      \llap{\box\@tempboxa}%
      #1
    \par\egroup}
\allowdisplaybreaks[4]
\def\make@df@tag{\@ifstar\thu@make@df@tag@@\make@df@tag@@@}
\def\thu@make@df@tag@@#1{%
   \gdef\df@tag{\thu@maketag{#1}\def\@currentlabel{#1}}}
 % redefinitation of tagform broken eqref!
\renewcommand{\eqref}[1]{\textup{\ref{#1}}}
\renewcommand\theequation{\ifnum \c@chapter>\z@ \thechapter-\fi\@arabic\c@equation}
\ifthu@bachelor
  \def\thu@maketag#1{\maketag@@@{%
    (\ignorespaces\text{\equationname\hskip0.5em}#1\unskip\@@italiccorr)}}
  \def\tagform@#1{\maketag@@@{%
    (\ignorespaces\text{\equationname\hskip0.5em}#1\unskip\@@italiccorr)\equcaption{#1}}}
\else
  \def\thu@maketag#1{\maketag@@@{(\ignorespaces #1\unskip\@@italiccorr)}}
  \def\tagform@#1{\maketag@@@{%
    (\ignorespaces #1\unskip\@@italiccorr)\equcaption{#1}}}
\fi
\gdef\@endtrivlist#1{%  % from \endtrivlist
  \if@inlabel \indent\fi
  \if@newlist \@noitemerr\fi
  \ifhmode
     \ifdim\lastskip >\z@ #1\unskip \par  %<<<<<<<<<<<<<<<<<<<<<<
           \else #1\unskip \par \fi
  \fi
  \if@noparlist \else
    \ifdim\lastskip >\z@
       \@tempskipa\lastskip \vskip -\lastskip
      \advance\@tempskipa\parskip \advance\@tempskipa -\@outerparskip
      \vskip\@tempskipa
    \fi
    \@endparenv
  \fi #1}
\theorembodyfont{\song\rmfamily}
\theoremheaderfont{\hei\rmfamily}
 % \theoremsymbol{\ensuremath{\blacksquare}}
\theoremsymbol{\ensuremath{\square}}
\theoremstyle{nonumberplain}
\theoremstyle{plain}
\theoremsymbol{}
\setlength{\floatsep}{12bp \@plus4pt \@minus1pt}
\setlength{\intextsep}{12bp \@plus4pt \@minus2pt}
\setlength{\textfloatsep}{12bp \@plus4pt \@minus2pt}
\setlength{\@fptop}{0bp \@plus1.0fil}
\setlength{\@fpsep}{12bp \@plus2.0fil}
\setlength{\@fpbot}{0bp \@plus1.0fil}
\renewcommand{\textfraction}{0.15}
\renewcommand{\topfraction}{0.85}
\renewcommand{\bottomfraction}{0.65}
\renewcommand{\floatpagefraction}{0.60}
\let\old@tabular\@tabular
\def\thu@tabular{\dawu[1.5]\old@tabular}
\DeclareCaptionLabelFormat{thu}{{\dawu[1.5]\song #1~\rmfamily #2}}
\DeclareCaptionLabelSeparator{thu}{\hspace{1em}}
\DeclareCaptionFont{thu}{\dawu[1.5]}
\captionsetup{labelformat=thu,labelsep=thu,font=thu}
\captionsetup[table]{position=top,belowskip={12bp-\intextsep},aboveskip=3bp}
\captionsetup[figure]{position=bottom,belowskip={12bp-\intextsep},aboveskip=-2bp}
\captionsetup[subfloat]{font=thu,captionskip=6bp,nearskip=6bp,farskip=0bp,topadjust=0bp}
 %\renewcommand{\thesubfigure}{\thefigure--(\arabic{subfigure})}
 % \renewcommand{\p@subfigure}{:}
\def\LT@c@ption#1[#2]#3{% change code from longtable.sty
  \LT@makecaption#1\fnum@table{#3}%
  \def\@tempa{#2}%
  \ifx\@tempa\@empty\else
    {\let\\\space
    \addcontentsline{\csname ext@table\endcsname}{table}%
                    {\protect\numberline{\tablename\hskip0.5em\thetable}{#2}}}%
  \fi}
\let\thu@LT@array\LT@array
\def\LT@array{\dawu[1.5]\thu@LT@array} % set default font size
\def\hlinewd#1{%
  \noalign{\ifnum0=`}\fi\hrule \@height #1 \futurelet
    \reserved@a\@xhline}
\ifthu@arialtitle
  \def\thu@title@font{\sffamily}
\fi
\renewcommand\chapter{\if@openright\cleardoublepage\else\clearpage\fi\phantomsection%
                    \ifthu@bachelor\thispagestyle{thu@plain}%
                    \else\thispagestyle{thu@headings}\fi%
                    \global\@topnum\z@%
                    \@afterindenttrue%
                    \secdef\@chapter\@schapter}
\def\@chapter[#1]#2{%
  \ifnum \c@secnumdepth >\m@ne
   \if@mainmatter
     \refstepcounter{chapter}%
     \addcontentsline{toc}{chapter}{\protect\numberline{\@chapapp}#1}%TODO: shit
   \else
     \addcontentsline{toc}{chapter}{#1}%
   \fi
  \else
    \addcontentsline{toc}{chapter}{#1}%
  \fi
  \chaptermark{#1}%
  \@makechapterhead{#2}}
\def\@makechapterhead#1{%
  \vspace*{20bp}%
  {\parindent \z@ \centering
    \hei\csname thu@title@font\endcsname\ifthu@bachelor\xiaosan\else\sanhao[1]\fi
    \ifnum \c@secnumdepth >\m@ne
      \@chapapp\hskip1em
    \fi
    #1\par\nobreak
    \vskip 24bp}}
\def\@schapter#1{%
  \@makeschapterhead{#1}
  \@afterheading}
\def\@makeschapterhead#1{%
  \vspace*{20bp}%
  {\parindent \z@ \centering
   \hei\csname thu@title@font\endcsname\sanhao[1]
   \ifthu@bachelor\xiaosan\else
     \def\@tempa{#1}
     \def\@tempb{\eabstractname}
     \ifx\@tempa\@tempb\bfseries\fi
   \fi
   \interlinepenalty\@M
   #1\par\nobreak
   \vskip 24bp}}
\def\thu@chapter*{%
  \@ifnextchar [ % ]
    {\thu@@chapter}
    {\thu@@chapter@}}
\def\thu@@chapter@#1{\thu@@chapter[#1]{#1}}
\def\thu@@chapter[#1]#2{%
  \@ifnextchar [ % ]
    {\thu@@@chapter[#1]{#2}}
    {\thu@@@chapter[#1]{#2}[]}}
\def\thu@@@chapter[#1]#2[#3]{%
  \if@openright\cleardoublepage\else\clearpage\fi
  \phantomsection
  \def\@tmpa{#1}
  \def\@tmpb{#3}
  \ifx\@tmpa\@empty
    \pdfbookmark[0]{#2}{\expandafter\@gobble\string#2}
  \else
    \addcontentsline{toc}{chapter}{#1}
  \fi
  \chapter*{#2}
  \ifx\@tmpb\@empty
    \@mkboth{#2}{#2}
  \else
    \@mkboth{#3}{#3}
  \fi}
\renewcommand\section{\@startsection {section}{1}{\z@}%
                     {-24bp \@plus -1ex \@minus -.2ex}%
                     {6bp \@plus .2ex}%
                     {\hei\csname thu@title@font\endcsname\sihao[1.429]}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                        {-16bp \@plus -1ex \@minus -.2ex}%
                        {6bp \@plus .2ex}%
                        {\hei\csname thu@title@font\endcsname\banxiaosi[1.538]}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                           {-16bp \@plus -1ex \@minus -.2ex}%
                           {6bp \@plus .2ex}%
                           {\hei\csname thu@title@font\endcsname\xiaosi[1.667]}}
\setcounter{secnumdepth}{3}
\ifthu@doctor
  \setcounter{tocdepth}{2}
\else
  \setcounter{tocdepth}{3}
\fi
\renewcommand\tableofcontents{%
  \thu@chapter*[]{\contentsname}
  \ifthu@bachelor\wuhao[1.8]\else\xiaosi[1.5]\fi\@starttoc{toc}\normalsize}
\ifthu@arialtoc
  \def\thu@toc@font{\sffamily}
\fi
\def\@pnumwidth{2em} % û
\def\@tocrmarg{2em}
\def\@dotsep{1} % Ŀ¼ľ
\def\@dottedtocline#1#2#3#4#5{%
  \ifnum #1>\c@tocdepth \else
    \vskip \z@ \@plus.2\p@
    {\leftskip #2\relax \rightskip \@tocrmarg \parfillskip -\rightskip
    \parindent #2\relax\@afterindenttrue
    \interlinepenalty\@M
    \leavevmode
    \@tempdima #3\relax
    \advance\leftskip \@tempdima \null\nobreak\hskip -\leftskip
    {\csname thu@toc@font\endcsname #4}\nobreak
    \leaders\hbox{$\m@th\mkern \@dotsep mu\hbox{.}\mkern \@dotsep mu$}\hfill
    \nobreak{\normalfont \normalcolor #5}%
    \par}%
  \fi}
\renewcommand*\l@chapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 4bp \@plus\p@
    \setlength\@tempdima{4em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      {\hei\csname thu@toc@font\endcsname #1} % numberline is called here, and it use @tempdima
      \leaders\hbox{$\m@th\mkern \@dotsep mu\hbox{.}\mkern \@dotsep mu$}\hfill
      \nobreak{\normalfont\normalcolor #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi}
\renewcommand*\l@section{\@dottedtocline{1}{1.2em}{2.1em}}
\renewcommand*\l@subsection{\@dottedtocline{2}{2em}{3em}}
\renewcommand*\l@subsubsection{\@dottedtocline{3}{3.5em}{3.8em}}
\def\thu@define@term#1{
  \expandafter\gdef\csname #1\endcsname##1{%
    \expandafter\gdef\csname thu@#1\endcsname{##1}}
  \csname #1\endcsname{}}
\thu@define@term{secretlevel}
\thu@define@term{secretyear}
\thu@define@term{ctitle}
\thu@define@term{cdegree}
\newcommand\cdepartment[2][]{\def\thu@cdepartment@short{#1}\def\thu@cdepartment{#2}}
\def\caffil{\cdepartment} % for compatibility
\def\thu@cdepartment@short{}
\def\thu@cdepartment{}
\thu@define@term{cmajor}
\def\csubject{\cmajor} % for compatibility
\thu@define@term{cauthor}
\thu@define@term{csupervisor}
\thu@define@term{cassosupervisor}
\thu@define@term{ccosupervisor}
\thu@define@term{cdate}
\thu@define@term{etitle}
\thu@define@term{edegree}
\thu@define@term{edepartment}
\def\eaffil{\edepartment} % todo: for compability
\thu@define@term{emajor}
\def\esubject{\emajor} % todo: for compability
\thu@define@term{eauthor}
\thu@define@term{esupervisor}
\thu@define@term{eassosupervisor}
\thu@define@term{ecosupervisor}
\thu@define@term{edate}
\long\@xp\def\@xp\collect@@body\@xp#\@xp1\@xp\end\@xp#\@xp2\@xp{%
  \collect@@body{#1}\end{#2}}
\long\@xp\def\@xp\push@begins\@xp#\@xp1\@xp\begin\@xp#\@xp2\@xp{%
  \push@begins{#1}\begin{#2}}
\long\@xp\def\@xp\addto@envbody\@xp#\@xp1\@xp{%
  \addto@envbody{#1}}
\newcommand{\thu@@cabstract}[1]{\long\gdef\thu@cabstract{#1}}
\newenvironment{cabstract}{\collect@body\thu@@cabstract}{}
\newcommand{\thu@@eabstract}[1]{\long\gdef\thu@eabstract{#1}}
\newenvironment{eabstract}{\collect@body\thu@@eabstract}{}
\def\thu@parse@keywords#1{
  \expandafter\gdef\csname thu@#1\endcsname{} % todo: need or not?
  \expandafter\gdef\csname #1\endcsname##1{
    \@for\reserved@a:=##1\do{
      \expandafter\ifx\csname thu@#1\endcsname\@empty\else
        \expandafter\g@addto@macro\csname thu@#1\endcsname{\ignorespaces\csname thu@#1@separator\endcsname}
      \fi
      \expandafter\expandafter\expandafter\g@addto@macro%
        \expandafter\csname thu@#1\expandafter\endcsname\expandafter{\reserved@a}}}}
\thu@parse@keywords{ckeywords}
\thu@parse@keywords{ekeywords}
\newlength{\thu@title@width}
\def\thu@put@title#1{\makebox{\hb@xt@ \thu@title@width{#1}}}
\newcommand{\thu@first@titlepage}{
  \begin{center}
    \vspace*{-1.3cm}
    \parbox[b][2.4cm][t]{\textwidth}{%
      \ifthu@secret\hfill{\sihao\thu@secret@title}\else\rule{1cm}{0cm}\fi}
    \ifthu@bachelor
      \vskip0.2cm
      {\ziju{10bp}\yihao\li\thu@schoolename}
      \par\vskip1.2cm
      {\ziju{18bp}\xiaochu\hei\thu@bachelor@subtitle}
      \vskip2.5cm
      \hspace*{-0.3cm}\noindent\hei\xiaoer\thu@bachelor@title@pre\thu@title@sep
      \parbox[t]{12cm}{%
         \begin{picture}(0,0)(0,0)
           \setlength\unitlength{1cm}
           \linethickness{1.3pt}
           \put(0,-0.25){\line(1,0){12}}
           \put(0,-1.68){\line(1,0){12}}
         \end{picture}%
         \ignorespaces\yihao[1.55]\thu@ctitle} %TODO: CJKulem.sty
      \vskip1.55cm
    \else
      \parbox[t][9cm][t]{\paperwidth-8cm}{
      \renewcommand{\baselinestretch}{1.5}
      \begin{center}
      \yihao[1.2]{\hei\sffamily\thu@ctitle}\par
      \ifthu@master
        \erhao[1.1] \textbf{\sffamily\thu@etitle}\par\vskip 5bp
      \else % for doctor
        \par\vskip 20bp
      \fi
      \xiaoer[1] \textrm{{\ziju{2bp}\thu@apply}}
      \end{center}}
    \fi
    \parbox[t][7.8cm][t]{\textwidth}{{\sanhao[1.5]
      \begin{center}\fs
        \ifthu@bachelor
          \setlength{\thu@title@width}{4em}
          \setlength{\extrarowheight}{6pt}
          \begin{tabular}{p{\thu@title@width}@{}l@{\extracolsep{4pt}}l}
            \thu@put@title{\thu@bachelor@departmenttitle} & \thu@title@sep & \thu@cdepartment\\
            \thu@put@title{\thu@bachelor@majortitle}      & \thu@title@sep & \thu@cmajor\\
            \thu@put@title{\thu@bachelor@authortitle}     & \thu@title@sep & \thu@cauthor \\
            \thu@put@title{\thu@csupervisortitle}         & \thu@title@sep & \thu@csupervisor\\
            \ifx\thu@cassosupervisor\@empty\else
              \thu@put@title{\thu@cassosupertitle}        & \thu@title@sep & \thu@cassosupervisor\\
            \fi
          \end{tabular}
        \else
          \setlength{\thu@title@width}{6em}
          \setlength{\extrarowheight}{4pt}
          \begin{tabular}{p{\thu@title@width}c@{\extracolsep{4pt}}l}
            \thu@put@title{\thu@cdepartmenttitle}  & \thu@title@sep & {\ziju{3bp}\thu@cdepartment}\\
            \thu@put@title{\thu@cmajortitle}       & \thu@title@sep & {\ziju{3bp}\thu@cmajor}\\
            \thu@put@title{\thu@cauthortitle}      & \thu@title@sep & {\ziju{11bp}\thu@cauthor}\\
            \thu@put@title{\thu@csupervisortitle}  & \thu@title@sep & {\ziju{11bp}\thu@csupervisor}\\
            \ifx\thu@cassosupervisor\@empty\else
              \thu@put@title{\thu@cassosupertitle} & \thu@title@sep & {\ziju{11bp}\thu@cassosupervisor}\\
            \fi
            \ifx\thu@ccosupervisor\@empty\else
              \thu@put@title{\thu@ccosupertitle}   & \thu@title@sep & {\ziju{11bp}\thu@ccosupervisor}\\
            \fi
          \end{tabular}
        \fi
      \end{center}}}
     \begin{center}
       {\ifthu@bachelor\xiaosi\else\sanhao\fi \song \thu@cdate}
     \end{center}
    \end{center}} % end of titlepage
\newcommand{\thu@doctor@engcover}{%
  \begin{center}
    \vspace*{0.2cm}
    \parbox[t][5.2cm][t]{\paperwidth-7.2cm}{
      \renewcommand{\baselinestretch}{1.5}
      \begin{center}
        \erhao[1.1]\bfseries\sffamily\thu@etitle
      \end{center}}
    \parbox[t][5.8cm][t]{\paperwidth-7.2cm}{
      \renewcommand{\baselinestretch}{1.3}
      \begin{center}
        \sanhao Dissertation Submitted to\\
        {\bfseries Tsinghua University}\\
        in partial fulfillment of the requirement\\
        for the degree of\\
        {\bfseries\sffamily\thu@edegree}
      \end{center}}
    \parbox[t][3.6cm][b]{\paperwidth-7.2cm}{
      \renewcommand{\baselinestretch}{1.3}
      \begin{center}
        \sanhao\sffamily by\\[3bp]
        \bfseries\thu@eauthor\\(~\thu@emajor~)
      \end{center}}
    \par\vspace{0.9cm}
    \parbox[t][2.1cm][t]{\paperwidth-7.2cm}{
      \renewcommand{\baselinestretch}{1.2}\xiaosan\centering
      \begin{tabular}{rl}
        Dissertation Supervisor : & \thu@esupervisor\\
        \ifx\thu@eassosupervisor\@empty
          \else Associate Supervisor : & \thu@eassosupervisor\\\fi
      \end{tabular}}
    \parbox[t][2cm][b]{\paperwidth-7.2cm}{
    \begin{center}
      \sanhao\bfseries\sffamily\thu@edate
    \end{center}}
  \end{center}}
\newcommand\thu@underline[2][6em]{\hskip1pt\underline{\hb@xt@ #1{\hss#2\hss}}\hskip3pt}
\newcommand{\thu@authorization@mk}{%
  \ifthu@bachelor\vspace*{-0.6cm}\else\vspace*{-0.1cm}\fi % shit code!
  \begin{center}\erhao\hei\thu@authtitle\end{center}
  \ifthu@bachelor\vskip\baselineskip\else\vskip18pt\sihao[2.03]\fi\par
  \thu@authorization\par
  \textbf{\thu@authorizationaddon}\par
  \ifthu@bachelor\vskip2.54cm\else\vskip1.9cm\fi
  \ifthu@bachelor
    \noindent\thu@authorsig\thu@underline\relax%
    \thu@teachersig\thu@underline\relax\thu@frontdate\thu@underline\relax
  \else
    \begingroup
      \parindent0pt\xiaosi
      \hspace*{1.5cm}\thu@authorsig\thu@underline[7em]\relax\hfill%
                     \thu@teachersig\thu@underline[7em]\relax\hspace*{1cm}\\[3pt]
      \hspace*{1.5cm}\thu@frontdate\thu@underline[7em]\relax\hfill%
                     \thu@frontdate\thu@underline[7em]\relax\hspace*{1cm}
    \endgroup
  \fi}
\newcommand{\makecover}{
  \phantomsection
  \pdfbookmark[-1]{\thu@ctitle}{ctitle}
  \normalsize%
  \begin{titlepage}
\thu@first@titlepage
\ifthu@doctor
  \cleardoublepage\thu@doctor@engcover
\fi
\cleardoublepage\thu@authorization@mk
    \end{titlepage}
\normalsize
\thu@makeabstract
\let\@tabular\thu@tabular}
\newcommand{\thu@makeabstract}{%
  \cleardoublepage % always openright for Abstract
  \thu@chapter*[]{\cabstractname} % no tocline
  \ifthu@bachelor
    \pagestyle{thu@plain}
  \else
    \pagestyle{thu@headings}
  \fi
  \pagenumbering{Roman}
  \thu@cabstract
  \vskip12bp
  \setbox0=\hbox{{\hei \thu@ckeywords@title}}
  \noindent\hangindent\wd0\hangafter1\box0\thu@ckeywords
  \thu@chapter*[]{\eabstractname} % no tocline
  \thu@eabstract
  \vskip12bp
  \setbox0=\hbox{\textbf{Key words:\enskip}}
  \noindent\hangindent\wd0\hangafter1\box0\thu@ekeywords}
\newenvironment{denotation}[1][2.5cm]{
  \thu@chapter*[]{\thu@denotation@name} % no tocline
  \noindent\begin{list}{}%
    {\vskip-30bp\xiaosi[1.6]
     \renewcommand\makelabel[1]{##1\hfil}
     \setlength{\labelwidth}{#1} % ǩӿ
     \setlength{\labelsep}{0.5cm} % ǩбı
     \setlength{\itemindent}{0cm} % ǩ
     \setlength{\leftmargin}{\labelwidth+\labelsep} % ߽
     \setlength{\rightmargin}{0cm}
     \setlength{\parsep}{0cm} % 
     \setlength{\itemsep}{0cm} % ǩ
    \setlength{\listparindent}{0cm} % 
    \setlength{\topsep}{0pt} % ǩĵļ
   }}{\end{list}}
\newenvironment{ack}{%
  \ifthu@bachelor
    \thu@chapter*{\thu@ackname}
  \else
    % \cleardoublepage
    \thu@chapter*[\thu@acklongname]{\thu@ackname}[\thu@acklongname]
  \fi}
  {%
   \ifthu@bachelor\relax\else %TAG 1
     \par\vfill%
     \noindent
     {\setlength{\unitlength}{0.1\textwidth}
      \begin{picture}(10, 0.1)
        \multiput(0,0)(1, 0){10}{\rule{0.8\unitlength}{1.2pt}}
        \multiput(0,0.08)(1, 0){10}{\rule{0.8\unitlength}{1.2pt}}
      \end{picture}}
   \fi % END TAG 1
   \ifthu@bachelor
     \thu@chapter*{\thu@declarename}
   \else
     \parbox[t][4cm][c]{\textwidth}{{\sanhao\hei\centerline{\thu@declarename}}}
   \fi
   \par{\xiaosi\parindent2em\thu@declaretext}\vskip2cm
     {\xiaosi\hfill\thu@signature\thu@underline[2.5cm]\relax%
      \thu@backdate\thu@underline[2.5cm]\relax}%
  }
\long\def\@caption#1[#2]#3{%
  \par
  \addcontentsline{\csname ext@#1\endcsname}{#1}%
                  {\protect\numberline{\csname #1name\endcsname\hskip0.5em\csname the#1\endcsname}%
                  {\ignorespaces #2}}%
  \begingroup
  \@parboxrestore
  \if@minipage
  \@setminipage
  \fi
  \normalsize
  \@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
  \endgroup}
\def\thu@listof#1#2{%
  \@ifstar
  {\thu@chapter*[]{#1}\@starttoc{#2}}
  {\thu@chapter*{#1}\@starttoc{#2}}}
\renewcommand\listoffigures{\thu@listof{\listfigurename}{\ext@figure}}
\renewcommand*\l@figure{\@dottedtocline{1}{0em}{4em}}
\renewcommand\listoftables{\thu@listof{\listtablename}{\ext@table}}
\let\l@table\l@figure
\def\ext@equation{loe}
\def\equcaption#1{%
  \addcontentsline{\ext@equation}{equation}%
                  {\protect\numberline{\equationname\hskip0.5em #1}}}
\newcommand\listofequations{\thu@listof{\listequationname}{\ext@equation}}
\ifthu@bachelor
  \newcommand*\l@equation{\@dottedtocline{1}{0em}{4em}}
\else
  \newcommand*\l@equation{\@dottedtocline{1}{0em}{4.2em}}
\fi
\bibpunct{[}{]}{,}{s}{}{,}
\renewcommand\NAT@citesuper[3]{\ifNAT@swa
\unskip\kern\p@\textsuperscript{\NAT@@open #1\NAT@@close}%
   \if*#3*\else\ (#3)\fi\else #1\fi\endgroup}
\DeclareRobustCommand\onlinecite{\@onlinecite}
\def\@onlinecite#1{\begingroup\let\@cite\NAT@citenum\citep{#1}\endgroup}
\def\thudot{\ifthu@bachelor\else\unskip.\fi}
\def\thumasterbib{\ifthu@doctor [M]\else [Master Thesis]\fi}
\def\thuphdbib{\ifthu@doctor [D]\else [Doctor Thesis]\fi}
\renewenvironment{thebibliography}[1]{%
   \thu@chapter*{\bibname}%
   \wuhao[1.5]
   \list{\@biblabel{\@arabic\c@enumiv}}%
        {\renewcommand{\makelabel}[1]{##1\hfill}
         \settowidth\labelwidth{1.1cm}
         \setlength{\labelsep}{0.6em}
         \setlength{\itemindent}{0pt}
         \setlength{\leftmargin}{\labelwidth+\labelsep}
         \addtolength{\itemsep}{-0.7em}
         \usecounter{enumiv}%
         \let\p@enumiv\@empty
         \renewcommand\theenumiv{\@arabic\c@enumiv}}%
    \sloppy
    \clubpenalty4000
    \@clubpenalty \clubpenalty
    \widowpenalty4000%
    \interlinepenalty4000%
    \sfcode`\.\@m}
   {\def\@noitemerr
     {\@latex@warning{Empty `thebibliography' environment}}%
    \endlist}
\let\thu@appendix\appendix
\renewenvironment{appendix}{%
  \thu@appendix
  \gdef\@chapapp{\appendixname~\thechapter}
  %\renewcommand\theequation{\ifnum \c@chapter>\z@ \thechapter-\fi\@arabic\c@equation}
  }{}
\newenvironment{resume}{%
  % \cleardoublepage
  \thu@chapter*{\thu@resume@title}}{}
\newcommand{\resumeitem}[1]{\vspace{2.5em}{\sihao \hei \centerline{#1}}\par}
\newcommand{\thu@verticle}{%
  \renewcommand{\CJKsymbol}[1]{%
  \setbox0=\hbox{\symbol{##1}}%
  \newcommand{\POS}{}%
  \ifthenelse{\lengthtest{\ht0<.39\wd0}}%
             {\renewcommand{\POS}{c}}{\renewcommand{\POS}{r}}%
  \makebox[1.3\wd0][\POS]{\rotatebox[origin=lB]{90}{\symbol{##1}}}%
  \ifCJK@bold@%
  \hbox to \CJKboldshift{\hss\makebox[1.3\wd0][\POS]{%
      \rotatebox[origin=lB]{90}{\symbol{##1}}}}%
  \hbox to \CJKboldshift{\hss\makebox[1.3\wd0][\POS]{%
      \rotatebox[origin=lB]{90}{\symbol{##1}}}}%
  \fi}}
\newsavebox{\thu@saverotate}%
\newcommand{\shupai}[2][\textheight]{%
  \savebox{\thu@saverotate}{\parbox[t]{#1}{\thu@verticle #2}}
  \hfill\rotatebox[origin=lt]{-90}{\usebox{\thu@saverotate}}}
\newcommand{\shuji}[1][\thu@ctitle]{
  \newpage%
  \thispagestyle{empty}
  \vspace*{1cm}
  \shupai[\textheight-2cm]{\fs\xiaosan #1\hfill\thu@cauthor}}
\iffalse
\newcommand{\bs}{\symbol{'134}}%Print backslash
 % \newcommand{\bs}{\ensuremath{\mathtt{\backslash}}}%Print backslash
 % Index entry for a command (\cih for hidden command index
\newcommand{\cih}[1]{%
\index{commands!#1@\texttt{\bs#1}}%
\index{#1@\texttt{\hspace*{-1.2ex}\bs #1}}
}
\newcommand{\ci}[1]{\cih{#1}\texttt{\bs#1}}
 % Package
\newcommand{\pai}[1]{%
\index{packages!#1@\textsf{#1}}%
\index{#1@\textsf{#1}}%
\textsf{#1}}
 % Index entry for an environment
\newcommand{\ei}[1]{%
\index{environments!\texttt{#1}}%
\index{#1@\texttt{#1}}%
\texttt{#1}}
 % Indexentry for a word (Word inserted into the text)
\newcommand{\wi}[1]{\index{#1}#1}
\fi
\newcommand*{\ziju}[1]{\renewcommand{\CJKglue}{\hskip #1}}
\newcommand{\pozhehao}{\kern0.3ex\rule[0.8ex]{2em}{0.1ex}\kern0.3ex}
\def\thu@active@cjk{
  % Activate all >128 characters.
  \count@=127
  \@whilenum\count@<255 \do{%
    \advance\count@ by 1
    \lccode`\~=\count@
    \catcode\count@=\active
    \lowercase{\def~{\kern1ex}}}}
\AtEndOfClass{\thu@active@cjk\input{thuthesis.cfg}}%
\def\thu@fixselectfont{%
  \DeclareRobustCommand{\selectfont}{%
       \ifx\f@linespread\baselinestretch \else
          \set@fontsize\baselinestretch\f@size\f@baselineskip \fi
       \xdef\font@name{%
          \csname\curr@fontshape/\f@size\endcsname}%
       \pickup@font
       \font@name
   % CJK addition:
       \CJK@bold@false
       \csname \curr@fontshape\endcsname
   % everysel addition:
       \@EverySelectfont@EveryHook
       \@EverySelectfont@AtNextHook
       \gdef\@EverySelectfont@AtNextHook{}%
   % end additions
       \size@update
       \enc@update}}
\def\thu@setup@pdfinfo{%
  \hypersetup{%
    pdftitle={\thu@ctitle},
    pdfauthor={\thu@cauthor},
    pdfsubject={\thu@cdegree},
    pdfkeywords={\thu@ckeywords},
    pdfcreator={\thu@cauthor},
    pdfproducer={\thuthesis}}}
\def\thu@beginCJK{%
  \thu@fixselectfont%
  \begin{CJK*}{GBK}{song}%
  \sloppy\CJKindent\CJKtilde}
\def\thu@endCJK{\clearpage\end{CJK*}}
\let\thu@begindocumenthook\@begindocumenthook
\let\thu@enddocumenthook\@enddocumenthook
\def\AtBeginDocument{\g@addto@macro\thu@begindocumenthook}
\def\AtEndDocument{\g@addto@macro\thu@enddocumenthook}
\def\@begindocumenthook{\thu@begindocumenthook\thu@beginCJK}
\def\@enddocumenthook{\thu@endCJK\thu@enddocumenthook}
\AtBeginDocument{\thu@setup@pdfinfo\thu@item@space}
\endinput
%%
%% End of file `thuthesis.cls'.
