
# Generated from the Telepathy spec
""" Copyright (C) 2005-2008 Collabora Limited 
 Copyright (C) 2005-2008 Nokia Corporation 
 Copyright (C) 2006 INdT 

    This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  
"""

import dbus.service


class ChannelTypeStreamedMedia(dbus.service.Interface):
    """\
      A channel that can send and receive streamed media such as audio or video.
    Provides a number of methods for listing and requesting new streams, and
    signals to indicate when streams have been added, removed and changed
    status.

      To make a media call to a contact, clients should call CreateChannel
        with ChannelType
        = StreamedMedia,
        TargetHandleType
        = Contact, and one of TargetHandle
        or TargetID
        (which should yield a channel with the local user in Members,
        and the remote contact as TargetHandle
        but not in any group members list), then call
        RequestStreams to initiate the call (at
        which point the contact should appear in the channel's RemotePendingMembers).

      Incoming calls should be signalled as TargetHandleType
        = Contact, TargetHandle
        set to the remote contact, with the local user in LocalPendingMembers;
        to accept the call, AddMembers
        can be used to move the local user to the group's members.

      In the past, several other patterns have been used to place outgoing
        calls; see
        http://telepathy.freedesktop.org/wiki/Requesting%20StreamedMedia%20channels
        for the details.

    In general this should be used in conjunction with the MediaSignalling
    interface to exchange connection candidates and codec choices with
    whichever component is responsible for the streams. However, in certain
    applications where no candidate exchange is necessary (eg the streams are
    handled by specialised hardware which is controlled directly by the
    connection manager), the signalling interface can be omitted and this
    channel type used simply to control the streams.
    """

    @dbus.service.method('org.freedesktop.Telepathy.Channel.Type.StreamedMedia', in_signature='', out_signature='a(uuuuuu)')
    def ListStreams(self):
        """
        Returns an array of structs representing the streams currently active
        within this channel. Each stream is identified by an unsigned integer
        which is unique for each stream within the channel.
      
        """
        raise NotImplementedError
  
    @dbus.service.method('org.freedesktop.Telepathy.Channel.Type.StreamedMedia', in_signature='au', out_signature='')
    def RemoveStreams(self, Streams):
        """
        Request that the given streams are removed.
      
        """
        raise NotImplementedError
  
    @dbus.service.method('org.freedesktop.Telepathy.Channel.Type.StreamedMedia', in_signature='uu', out_signature='')
    def RequestStreamDirection(self, Stream_ID, Stream_Direction):
        """
        Request a change in the direction of an existing stream. In particular,
        this might be useful to stop sending media of a particular type,
        or inform the peer that you are no longer using media that is being
        sent to you.

        Depending on the protocol, streams which are no longer sending in
        either direction should be removed and a
        StreamRemoved signal emitted.
        Some direction changes can be enforced locally (for example,
        BIDIRECTIONAL -> RECEIVE can be achieved by merely stopping sending),
        others may not be possible on some protocols, and some need agreement
        from the remote end. In this case, the MEDIA_STREAM_PENDING_REMOTE_SEND
        flag will be set in the
        StreamDirectionChanged signal, and the
        signal
        emitted again without the flag to indicate the resulting direction when
        the remote end has accepted or rejected the change.
      
        """
        raise NotImplementedError
  
    @dbus.service.method('org.freedesktop.Telepathy.Channel.Type.StreamedMedia', in_signature='uau', out_signature='a(uuuuuu)')
    def RequestStreams(self, Contact_Handle, Types):
        """
        Request that streams be established to exchange the given types of
        media with the given member. In general this will try and establish a
        bidirectional stream, but on some protocols it may not be possible to
        indicate to the peer that you would like to receive media, so a
        send-only stream will be created initially. In the cases where the
        stream requires remote agreement (eg you wish to receive media from
        them), the StreamDirectionChanged signal
        will be emitted with the
        MEDIA_STREAM_PENDING_REMOTE_SEND flag set, and the signal emitted again
        with the flag cleared when the remote end has replied.
      
        """
        raise NotImplementedError
  
    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Type.StreamedMedia', signature='uuu')
    def StreamAdded(self, Stream_ID, Contact_Handle, Stream_Type):
        """
        Emitted when a new stream has been added to this channel.
      
        """
        pass
  
    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Type.StreamedMedia', signature='uuu')
    def StreamDirectionChanged(self, Stream_ID, Stream_Direction, Pending_Flags):
        """
        Emitted when the direction or pending flags of a stream are changed. If
        the MEDIA_STREAM_PENDING_LOCAL_SEND flag is set, the remote user has
        requested that we begin sending on this stream.
        RequestStreamDirection
        should be called to indicate whether or not this change is acceptable.
      
        """
        pass
  
    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Type.StreamedMedia', signature='uus')
    def StreamError(self, Stream_ID, Error_Code, Message):
        """
        Emitted when a stream encounters an error.
      
        """
        pass
  
    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Type.StreamedMedia', signature='u')
    def StreamRemoved(self, Stream_ID):
        """
        Emitted when a stream has been removed from this channel.
      
        """
        pass
  
    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Type.StreamedMedia', signature='uu')
    def StreamStateChanged(self, Stream_ID, Stream_State):
        """
        Emitted when a member's stream's state changes.
      
        """
        pass
  