#!/usr/bin/perl
#
# Test script for Perl extension Curl::easy.
# Check out the file README for more info.

use strict;
use WWW::Curl::Easy;

my $url = "http://curl.haxx.se/dev/";

print "Testing curl version ",WWW::Curl::Easy::version(),"\n";

# Init the curl session
my $curl= WWW::Curl::Easy->new() or die "curl init failed!\n";

# Follow location headers
$curl->setopt(CURLOPT_FOLLOWLOCATION, 1);

# Add some additional headers to the http-request:
my @myheaders=(
    "I-am-a-silly-programmer: yes indeed you are",
    "User-Agent: Perl interface for libcURL"
);

$curl->setopt(CURLOPT_HTTPHEADER, \@myheaders);
                                                                        
$curl->setopt(CURLOPT_URL, $url);

# a subroutine which is called for each 'chunk' as the
# file is received.
sub body_callback {
    my ($chunk,$context)=@_;
    # add the chunk we received to the end of the array we've been given
    push @{$context}, $chunk;
    return length($chunk); # OK
}

# configure which subroutine to call when some data comes in
$curl->setopt(CURLOPT_WRITEFUNCTION, \&body_callback);

my @body;
# tell the subroutine which array to put the data into
$curl->setopt(CURLOPT_FILE, \@body);

if ($curl->perform() != 0) {
    print "Failed ::".$curl->errbuf."\n";
};

# print the array out, joined up with no spaces
print join("",@body);

# done - perl will 'destroy' our curl handles for us, no need to clean up.
