/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/


#ifndef _MULTILINEDIT_H
#define _MULTILINEDIT_H

#include "lineedit.h"
#include "font.h"

namespace uta {

///
class MultiLineEdit : public LineEdit
{
  //OBJECT

 public:

  ///
  MultiLineEdit(Widget* parent, int x, int y, int w, int h, 
		 const Font *font=0, bool readonly = true);
  ///
  virtual ~MultiLineEdit();

  ///
  void setWrapping(bool flag);
  ///
  void setMaxLinesToStore(unsigned n) 
    { maxLinesToStore_ = n; textChanged_ = true; needsUpdate_ = true; };

  ///add Text 
  virtual void addText(const char*);  
  ///
  virtual void timer();
  ///
  unsigned visibleLines() const;
  ///
  virtual bool processEvent(const Event *event);
  ///
  void setMarkupColor(int index,
		      const Color& fontCol, 
		      const Color& fadeCol = Font::defaultFadeColor);
  ///
  void setMarkupFont(int index, const Font* font);
  ///
  void setImage(int index, const Surface* surface);

  /** Markup tags:
   *  in c-strings you may use the octal encodings:
   *  \177 \176 \175 \174 \173 \172
   */
  enum tag_t { START_TAG=127, END_TAG=126, PALETTE_TAG=125, FONT_TAG=124,
	       IMAGE_TAG=123, LINK_TAG=122
  };
  
  ///
  SigC::Signal1<void, unsigned> linkActivated;

 protected:
  ///
  void breakText(std::string&, std::vector<std::string>&, unsigned);
  ///
  void renderTextLines(const std::vector<std::string>&);
  ///
  void preprocessLines(std::vector<std::string>& lines);
  /**jump to a new line.
     the parameter is always ignored !
   */
  void newline(const char*);
  ///
  virtual void create();
  ///
  bool wordWrap_;
  ///
  bool readOnly_;
  ///
  unsigned maxLinesToStore_;
  ///
  std::vector< std::vector<Color> > markup_;
  ///
  std::vector<const Font*> fonts_;
  ///
  std::vector<const Surface*> images_;
  ///
  typedef struct 
  {
    unsigned link;      // 0 means no link
    unsigned image;     // 0 means no images
    unsigned font;      // 0 means the default font
    unsigned palette;   // 0 means the default color
    std::string text;
  } TextChunk;
  ///
  typedef std::vector<TextChunk> TextLine;
  ///
  std::vector<TextLine> textLines_;
  ///
  typedef struct
  {
    unsigned id;
    Rect rect;
  } LinkArea;
  ///
  std::vector<LinkArea> linkAreas_;
};

}

#endif // _MULTILINEDIT_
