###########################################################################
#
# This file is auto-generated by the Perl DateTime Suite locale
# generator (0.05).  This code generator comes with the
# DateTime::Locale distribution in the tools/ directory, and is called
# generate-from-cldr.
#
# This file as generated from the CLDR XML locale data.  See the
# LICENSE.cldr file included in this distribution for license details.
#
# This file was generated from the source file lv.xml
# The source file version number was 1.82, generated on
# 2008/06/26 03:47:58.
#
# Do not edit this file directly.
#
###########################################################################

package DateTime::Locale::lv;

use strict;
use warnings;
use utf8;

use base 'DateTime::Locale::root';

sub cldr_version { return "1\.6\.1" }

{
    my $am_pm_abbreviated = [ "AM", "PM" ];
    sub am_pm_abbreviated { return $am_pm_abbreviated }
}
{
    my $date_format_full = "EEEE\,\ yyyy\.\ \'gada\'\ d\.\ MMMM";
    sub date_format_full { return $date_format_full }
}

{
    my $date_format_long = "yyyy\.\ \'gada\'\ d\.\ MMMM";
    sub date_format_long { return $date_format_long }
}

{
    my $date_format_medium = "yyyy\.d\.M";
    sub date_format_medium { return $date_format_medium }
}

{
    my $date_format_short = "yy\.d\.M";
    sub date_format_short { return $date_format_short }
}

{
    my $datetime_format = "\{1\}\ \{0\}";
    sub datetime_format { return $datetime_format }
}

{
    my $day_format_abbreviated = [ "P", "O", "T", "C", "Pk", "S", "Sv" ];
    sub day_format_abbreviated { return $day_format_abbreviated }
}

sub day_format_narrow { $_[0]->day_stand_alone_narrow() }

{
    my $day_format_wide = [ "pirmdiena", "otrdiena", "trešdiena", "ceturtdiena", "piektdiena", "sestdiena", "svētdiena" ];
    sub day_format_wide { return $day_format_wide }
}

sub day_stand_alone_abbreviated { $_[0]->day_format_abbreviated() }

{
    my $day_stand_alone_narrow = [ "P", "O", "T", "C", "P", "S", "S" ];
    sub day_stand_alone_narrow { return $day_stand_alone_narrow }
}

sub day_stand_alone_wide { $_[0]->day_format_wide() }

{
    my $era_abbreviated = [ "pmē", "mē" ];
    sub era_abbreviated { return $era_abbreviated }
}
{
    my $era_narrow = [ "p\.m\.ē\.", "m\.ē\." ];
    sub era_narrow { return $era_narrow }
}
{
    my $era_wide = [ "pirms\ mūsu\ ēras", "mūsu\ ērā" ];
    sub era_wide { return $era_wide }
}
{
    my $first_day_of_week = 1;
    sub first_day_of_week { return $first_day_of_week }
}

{
    my $month_format_abbreviated = [ "Jan", "Feb", "Mar", "Apr", "Mai", "Jūn", "Jūl", "Aug", "Sep", "Okt", "Nov", "Dec" ];
    sub month_format_abbreviated { return $month_format_abbreviated }
}

sub month_format_narrow { $_[0]->month_stand_alone_narrow() }

{
    my $month_format_wide = [ "janvāris", "februāris", "marts", "aprīlis", "maijs", "jūnijs", "jūlijs", "augusts", "septembris", "oktobris", "novembris", "decembris" ];
    sub month_format_wide { return $month_format_wide }
}

sub month_stand_alone_abbreviated { $_[0]->month_format_abbreviated() }

{
    my $month_stand_alone_narrow = [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ];
    sub month_stand_alone_narrow { return $month_stand_alone_narrow }
}

sub month_stand_alone_wide { $_[0]->month_format_wide() }

{
    my $quarter_format_abbreviated = [ "C1", "C2", "C3", "C4" ];
    sub quarter_format_abbreviated { return $quarter_format_abbreviated }
}

sub quarter_format_narrow { $_[0]->quarter_stand_alone_narrow() }

{
    my $quarter_format_wide = [ "1\.\ ceturksnis", "2\.\ ceturksnis", "3\.\ ceturksnis", "4\.\ ceturksnis" ];
    sub quarter_format_wide { return $quarter_format_wide }
}

sub quarter_stand_alone_abbreviated { $_[0]->quarter_format_abbreviated() }

{
    my $quarter_stand_alone_narrow = [ "1", "2", "3", "4" ];
    sub quarter_stand_alone_narrow { return $quarter_stand_alone_narrow }
}

sub quarter_stand_alone_wide { $_[0]->quarter_format_wide() }

{
    my $time_format_full = "HH\:mm\:ss\ v";
    sub time_format_full { return $time_format_full }
}

{
    my $time_format_long = "HH\:mm\:ss\ z";
    sub time_format_long { return $time_format_long }
}

{
    my $time_format_medium = "HH\:mm\:ss";
    sub time_format_medium { return $time_format_medium }
}

{
    my $time_format_short = "HH\:mm";
    sub time_format_short { return $time_format_short }
}

{
    my $_format_for_Ed = "E\ d";
    sub _format_for_Ed { return $_format_for_Ed }
}

{
    my $_format_for_H = "H";
    sub _format_for_H { return $_format_for_H }
}

{
    my $_format_for_HHmm = "HH\:mm";
    sub _format_for_HHmm { return $_format_for_HHmm }
}

{
    my $_format_for_HHmmss = "HH\:mm\:ss";
    sub _format_for_HHmmss { return $_format_for_HHmmss }
}

{
    my $_format_for_Hm = "HH\:mm";
    sub _format_for_Hm { return $_format_for_Hm }
}

{
    my $_format_for_M = "L";
    sub _format_for_M { return $_format_for_M }
}

{
    my $_format_for_MEd = "E\,\ dd\.MM";
    sub _format_for_MEd { return $_format_for_MEd }
}

{
    my $_format_for_MMM = "LLL";
    sub _format_for_MMM { return $_format_for_MMM }
}

{
    my $_format_for_MMMEd = "E\,\ d\.\ MMM";
    sub _format_for_MMMEd { return $_format_for_MMMEd }
}

{
    my $_format_for_MMMMEd = "E\,\ d\.\ MMMM";
    sub _format_for_MMMMEd { return $_format_for_MMMMEd }
}

{
    my $_format_for_MMMMd = "d\.\ MMMM";
    sub _format_for_MMMMd { return $_format_for_MMMMd }
}

{
    my $_format_for_MMMd = "d\.\ MMM";
    sub _format_for_MMMd { return $_format_for_MMMd }
}

{
    my $_format_for_Md = "d\.M";
    sub _format_for_Md { return $_format_for_Md }
}

{
    my $_format_for_d = "d";
    sub _format_for_d { return $_format_for_d }
}

{
    my $_format_for_mmss = "mm\:ss";
    sub _format_for_mmss { return $_format_for_mmss }
}

{
    my $_format_for_ms = "mm\:ss";
    sub _format_for_ms { return $_format_for_ms }
}

{
    my $_format_for_y = "yyyy";
    sub _format_for_y { return $_format_for_y }
}

{
    my $_format_for_yM = "mm\.yyyy";
    sub _format_for_yM { return $_format_for_yM }
}

{
    my $_format_for_yMEd = "EEE\,\ dd\.mm\.yyyy";
    sub _format_for_yMEd { return $_format_for_yMEd }
}

{
    my $_format_for_yMMM = "yyyy\.\ MMM";
    sub _format_for_yMMM { return $_format_for_yMMM }
}

{
    my $_format_for_yMMMEd = "EEE\,\ dd\.\ MMM\,\ yyyy";
    sub _format_for_yMMMEd { return $_format_for_yMMMEd }
}

{
    my $_format_for_yMMMM = "yyyy\.\ MMMM";
    sub _format_for_yMMMM { return $_format_for_yMMMM }
}

{
    my $_format_for_yQ = "Q\ yyyy";
    sub _format_for_yQ { return $_format_for_yQ }
}

{
    my $_format_for_yQQQ = "yyyy\ QQQ";
    sub _format_for_yQQQ { return $_format_for_yQQQ }
}

{
    my $_format_for_yyQ = "Q\ yy";
    sub _format_for_yyQ { return $_format_for_yyQ }
}

{
    my $_format_for_yyyy = "yyyy\.\ \'g\'\.";
    sub _format_for_yyyy { return $_format_for_yyyy }
}

{
    my $_available_formats =
        {
          "Ed" => "E\ d",
          "H" => "H",
          "HHmm" => "HH\:mm",
          "HHmmss" => "HH\:mm\:ss",
          "Hm" => "HH\:mm",
          "M" => "L",
          "MEd" => "E\,\ dd\.MM",
          "MMM" => "LLL",
          "MMMEd" => "E\,\ d\.\ MMM",
          "MMMMEd" => "E\,\ d\.\ MMMM",
          "MMMMd" => "d\.\ MMMM",
          "MMMd" => "d\.\ MMM",
          "Md" => "d\.M",
          "d" => "d",
          "mmss" => "mm\:ss",
          "ms" => "mm\:ss",
          "y" => "yyyy",
          "yM" => "mm\.yyyy",
          "yMEd" => "EEE\,\ dd\.mm\.yyyy",
          "yMMM" => "yyyy\.\ MMM",
          "yMMMEd" => "EEE\,\ dd\.\ MMM\,\ yyyy",
          "yMMMM" => "yyyy\.\ MMMM",
          "yQ" => "Q\ yyyy",
          "yQQQ" => "yyyy\ QQQ",
          "yyQ" => "Q\ yy",
          "yyyy" => "yyyy\.\ \'g\'\."
        };
    sub _available_formats { return $_available_formats }
}

1;

__END__


=pod

=encoding utf8

=head1 NAME

DateTime::Locale::lv

=head1 SYNOPSIS

  use DateTime;

  my $dt = DateTime->now( locale => 'lv' );
  print $dt->month_name();

=head1 DESCRIPTION

This is the DateTime locale package for Latvian.

=head1 DATA

This locale inherits from the L<DateTime::Locale::root> locale.

It contains the following data.

=head2 Days

=head3 Wide (format)

  pirmdiena
  otrdiena
  trešdiena
  ceturtdiena
  piektdiena
  sestdiena
  svētdiena

=head3 Abbreviated (format)

  P
  O
  T
  C
  Pk
  S
  Sv

=head3 Narrow (format)

  P
  O
  T
  C
  P
  S
  S

=head3 Wide (stand-alone)

  pirmdiena
  otrdiena
  trešdiena
  ceturtdiena
  piektdiena
  sestdiena
  svētdiena

=head3 Abbreviated (stand-alone)

  P
  O
  T
  C
  Pk
  S
  Sv

=head3 Narrow (stand-alone)

  P
  O
  T
  C
  P
  S
  S

=head2 Months

=head3 Wide (format)

  janvāris
  februāris
  marts
  aprīlis
  maijs
  jūnijs
  jūlijs
  augusts
  septembris
  oktobris
  novembris
  decembris

=head3 Abbreviated (format)

  Jan
  Feb
  Mar
  Apr
  Mai
  Jūn
  Jūl
  Aug
  Sep
  Okt
  Nov
  Dec

=head3 Narrow (format)

  J
  F
  M
  A
  M
  J
  J
  A
  S
  O
  N
  D

=head3 Wide (stand-alone)

  janvāris
  februāris
  marts
  aprīlis
  maijs
  jūnijs
  jūlijs
  augusts
  septembris
  oktobris
  novembris
  decembris

=head3 Abbreviated (stand-alone)

  Jan
  Feb
  Mar
  Apr
  Mai
  Jūn
  Jūl
  Aug
  Sep
  Okt
  Nov
  Dec

=head3 Narrow (stand-alone)

  J
  F
  M
  A
  M
  J
  J
  A
  S
  O
  N
  D

=head2 Quarters

=head3 Wide (format)

  1. ceturksnis
  2. ceturksnis
  3. ceturksnis
  4. ceturksnis

=head3 Abbreviated (format)

  C1
  C2
  C3
  C4

=head3 Narrow (format)

  1
  2
  3
  4

=head3 Wide (stand-alone)

  1. ceturksnis
  2. ceturksnis
  3. ceturksnis
  4. ceturksnis

=head3 Abbreviated (stand-alone)

  C1
  C2
  C3
  C4

=head3 Narrow (stand-alone)

  1
  2
  3
  4

=head2 Eras

=head3 Wide

  pirms mūsu ēras
  mūsu ērā

=head3 Abbreviated

  pmē
  mē

=head3 Narrow

  p.m.ē.
  m.ē.

=head2 Date Formats

=head3 Full

   2008-02-05T12:30:30 = otrdiena, 2008. gada 5. februāris
   1995-12-22T09:05:02 = piektdiena, 1995. gada 22. decembris
  -0010-09-15T04:44:23 = sestdiena, -010. gada 15. septembris

=head3 Long

   2008-02-05T12:30:30 = 2008. gada 5. februāris
   1995-12-22T09:05:02 = 1995. gada 22. decembris
  -0010-09-15T04:44:23 = -010. gada 15. septembris

=head3 Medium

   2008-02-05T12:30:30 = 2008.5.2
   1995-12-22T09:05:02 = 1995.22.12
  -0010-09-15T04:44:23 = -010.15.9

=head3 Short

   2008-02-05T12:30:30 = 8.5.2
   1995-12-22T09:05:02 = 95.22.12
  -0010-09-15T04:44:23 = 10.15.9

=head3 Default

   2008-02-05T12:30:30 = 2008.5.2
   1995-12-22T09:05:02 = 1995.22.12
  -0010-09-15T04:44:23 = -010.15.9

=head2 Time Formats

=head3 Full

   2008-02-05T12:30:30 = 12:30:30 UTC
   1995-12-22T09:05:02 = 09:05:02 UTC
  -0010-09-15T04:44:23 = 04:44:23 UTC

=head3 Long

   2008-02-05T12:30:30 = 12:30:30 UTC
   1995-12-22T09:05:02 = 09:05:02 UTC
  -0010-09-15T04:44:23 = 04:44:23 UTC

=head3 Medium

   2008-02-05T12:30:30 = 12:30:30
   1995-12-22T09:05:02 = 09:05:02
  -0010-09-15T04:44:23 = 04:44:23

=head3 Short

   2008-02-05T12:30:30 = 12:30
   1995-12-22T09:05:02 = 09:05
  -0010-09-15T04:44:23 = 04:44

=head3 Default

   2008-02-05T12:30:30 = 12:30:30
   1995-12-22T09:05:02 = 09:05:02
  -0010-09-15T04:44:23 = 04:44:23

=head2 Datetime Formats

=head3 Full

   2008-02-05T12:30:30 = otrdiena, 2008. gada 5. februāris 12:30:30 UTC
   1995-12-22T09:05:02 = piektdiena, 1995. gada 22. decembris 09:05:02 UTC
  -0010-09-15T04:44:23 = sestdiena, -010. gada 15. septembris 04:44:23 UTC

=head3 Long

   2008-02-05T12:30:30 = 2008. gada 5. februāris 12:30:30 UTC
   1995-12-22T09:05:02 = 1995. gada 22. decembris 09:05:02 UTC
  -0010-09-15T04:44:23 = -010. gada 15. septembris 04:44:23 UTC

=head3 Medium

   2008-02-05T12:30:30 = 2008.5.2 12:30:30
   1995-12-22T09:05:02 = 1995.22.12 09:05:02
  -0010-09-15T04:44:23 = -010.15.9 04:44:23

=head3 Short

   2008-02-05T12:30:30 = 8.5.2 12:30
   1995-12-22T09:05:02 = 95.22.12 09:05
  -0010-09-15T04:44:23 = 10.15.9 04:44

=head3 Default

   2008-02-05T12:30:30 = 2008.5.2 12:30:30
   1995-12-22T09:05:02 = 1995.22.12 09:05:02
  -0010-09-15T04:44:23 = -010.15.9 04:44:23

=head2 Available Formats

=head3 Ed (E d)

   2008-02-05T12:30:30 = O 5
   1995-12-22T09:05:02 = Pk 22
  -0010-09-15T04:44:23 = S 15

=head3 H (H)

   2008-02-05T12:30:30 = 12
   1995-12-22T09:05:02 = 9
  -0010-09-15T04:44:23 = 4

=head3 HHmm (HH:mm)

   2008-02-05T12:30:30 = 12:30
   1995-12-22T09:05:02 = 09:05
  -0010-09-15T04:44:23 = 04:44

=head3 HHmmss (HH:mm:ss)

   2008-02-05T12:30:30 = 12:30:30
   1995-12-22T09:05:02 = 09:05:02
  -0010-09-15T04:44:23 = 04:44:23

=head3 Hm (HH:mm)

   2008-02-05T12:30:30 = 12:30
   1995-12-22T09:05:02 = 09:05
  -0010-09-15T04:44:23 = 04:44

=head3 M (L)

   2008-02-05T12:30:30 = 2
   1995-12-22T09:05:02 = 12
  -0010-09-15T04:44:23 = 9

=head3 MEd (E, dd.MM)

   2008-02-05T12:30:30 = O, 05.02
   1995-12-22T09:05:02 = Pk, 22.12
  -0010-09-15T04:44:23 = S, 15.09

=head3 MMM (LLL)

   2008-02-05T12:30:30 = Feb
   1995-12-22T09:05:02 = Dec
  -0010-09-15T04:44:23 = Sep

=head3 MMMEd (E, d. MMM)

   2008-02-05T12:30:30 = O, 5. Feb
   1995-12-22T09:05:02 = Pk, 22. Dec
  -0010-09-15T04:44:23 = S, 15. Sep

=head3 MMMMEd (E, d. MMMM)

   2008-02-05T12:30:30 = O, 5. februāris
   1995-12-22T09:05:02 = Pk, 22. decembris
  -0010-09-15T04:44:23 = S, 15. septembris

=head3 MMMMd (d. MMMM)

   2008-02-05T12:30:30 = 5. februāris
   1995-12-22T09:05:02 = 22. decembris
  -0010-09-15T04:44:23 = 15. septembris

=head3 MMMd (d. MMM)

   2008-02-05T12:30:30 = 5. Feb
   1995-12-22T09:05:02 = 22. Dec
  -0010-09-15T04:44:23 = 15. Sep

=head3 Md (d.M)

   2008-02-05T12:30:30 = 5.2
   1995-12-22T09:05:02 = 22.12
  -0010-09-15T04:44:23 = 15.9

=head3 d (d)

   2008-02-05T12:30:30 = 5
   1995-12-22T09:05:02 = 22
  -0010-09-15T04:44:23 = 15

=head3 mmss (mm:ss)

   2008-02-05T12:30:30 = 30:30
   1995-12-22T09:05:02 = 05:02
  -0010-09-15T04:44:23 = 44:23

=head3 ms (mm:ss)

   2008-02-05T12:30:30 = 30:30
   1995-12-22T09:05:02 = 05:02
  -0010-09-15T04:44:23 = 44:23

=head3 y (yyyy)

   2008-02-05T12:30:30 = 2008
   1995-12-22T09:05:02 = 1995
  -0010-09-15T04:44:23 = -010

=head3 yM (mm.yyyy)

   2008-02-05T12:30:30 = 30.2008
   1995-12-22T09:05:02 = 05.1995
  -0010-09-15T04:44:23 = 44.-010

=head3 yMEd (EEE, dd.mm.yyyy)

   2008-02-05T12:30:30 = O, 05.30.2008
   1995-12-22T09:05:02 = Pk, 22.05.1995
  -0010-09-15T04:44:23 = S, 15.44.-010

=head3 yMMM (yyyy. MMM)

   2008-02-05T12:30:30 = 2008. Feb
   1995-12-22T09:05:02 = 1995. Dec
  -0010-09-15T04:44:23 = -010. Sep

=head3 yMMMEd (EEE, dd. MMM, yyyy)

   2008-02-05T12:30:30 = O, 05. Feb, 2008
   1995-12-22T09:05:02 = Pk, 22. Dec, 1995
  -0010-09-15T04:44:23 = S, 15. Sep, -010

=head3 yMMMM (yyyy. MMMM)

   2008-02-05T12:30:30 = 2008. februāris
   1995-12-22T09:05:02 = 1995. decembris
  -0010-09-15T04:44:23 = -010. septembris

=head3 yQ (Q yyyy)

   2008-02-05T12:30:30 = 1 2008
   1995-12-22T09:05:02 = 4 1995
  -0010-09-15T04:44:23 = 3 -010

=head3 yQQQ (yyyy QQQ)

   2008-02-05T12:30:30 = 2008 C1
   1995-12-22T09:05:02 = 1995 C4
  -0010-09-15T04:44:23 = -010 C3

=head3 yyQ (Q yy)

   2008-02-05T12:30:30 = 1 8
   1995-12-22T09:05:02 = 4 95
  -0010-09-15T04:44:23 = 3 10

=head3 yyyy (yyyy. 'g'.)

   2008-02-05T12:30:30 = 2008. g.
   1995-12-22T09:05:02 = 1995. g.
  -0010-09-15T04:44:23 = -010. g.

=head2 Miscellaneous

=head3 Prefers 24 hour time?

Yes

=head3 Local first day of the week

pirmdiena


=head1 SUPPORT

See L<DateTime::Locale>.

=head1 AUTHOR

Dave Rolsky <autarch@urth.org>

=head1 COPYRIGHT

Copyright (c) 2008 David Rolsky. All rights reserved. This program is
free software; you can redistribute it and/or modify it under the same
terms as Perl itself.

This module was generated from data provided by the CLDR project, see
the LICENSE.cldr in this distribution for details on the CLDR data's
license.

=cut
