<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: ForgotPassword.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../includes/global.inc.php');

//Debug::setVerbosity( 11 );

$authenticate=FALSE;
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

$smarty->assign('title', TTi18n::gettext('Password Reset'));

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'email',
												'key',
												'email_sent',
												'password',
												'password2',
												) ) );

$validator = new Validator();

$action = Misc::findSubmitButton();
Debug::Text('Action: '. $action, __FILE__, __LINE__, __METHOD__,10);
switch ($action) {
	case 'change_password':
		Debug::Text('Change Password: '. $key, __FILE__, __LINE__, __METHOD__,10);
		$ulf = new UserListFactory();
		$ulf->getByPasswordResetKey( $key );
		if ( $ulf->getRecordCount() == 1 ) {
			Debug::Text('FOUND Password reset key! ', __FILE__, __LINE__, __METHOD__,10);

			$user_obj = $ulf->getCurrent();
			$user_name = $user_obj->getUserName();

			//Make sure passwords match
			if ( $password == $password2 ) {
				//Change password

				$user_obj->setPassword( $password );
				$user_obj->setPasswordResetKey('');
				$user_obj->setPasswordResetDate('');
				if ( $user_obj->isValid() ) {
					$user_obj->Save();

					Debug::Text('Password Change succesful!', __FILE__, __LINE__, __METHOD__,10);

					Redirect::Page( URLBuilder::getURL( array('password_reset' => 1 ), 'Login.php' ) );
				}

			} else {

				$validator->isTrue('password',FALSE, 'Passwords do not match');
			}

		} else {
			Debug::Text('DID NOT FIND Password reset key! ', __FILE__, __LINE__, __METHOD__,10);
			$action = 'reset_password';
		}

		break;
	case 'password_reset':
		//Debug::setVerbosity( 11 );
		Debug::Text('Key: '. $key, __FILE__, __LINE__, __METHOD__,10);
		$ulf = new UserListFactory();
		$ulf->getByPasswordResetKey( $key );
		if ( $ulf->getRecordCount() == 1 ) {
			Debug::Text('FOUND Password reset key! ', __FILE__, __LINE__, __METHOD__,10);
			$user_obj = $ulf->getCurrent();

			$user_name = $user_obj->getUserName();

		} else {
			Debug::Text('DID NOT FIND Password reset key! ', __FILE__, __LINE__, __METHOD__,10);
			$action = 'reset_password';
		}

		break;
	case 'reset_password':
		//Debug::setVerbosity( 11 );
		Debug::Text('Email: '. $email, __FILE__, __LINE__, __METHOD__,10);

		$ulf = new UserListFactory();
		$ulf->getByHomeEmailOrWorkEmail( $email );
		if ( $ulf->getRecordCount() == 1 ) {
			$user_obj = $ulf->getCurrent();
			$user_obj->sendPasswordResetEmail();
			Debug::Text('Found USER! ', __FILE__, __LINE__, __METHOD__,10);

			Redirect::Page( URLBuilder::getURL( array('email_sent' => 1, 'email' => $email ), 'ForgotPassword.php' ) );
		} else {
			//Error
			Debug::Text('DID NOT FIND USER! ', __FILE__, __LINE__, __METHOD__,10);
			$validator->isTrue('email',FALSE, 'Email address was not found in our database');
		}
/*
		$validator->isTrue('user_name',FALSE, 'User Name or Password is incorrect');
*/
		break;
	default:
		break;
}

$smarty->assign_by_ref('email', $email);
$smarty->assign_by_ref('email_sent', $email_sent);
$smarty->assign_by_ref('key', $key);
$smarty->assign_by_ref('user_name', $user_name);
$smarty->assign_by_ref('action', $action);

$smarty->assign_by_ref('validator', $validator);

$smarty->display('ForgotPassword.tpl');
?>