/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Config;
import br.arca.morcego.Vertex;

public class Matrix3D {
    private float xx = 1.0f;
    private float xy;
    private float xz;
    private float yx;
    private float yy = 1.0f;
    private float yz;
    private float zx;
    private float zy;
    private float zz = 1.0f;
    private static float xf = 1.0f;
    private static float yf = 1.0f;
    private static float zf = 1.0f;
    private static float f = 1.0f;
    private boolean identity = false;

    public void xrot(double theta) {
        this.identity = false;
        double ct = Math.cos(theta *= Math.PI / 180);
        double st = Math.sin(theta);
        float Nxx = (float)((double)this.xx * ct + (double)this.zx * st);
        float Nxy = (float)((double)this.xy * ct + (double)this.zy * st);
        float Nxz = (float)((double)this.xz * ct + (double)this.zz * st);
        float Nzx = (float)((double)this.zx * ct - (double)this.xx * st);
        float Nzy = (float)((double)this.zy * ct - (double)this.xy * st);
        float Nzz = (float)((double)this.zz * ct - (double)this.xz * st);
        this.xx = Nxx;
        this.xy = Nxy;
        this.xz = Nxz;
        this.zx = Nzx;
        this.zy = Nzy;
        this.zz = Nzz;
    }

    public void yrot(double theta) {
        this.identity = false;
        double ct = Math.cos(theta *= Math.PI / 180);
        double st = Math.sin(theta);
        float Nyx = (float)((double)this.yx * ct + (double)this.zx * st);
        float Nyy = (float)((double)this.yy * ct + (double)this.zy * st);
        float Nyz = (float)((double)this.yz * ct + (double)this.zz * st);
        float Nzx = (float)((double)this.zx * ct - (double)this.yx * st);
        float Nzy = (float)((double)this.zy * ct - (double)this.yy * st);
        float Nzz = (float)((double)this.zz * ct - (double)this.yz * st);
        this.yx = Nyx;
        this.yy = Nyy;
        this.yz = Nyz;
        this.zx = Nzx;
        this.zy = Nzy;
        this.zz = Nzz;
    }

    public void zrot(double theta) {
        this.identity = false;
        double ct = Math.cos(theta *= Math.PI / 180);
        double st = Math.sin(theta);
        float Nyx = (float)((double)this.yx * ct + (double)this.xx * st);
        float Nyy = (float)((double)this.yy * ct + (double)this.xy * st);
        float Nyz = (float)((double)this.yz * ct + (double)this.xz * st);
        float Nxx = (float)((double)this.xx * ct - (double)this.yx * st);
        float Nxy = (float)((double)this.xy * ct - (double)this.yy * st);
        float Nxz = (float)((double)this.xz * ct - (double)this.yz * st);
        this.yx = Nyx;
        this.yy = Nyy;
        this.yz = Nyz;
        this.xx = Nxx;
        this.xy = Nxy;
        this.xz = Nxz;
    }

    void mul(float n) {
        this.identity = false;
        this.xx *= n;
        this.xy *= n;
        this.xz *= n;
        this.yx *= n;
        this.yy *= n;
        this.yz *= n;
        this.zx *= n;
        this.zy *= n;
        this.zz *= n;
    }

    void mul(Matrix3D rhs) {
        this.identity = false;
        float lxx = this.xx * rhs.xx + this.yx * rhs.xy + this.zx * rhs.xz;
        float lxy = this.xy * rhs.xx + this.yy * rhs.xy + this.zy * rhs.xz;
        float lxz = this.xz * rhs.xx + this.yz * rhs.xy + this.zz * rhs.xz;
        float lyx = this.xx * rhs.yx + this.yx * rhs.yy + this.zx * rhs.yz;
        float lyy = this.xy * rhs.yx + this.yy * rhs.yy + this.zy * rhs.yz;
        float lyz = this.xz * rhs.yx + this.yz * rhs.yy + this.zz * rhs.yz;
        float lzx = this.xx * rhs.zx + this.yx * rhs.zy + this.zx * rhs.zz;
        float lzy = this.xy * rhs.zx + this.yy * rhs.zy + this.zy * rhs.zz;
        float lzz = this.xz * rhs.zx + this.yz * rhs.zy + this.zz * rhs.zz;
        this.xx = lxx;
        this.xy = lxy;
        this.xz = lxz;
        this.yx = lyx;
        this.yy = lyy;
        this.yz = lyz;
        this.zx = lzx;
        this.zy = lzy;
        this.zz = lzz;
    }

    public void setIdentity() {
        this.identity = true;
        this.xx = 1.0f;
        this.xy = 0.0f;
        this.xz = 0.0f;
        this.yx = 0.0f;
        this.yy = 1.0f;
        this.yz = 0.0f;
        this.zx = 0.0f;
        this.zy = 0.0f;
        this.zz = 1.0f;
    }

    public void transform(Vertex v1) {
        float X = v1.x * this.xx + v1.y * this.xy + v1.z * this.xz;
        float Y = v1.x * this.yx + v1.y * this.yy + v1.z * this.yz;
        float Z = v1.x * this.zx + v1.y * this.zy + v1.z * this.zz;
        int radius = (Integer)Config.getValue("universeRadius");
        X = Math.max((float)(-radius), Math.min(X, (float)radius));
        Y = Math.max((float)(-radius), Math.min(Y, (float)radius));
        Z = Math.max((float)(-radius), Math.min(Z, (float)radius));
        v1.x = X;
        v1.y = Y;
        v1.z = Z;
    }

    public String toString() {
        return "[," + this.xx + "," + this.xy + "," + this.xz + ";" + "," + this.yx + "," + this.yy + "," + this.yz + ";" + "," + this.zx + "," + this.zy + "," + this.zz + "]";
    }

    public boolean isIdentity() {
        return this.identity;
    }
}

