'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.10/tcllib-1.10/modules/page/page_util_peg.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "page_util_peg" n 1.0 page "Parser generator tools"
.BS
.SH NAME
page_util_peg \- page PEG transformation utilities
.SH SYNOPSIS
package require \fBpage::util::peg  ?0.1?\fR
.sp
package require \fBsnit \fR
.sp
\fB::page::util::peg::symbolNodeOf\fR \fItree\fR \fInode\fR
.sp
\fB::page::util::peg::symbolOf\fR \fItree\fR \fInode\fR
.sp
\fB::page::util::peg::updateUndefinedDueRemoval\fR \fItree\fR
.sp
\fB::page::util::peg::flatten\fR \fItreequery\fR \fItree\fR
.sp
\fB::page::util::peg::getWarnings\fR \fItree\fR
.sp
\fB::page::util::peg::printWarnings\fR \fImsg\fR
.sp
\fB::page::util::peg::peOf\fR \fItree\fR \fIeroot\fR
.sp
\fB::page::util::peg::printTclExpr\fR \fIpe\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides a few common operations to PEG transformations.
They assume a \fINormalized PE Grammar Tree\fR as input, see the
package \fBpage::util::norm::peg\fR, possibly augmented with
attributes coming from transformations not in conflict with the base
definition.
.PP
.SH API
.TP
\fB::page::util::peg::symbolNodeOf\fR \fItree\fR \fInode\fR
Given an arbitrary expression \fInode\fR in the AST \fItree\fR it
determines the node (itself or an ancestor) containing the name of the
nonterminal symbol the node belongs to, and returns its id. The result
is either the root of the tree (for the start expression), or a
definition node.
.TP
\fB::page::util::peg::symbolOf\fR \fItree\fR \fInode\fR
As \fB::page::util::peg::symbolNodeOf\fR, but returns the symbol name
instead of the node.
.TP
\fB::page::util::peg::updateUndefinedDueRemoval\fR \fItree\fR
The removal of nodes in the AST \fItree\fR can cause symbols to lose
one or more users.
.nf

	A used by B and C,
	B is reachable,
	C is not,

	so A now loses the node in the expression for C calling it,
	or rather, not calling it anymore.

.fi
This command updates the cross-references and which nonterminals are
now undefined.
.TP
\fB::page::util::peg::flatten\fR \fItreequery\fR \fItree\fR
This commands flattens nested sequence and choice operators in the AST
\fItree\fR, re-using the \fBtreeql\fR object \fItreequery\fR to
run the query determining which nodes to cut.
.TP
\fB::page::util::peg::getWarnings\fR \fItree\fR
This command looks at the attributes of the AST \fItree\fR for
problems with the grammar and issues warnings. They do not prevent us
from writing the grammar, but still represent problems with it the
user should be made aware of.
.sp
The result of the command is a dictionary mapping nonterminal names to
their associated warnings.
.TP
\fB::page::util::peg::printWarnings\fR \fImsg\fR
The argument of the command is a dictionary mapping nonterminal names
to their associated warnings, as generated by, for example, the
command \fB::page::util::peg::getWarnings\fR.
.sp
The warnings contained therein are formatted and then printed via the
log command \fBpage_info\fR. This means that this command can be used
only from within a plugin managed by the package
\fBpage::pluginmgr\fR.
.TP
\fB::page::util::peg::peOf\fR \fItree\fR \fIeroot\fR
This command converts the parsing expression starting at the node
\fIeroot\fR in the AST \fItree\fR into a nested list. The exact syntax
of this list specified by the package \fBgrammar::peg\fR.
.TP
\fB::page::util::peg::printTclExpr\fR \fIpe\fR
This command converts the parsing expression contained in the nested
list \fIpe\fR into a Tcl string which can be placed into a Tcl script.
See the package \fBgrammar::peg\fR for the exact syntax of
\fIpe\fR.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, will undoubtedly contain bugs and other problems.
Please report such in the category \fIpage\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have.
.SH KEYWORDS
PEG, page, parser generator, parsing expression grammar, text processing, transformation
.SH COPYRIGHT
.nf
Copyright (c) 2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi