/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.status;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.jk.status.AbstractJkStatusTask;
import org.apache.tools.ant.BuildException;

public class JkStatusUpdateLoadbalancerTask
extends AbstractJkStatusTask {
    private static final String info = "org.apache.jk.status.JkStatusUpdateLoadbalancerTask/1.0";
    protected String loadbalancer;
    protected int retries = -1;
    protected int recoverWaitTime = -1;
    protected int methodCode = -1;
    protected String method;
    protected Boolean stickySession;
    protected Boolean forceStickySession;
    protected int lockCode = -1;
    protected String lock;
    protected int maxReplyTimeouts = -1;

    public String getInfo() {
        return info;
    }

    public JkStatusUpdateLoadbalancerTask() {
        this.setUrl("http://localhost/jkstatus");
    }

    public Boolean getForceStickySession() {
        return this.forceStickySession;
    }

    public void setForceStickySession(Boolean forceStickySession) {
        this.forceStickySession = forceStickySession;
    }

    public String getLoadbalancer() {
        return this.loadbalancer;
    }

    public void setLoadbalancer(String loadbalancer) {
        this.loadbalancer = loadbalancer;
    }

    public String getLock() {
        return this.lock;
    }

    public void setLock(String locking) {
        this.lock = locking;
    }

    public int getLockCode() {
        return this.lockCode;
    }

    public void setLockCode(int lockingCode) {
        this.lockCode = lockingCode;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public int getMethodCode() {
        return this.methodCode;
    }

    public void setMethodCode(int methodCode) {
        this.methodCode = methodCode;
    }

    public int getRecoverWaitTime() {
        return this.recoverWaitTime;
    }

    public void setRecoverWaitTime(int recoverWaitTime) {
        this.recoverWaitTime = recoverWaitTime;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public Boolean getStickySession() {
        return this.stickySession;
    }

    public void setStickySession(Boolean stickySession) {
        this.stickySession = stickySession;
    }

    public int getMaxReplyTimeouts() {
        return this.maxReplyTimeouts;
    }

    public void setMaxReplyTimeouts(int maxReplyTimeouts) {
        this.maxReplyTimeouts = maxReplyTimeouts;
    }

    protected StringBuffer createLink() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("?cmd=update&mime=txt");
            sb.append("&w=");
            sb.append(URLEncoder.encode(this.loadbalancer, this.getCharset()));
            if (this.stickySession != null) {
                sb.append("&vls=");
                sb.append(this.stickySession);
            }
            if (this.forceStickySession != null) {
                sb.append("&vlf=");
                sb.append(this.forceStickySession);
            }
            if (this.retries >= 0) {
                sb.append("&vlr=");
                sb.append(this.retries);
            }
            if (this.recoverWaitTime >= 0) {
                sb.append("&vlt=");
                sb.append(this.recoverWaitTime);
            }
            if (this.method == null && this.methodCode >= 0 && this.methodCode < 4) {
                sb.append("&vlm=");
                sb.append(this.methodCode);
            }
            if (this.method != null) {
                sb.append("&vlm=");
                sb.append(this.method);
            }
            if (this.lock == null && this.lockCode >= 0 && this.lockCode < 2) {
                sb.append("&vll=");
                sb.append(this.lockCode);
            }
            if (this.lock != null) {
                sb.append("&vll=");
                sb.append(this.lock);
            }
            if (this.maxReplyTimeouts >= 0) {
                sb.append("&vlx=");
                sb.append(this.maxReplyTimeouts);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BuildException("Invalid 'charset' attribute: " + this.getCharset());
        }
        return sb;
    }

    protected void checkParameter() {
        if (this.loadbalancer == null) {
            throw new BuildException("Must specify 'loadbalancer' attribute");
        }
    }
}

