<?xml version="1.0" encoding="UTF-8"?>
<!-- 
/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can get a copy of the License at http://www.thinkingrock.com.au/cddl.html
 * or http://www.thinkingrock.com.au/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.thinkingrock.com.au/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * The Original Software is ThinkingRock. The Initial Developer of the Original
 * Software is Avente Pty Ltd, Australia.
 *
 * Portions Copyright 2006-2007 Avente Pty Ltd. All Rights Reserved.
 */
-->
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:output method="xml" 
                version="1.0" 
                omit-xml-declaration="no" 
                indent="yes"/>
    
    <!--=====================================================================-->
    <!-- Parameters                                                          -->	
    <!--=====================================================================-->
    <xsl:param name="page-1"/>
    <xsl:param name="page-2"/>
    <xsl:param name="page-3"/>
    <xsl:param name="page-4"/>
    <xsl:param name="page-5"/>
    <xsl:param name="page-6"/>
    <xsl:param name="page-7"/>
    <xsl:param name="page-8"/>
    <xsl:param name="show-project"/>
    
    <!--=====================================================================-->
    <!-- Variables                                                           -->	
    <!--=====================================================================-->		
    <xsl:variable name="require-doasap">
        <xsl:choose>
            <xsl:when test="starts-with($page-1,'doasap')">true</xsl:when>
            <xsl:when test="starts-with($page-2,'doasap')">true</xsl:when>
            <xsl:when test="starts-with($page-3,'doasap')">true</xsl:when>
            <xsl:when test="starts-with($page-4,'doasap')">true</xsl:when>
            <xsl:when test="starts-with($page-5,'doasap')">true</xsl:when>
            <xsl:when test="starts-with($page-6,'doasap')">true</xsl:when>
            <xsl:when test="starts-with($page-7,'doasap')">true</xsl:when>
            <xsl:when test="starts-with($page-8,'doasap')">true</xsl:when>
            <xsl:otherwise>false</xsl:otherwise>
        </xsl:choose>			
    </xsl:variable>	
    <xsl:variable name="require-overdue">
        <xsl:choose>
            <xsl:when test="starts-with($page-1,'overdue')">true</xsl:when>
            <xsl:when test="starts-with($page-2,'overdue')">true</xsl:when>
            <xsl:when test="starts-with($page-3,'overdue')">true</xsl:when>
            <xsl:when test="starts-with($page-4,'overdue')">true</xsl:when>
            <xsl:when test="starts-with($page-5,'overdue')">true</xsl:when>
            <xsl:when test="starts-with($page-6,'overdue')">true</xsl:when>
            <xsl:when test="starts-with($page-7,'overdue')">true</xsl:when>
            <xsl:when test="starts-with($page-8,'overdue')">true</xsl:when>
            <xsl:otherwise>false</xsl:otherwise>
        </xsl:choose>			
    </xsl:variable>
    <xsl:variable name="require-today">
        <xsl:choose>
            <xsl:when test="starts-with($page-1,'today')">true</xsl:when>
            <xsl:when test="starts-with($page-2,'today')">true</xsl:when>
            <xsl:when test="starts-with($page-3,'today')">true</xsl:when>
            <xsl:when test="starts-with($page-4,'today')">true</xsl:when>
            <xsl:when test="starts-with($page-5,'today')">true</xsl:when>
            <xsl:when test="starts-with($page-6,'today')">true</xsl:when>
            <xsl:when test="starts-with($page-7,'today')">true</xsl:when>
            <xsl:when test="starts-with($page-8,'today')">true</xsl:when>
            <xsl:otherwise>false</xsl:otherwise>
        </xsl:choose>			
    </xsl:variable>
    <xsl:variable name="require-this-week">
        <xsl:choose>
            <xsl:when test="starts-with($page-1,'this-week')">true</xsl:when>
            <xsl:when test="starts-with($page-2,'this-week')">true</xsl:when>
            <xsl:when test="starts-with($page-3,'this-week')">true</xsl:when>
            <xsl:when test="starts-with($page-4,'this-week')">true</xsl:when>
            <xsl:when test="starts-with($page-5,'this-week')">true</xsl:when>
            <xsl:when test="starts-with($page-6,'this-week')">true</xsl:when>
            <xsl:when test="starts-with($page-7,'this-week')">true</xsl:when>
            <xsl:when test="starts-with($page-8,'this-week')">true</xsl:when>
            <xsl:otherwise>false</xsl:otherwise>
        </xsl:choose>			
    </xsl:variable>
    <xsl:variable name="require-blank">
        <xsl:choose>
            <xsl:when test="starts-with($page-1,'blank')">true</xsl:when>
            <xsl:when test="starts-with($page-2,'blank')">true</xsl:when>
            <xsl:when test="starts-with($page-3,'blank')">true</xsl:when>
            <xsl:when test="starts-with($page-4,'blank')">true</xsl:when>
            <xsl:when test="starts-with($page-5,'blank')">true</xsl:when>
            <xsl:when test="starts-with($page-6,'blank')">true</xsl:when>
            <xsl:when test="starts-with($page-7,'blank')">true</xsl:when>
            <xsl:when test="starts-with($page-8,'blank')">true</xsl:when>
            <xsl:otherwise>false</xsl:otherwise>
        </xsl:choose>			
    </xsl:variable>
    <xsl:variable name="require-new-thoughts">
        <xsl:choose>
            <xsl:when test="starts-with($page-1,'new-thoughts')">true</xsl:when>
            <xsl:when test="starts-with($page-2,'new-thoughts')">true</xsl:when>
            <xsl:when test="starts-with($page-3,'new-thoughts')">true</xsl:when>
            <xsl:when test="starts-with($page-4,'new-thoughts')">true</xsl:when>
            <xsl:when test="starts-with($page-5,'new-thoughts')">true</xsl:when>
            <xsl:when test="starts-with($page-6,'new-thoughts')">true</xsl:when>
            <xsl:when test="starts-with($page-7,'new-thoughts')">true</xsl:when>
            <xsl:when test="starts-with($page-8,'new-thoughts')">true</xsl:when>
            <xsl:otherwise>false</xsl:otherwise>
        </xsl:choose>			
    </xsl:variable>
    
    <xsl:variable name="today" select="number(substring(/data/date,1,8))"/>	
    <xsl:variable name="week"  select="number(substring(/data/week,1,8))"/>		
    
    <!--=====================================================================-->
    <!-- Root element                                                        -->
    <!--=====================================================================-->
    <xsl:template match="data">
        <pm>
            <xsl:call-template name="date"><xsl:with-param name="d" select="/data/date"/></xsl:call-template>  										
            
            <xsl:if test="$require-doasap='true'">
                <xsl:call-template name="list-doasap"/>												
            </xsl:if>
            <xsl:if test="$require-overdue='true'">
                <xsl:call-template name="list-overdue"/>		
            </xsl:if>
            <xsl:if test="$require-today='true'">
                <xsl:call-template name="list-today"/>
            </xsl:if>
            <xsl:if test="$require-this-week='true'">
                <xsl:call-template name="list-this-week"/>															
            </xsl:if>
            <xsl:if test="$require-blank='true'">
                <xsl:call-template name="list-blank"/>															
            </xsl:if>
            <xsl:if test="$require-new-thoughts='true'">
                <xsl:call-template name="list-new-thoughts"/>															
            </xsl:if>
        </pm>
    </xsl:template>
    
    <!--=====================================================================-->
    <!-- List overdue actions                                                -->	
    <!--=====================================================================-->
    <xsl:template name="list-overdue">	
        <list name="overdue">	
            <xsl:apply-templates select="//action[done='false' and state[(@type='SCHEDULED' or @type='DELEGATED') and date and number(substring(date,1,8)) &lt; $today]]">
                <xsl:sort select="state/date"/>
                <xsl:sort select="state/@type"/>
                <xsl:sort select="desc"/>
            </xsl:apply-templates>
            <xsl:call-template name="list-blank-lines"/>
            <xsl:call-template name="list-blank-lines"/>
            <xsl:call-template name="list-blank-lines"/>
        </list>	
    </xsl:template>
    
    <!--=====================================================================-->
    <!-- List this week actions                                              -->	
    <!--=====================================================================-->
    <xsl:template name="list-this-week">	
        <list name="this-week">	
            <xsl:apply-templates select="//action[done='false' and state[(@type='SCHEDULED' or @type='DELEGATED') and date and number(substring(date,1,8)) &gt; $today and number(substring(date,1,8)) &lt; $week]]">
                <xsl:sort select="state/date"/>
                <xsl:sort select="state/@type"/>
                <xsl:sort select="desc"/>
            </xsl:apply-templates>
            <xsl:call-template name="list-blank-lines"/>
            <xsl:call-template name="list-blank-lines"/>
            <xsl:call-template name="list-blank-lines"/>			
        </list>	
    </xsl:template>
    
    <!--=====================================================================-->
    <!-- List today actions                                                  -->	
    <!--=====================================================================-->
    <xsl:template name="list-today">	
        <list name="today">	
            <xsl:apply-templates select="//action[done='false' and state[(@type='SCHEDULED' or @type='DELEGATED') and date and number(substring(date,1,8)) = $today]]">
                <xsl:sort select="state/date"/>
                <xsl:sort select="state/@type"/>
                <xsl:sort select="desc"/>
            </xsl:apply-templates>
            <xsl:call-template name="list-blank-lines"/>
            <xsl:call-template name="list-blank-lines"/>
            <xsl:call-template name="list-blank-lines"/>			
        </list>	
    </xsl:template>
    
    <!--=====================================================================-->
    <!-- List Do ASAP actions                                                -->	
    <!--=====================================================================-->
    <xsl:template name="list-doasap">	
        <list name="doasap">
            <xsl:apply-templates select="contexts/context">		
                <xsl:with-param name="type">ASAP</xsl:with-param>
                <xsl:sort select="name"/>
            </xsl:apply-templates>					
            <xsl:call-template name="list-blank-lines"/>
            <xsl:call-template name="list-blank-lines"/>
            <xsl:call-template name="list-blank-lines"/>								
        </list>	
    </xsl:template>
    
    <!--=====================================================================-->
    <!-- Match context: list actions of given state type for context.        -->	
    <!--=====================================================================-->
    <xsl:template match="context">
        <xsl:param name="type"/>
        <xsl:variable name="key" select="@key"/>
        <xsl:variable name="actions" select="//action[context-key=$key and state[@type=$type] and not(done='true')]"/>
        <xsl:if test="count($actions) &gt; 0">
            <line><group-context><xsl:value-of select="name"/></group-context></line>
            <xsl:apply-templates select="$actions">
                <xsl:sort select="desc"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <!--=====================================================================-->
    <!-- Match action: list action.                                          -->	
    <!--=====================================================================-->
    <xsl:template match="action">
        <xsl:variable name="done" select="done"/>						
        <xsl:variable name="topic-key" select="topic-key"/>			
        <xsl:variable name="context-key" select="context-key"/>												
        <xsl:variable name="project-key" select="parent-key"/>												
        <xsl:variable name="thought-key" select="thought-key"/>			
        <xsl:choose>
            <xsl:when test="state[@type='ASAP']">			
                <line>
                    <tickbox tick='{$done}'/>				
                    <desc><xsl:value-of select="desc"/></desc>			
                    <topic><xsl:value-of select="//topics/topic[@key=$topic-key]/name"/></topic>							
                </line>
                <xsl:if test="$show-project='true'">
                    <line>
                        <spaces no="3"/>  
                        <xsl:call-template name="project">
                            <xsl:with-param name="project-key" select="$project-key"/>
                            <xsl:with-param name="thought-key" select="$thought-key"/>
                        </xsl:call-template>				
                    </line>			
                </xsl:if>
            </xsl:when>
            <xsl:when test="state[@type='SCHEDULED']">						
                <line>
                    <tickbox tick='{$done}'/>									
                    <xsl:call-template name="datetime"><xsl:with-param name="d" select="state/date"/></xsl:call-template>
                    <xsl:call-template name="time"><xsl:with-param name="d" select="state/date"/></xsl:call-template>
                    <desc><xsl:value-of select="desc"/></desc>			
                </line>
                <line>
                    <spaces no="3"/>  
                    <context><xsl:value-of select="//contexts/context[@key=$context-key]/name"/></context>										
                    <topic><xsl:value-of select="//topics/topic[@key=$topic-key]/name"/></topic>
                    <xsl:if test="$show-project='true'">
                        <xsl:call-template name="project">
                            <xsl:with-param name="project-key" select="$project-key"/>
                            <xsl:with-param name="thought-key" select="$thought-key"/>
                        </xsl:call-template>				
                    </xsl:if>  		  										
                </line>   		  		
            </xsl:when>
            <xsl:when test="state[@type='DELEGATED']">
                <line>
                    <tickbox tick='{$done}'/>									
                    <xsl:call-template name="date"><xsl:with-param name="d" select="state/date"/></xsl:call-template>  										
                    <desc><xsl:value-of select="desc"/></desc>			
                    <to><xsl:value-of select="state/to"/></to>								
                </line>
                <line>
                    <spaces no="3"/>  
                    <context><xsl:value-of select="//contexts/context[@key=$context-key]/name"/></context>										
                    <topic><xsl:value-of select="//topics/topic[@key=$topic-key]/name"/></topic>	
                    <xsl:if test="$show-project='true'">
                        <xsl:call-template name="project">
                            <xsl:with-param name="project-key" select="$project-key"/>
                            <xsl:with-param name="thought-key" select="$thought-key"/>
                        </xsl:call-template>				
                    </xsl:if>  		  										
                </line>   		  		
            </xsl:when> 			
        </xsl:choose>
    </xsl:template>
    
    <!--=====================================================================-->
    <!-- Project or thought                                                  -->	
    <!--=====================================================================-->
    <xsl:template name="project">
        <xsl:param name="project-key"/>		
        <xsl:param name="thought-key"/>		
        <xsl:choose>
            <xsl:when test="$project-key">
                <from>[<xsl:value-of select="//projects/project[@key=$project-key]/desc"/>]</from>  					
            </xsl:when>
            <xsl:when test="$thought-key">
                <from>{<xsl:value-of select="//thoughts/thought[@key=$thought-key]/desc"/>}</from>  					
            </xsl:when>
            <xsl:otherwise>
                <from></from>  					
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!--=====================================================================-->
    <!-- List blank                                                          -->	
    <!--=====================================================================-->
    <xsl:template name="list-blank">		
        <list name="blank">
            <xsl:call-template name="list-blank-lines"/>
        </list>
    </xsl:template>
    
    <!--=====================================================================-->
    <!-- List blank lines                                                    -->	
    <!--=====================================================================-->
    <xsl:template name="list-blank-lines">		
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
        <line/>
    </xsl:template>	
    
    <!--=====================================================================-->
    <!-- List new thoughts                                                   -->	
    <!--=====================================================================-->
    <xsl:template name="list-new-thoughts">	
        <list name="new-thoughts">		
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
            <line><tickbox/></line>
        </list>	
    </xsl:template>	
    
    <!--=====================================================================-->
    <!-- Date                                                                -->	
    <!--=====================================================================-->
    <xsl:template name="date">
        <xsl:param name="d"/>								
        <xsl:variable name="date" select="number(substring($d,1,8))"/>				
        <xsl:variable name="color">
            <xsl:choose>
                <xsl:when test="$date &lt; $today">red</xsl:when>
                <xsl:when test="$date = $today">blue</xsl:when>			
                <xsl:when test="$date &lt;= $week">green</xsl:when>			
                <xsl:otherwise>black</xsl:otherwise>							
            </xsl:choose>			
        </xsl:variable>	
        <date color="{$color}">
            <xsl:variable name="fdp" select="substring-after($d,' ')"/>					
            <xsl:value-of select="substring($fdp, 1, string-length($fdp)-14)"/>			
        </date>							
    </xsl:template>
    
    <!--=====================================================================-->
    <!-- Date and time                                                       -->	
    <!--=====================================================================-->
    <xsl:template name="datetime">
        <xsl:param name="d"/>		
        <xsl:variable name="date" select="number(substring($d,1,8))"/>		
        <xsl:variable name="color">
            <xsl:choose>
                <xsl:when test="$date &lt; $today">red</xsl:when>
                <xsl:when test="$date = $today">blue</xsl:when>			
                <xsl:when test="$date &lt;= $week">green</xsl:when>			
                <xsl:otherwise>black</xsl:otherwise>							
            </xsl:choose>			
        </xsl:variable>	
        <date color="{$color}">
            <xsl:call-template name="date"><xsl:with-param name="d" select="$d"/></xsl:call-template>
            <xsl:text> </xsl:text>
            <xsl:call-template name="time"><xsl:with-param name="d" select="$d"/></xsl:call-template>
        </date>					
    </xsl:template>
    
    <!--=====================================================================-->
    <!-- Time                                                                -->	
    <!--=====================================================================-->
    <xsl:template name="time">
        <xsl:param name="d"/>		
        <xsl:variable name="date" select="number(substring($d,1,8))"/>		
        <xsl:variable name="color">
            <xsl:choose>
                <xsl:when test="$date &lt; $today">red</xsl:when>
                <xsl:when test="$date = $today">blue</xsl:when>			
                <xsl:when test="$date &lt;= $week">green</xsl:when>			
                <xsl:otherwise>black</xsl:otherwise>							
            </xsl:choose>			
        </xsl:variable>	
        <time color="{$color}">
            <xsl:value-of select="substring($d,9,2)"/>
            <xsl:text>:</xsl:text>
            <xsl:value-of select="substring($d,11,2)"/>
        </time>
    </xsl:template> 	
    
    <!--=====================================================================-->
    
</xsl:stylesheet>
