/*
 * Decompiled with CFR 0.152.
 */
package tr.view.project;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.project.Sequencing;
import tr.model.topic.Topic;
import tr.prefs.projects.ProjectsPrefs;
import tr.runtime.Open;
import tr.swing.TextArea;
import tr.swing.date.field.DateField;
import tr.swing.document.LazyDocumentListener;
import tr.swing.editorpane.HyperEditorPane;
import tr.util.Observable;
import tr.util.Observer;
import tr.util.Utils;
import tr.view.criteria.PriorityComboBoxModel;
import tr.view.project.SequencingModel;
import tr.view.topics.TopicsComboBox;
import tr.view.topics.TopicsComboBoxModel;

public final class ProjectPanel
extends JPanel {
    private final PropertyChangeListener descrListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ProjectPanel.this.descriptionText.hasFocus()) {
                return;
            }
            if (!ProjectPanel.this.descriptionText.getText().equals(ProjectPanel.this.project.getDescription())) {
                ProjectPanel.this.descriptionText.setText(ProjectPanel.this.project.getDescription());
            }
        }
    };
    private final PropertyChangeListener topicListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ProjectPanel.this.topicCombo.hasFocus()) {
                return;
            }
            if (!Utils.equal((Object)ProjectPanel.this.project.getTopic(), (Object)ProjectPanel.this.topicCombo.getSelectedItem())) {
                ProjectPanel.this.topicCombo.setSelectedItem(ProjectPanel.this.project.getTopic());
            }
        }
    };
    private final PropertyChangeListener doneListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ProjectPanel.this.completedCheckBox.isSelected() != ProjectPanel.this.project.isDone()) {
                ProjectPanel.this.completedCheckBox.setSelected(ProjectPanel.this.project.isDone());
                ProjectPanel.this.completedDateField.setDate(ProjectPanel.this.project.getDoneDate());
                ProjectPanel.this.completedDateField.setEnabled(ProjectPanel.this.project.canSetDone(true));
            }
        }
    };
    private JLabel brainstormLabel;
    private JScrollPane brainstormScrollPane;
    private TextArea brainstormTextArea;
    private JCheckBox completedCheckBox;
    private DateField completedDateField;
    private DateField createdDateField;
    private JLabel createdDateLabel;
    private JLabel descriptionLabel;
    private JTextField descriptionText;
    private DateField dueDateField;
    private JLabel dueDateLabel;
    private HyperEditorPane notesEditorPane;
    private JLabel notesLabel;
    private JLabel organiseLabel;
    private JScrollPane organiseScrollPane;
    private TextArea organiseTextArea;
    private JComboBox priorityCombo;
    private JLabel priorityLabel;
    private JLabel purposeLabel;
    private JScrollPane purposeScrollPane;
    private TextArea purposeTextArea;
    private JCheckBox sequencingCheckBox;
    private JComboBox sequencingCombo;
    private JLabel sequencingLabel;
    private DateField startDateField;
    private JLabel startDateLabel;
    private JComboBox topicCombo;
    private JLabel topicLabel;
    private JLabel visionLabel;
    private JScrollPane visionScrollPane;
    private TextArea visionTextArea;
    private static final String DEFAULT_DESCRIPTION = "New Project";
    private Lookup.Result result;
    private Project project;
    private ComboBoxModel topicsModel;
    private boolean updating;
    private DocumentListener docListenerDescription;
    private DocumentListener docListenerPurpose;
    private DocumentListener docListenerVision;
    private DocumentListener docListenerBrainstorm;
    private DocumentListener docListenerOrganise;
    private DocumentListener docListenerNotes;
    private FocusAdapter focusAdapterDescription;
    private ActionListener actionListenerTopic;
    private ActionListener actionListenerPriorityCombo;
    private ActionListener actionListenerSequencingCombo;
    private ActionListener actionListenerSequencingCheckBox;
    private ActionListener actionListenerCompletedCheckBox;
    private PropertyChangeListener createdDatePropertyChangeListener;
    private PropertyChangeListener startDatePropertyChangeListener;
    private PropertyChangeListener dueDatePropertyChangeListener;
    private PropertyChangeListener completedDatePropertyChangeListener;
    private HyperlinkListener hyperlinkListener;
    private Observer observerCriterion;

    public ProjectPanel() {
        this.initComponents();
        this.initModel(null);
        this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ProjectPanel.this.dataChanged();
            }
        });
        this.dataChanged();
    }

    private void dataChanged() {
        Data data = this.getData();
        if (data == null) {
            return;
        }
        if (this.observerCriterion == null) {
            this.observerCriterion = new Observer(){

                public void update(Observable observable, Object arguement) {
                    ProjectPanel.this.showHideCriteria();
                }
            };
        }
        this.getData().getPriorityCriterion().addObserver(this.observerCriterion);
    }

    private Data getData() {
        return (Data)DataLookup.instance().lookup(Data.class);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    public void edit() {
        this.descriptionText.requestFocusInWindow();
    }

    private ComboBoxModel getPriorityComboBoxModel() {
        return new PriorityComboBoxModel();
    }

    private void descriptionTextFocusGained(FocusEvent evt) {
        if (this.descriptionText.getText().equals(DEFAULT_DESCRIPTION)) {
            this.descriptionText.setSelectionStart(0);
            this.descriptionText.setSelectionEnd(DEFAULT_DESCRIPTION.length());
        }
    }

    private void topicComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        JComboBox combo = (JComboBox)evt.getSource();
        this.project.setTopic((Topic)combo.getSelectedItem());
    }

    private void priorityComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setPriority((Value)this.priorityCombo.getSelectedItem());
    }

    private void sequencingComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setSequenceType((Sequencing)this.sequencingCombo.getSelectedItem());
    }

    private void sequencingCheckBoxActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setSequencing(this.sequencingCheckBox.isSelected());
        this.sequencingCombo.setEnabled(this.sequencingCheckBox.isSelected());
    }

    private void completedCheckBoxActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        if (this.completedCheckBox.isSelected() && !this.project.canSetDone(true)) {
            this.completedCheckBox.setSelected(false);
            String t = "";
            String m = "This project can not be set to \"done\" as it has actions or sub-projects that are not \"done\".";
            Frame p = WindowManager.getDefault().getMainWindow();
            JOptionPane.showMessageDialog(p, m, t, 2);
        } else {
            this.project.setDone(this.completedCheckBox.isSelected());
            this.completedDateField.setDate(this.project.getDoneDate());
        }
        this.completedDateField.setEnabled(this.project.isDone());
    }

    private void changedCreatedDate() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setCreated(this.createdDateField.getDate());
    }

    private void changedStartDate() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setStartDate(this.startDateField.getDate());
    }

    private void changedDueDate() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setDueDate(this.dueDateField.getDate());
    }

    private void changedCompletedDate() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setDoneDate(this.completedDateField.getDate());
    }

    private void notesEditorPaneHyperlinkAction(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (url == null) {
            return;
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Open.open((URL)url);
        }
    }

    private void addListeners() {
        this.docListenerDescription = new LazyDocumentListener(){

            public void update() {
                ProjectPanel.this.changedDescription();
            }
        };
        this.descriptionText.getDocument().addDocumentListener(this.docListenerDescription);
        this.actionListenerPriorityCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.priorityComboActionPerformed(evt);
            }
        };
        this.priorityCombo.addActionListener(this.actionListenerPriorityCombo);
        this.docListenerPurpose = new LazyDocumentListener(){

            public void update() {
                ProjectPanel.this.changedPurpose();
            }
        };
        this.purposeTextArea.getDocument().addDocumentListener(this.docListenerPurpose);
        this.docListenerBrainstorm = new LazyDocumentListener(){

            public void update() {
                ProjectPanel.this.changedBrainstorm();
            }
        };
        this.brainstormTextArea.getDocument().addDocumentListener(this.docListenerBrainstorm);
        this.docListenerOrganise = new LazyDocumentListener(){

            public void update() {
                ProjectPanel.this.changedOrganise();
            }
        };
        this.organiseTextArea.getDocument().addDocumentListener(this.docListenerOrganise);
        this.docListenerVision = new LazyDocumentListener(){

            public void update() {
                ProjectPanel.this.changedVision();
            }
        };
        this.visionTextArea.getDocument().addDocumentListener(this.docListenerVision);
        this.docListenerNotes = new LazyDocumentListener(){

            public void update() {
                ProjectPanel.this.changedNotes();
            }
        };
        this.notesEditorPane.addDocumentListener(this.docListenerNotes);
        this.focusAdapterDescription = new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ProjectPanel.this.descriptionTextFocusGained(evt);
            }
        };
        this.descriptionText.addFocusListener(this.focusAdapterDescription);
        this.actionListenerTopic = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.topicComboActionPerformed(evt);
            }
        };
        this.topicCombo.addActionListener(this.actionListenerTopic);
        this.actionListenerSequencingCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.sequencingComboActionPerformed(evt);
            }
        };
        this.sequencingCombo.addActionListener(this.actionListenerSequencingCombo);
        this.actionListenerSequencingCheckBox = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.sequencingCheckBoxActionPerformed(evt);
            }
        };
        this.sequencingCheckBox.addActionListener(this.actionListenerSequencingCheckBox);
        this.createdDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ProjectPanel.this.changedCreatedDate();
            }
        };
        this.createdDateField.addPropertyChangeListener("value", this.createdDatePropertyChangeListener);
        this.startDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ProjectPanel.this.changedStartDate();
            }
        };
        this.startDateField.addPropertyChangeListener("value", this.startDatePropertyChangeListener);
        this.dueDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ProjectPanel.this.changedDueDate();
            }
        };
        this.dueDateField.addPropertyChangeListener("value", this.dueDatePropertyChangeListener);
        this.actionListenerCompletedCheckBox = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.completedCheckBoxActionPerformed(evt);
            }
        };
        this.completedCheckBox.addActionListener(this.actionListenerCompletedCheckBox);
        this.completedDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ProjectPanel.this.changedCompletedDate();
            }
        };
        this.completedDateField.addPropertyChangeListener("value", this.completedDatePropertyChangeListener);
        this.hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                ProjectPanel.this.notesEditorPaneHyperlinkAction(evt);
            }
        };
        this.notesEditorPane.addHyperlinkListener(this.hyperlinkListener);
    }

    private void removeListeners() {
        this.descriptionText.getDocument().removeDocumentListener(this.docListenerDescription);
        this.purposeTextArea.getDocument().removeDocumentListener(this.docListenerPurpose);
        this.brainstormTextArea.getDocument().removeDocumentListener(this.docListenerBrainstorm);
        this.organiseTextArea.getDocument().removeDocumentListener(this.docListenerOrganise);
        this.visionTextArea.getDocument().removeDocumentListener(this.docListenerVision);
        this.notesEditorPane.removeDocumentListener(this.docListenerNotes);
        this.descriptionText.removeFocusListener(this.focusAdapterDescription);
        this.topicCombo.removeActionListener(this.actionListenerTopic);
        this.sequencingCombo.removeActionListener(this.actionListenerSequencingCombo);
        this.sequencingCheckBox.removeActionListener(this.actionListenerSequencingCheckBox);
        this.createdDateField.removePropertyChangeListener(this.createdDatePropertyChangeListener);
        this.createdDatePropertyChangeListener = null;
        this.startDateField.removePropertyChangeListener(this.startDatePropertyChangeListener);
        this.startDatePropertyChangeListener = null;
        this.dueDateField.removePropertyChangeListener(this.dueDatePropertyChangeListener);
        this.dueDatePropertyChangeListener = null;
        this.completedCheckBox.removeActionListener(this.actionListenerCompletedCheckBox);
        this.actionListenerSequencingCheckBox = null;
        this.completedDateField.removePropertyChangeListener(this.completedDatePropertyChangeListener);
        this.completedDatePropertyChangeListener = null;
        this.notesEditorPane.removeHyperlinkListener(this.hyperlinkListener);
        this.priorityCombo.removeActionListener(this.actionListenerPriorityCombo);
        this.docListenerDescription = null;
        this.docListenerPurpose = null;
        this.docListenerVision = null;
        this.docListenerBrainstorm = null;
        this.docListenerOrganise = null;
        this.docListenerNotes = null;
        this.focusAdapterDescription = null;
        this.actionListenerTopic = null;
        this.actionListenerSequencingCombo = null;
        this.actionListenerCompletedCheckBox = null;
        this.hyperlinkListener = null;
        this.actionListenerPriorityCombo = null;
    }

    public Project getModel() {
        return this.project;
    }

    public void initModel(Project project) {
        if (Utils.equal((Object)this.project, (Object)project)) {
            return;
        }
        if (this.project != null) {
            this.project.removePropertyChangeListenter("Done", this.doneListener);
            this.project.removePropertyChangeListenter("Descr", this.descrListener);
            this.project.removePropertyChangeListenter("Topic", this.topicListener);
        }
        this.project = project;
        if (this.project != null) {
            this.project.addPropertyChangeListenter("Done", this.doneListener);
            this.project.addPropertyChangeListenter("Descr", this.descrListener);
            this.project.addPropertyChangeListenter("Topic", this.topicListener);
        }
        this.initView();
    }

    private void initView() {
        this.updating = true;
        if (this.project == null) {
            this.descriptionText.setText("");
            this.topicCombo.setSelectedItem(null);
            this.priorityCombo.setSelectedItem(null);
            this.purposeTextArea.setText("");
            this.visionTextArea.setText("");
            this.brainstormTextArea.setText("");
            this.organiseTextArea.setText("");
            this.notesEditorPane.setText("");
            this.sequencingCheckBox.setSelected(false);
            this.sequencingCombo.setSelectedItem(null);
            this.startDateField.setDate(null);
            this.dueDateField.setDate(null);
            this.createdDateField.setDate(null);
            this.completedCheckBox.setSelected(false);
            this.completedDateField.setDate(null);
            this.setEnabled(false);
        } else {
            this.descriptionText.setText(this.project.getDescription());
            this.topicCombo.setSelectedItem(this.project.getTopic());
            this.priorityCombo.setSelectedItem(this.project.getPriority());
            this.purposeTextArea.setText(this.project.getPurpose());
            this.visionTextArea.setText(this.project.getVision());
            this.brainstormTextArea.setText(this.project.getBrainstorming());
            this.organiseTextArea.setText(this.project.getOrganising());
            this.notesEditorPane.setText(this.project.getNotes());
            boolean sequence = ProjectsPrefs.isSequencing();
            this.sequencingLabel.setVisible(sequence);
            this.sequencingCheckBox.setVisible(sequence);
            this.sequencingCombo.setVisible(sequence);
            this.sequencingCheckBox.setSelected(this.project.isSequencing());
            this.sequencingCombo.setSelectedItem(this.project.getSequenceType());
            this.startDateField.setDate(this.project.getStartDate());
            this.dueDateField.setDate(this.project.getDueDate());
            this.createdDateField.setDate(this.project.getCreated());
            this.completedCheckBox.setSelected(this.project.isDone());
            this.completedDateField.setDate(this.project.getDoneDate());
            this.setEnabled(true);
        }
        this.updating = false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.descriptionLabel.setEnabled(enabled);
        this.descriptionText.setEnabled(enabled);
        this.topicLabel.setEnabled(enabled);
        this.topicCombo.setEnabled(enabled);
        this.purposeLabel.setEnabled(enabled);
        this.purposeTextArea.setEnabled(enabled);
        this.visionLabel.setEnabled(enabled);
        this.visionTextArea.setEnabled(enabled);
        this.brainstormLabel.setEnabled(enabled);
        this.brainstormTextArea.setEnabled(enabled);
        this.organiseLabel.setEnabled(enabled);
        this.organiseTextArea.setEnabled(enabled);
        this.notesLabel.setEnabled(enabled);
        this.notesEditorPane.setEnabled(enabled);
        this.notesEditorPane.setEditable(false);
        this.sequencingLabel.setEnabled(enabled);
        this.sequencingCheckBox.setEnabled(enabled);
        this.sequencingCombo.setEnabled(enabled && this.project.isSequencing());
        this.createdDateLabel.setEnabled(enabled);
        this.createdDateField.setEnabled(enabled && ProjectsPrefs.isEditCreateDate());
        this.startDateLabel.setEnabled(enabled);
        this.startDateField.setEnabled(enabled);
        this.startDateLabel.setVisible(ProjectsPrefs.isIncludeStartDate());
        this.startDateField.setVisible(ProjectsPrefs.isIncludeStartDate());
        this.dueDateLabel.setEnabled(enabled);
        this.dueDateField.setEnabled(enabled);
        this.dueDateLabel.setVisible(ProjectsPrefs.isIncludeDueDate());
        this.dueDateField.setVisible(ProjectsPrefs.isIncludeDueDate());
        this.completedCheckBox.setEnabled(enabled);
        this.completedDateField.setEnabled(enabled && this.project.canSetDone(true));
        this.priorityLabel.setEnabled(enabled);
        this.priorityCombo.setEnabled(enabled);
        this.showHideCriteria();
    }

    private void showHideCriteria() {
        Data data = this.getData();
        this.priorityLabel.setVisible(data.getPriorityCriterion().use);
        this.priorityCombo.setVisible(data.getPriorityCriterion().use);
    }

    public void focus() {
        this.descriptionText.requestFocus();
    }

    private void changedDescription() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setDescription(this.descriptionText.getText());
    }

    private void changedPurpose() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setPurpose(this.purposeTextArea.getText());
    }

    private void changedVision() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setVision(this.visionTextArea.getText());
    }

    private void changedBrainstorm() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setBrainstorming(this.brainstormTextArea.getText());
    }

    private void changedOrganise() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setOrganising(this.organiseTextArea.getText());
    }

    private void changedNotes() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setNotes(this.notesEditorPane.getText());
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.descriptionText = new JTextField();
        this.topicLabel = new JLabel();
        this.topicsModel = new TopicsComboBoxModel(false);
        this.topicCombo = new TopicsComboBox(this.topicsModel);
        this.priorityLabel = new JLabel();
        this.priorityCombo = new JComboBox();
        this.purposeLabel = new JLabel();
        this.purposeScrollPane = new JScrollPane();
        this.purposeTextArea = new TextArea();
        this.visionLabel = new JLabel();
        this.visionScrollPane = new JScrollPane();
        this.visionTextArea = new TextArea();
        this.brainstormLabel = new JLabel();
        this.brainstormScrollPane = new JScrollPane();
        this.brainstormTextArea = new TextArea();
        this.organiseLabel = new JLabel();
        this.organiseScrollPane = new JScrollPane();
        this.organiseTextArea = new TextArea();
        this.notesLabel = new JLabel();
        this.notesEditorPane = new HyperEditorPane();
        this.sequencingLabel = new JLabel();
        this.sequencingCheckBox = new JCheckBox();
        this.sequencingCombo = new JComboBox();
        this.createdDateLabel = new JLabel();
        this.startDateLabel = new JLabel();
        this.dueDateLabel = new JLabel();
        this.completedCheckBox = new JCheckBox();
        this.createdDateField = new DateField();
        this.startDateField = new DateField();
        this.dueDateField = new DateField();
        this.completedDateField = new DateField();
        this.descriptionLabel.setHorizontalAlignment(11);
        this.descriptionLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.description"));
        this.descriptionLabel.setMaximumSize(new Dimension(96, 16));
        this.descriptionLabel.setMinimumSize(new Dimension(96, 16));
        this.descriptionLabel.setPreferredSize(new Dimension(96, 16));
        this.topicLabel.setHorizontalAlignment(11);
        this.topicLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.topic"));
        this.topicLabel.setMaximumSize(new Dimension(96, 16));
        this.topicLabel.setMinimumSize(new Dimension(96, 16));
        this.topicLabel.setPreferredSize(new Dimension(96, 16));
        this.priorityLabel.setHorizontalAlignment(11);
        this.priorityLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Priority"));
        this.priorityLabel.setFocusable(false);
        this.priorityLabel.setMaximumSize(new Dimension(96, 16));
        this.priorityLabel.setMinimumSize(new Dimension(96, 16));
        this.priorityLabel.setPreferredSize(new Dimension(96, 16));
        this.priorityCombo.setModel(this.getPriorityComboBoxModel());
        this.purposeLabel.setHorizontalAlignment(11);
        this.purposeLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.purpose"));
        this.purposeLabel.setMaximumSize(new Dimension(96, 16));
        this.purposeLabel.setMinimumSize(new Dimension(96, 16));
        this.purposeLabel.setPreferredSize(new Dimension(96, 16));
        this.purposeTextArea.setColumns(20);
        this.purposeTextArea.setRows(1);
        this.purposeScrollPane.setViewportView((Component)this.purposeTextArea);
        this.visionLabel.setHorizontalAlignment(11);
        this.visionLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.vision"));
        this.visionLabel.setMaximumSize(new Dimension(96, 16));
        this.visionLabel.setMinimumSize(new Dimension(96, 16));
        this.visionLabel.setPreferredSize(new Dimension(96, 16));
        this.visionTextArea.setColumns(20);
        this.visionTextArea.setRows(1);
        this.visionScrollPane.setViewportView((Component)this.visionTextArea);
        this.brainstormLabel.setHorizontalAlignment(11);
        this.brainstormLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.brainstorming"));
        this.brainstormLabel.setMaximumSize(new Dimension(96, 16));
        this.brainstormLabel.setMinimumSize(new Dimension(96, 16));
        this.brainstormLabel.setPreferredSize(new Dimension(96, 16));
        this.brainstormTextArea.setColumns(20);
        this.brainstormTextArea.setRows(1);
        this.brainstormScrollPane.setViewportView((Component)this.brainstormTextArea);
        this.organiseLabel.setHorizontalAlignment(11);
        this.organiseLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.organising"));
        this.organiseLabel.setMaximumSize(new Dimension(96, 16));
        this.organiseLabel.setMinimumSize(new Dimension(96, 16));
        this.organiseLabel.setPreferredSize(new Dimension(96, 16));
        this.organiseTextArea.setColumns(20);
        this.organiseTextArea.setRows(1);
        this.organiseScrollPane.setViewportView((Component)this.organiseTextArea);
        this.notesLabel.setHorizontalAlignment(11);
        this.notesLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.notes"));
        this.notesLabel.setMaximumSize(new Dimension(96, 16));
        this.notesLabel.setMinimumSize(new Dimension(96, 16));
        this.notesLabel.setPreferredSize(new Dimension(96, 16));
        this.sequencingLabel.setHorizontalAlignment(11);
        this.sequencingLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.sequencing"));
        this.sequencingLabel.setMaximumSize(new Dimension(96, 16));
        this.sequencingLabel.setMinimumSize(new Dimension(96, 16));
        this.sequencingLabel.setPreferredSize(new Dimension(96, 16));
        this.sequencingCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.sequencingCombo.setModel(new SequencingModel());
        this.createdDateLabel.setHorizontalAlignment(11);
        this.createdDateLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.created"));
        this.createdDateLabel.setMaximumSize(new Dimension(96, 23));
        this.createdDateLabel.setMinimumSize(new Dimension(96, 23));
        this.createdDateLabel.setPreferredSize(new Dimension(96, 23));
        this.startDateLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.start"));
        this.startDateLabel.setMaximumSize(new Dimension(29, 23));
        this.startDateLabel.setMinimumSize(new Dimension(29, 23));
        this.startDateLabel.setPreferredSize(new Dimension(29, 23));
        this.dueDateLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.due"));
        this.dueDateLabel.setMaximumSize(new Dimension(25, 23));
        this.dueDateLabel.setMinimumSize(new Dimension(25, 23));
        this.dueDateLabel.setPreferredSize(new Dimension(25, 23));
        this.completedCheckBox.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.completed"));
        this.completedCheckBox.setHorizontalTextPosition(10);
        this.completedCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.completedCheckBox.setMaximumSize(new Dimension(90, 23));
        this.completedCheckBox.setMinimumSize(new Dimension(90, 23));
        this.completedCheckBox.setPreferredSize(new Dimension(90, 23));
        this.createdDateField.setMinimumSize(new Dimension(120, 23));
        this.createdDateField.setPreferredSize(new Dimension(120, 23));
        this.startDateField.setMinimumSize(new Dimension(120, 23));
        this.startDateField.setPreferredSize(new Dimension(120, 23));
        this.dueDateField.setMinimumSize(new Dimension(120, 23));
        this.dueDateField.setPreferredSize(new Dimension(120, 23));
        this.completedDateField.setMinimumSize(new Dimension(120, 23));
        this.completedDateField.setPreferredSize(new Dimension(120, 23));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.descriptionLabel, -1, 96, Short.MAX_VALUE).add((Component)this.topicLabel, -2, 96, -2).add((Component)this.priorityLabel, -2, 96, -2).add((Component)this.purposeLabel, -1, 96, Short.MAX_VALUE).add((Component)this.visionLabel, -1, 96, Short.MAX_VALUE).add((Component)this.brainstormLabel, -1, 96, Short.MAX_VALUE).add((Component)this.organiseLabel, -1, 96, Short.MAX_VALUE).add((Component)this.sequencingLabel, -1, 96, Short.MAX_VALUE).add((Component)this.createdDateLabel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.notesLabel, -1, 96, Short.MAX_VALUE).addPreferredGap(0))).add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.notesEditorPane, -1, 674, Short.MAX_VALUE).add(1, (Component)this.purposeScrollPane, -1, 674, Short.MAX_VALUE).add(1, (Component)this.visionScrollPane, -1, 674, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(2, 2, 2).add((Component)this.createdDateField, -2, -1, -2).addPreferredGap(0).add((Component)this.startDateLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.startDateField, -2, -1, -2).addPreferredGap(0).add((Component)this.dueDateLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.dueDateField, -2, -1, -2).add(13, 13, 13).add((Component)this.completedCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.completedDateField, -2, -1, -2)).add(1, (Component)this.topicCombo, -2, 254, -2).add(1, (Component)this.brainstormScrollPane, -1, 674, Short.MAX_VALUE).add(1, (Component)this.organiseScrollPane, -1, 674, Short.MAX_VALUE).add(1, (Component)this.priorityCombo, -2, 150, -2).add((Component)this.descriptionText, -1, 674, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.sequencingCheckBox).addPreferredGap(0).add((Component)this.sequencingCombo, -2, 171, -2))).addContainerGap()));
        layout.linkSize(new Component[]{this.brainstormLabel, this.createdDateLabel, this.descriptionLabel, this.notesLabel, this.organiseLabel, this.priorityLabel, this.purposeLabel, this.sequencingLabel, this.topicLabel, this.visionLabel}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.descriptionText, -2, 22, -2).add((Component)this.descriptionLabel, -2, 22, -2)).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.topicCombo, -2, -1, -2).add((Component)this.topicLabel, -2, 22, -2)).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.priorityCombo, -2, -1, -2).add((Component)this.priorityLabel, -2, 22, -2)).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.purposeScrollPane, -1, 23, Short.MAX_VALUE).add(4, 4, 4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.purposeLabel, -2, -1, -2).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.visionScrollPane, -1, 23, Short.MAX_VALUE).add(4, 4, 4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.visionLabel, -2, -1, -2).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.brainstormScrollPane, -1, 23, Short.MAX_VALUE).add(4, 4, 4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.brainstormLabel, -2, -1, -2).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.organiseScrollPane, -1, 23, Short.MAX_VALUE).add(4, 4, 4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.organiseLabel, -2, -1, -2).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(29, 29, 29).add((Component)this.notesLabel, -2, -1, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.notesEditorPane, -1, -1, Short.MAX_VALUE))).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.sequencingCheckBox, -2, 22, -2).add((Component)this.sequencingLabel, -2, 22, -2).add((Component)this.sequencingCombo, -2, -1, -2)).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.createdDateLabel, -2, -1, -2).add((Component)this.createdDateField, -2, -1, -2).add((Component)this.startDateField, -2, -1, -2).add(1, (Component)this.dueDateLabel, -2, -1, -2).add(1, (Component)this.dueDateField, -2, -1, -2).add(1, (Component)this.completedCheckBox, -2, -1, -2).add((Component)this.startDateLabel, -2, -1, -2)).add((Component)this.completedDateField, -2, -1, -2)).addContainerGap()));
    }
}

