/*
 * Decompiled with CFR 0.152.
 */
package tr.data.files;

import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openide.awt.Actions;
import org.openide.util.actions.SystemAction;
import tr.data.files.Prefs;
import tr.data.files.RecentDataFileOpenAction;
import tr.data.files.RecentDataFilesClearAction;

public class RecentDataFileMenu
extends Actions.MenuItem {
    private JComponent[] presenters;

    public RecentDataFileMenu() {
        super((Action)new FakeAction(), false);
    }

    public JComponent[] getMenuPresenters() {
        if (this.presenters == null) {
            this.initialise();
        }
        return this.presenters;
    }

    public JComponent[] synchMenuPresenters(JComponent[] items) {
        return this.getMenuPresenters();
    }

    void initialise() {
        Vector<String> paths = Prefs.getPaths();
        if (paths == null || paths.size() == 0) {
            JMenuItem menuItem = new JMenuItem("Open Recent");
            menuItem.setEnabled(false);
            this.presenters = new JComponent[]{menuItem};
        } else {
            JMenu menu = new JMenu("Open Recent");
            for (String path : paths) {
                menu.add(new RecentDataFileOpenAction(path));
            }
            menu.add(new JSeparator());
            menu.add((Action)SystemAction.get(RecentDataFilesClearAction.class));
            this.presenters = new JComponent[]{menu};
        }
    }

    private static class FakeAction
    extends AbstractAction {
        private FakeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

