/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.multiview.Accessor;
import org.netbeans.core.multiview.GetLeftEditorAction;
import org.netbeans.core.multiview.GetRightEditorAction;
import org.netbeans.core.multiview.MultiViewActionMap;
import org.netbeans.core.multiview.MultiViewHandlerDelegate;
import org.netbeans.core.multiview.MultiViewModel;
import org.netbeans.core.multiview.MultiViewTopComponent;
import org.netbeans.core.multiview.MultiViewTopComponentLookup;
import org.netbeans.core.multiview.SpiAccessor;
import org.netbeans.core.multiview.TabsComponent;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiViewPeer {
    static final String MULTIVIEW_ID = "MultiView-";
    MultiViewModel model;
    TabsComponent tabs;
    SelectionListener selListener = new SelectionListener();
    CloseOperationHandler closeHandler;
    transient MultiViewTopComponentLookup lookup;
    TopComponent peer;
    private MultiViewModel.ActionRequestObserverFactory factory;
    private MultiViewActionMap delegatingMap;
    private boolean activated = false;
    private Object editorSettingsListener;
    private DelegateUndoRedo delegateUndoRedo;

    public MultiViewPeer(TopComponent topComponent, MultiViewModel.ActionRequestObserverFactory actionRequestObserverFactory) {
        this.peer = topComponent;
        this.factory = actionRequestObserverFactory;
        this.editorSettingsListener = this.createEditorListener();
        this.delegateUndoRedo = new DelegateUndoRedo();
    }

    public void setMultiViewDescriptions(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription) {
        if (this.model != null) {
            this.model.removeElementSelectionListener(this.selListener);
        }
        this.model = new MultiViewModel(multiViewDescriptionArray, multiViewDescription, this.factory);
        this.model.addElementSelectionListener(this.selListener);
        this.tabs.setModel(this.model);
    }

    public void setCloseOperationHandler(CloseOperationHandler closeOperationHandler) {
        this.closeHandler = closeOperationHandler;
    }

    void setDeserializedMultiViewDescriptions(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription, Map<MultiViewDescription, MultiViewElement> map) {
        if (this.model != null) {
            this.model.removeElementSelectionListener(this.selListener);
        }
        this.model = new MultiViewModel(multiViewDescriptionArray, multiViewDescription, this.factory, map);
        this.model.addElementSelectionListener(this.selListener);
        this.tabs.setModel(this.model);
    }

    MultiViewModel getModel() {
        return this.model;
    }

    void initComponents() {
        this.initActionMap();
        this.peer.setLayout((LayoutManager)new BorderLayout());
        this.tabs = new TabsComponent(this.isToolbarVisible());
        this.peer.add((Component)this.tabs);
        ActionMap actionMap = this.peer.getActionMap();
        AccessTogglesAction accessTogglesAction = new AccessTogglesAction();
        actionMap.put("NextViewAction", new GetRightEditorAction());
        actionMap.put("PreviousViewAction", new GetLeftEditorAction());
        actionMap.put("accesstoggles", accessTogglesAction);
        InputMap inputMap = this.peer.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke("control F10");
        inputMap.put(keyStroke, "accesstoggles");
        inputMap = this.peer.getInputMap(0);
        inputMap.put(keyStroke, "accesstoggles");
        this.peer.putClientProperty((Object)"MultiViewBorderHack.topOffset", (Object)new Integer(this.tabs.getPreferredSize().height - 1));
    }

    private void initActionMap() {
        this.delegatingMap = new MultiViewActionMap(this.peer, new ActionMap());
        if (this.peer instanceof TopComponent.Cloneable) {
            this.delegatingMap.put("cloneWindow", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TopComponent topComponent = ((TopComponent.Cloneable)MultiViewPeer.this.peer).cloneComponent();
                    topComponent.open();
                    topComponent.requestActive();
                }
            });
        }
        this.delegatingMap.put("closeWindow", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiViewPeer.this.peer.close();
            }
        });
        this.peer.setActionMap((ActionMap)this.delegatingMap);
    }

    void peerComponentClosed() {
        for (MultiViewElement multiViewElement : this.model.getCreatedElements()) {
            this.model.markAsHidden(multiViewElement);
            multiViewElement.componentClosed();
        }
        this.tabs.peerComponentClosed();
    }

    void peerComponentShowing() {
        MultiViewElement multiViewElement = this.model.getActiveElement();
        multiViewElement.componentShowing();
        this.delegatingMap.setDelegateMap(multiViewElement.getVisualRepresentation().getActionMap());
        ((MultiViewTopComponentLookup)this.peer.getLookup()).setElementLookup(multiViewElement.getLookup());
        JComponent jComponent = multiViewElement.getToolbarRepresentation();
        assert (jComponent != null) : "MultiViewElement " + multiViewElement.getClass() + " returns null as toolbar component.";
        jComponent.setOpaque(false);
        this.tabs.setInnerToolBar(jComponent);
        this.tabs.setToolbarBarVisible(this.isToolbarVisible());
        if (this.editorSettingsListener != null) {
            this.addEditorListener(this.editorSettingsListener);
        }
    }

    void peerComponentHidden() {
        this.model.getActiveElement().componentHidden();
        if (this.editorSettingsListener != null) {
            this.removeEditorListener(this.editorSettingsListener);
        }
    }

    void peerComponentDeactivated() {
        this.activated = false;
        this.model.getActiveElement().componentDeactivated();
    }

    boolean isActivated() {
        return this.activated;
    }

    void peerComponentActivated() {
        this.activated = true;
        this.model.getActiveElement().componentActivated();
    }

    void peerComponentOpened() {
        this.showCurrentElement(true);
        this.tabs.setToolbarBarVisible(this.isToolbarVisible());
    }

    boolean requestFocusInWindow() {
        if (this.model == null) {
            return false;
        }
        return this.model.getActiveElement().getVisualRepresentation().requestFocusInWindow();
    }

    void requestFocus() {
        if (this.model != null) {
            this.model.getActiveElement().getVisualRepresentation().requestFocus();
        }
    }

    void hideElement(MultiViewDescription multiViewDescription) {
        if (multiViewDescription != null) {
            MultiViewElement multiViewElement = this.model.getElementForDescription(multiViewDescription);
            multiViewElement.componentHidden();
        }
    }

    void showCurrentElement() {
        this.showCurrentElement(false);
    }

    private void showCurrentElement(boolean bl) {
        MultiViewElement multiViewElement = this.model.getActiveElement();
        MultiViewDescription multiViewDescription = this.model.getActiveDescription();
        this.tabs.switchToCard(multiViewElement, multiViewDescription.getDisplayName());
        this.peer.setIcon(multiViewDescription.getIcon());
        if ((this.peer.isOpened() || bl) && !this.model.wasShownBefore(multiViewElement)) {
            multiViewElement.componentOpened();
            this.model.markAsShown(multiViewElement);
        }
        if (!bl) {
            if (this.peer.isVisible()) {
                multiViewElement.componentShowing();
            }
            this.delegatingMap.setDelegateMap(multiViewElement.getVisualRepresentation().getActionMap());
            ((MultiViewTopComponentLookup)this.peer.getLookup()).setElementLookup(multiViewElement.getLookup());
            if (this.peer.isVisible()) {
                this.tabs.setInnerToolBar(multiViewElement.getToolbarRepresentation());
                this.tabs.setToolbarBarVisible(this.isToolbarVisible());
            }
        }
    }

    Action[] peerGetActions(Action[] actionArray) {
        Action[] actionArray2 = this.model.getActiveElement().getActions();
        block0: for (int i = 0; i < actionArray2.length; ++i) {
            Action action = actionArray2[i];
            for (int j = 0; j < actionArray.length; ++j) {
                Action action2 = actionArray[j];
                if (action2 == null || action == null || !action2.getClass().equals(action.getClass())) continue;
                actionArray2[i] = actionArray[j];
                continue block0;
            }
        }
        return actionArray2;
    }

    MultiViewHandlerDelegate getMultiViewHandlerDelegate() {
        return new MVTCHandler();
    }

    int getPersistenceType() {
        MultiViewDescription[] multiViewDescriptionArray = this.model.getDescriptions();
        int n = 2;
        for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
            if (!(multiViewDescriptionArray[i] instanceof Serializable)) {
                Logger.getLogger(MultiViewTopComponent.class.getName()).warning("The MultiviewDescription instance " + multiViewDescriptionArray[i].getClass() + " is not serializable. Cannot persist TopComponent.");
                n = 2;
                break;
            }
            if (multiViewDescriptionArray[i].getPersistenceType() == 0) {
                n = multiViewDescriptionArray[i].getPersistenceType();
            }
            if (multiViewDescriptionArray[i].getPersistenceType() != 1 || n == 0) continue;
            n = multiViewDescriptionArray[i].getPersistenceType();
        }
        return n;
    }

    String preferredID() {
        StringBuffer stringBuffer = new StringBuffer(MULTIVIEW_ID);
        assert (this.model != null) : "Multiview Model not set, error on deserialization of client code. Please add comment to issue #121119 at netbeans.org and attach the ~/.netbeans/var/log/messages.log file";
        MultiViewDescription[] multiViewDescriptionArray = this.model.getDescriptions();
        for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
            stringBuffer.append(multiViewDescriptionArray[i].preferredID());
            stringBuffer.append("|");
        }
        return stringBuffer.toString();
    }

    void peerWriteExternal(ObjectOutput objectOutput) throws IOException {
        if (this.closeHandler != null) {
            if (this.closeHandler instanceof Serializable) {
                objectOutput.writeObject(this.closeHandler);
            } else {
                Logger.getAnonymousLogger().info("The CloseOperationHandler isn not serializable. MultiView component id=" + this.preferredID());
            }
        }
        MultiViewDescription[] multiViewDescriptionArray = this.model.getDescriptions();
        MultiViewDescription multiViewDescription = this.model.getActiveDescription();
        int n = 0;
        for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
            MultiViewElement multiViewElement;
            objectOutput.writeObject(multiViewDescriptionArray[i]);
            if (multiViewDescriptionArray[i].getPersistenceType() != 2 && (multiViewElement = this.model.getElementForDescription(multiViewDescriptionArray[i], false)) != null && multiViewElement instanceof Serializable) {
                objectOutput.writeObject(multiViewElement);
            }
            if (multiViewDescriptionArray[i] != multiViewDescription) continue;
            n = i;
        }
        objectOutput.writeObject(new Integer(n));
    }

    void peerReadExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object;
        MultiViewDescription[] multiViewDescriptionArray;
        ArrayList<MultiViewDescription> arrayList = new ArrayList<MultiViewDescription>();
        HashMap<MultiViewDescription, MultiViewElement> hashMap = new HashMap<MultiViewDescription, MultiViewElement>();
        int n = 0;
        CloseOperationHandler closeOperationHandler = null;
        try {
            while (true) {
                if ((multiViewDescriptionArray = objectInput.readObject()) instanceof MultiViewDescription) {
                    arrayList.add((MultiViewDescription)multiViewDescriptionArray);
                } else if (multiViewDescriptionArray instanceof MultiViewElement) {
                    hashMap.put((MultiViewDescription)arrayList.get(arrayList.size() - 1), (MultiViewElement)multiViewDescriptionArray);
                } else if (multiViewDescriptionArray instanceof Integer) {
                    object = (Integer)multiViewDescriptionArray;
                    n = (Integer)object;
                    break;
                }
                if (!(multiViewDescriptionArray instanceof CloseOperationHandler)) continue;
                closeOperationHandler = (CloseOperationHandler)multiViewDescriptionArray;
            }
        }
        catch (IOException iOException) {
            if (closeOperationHandler == null) {
                closeOperationHandler = SpiAccessor.DEFAULT.createDefaultCloseHandler();
            }
            this.setCloseOperationHandler(closeOperationHandler);
            if (arrayList.size() > 0) {
                MultiViewDescription[] multiViewDescriptionArray2 = new MultiViewDescription[arrayList.size()];
                multiViewDescriptionArray2 = arrayList.toArray(multiViewDescriptionArray2);
                MultiViewDescription multiViewDescription = multiViewDescriptionArray2[0];
                hashMap.clear();
                this.setDeserializedMultiViewDescriptions(multiViewDescriptionArray2, multiViewDescription, hashMap);
            }
            throw iOException;
        }
        if (closeOperationHandler == null) {
            closeOperationHandler = SpiAccessor.DEFAULT.createDefaultCloseHandler();
        }
        this.setCloseOperationHandler(closeOperationHandler);
        multiViewDescriptionArray = new MultiViewDescription[arrayList.size()];
        multiViewDescriptionArray = arrayList.toArray(multiViewDescriptionArray);
        object = multiViewDescriptionArray[n];
        this.setDeserializedMultiViewDescriptions(multiViewDescriptionArray, (MultiViewDescription)object, hashMap);
    }

    private Action[] getDefaultTCActions() {
        if (this.peer instanceof MultiViewTopComponent) {
            return ((MultiViewTopComponent)this.peer).getDefaultTCActions();
        }
        return new Action[0];
    }

    JEditorPane getEditorPane() {
        MultiViewElement multiViewElement;
        if (this.model != null && (multiViewElement = this.model.getActiveElement()) != null && multiViewElement.getVisualRepresentation() instanceof CloneableEditorSupport.Pane) {
            CloneableEditorSupport.Pane pane = (CloneableEditorSupport.Pane)multiViewElement.getVisualRepresentation();
            return pane.getEditorPane();
        }
        return null;
    }

    HelpCtx getHelpCtx() {
        return this.model.getActiveDescription().getHelpCtx();
    }

    UndoRedo peerGetUndoRedo() {
        return this.delegateUndoRedo;
    }

    private UndoRedo privateGetUndoRedo() {
        return this.model.getActiveElement().getUndoRedo() != null ? this.model.getActiveElement().getUndoRedo() : UndoRedo.NONE;
    }

    boolean canClose() {
        CloseOperationState[] closeOperationStateArray;
        Collection collection = this.model.getCreatedElements();
        Iterator iterator = collection.iterator();
        ArrayList<CloseOperationState> arrayList = new ArrayList<CloseOperationState>();
        while (iterator.hasNext()) {
            closeOperationStateArray = (CloseOperationState[])iterator.next();
            CloseOperationState closeOperationState = closeOperationStateArray.canCloseElement();
            if (closeOperationState.canClose()) continue;
            arrayList.add(closeOperationState);
        }
        if (arrayList.size() > 0) {
            closeOperationStateArray = new CloseOperationState[arrayList.size()];
            closeOperationStateArray = arrayList.toArray(closeOperationStateArray);
            return this.closeHandler.resolveCloseOperation(closeOperationStateArray);
        }
        return true;
    }

    public void updateName() {
        MultiViewElement multiViewElement;
        if (this.model != null && (multiViewElement = this.model.getActiveElement()).getVisualRepresentation() instanceof CloneableEditorSupport.Pane) {
            CloneableEditorSupport.Pane pane = (CloneableEditorSupport.Pane)multiViewElement.getVisualRepresentation();
            pane.updateName();
            this.peer.setDisplayName(pane.getComponent().getDisplayName());
        }
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new MultiViewTopComponentLookup(this.delegatingMap);
        }
        return this.lookup;
    }

    void addEditorListener(Object object) {
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clazz = Class.forName("org.netbeans.editor.Settings", false, classLoader);
            Class<?> clazz2 = Class.forName("org.netbeans.editor.SettingsChangeListener", false, classLoader);
            Method method = clazz.getMethod("addSettingsChangeListener", clazz2);
            method.invoke(clazz, object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    void removeEditorListener(Object object) {
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clazz = Class.forName("org.netbeans.editor.Settings", false, classLoader);
            Class<?> clazz2 = Class.forName("org.netbeans.editor.SettingsChangeListener", false, classLoader);
            Method method = clazz.getMethod("removeSettingsChangeListener", clazz2);
            method.invoke(clazz, object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    Object createEditorListener() {
        try {
            Class<?> clazz;
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            try {
                clazz = Class.forName("org.netbeans.editor.SettingsChangeListener", false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(MultiViewPeer.class.getName()).log(Level.CONFIG, "Disabling interaction with editor/lib", classNotFoundException);
                return null;
            }
            InvocationHandler invocationHandler = new InvocationHandler(){

                public Object invoke(Object object, Method method, Object[] objectArray) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MultiViewPeer.this.tabs.setToolbarBarVisible(MultiViewPeer.this.isToolbarVisible());
                        }
                    });
                    return null;
                }
            };
            return Proxy.newProxyInstance(classLoader, new Class[]{clazz}, invocationHandler);
        }
        catch (Throwable throwable) {
            Logger.getLogger(MultiViewPeer.class.getName()).log(Level.WARNING, null, throwable);
            return null;
        }
    }

    boolean isToolbarVisible() {
        GenericDeclaration genericDeclaration;
        Action action;
        JEditorPane jEditorPane = this.getEditorPane();
        if (jEditorPane != null) {
            action = jEditorPane.getActionMap().get("toggle-toolbar");
            if (action == null) {
                return true;
            }
        } else {
            return true;
        }
        action = null;
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            MultiViewPeer.class.getClassLoader();
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            genericDeclaration = Class.forName("org.netbeans.modules.editor.options.BaseOptions", true, classLoader);
            action = SharedClassObject.findObject(genericDeclaration);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        if (action != null) {
            try {
                genericDeclaration = action.getClass().getMethod("isToolbarVisible", new Class[0]);
                Object object = ((Method)genericDeclaration).invoke(action, new Object[0]);
                if (object instanceof Boolean) {
                    return (Boolean)object;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return true;
    }

    public String toString() {
        return "[model=" + this.model + "]";
    }

    private class AccessTogglesAction
    extends AbstractAction {
        AccessTogglesAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control F10"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MultiViewPeer.this.tabs.requestFocusForSelectedButton();
        }
    }

    private class DelegateUndoRedo
    implements UndoRedo {
        private List listeners = new ArrayList();

        private DelegateUndoRedo() {
        }

        public boolean canUndo() {
            return MultiViewPeer.this.privateGetUndoRedo().canUndo();
        }

        public boolean canRedo() {
            return MultiViewPeer.this.privateGetUndoRedo().canRedo();
        }

        public void undo() throws CannotUndoException {
            MultiViewPeer.this.privateGetUndoRedo().undo();
        }

        public void redo() throws CannotRedoException {
            MultiViewPeer.this.privateGetUndoRedo().redo();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
            MultiViewPeer.this.privateGetUndoRedo().addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
            MultiViewPeer.this.privateGetUndoRedo().removeChangeListener(changeListener);
        }

        public String getUndoPresentationName() {
            return MultiViewPeer.this.privateGetUndoRedo().getUndoPresentationName();
        }

        public String getRedoPresentationName() {
            return MultiViewPeer.this.privateGetUndoRedo().getRedoPresentationName();
        }

        private void fireElementChange() {
            for (ChangeListener changeListener : new ArrayList(this.listeners)) {
                ChangeEvent changeEvent = new ChangeEvent(this);
                changeListener.stateChanged(changeEvent);
            }
        }

        void updateListeners(MultiViewElement multiViewElement, MultiViewElement multiViewElement2) {
            for (ChangeListener changeListener : this.listeners) {
                if (multiViewElement.getUndoRedo() != null) {
                    multiViewElement.getUndoRedo().removeChangeListener(changeListener);
                }
                if (multiViewElement2.getUndoRedo() == null) continue;
                multiViewElement2.getUndoRedo().addChangeListener(changeListener);
            }
            this.fireElementChange();
        }
    }

    private class MVTCHandler
    implements MultiViewHandlerDelegate {
        private MultiViewPerspective[] perspectives = null;

        private MVTCHandler() {
        }

        public MultiViewPerspective[] getDescriptions() {
            return MultiViewPeer.this.model.getPerspectives();
        }

        public MultiViewPerspective getSelectedDescription() {
            return MultiViewPeer.this.model.getSelectedPerspective();
        }

        public void requestActive(MultiViewPerspective multiViewPerspective) {
            MultiViewDescription multiViewDescription = Accessor.DEFAULT.extractDescription(multiViewPerspective);
            if (MultiViewPeer.this.model.getActiveDescription() != multiViewDescription) {
                MultiViewPeer.this.tabs.changeActiveManually(multiViewDescription);
                MultiViewPeer.this.model.getActiveElement().componentActivated();
            }
        }

        public void requestVisible(MultiViewPerspective multiViewPerspective) {
            MultiViewDescription multiViewDescription = Accessor.DEFAULT.extractDescription(multiViewPerspective);
            MultiViewPeer.this.tabs.changeVisibleManually(multiViewDescription);
        }
    }

    private class SelectionListener
    implements MultiViewModel.ElementSelectionListener {
        private SelectionListener() {
        }

        public void selectionChanged(MultiViewDescription multiViewDescription, MultiViewDescription multiViewDescription2) {
            if (MultiViewPeer.this.isActivated()) {
                MultiViewElement multiViewElement = MultiViewPeer.this.model.getElementForDescription(multiViewDescription);
                multiViewElement.componentDeactivated();
            }
            MultiViewPeer.this.hideElement(multiViewDescription);
            MultiViewPeer.this.showCurrentElement();
            MultiViewPeer.this.delegateUndoRedo.updateListeners(MultiViewPeer.this.model.getElementForDescription(multiViewDescription), MultiViewPeer.this.model.getElementForDescription(multiViewDescription2));
        }

        public void selectionActivatedByButton() {
            MultiViewElement multiViewElement = MultiViewPeer.this.model.getActiveElement();
            multiViewElement.getVisualRepresentation().requestFocus();
            multiViewElement.componentActivated();
        }
    }
}

