/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.netbeans.updater.UpdateTracking;

class Localization {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String LOCALE_DIR = "modules" + FILE_SEPARATOR + "ext" + FILE_SEPARATOR + "locale";
    private static final String BUNDLE_NAME = "org/netbeans/updater/Bundle";
    private static final String BUNDLE_EXT = ".properties";
    private static final String UPDATER_JAR = "updater";
    private static final String UPDATER_JAR_EXT = ".jar";
    private static ClassLoader brandedLoader = null;
    private static String brandingToken = null;
    private static Map<String, ResourceBundle> bundleCache = new HashMap<String, ResourceBundle>();

    Localization() {
    }

    public static String getBranding() {
        if (brandingToken != null) {
            Localization.init();
        }
        return brandingToken;
    }

    public static String getBrandedString(String string) {
        Localization.init();
        LocaleIterator localeIterator = new LocaleIterator(Locale.getDefault());
        while (localeIterator.hasNext()) {
            try {
                String string2;
                ResourceBundle resourceBundle = Localization.findBrandedBundle((String)localeIterator.next());
                if (resourceBundle == null || (string2 = resourceBundle.getString(string)) == null) continue;
                return string2;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle findBrandedBundle(String string) {
        ResourceBundle resourceBundle = bundleCache.get(string);
        if (resourceBundle != null) {
            return resourceBundle;
        }
        InputStream inputStream = brandedLoader.getResourceAsStream(BUNDLE_NAME + string + BUNDLE_EXT);
        if (inputStream != null) {
            ResourceBundle resourceBundle2;
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                resourceBundle = new PBundle(properties, new Locale(""));
                bundleCache.put(string, resourceBundle);
                resourceBundle2 = resourceBundle;
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            inputStream.close();
            return resourceBundle2;
        }
        return null;
    }

    public static URL getBrandedResource(String string, String string2) {
        Localization.init();
        LocaleIterator localeIterator = new LocaleIterator(Locale.getDefault());
        while (localeIterator.hasNext()) {
            URL uRL = brandedLoader.getResource(string + localeIterator.next() + string2);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    public static InputStream getBrandedResourceAsStream(String string, String string2) {
        Localization.init();
        LocaleIterator localeIterator = new LocaleIterator(Locale.getDefault());
        while (localeIterator.hasNext()) {
            InputStream inputStream = brandedLoader.getResourceAsStream(string + localeIterator.next() + string2);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    public static void setBranding(String string) {
        brandingToken = string;
    }

    private static synchronized void init() {
        if (brandingToken == null) {
            brandingToken = Localization.initBranding();
        }
        if (brandedLoader == null) {
            brandedLoader = Localization.class.getClassLoader();
            ArrayList<URL> arrayList = new ArrayList<URL>();
            URL[] uRLArray = new LocaleIterator(Locale.getDefault());
            while (uRLArray.hasNext()) {
                String string = uRLArray.next().toString();
                for (File file : UpdateTracking.clusters(true)) {
                    File file2 = new File(file.getPath() + FILE_SEPARATOR + LOCALE_DIR + FILE_SEPARATOR + UPDATER_JAR + string + UPDATER_JAR_EXT);
                    if (!file2.exists()) continue;
                    try {
                        arrayList.add(file2.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            if (!arrayList.isEmpty()) {
                uRLArray = new URL[arrayList.size()];
                arrayList.toArray(uRLArray);
                brandedLoader = new URLClassLoader(uRLArray, brandedLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String initBranding() {
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            if (UpdateTracking.getPlatformDir() == null) {
                String string2 = string;
                return string2;
            }
            File file = new File(UpdateTracking.getPlatformDir(), "lib" + FILE_SEPARATOR + "branding");
            bufferedReader = new BufferedReader(new FileReader(file));
            if (bufferedReader.ready()) {
                System.out.println("Warning - It's obsolete. Use --branding <branding> instead 'branding' file.");
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    private static class LocaleIterator
    implements Iterator {
        private boolean defaultInProgress = false;
        private boolean empty = false;
        private Locale locale;
        private Locale initLocale;
        private String current;
        private String branding;

        public LocaleIterator(Locale locale) {
            this.locale = this.initLocale = locale;
            if (locale.equals(Locale.getDefault())) {
                this.defaultInProgress = true;
            }
            this.current = '_' + locale.toString();
            this.branding = brandingToken == null ? null : "_" + brandingToken;
        }

        public Object next() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            String string = this.branding == null ? this.current : this.branding + this.current;
            int n = this.current.lastIndexOf(95);
            if (n == 0) {
                if (this.empty) {
                    this.reset();
                } else {
                    this.current = "";
                    this.empty = true;
                }
            } else if (n == -1) {
                if (this.defaultInProgress) {
                    this.reset();
                } else {
                    this.locale = Locale.getDefault();
                    this.current = '_' + this.locale.toString();
                    this.defaultInProgress = true;
                }
            } else {
                this.current = this.current.substring(0, n);
            }
            return string;
        }

        private void reset() {
            if (this.branding != null) {
                this.current = '_' + this.initLocale.toString();
                int n = this.branding.lastIndexOf(95);
                this.branding = n == 0 ? null : this.branding.substring(0, n);
                this.empty = false;
            } else {
                this.current = null;
            }
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PBundle
    extends ResourceBundle {
        private final Map<String, String> m;
        private final Locale locale;

        public PBundle(Map map, Locale locale) {
            this.m = map;
            this.locale = locale;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this.m.keySet());
        }

        @Override
        protected Object handleGetObject(String string) {
            return this.m.get(string);
        }

        @Override
        public Locale getLocale() {
            return this.locale;
        }
    }
}

