/*
 * Decompiled with CFR 0.152.
 */
package tr.view.process;

import au.com.thinkingrock.tr.resource.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.openide.awt.Toolbar;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import tr.appl.Constants;
import tr.prefs.gui.GUIPrefs;
import tr.view.Window;
import tr.view.process.ProcessAction;
import tr.view.process.ProcessNode;
import tr.view.process.ProcessNodeProvider;
import tr.view.process.panels.PanelProcess;

public final class ProcessTopComponent
extends Window
implements ProcessNodeProvider {
    public static final String PREFERRED_ID = "ProcessTopComponent";
    private static ProcessTopComponent instance;
    private transient InstanceContent content;
    private transient PanelProcess panel;
    private transient Lookup lookup;
    private JScrollPane scrollPane;

    private ProcessTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ProcessTopComponent.class, (String)"CTL_ProcessTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ProcessTopComponent.class, (String)"HINT_ProcessTopComponent"));
        this.setIcon(Icons.ProcessThoughts.getImage());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized ProcessTopComponent getDefault() {
        if (instance == null) {
            instance = new ProcessTopComponent();
        }
        return instance;
    }

    public static synchronized ProcessTopComponent findInstance() {
        return ProcessTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentClosed() {
        this.getInstanceContent().set((Collection)Collections.EMPTY_LIST, null);
    }

    private JToolBar getToolBar() {
        SystemAction[] actions = new SystemAction[]{SystemAction.get(ProcessAction.class)};
        JToolBar toolbar = SystemAction.createToolbarPresenter((SystemAction[])actions);
        toolbar.setUI(new Toolbar().getUI());
        toolbar.setFloatable(false);
        Dimension buttonSize = Constants.TOOLBAR_BUTTON_SIZE;
        for (Component component : toolbar.getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            component.setPreferredSize(buttonSize);
            component.setMinimumSize(buttonSize);
            component.setMaximumSize(buttonSize);
            component.setSize(buttonSize);
        }
        return toolbar;
    }

    protected void componentOpened() {
        this.provide(null);
        this.removeAll();
        if (GUIPrefs.getButtonsPosition().equals("top")) {
            this.add(this.getToolBar(), "North");
        } else {
            this.add(this.getToolBar(), "South");
        }
        this.panel = new PanelProcess(this);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBorder(null);
        this.scrollPane.setViewportView(this.panel);
        this.add(this.scrollPane, "Center");
        this.panel.initModel();
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.panel != null) {
            this.panel.takeFocus();
        }
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public void refresh() {
    }

    private synchronized InstanceContent getInstanceContent() {
        if (this.content == null) {
            this.content = new InstanceContent();
        }
        return this.content;
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new AbstractLookup((AbstractLookup.Content)this.getInstanceContent());
        }
        return this.lookup;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.process");
    }

    public void provide(final ProcessNode processNode) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (ProcessTopComponent.this.panel == null || processNode == null) {
                    ProcessTopComponent.this.getInstanceContent().set((Collection)Collections.EMPTY_LIST, null);
                } else {
                    Vector<ProcessNode> collection = new Vector<ProcessNode>();
                    collection.add(processNode);
                    ProcessTopComponent.this.getInstanceContent().set(collection, null);
                }
            }
        });
    }
}

