/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.filters;

import ca.odell.glazedlists.matchers.Matcher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.openide.util.NbBundle;
import tr.model.action.Action;
import tr.model.action.ActionStateDelegated;
import tr.util.Utils;
import tr.view.actions.screens.filters.FilterChoice;
import tr.view.filters.FilterComboAbstract;

public class FilterSearch
extends FilterChoice
implements PropertyChangeListener {
    public static final byte INDEX = 13;
    private static final Logger LOG = Logger.getLogger("tr.view.actions");

    public FilterSearch() {
        this.initialise();
    }

    protected void initialise() {
        this.combo = new SearchComboBox();
        this.combo.addValueChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String string = (String)this.combo.getSelectedItem();
        if (string == null || string.trim().length() == 0) {
            this.fireMatchAll();
        } else {
            this.fireChanged(new SearchMatcher(string));
        }
    }

    public String getLabel() {
        return NbBundle.getMessage(this.getClass(), (String)"filter-search");
    }

    public String[] getSerialValues() {
        SearchComboBox searchCombo = (SearchComboBox)this.combo;
        if (searchCombo == null || searchCombo.string == null) {
            return null;
        }
        return new String[]{searchCombo.string};
    }

    public void setSerialValues(String[] values) {
        if (this.combo == null) {
            return;
        }
        this.combo.stopChangeEvents();
        if (values == null || values.length == 0) {
            this.combo.setSelectedItem(null);
        } else {
            this.combo.setSelectedItem((Object)values[0]);
        }
        this.combo.startChangeEvents();
    }

    public Object getValueAt() {
        return "";
    }

    public byte getIndex() {
        return 13;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FilterSearch)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SearchComboBox thisSearchCombo = (SearchComboBox)this.combo;
        SearchComboBox thatSearchCombo = (SearchComboBox)((FilterSearch)object).combo;
        String thisString = thisSearchCombo == null ? null : thisSearchCombo.string;
        String thatString = thatSearchCombo == null ? null : thatSearchCombo.string;
        return Utils.equal((Object)thisString, (Object)thatString);
    }

    protected boolean canExcludeNulls() {
        return false;
    }

    private class SearchComboBox
    extends FilterComboAbstract {
        private ActionListener listener;
        public String string;

        public SearchComboBox() {
            super((ComboBoxModel)new SearchComboBoxModel());
            this.listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String s;
                    SearchComboBox.this.setString(null);
                    Object object = SearchComboBox.this.getSelectedItem();
                    if (object instanceof String && (s = ((String)object).trim()).length() > 0) {
                        SearchComboBox.this.setString(s);
                    }
                }
            };
            this.setEditable(true);
            this.addActionListener(this.listener);
        }

        public void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        public void startChangeEvents() {
            this.addActionListener(this.listener);
        }

        private void setString(String newString) {
            if (newString == null || newString.trim().length() == 0) {
                this.string = null;
            } else {
                this.string = newString.trim().toLowerCase();
                ((SearchComboBoxModel)this.getModel()).addSearch(this.string);
            }
            this.fireValueChange();
        }
    }

    private class SearchComboBoxModel
    extends DefaultComboBoxModel {
        public final Vector<String> searches = new Vector();

        private SearchComboBoxModel() {
        }

        public void addSearch(String search) {
            if (search == null) {
                return;
            }
            if (!this.searches.contains(search = search.trim())) {
                this.searches.add(search);
                this.fireContentsChanged(search, 0, this.searches.size());
            }
        }

        public Object getElementAt(int index) {
            return this.searches.get(index);
        }

        public int getSize() {
            return this.searches.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchMatcher
    implements Matcher<Action> {
        private final String search;

        public SearchMatcher() {
            this.search = null;
        }

        public SearchMatcher(String search) {
            this.search = search.toLowerCase();
        }

        public boolean matches(Action action) {
            ActionStateDelegated s;
            if (action.getDescription().toLowerCase().contains(this.search)) {
                return true;
            }
            if (action.getNotes().toLowerCase().contains(this.search)) {
                return true;
            }
            return action.isStateDelegated() && (s = (ActionStateDelegated)action.getState()) != null && s.getTo() != null && s.getTo().toLowerCase().contains(this.search);
        }
    }
}

